/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.modules.ModuleScriptData;
import org.jetbrains.kotlin.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.PluginCliParser;
import org.jetbrains.kotlin.cli.jvm.compiler.CommandLineScriptUtils;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.repl.ReplFromTerminal;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.load.kotlin.incremental.cache.IncrementalCacheProvider;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;

public class K2JVMCompiler
extends CLICompiler<K2JVMCompilerArguments> {
    public static void main(String ... args) {
        K2JVMCompiler.doMain(new K2JVMCompiler(), args);
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JVMCompilerArguments arguments2, @NotNull Services services, @NotNull MessageCollector messageCollector, @NotNull Disposable rootDisposable) {
        ExitCode exitCode;
        CompilerJarLocator locator;
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "doExecute"));
        }
        if (services == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "services", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "doExecute"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "doExecute"));
        }
        if (rootDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDisposable", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "doExecute"));
        }
        KotlinPaths paths = arguments2.kotlinHome != null ? new KotlinPathsFromHomeDir(new File(arguments2.kotlinHome)) : PathUtil.getKotlinPathsForCompiler();
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Using Kotlin home directory " + paths.getHomePath(), CompilerMessageLocation.NO_LOCATION);
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageCollector);
        IncrementalCacheProvider incrementalCacheProvider = services.get(IncrementalCacheProvider.class);
        if (incrementalCacheProvider != null) {
            configuration.put(JVMConfigurationKeys.INCREMENTAL_CACHE_PROVIDER, incrementalCacheProvider);
        }
        if ((locator = services.get(CompilerJarLocator.class)) != null) {
            configuration.put(JVMConfigurationKeys.COMPILER_JAR_LOCATOR, locator);
        }
        try {
            if (!arguments2.noJdk) {
                configuration.addAll(JVMConfigurationKeys.CLASSPATH_KEY, PathUtil.getJdkClassesRoots());
            }
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageCollector, t);
            ExitCode exitCode2 = ExitCode.INTERNAL_ERROR;
            if (exitCode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "doExecute"));
            }
            return exitCode2;
        }
        try {
            PluginCliParser.loadPlugins(arguments2, configuration);
        }
        catch (CliOptionProcessingException e) {
            messageCollector.report(CompilerMessageSeverity.ERROR, e.getMessage(), CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode3 = ExitCode.INTERNAL_ERROR;
            if (exitCode3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "doExecute"));
            }
            return exitCode3;
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageCollector, t);
            ExitCode exitCode4 = ExitCode.INTERNAL_ERROR;
            if (exitCode4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "doExecute"));
            }
            return exitCode4;
        }
        if (arguments2.script) {
            if (arguments2.freeArgs.isEmpty()) {
                messageCollector.report(CompilerMessageSeverity.ERROR, "Specify script source path to evaluate", CompilerMessageLocation.NO_LOCATION);
                ExitCode exitCode5 = ExitCode.COMPILATION_ERROR;
                if (exitCode5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "doExecute"));
                }
                return exitCode5;
            }
            configuration.add(CommonConfigurationKeys.SOURCE_ROOTS_KEY, arguments2.freeArgs.get(0));
        } else if (arguments2.module == null) {
            configuration.addAll(CommonConfigurationKeys.SOURCE_ROOTS_KEY, arguments2.freeArgs);
            for (String source : arguments2.freeArgs) {
                File file = new File(source);
                if (!file.isDirectory()) continue;
                configuration.add(JVMConfigurationKeys.CLASSPATH_KEY, file);
            }
        }
        configuration.addAll(JVMConfigurationKeys.CLASSPATH_KEY, K2JVMCompiler.getClasspath(paths, arguments2));
        configuration.addAll(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY, K2JVMCompiler.getAnnotationsPath(paths, arguments2));
        if (arguments2.module == null && arguments2.freeArgs.isEmpty() && !arguments2.version) {
            ReplFromTerminal.run(rootDisposable, configuration);
            ExitCode exitCode6 = ExitCode.OK;
            if (exitCode6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "doExecute"));
            }
            return exitCode6;
        }
        configuration.put(JVMConfigurationKeys.SCRIPT_PARAMETERS, arguments2.script ? CommandLineScriptUtils.scriptParameters() : Collections.emptyList());
        K2JVMCompiler.putAdvancedOptions(configuration, arguments2);
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", CompilerMessageLocation.NO_LOCATION);
        try {
            File outputDir;
            File jar;
            this.configureEnvironment(configuration, arguments2);
            String destination = arguments2.destination;
            if (destination != null) {
                boolean isJar = destination.endsWith(".jar");
                jar = isJar ? new File(destination) : null;
                outputDir = isJar ? null : new File(destination);
            } else {
                jar = null;
                outputDir = null;
            }
            if (arguments2.module != null) {
                FilteringMessageCollector sanitizedCollector = new FilteringMessageCollector(messageCollector, Predicates.in(CompilerMessageSeverity.VERBOSE));
                ModuleScriptData moduleScript = CompileEnvironmentUtil.loadModuleDescriptions(paths, arguments2.module, sanitizedCollector);
                if (outputDir != null) {
                    messageCollector.report(CompilerMessageSeverity.WARNING, "The '-d' option with a directory destination is ignored because '-module' is specified", CompilerMessageLocation.NO_LOCATION);
                }
                File directory = new File(arguments2.module).getAbsoluteFile().getParentFile();
                KotlinToJVMBytecodeCompiler.compileModules(configuration, moduleScript.getModules(), directory, jar, arguments2.includeRuntime);
            } else if (arguments2.script) {
                List<String> scriptArgs = arguments2.freeArgs.subList(1, arguments2.freeArgs.size());
                JetCoreEnvironment environment = JetCoreEnvironment.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
                KotlinToJVMBytecodeCompiler.compileAndExecuteScript(paths, environment, scriptArgs);
            } else {
                JetCoreEnvironment environment = JetCoreEnvironment.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
                KotlinToJVMBytecodeCompiler.compileBunchOfSources(environment, jar, outputDir, arguments2.includeRuntime);
            }
            exitCode = ExitCode.OK;
        }
        catch (CompilationException e) {
            messageCollector.report(CompilerMessageSeverity.EXCEPTION, OutputMessageUtil.renderException(e), MessageUtil.psiElementToMessageLocation(e.getElement()));
            ExitCode exitCode7 = ExitCode.INTERNAL_ERROR;
            if (exitCode7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "doExecute"));
            }
            return exitCode7;
        }
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "doExecute"));
        }
        return exitCode;
    }

    private static void putAdvancedOptions(@NotNull CompilerConfiguration configuration, @NotNull K2JVMCompilerArguments arguments2) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "putAdvancedOptions"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "putAdvancedOptions"));
        }
        configuration.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments2.noCallAssertions);
        configuration.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments2.noParamAssertions);
        configuration.put(JVMConfigurationKeys.DISABLE_INLINE, arguments2.noInline);
        configuration.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments2.noOptimize);
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createArguments() {
        K2JVMCompilerArguments k2JVMCompilerArguments = new K2JVMCompilerArguments();
        if (k2JVMCompilerArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "createArguments"));
        }
        return k2JVMCompilerArguments;
    }

    @NotNull
    private static List<File> getClasspath(@NotNull KotlinPaths paths, @NotNull K2JVMCompilerArguments arguments2) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "getClasspath"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "getClasspath"));
        }
        ArrayList<File> classpath = Lists.newArrayList();
        if (arguments2.classpath != null) {
            for (String element : Splitter.on(File.pathSeparatorChar).split(arguments2.classpath)) {
                classpath.add(new File(element));
            }
        }
        if (!arguments2.noStdlib) {
            classpath.add(paths.getRuntimePath());
        }
        ArrayList<File> arrayList = classpath;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "getClasspath"));
        }
        return arrayList;
    }

    @NotNull
    private static List<File> getAnnotationsPath(@NotNull KotlinPaths paths, @NotNull K2JVMCompilerArguments arguments2) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "getAnnotationsPath"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "getAnnotationsPath"));
        }
        ArrayList<File> annotationsPath = Lists.newArrayList();
        if (arguments2.annotations != null) {
            for (String element : Splitter.on(File.pathSeparatorChar).split(arguments2.annotations)) {
                annotationsPath.add(new File(element));
            }
        }
        if (!arguments2.noJdkAnnotations) {
            annotationsPath.add(paths.getJdkAnnotationsPath());
        }
        ArrayList<File> arrayList = annotationsPath;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/K2JVMCompiler", "getAnnotationsPath"));
        }
        return arrayList;
    }
}

