/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.runner.JavaMainMethodProvider;
import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreJavaFileManager;
import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.core.JavaCoreProjectEnvironment;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCoreProxy;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileTypes.ContentBasedFileSubstitutor;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.PsiElementFinderImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsStubBuilderFactory;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Function1;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.JavaElementFinder;
import org.jetbrains.kotlin.asJava.KotlinLightClassForPackage;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.compiler.ClassPath;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.CliVirtualFileFinderFactory;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.cli.jvm.compiler.CoreExternalAnnotationsManager;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.extensions.ExternalDeclarationsProvider;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinderFactory;
import org.jetbrains.kotlin.parsing.JetParserDefinition;
import org.jetbrains.kotlin.parsing.JetScriptDefinitionProvider;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.CodeAnalyzerInitializer;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;
import org.jetbrains.kotlin.resolve.lazy.declarations.CliDeclarationProviderFactoryService;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactoryService;
import org.jetbrains.kotlin.utils.PathUtil;

public class JetCoreEnvironment {
    private static final Object APPLICATION_LOCK = new Object();
    private static JavaCoreApplicationEnvironment ourApplicationEnvironment;
    private static int ourProjectCount;
    private final JavaCoreProjectEnvironment projectEnvironment;
    private final List<JetFile> sourceFiles;
    private final ClassPath classPath;
    private final CoreExternalAnnotationsManager annotationsManager;
    private final CompilerConfiguration configuration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JetCoreEnvironment createForProduction(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> configFilePaths) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "createForProduction"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "createForProduction"));
        }
        if (configFilePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFilePaths", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "createForProduction"));
        }
        Disposer.register(parentDisposable, new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                Object object = APPLICATION_LOCK;
                synchronized (object) {
                    if (--ourProjectCount <= 0) {
                        JetCoreEnvironment.disposeApplicationEnvironment();
                    }
                }
            }
        });
        JetCoreEnvironment environment = new JetCoreEnvironment(parentDisposable, JetCoreEnvironment.getOrCreateApplicationEnvironmentForProduction(configuration, configFilePaths), configuration);
        Object object = APPLICATION_LOCK;
        synchronized (object) {
            ++ourProjectCount;
        }
        JetCoreEnvironment jetCoreEnvironment = environment;
        if (jetCoreEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "createForProduction"));
        }
        return jetCoreEnvironment;
    }

    @NotNull
    public static JetCoreEnvironment createForTests(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> extensionConfigs) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "createForTests"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "createForTests"));
        }
        if (extensionConfigs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionConfigs", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "createForTests"));
        }
        JetCoreEnvironment jetCoreEnvironment = new JetCoreEnvironment(parentDisposable, JetCoreEnvironment.createApplicationEnvironment(parentDisposable, configuration, extensionConfigs), configuration);
        if (jetCoreEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "createForTests"));
        }
        return jetCoreEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static JavaCoreApplicationEnvironment getOrCreateApplicationEnvironmentForProduction(@NotNull CompilerConfiguration configuration, @NotNull List<String> configFilePaths) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "getOrCreateApplicationEnvironmentForProduction"));
        }
        if (configFilePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFilePaths", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "getOrCreateApplicationEnvironmentForProduction"));
        }
        Object object = APPLICATION_LOCK;
        // MONITORENTER : object
        if (ourApplicationEnvironment != null) {
            JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = ourApplicationEnvironment;
            // MONITOREXIT : object
            if (javaCoreApplicationEnvironment != null) return javaCoreApplicationEnvironment;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "getOrCreateApplicationEnvironmentForProduction"));
        }
        Disposable parentDisposable = Disposer.newDisposable();
        ourApplicationEnvironment = JetCoreEnvironment.createApplicationEnvironment(parentDisposable, configuration, configFilePaths);
        ourProjectCount = 0;
        Disposer.register(parentDisposable, new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                Object object = APPLICATION_LOCK;
                synchronized (object) {
                    ourApplicationEnvironment = null;
                }
            }
        });
        JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = ourApplicationEnvironment;
        // MONITOREXIT : object
        if (javaCoreApplicationEnvironment != null) return javaCoreApplicationEnvironment;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "getOrCreateApplicationEnvironmentForProduction"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeApplicationEnvironment() {
        Object object = APPLICATION_LOCK;
        synchronized (object) {
            if (ourApplicationEnvironment == null) {
                return;
            }
            JavaCoreApplicationEnvironment environment = ourApplicationEnvironment;
            ourApplicationEnvironment = null;
            Disposer.dispose(environment.getParentDisposable());
        }
    }

    @NotNull
    private static JavaCoreApplicationEnvironment createApplicationEnvironment(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> configFilePaths) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "createApplicationEnvironment"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "createApplicationEnvironment"));
        }
        if (configFilePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFilePaths", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "createApplicationEnvironment"));
        }
        Extensions.cleanRootArea(parentDisposable);
        JetCoreEnvironment.registerAppExtensionPoints();
        JavaCoreApplicationEnvironment applicationEnvironment = new JavaCoreApplicationEnvironment(parentDisposable);
        for (String configPath : configFilePaths) {
            JetCoreEnvironment.registerApplicationExtensionPointsAndExtensionsFrom(configuration, configPath);
        }
        JetCoreEnvironment.registerApplicationServicesForCLI(applicationEnvironment);
        JetCoreEnvironment.registerApplicationServices(applicationEnvironment);
        JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = applicationEnvironment;
        if (javaCoreApplicationEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "createApplicationEnvironment"));
        }
        return javaCoreApplicationEnvironment;
    }

    private static void registerAppExtensionPoints() {
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ContentBasedFileSubstitutor.EP_NAME, ContentBasedFileSubstitutor.class);
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), "com.intellij.filetype.stubBuilder", FileTypeExtensionPoint.class);
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), FileContextProvider.EP_NAME, FileContextProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), MetaDataContributor.EP_NAME, MetaDataContributor.class);
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ClsStubBuilderFactory.EP_NAME, ClsStubBuilderFactory.class);
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), PsiAugmentProvider.EP_NAME, PsiAugmentProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), JavaMainMethodProvider.EP_NAME, JavaMainMethodProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ContainerProvider.EP_NAME, ContainerProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ClsCustomNavigationPolicy.EP_NAME, ClsCustomNavigationPolicy.class);
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ClassFileDecompilers.EP_NAME, ClassFileDecompilers.Decompiler.class);
    }

    private static void registerApplicationExtensionPointsAndExtensionsFrom(@NotNull CompilerConfiguration configuration, @NotNull String configFilePath) {
        IdeaPluginDescriptorImpl descriptor;
        File jar;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "registerApplicationExtensionPointsAndExtensionsFrom"));
        }
        if (configFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFilePath", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "registerApplicationExtensionPointsAndExtensionsFrom"));
        }
        CompilerJarLocator locator = configuration.get(JVMConfigurationKeys.COMPILER_JAR_LOCATOR);
        File file = jar = locator == null ? PathUtil.getPathUtilJar() : locator.getCompilerJar();
        if (jar.isFile()) {
            descriptor = PluginManagerCoreProxy.loadDescriptorFromJar(jar, configFilePath);
        } else {
            File srcDir = jar.getParentFile().getParentFile().getParentFile();
            File pluginDir = new File(srcDir, "idea/src");
            descriptor = PluginManagerCoreProxy.loadDescriptorFromDir(pluginDir, configFilePath);
        }
        assert (descriptor != null) : "Can not load descriptor from " + configFilePath + " relative to " + jar;
        PluginManagerCoreProxy.registerExtensionPointsAndExtensions(Extensions.getRootArea(), Collections.singletonList(descriptor));
    }

    private static void registerApplicationServicesForCLI(@NotNull JavaCoreApplicationEnvironment applicationEnvironment) {
        if (applicationEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationEnvironment", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "registerApplicationServicesForCLI"));
        }
        applicationEnvironment.registerFileType(PlainTextFileType.INSTANCE, "xml");
        applicationEnvironment.registerParserDefinition(new JavaParserDefinition());
    }

    public static void registerApplicationServices(@NotNull JavaCoreApplicationEnvironment applicationEnvironment) {
        if (applicationEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationEnvironment", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "registerApplicationServices"));
        }
        applicationEnvironment.registerFileType(JetFileType.INSTANCE, "kt");
        applicationEnvironment.registerFileType(JetFileType.INSTANCE, "ktm");
        applicationEnvironment.registerFileType(JetFileType.INSTANCE, "kts");
        applicationEnvironment.registerParserDefinition(new JetParserDefinition());
        applicationEnvironment.getApplication().registerService(KotlinBinaryClassCache.class, new KotlinBinaryClassCache());
    }

    private JetCoreEnvironment(@NotNull Disposable parentDisposable, @NotNull JavaCoreApplicationEnvironment applicationEnvironment, @NotNull CompilerConfiguration configuration) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "<init>"));
        }
        if (applicationEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationEnvironment", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "<init>"));
        }
        this.sourceFiles = new ArrayList<JetFile>();
        this.classPath = new ClassPath();
        this.configuration = configuration.copy();
        this.configuration.setReadOnly(true);
        this.projectEnvironment = new JavaCoreProjectEnvironment(parentDisposable, applicationEnvironment){

            @Override
            protected void preregisterServices() {
                JetCoreEnvironment.registerProjectExtensionPoints(Extensions.getArea(this.getProject()));
            }
        };
        MockProject project = this.projectEnvironment.getProject();
        this.annotationsManager = new CoreExternalAnnotationsManager(project.getComponent(PsiManager.class));
        project.registerService(ExternalAnnotationsManager.class, this.annotationsManager);
        project.registerService(DeclarationProviderFactoryService.class, new CliDeclarationProviderFactoryService(this.sourceFiles));
        JetCoreEnvironment.registerProjectServicesForCLI(this.projectEnvironment);
        JetCoreEnvironment.registerProjectServices(this.projectEnvironment);
        for (File path : configuration.getList(JVMConfigurationKeys.CLASSPATH_KEY)) {
            this.addToClasspath(path);
        }
        for (File path : configuration.getList(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY)) {
            this.addExternalAnnotationsRoot(path);
        }
        this.sourceFiles.addAll(CompileEnvironmentUtil.getJetFiles(this.getProject(), this.getSourceRootsCheckingForDuplicates(), new Function1<String, Unit>(){

            @Override
            public Unit invoke(String s) {
                JetCoreEnvironment.this.report(CompilerMessageSeverity.ERROR, s);
                return Unit.INSTANCE$;
            }
        }));
        ContainerUtil.sort(this.sourceFiles, new Comparator<JetFile>(){

            @Override
            public int compare(@NotNull JetFile o1, @NotNull JetFile o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment$5", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment$5", "compare"));
                }
                return o1.getVirtualFile().getPath().compareToIgnoreCase(o2.getVirtualFile().getPath());
            }
        });
        JetScriptDefinitionProvider.getInstance(project).addScriptDefinitions(configuration.getList(CommonConfigurationKeys.SCRIPT_DEFINITIONS_KEY));
        project.registerService(VirtualFileFinderFactory.class, new CliVirtualFileFinderFactory(this.classPath));
        ExternalDeclarationsProvider.OBJECT$.registerExtensionPoint(project);
        ExpressionCodegenExtension.OBJECT$.registerExtensionPoint(project);
        for (ComponentRegistrar registrar : configuration.getList(ComponentRegistrar.PLUGIN_COMPONENT_REGISTRARS)) {
            registrar.registerProjectComponents(project, configuration);
        }
    }

    private static void registerProjectExtensionPoints(ExtensionsArea area) {
        CoreApplicationEnvironment.registerExtensionPoint(area, PsiTreeChangePreprocessor.EP_NAME, PsiTreeChangePreprocessor.class);
        CoreApplicationEnvironment.registerExtensionPoint(area, PsiElementFinder.EP_NAME, PsiElementFinder.class);
    }

    public static void registerProjectServices(@NotNull JavaCoreProjectEnvironment projectEnvironment) {
        if (projectEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectEnvironment", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "registerProjectServices"));
        }
        MockProject project = projectEnvironment.getProject();
        project.registerService(JetScriptDefinitionProvider.class, new JetScriptDefinitionProvider());
        project.registerService(KotlinJavaPsiFacade.class, new KotlinJavaPsiFacade(project));
        project.registerService(KotlinLightClassForPackage.FileStubCache.class, new KotlinLightClassForPackage.FileStubCache(project));
    }

    private static void registerProjectServicesForCLI(@NotNull JavaCoreProjectEnvironment projectEnvironment) {
        if (projectEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectEnvironment", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "registerProjectServicesForCLI"));
        }
        MockProject project = projectEnvironment.getProject();
        project.registerService(CoreJavaFileManager.class, (CoreJavaFileManager)ServiceManager.getService(project, JavaFileManager.class));
        CliLightClassGenerationSupport cliLightClassGenerationSupport = new CliLightClassGenerationSupport(project);
        project.registerService(LightClassGenerationSupport.class, cliLightClassGenerationSupport);
        project.registerService(CliLightClassGenerationSupport.class, cliLightClassGenerationSupport);
        project.registerService(CodeAnalyzerInitializer.class, cliLightClassGenerationSupport);
        ExtensionsArea area = Extensions.getArea(project);
        area.getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension(new PsiElementFinderImpl(project, ServiceManager.getService(project, JavaFileManager.class)));
        area.getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension(new JavaElementFinder(project, cliLightClassGenerationSupport));
    }

    @NotNull
    public CompilerConfiguration getConfiguration() {
        CompilerConfiguration compilerConfiguration = this.configuration;
        if (compilerConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "getConfiguration"));
        }
        return compilerConfiguration;
    }

    @NotNull
    private CoreApplicationEnvironment getMyApplicationEnvironment() {
        CoreApplicationEnvironment coreApplicationEnvironment = this.projectEnvironment.getEnvironment();
        if (coreApplicationEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "getMyApplicationEnvironment"));
        }
        return coreApplicationEnvironment;
    }

    @NotNull
    public MockApplication getApplication() {
        MockApplication mockApplication = this.getMyApplicationEnvironment().getApplication();
        if (mockApplication == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "getApplication"));
        }
        return mockApplication;
    }

    @NotNull
    public Project getProject() {
        MockProject mockProject = this.projectEnvironment.getProject();
        if (mockProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "getProject"));
        }
        return mockProject;
    }

    private void addExternalAnnotationsRoot(File path) {
        if (!path.exists()) {
            this.report(CompilerMessageSeverity.WARNING, "Annotations path entry points to a non-existent location: " + path);
            return;
        }
        this.annotationsManager.addExternalAnnotationsRoot(PathUtil.jarFileOrDirectoryToVirtualFile(path));
    }

    private void addToClasspath(File path) {
        if (path.isFile()) {
            VirtualFile jarFile = this.getMyApplicationEnvironment().getJarFileSystem().findFileByPath(path + "!/");
            if (jarFile == null) {
                this.report(CompilerMessageSeverity.WARNING, "Classpath entry points to a file that is not a JAR archive: " + path);
                return;
            }
            this.projectEnvironment.addJarToClassPath(path);
            this.classPath.add(jarFile);
        } else {
            VirtualFile root = this.getMyApplicationEnvironment().getLocalFileSystem().findFileByPath(path.getAbsolutePath());
            if (root == null) {
                this.report(CompilerMessageSeverity.WARNING, "Classpath entry points to a non-existent location: " + path);
                return;
            }
            this.projectEnvironment.addSourcesToClasspath(root);
            this.classPath.add(root);
        }
    }

    @NotNull
    private Collection<String> getSourceRootsCheckingForDuplicates() {
        LinkedHashSet<String> uniqueSourceRoots = Sets.newLinkedHashSet();
        for (String sourceRoot : this.configuration.getList(CommonConfigurationKeys.SOURCE_ROOTS_KEY)) {
            if (uniqueSourceRoots.add(sourceRoot)) continue;
            this.report(CompilerMessageSeverity.WARNING, "Duplicate source root: " + sourceRoot);
        }
        LinkedHashSet<String> linkedHashSet = uniqueSourceRoots;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "getSourceRootsCheckingForDuplicates"));
        }
        return linkedHashSet;
    }

    @NotNull
    public List<JetFile> getSourceFiles() {
        List<JetFile> list = this.sourceFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "getSourceFiles"));
        }
        return list;
    }

    private void report(@NotNull CompilerMessageSeverity severity, @NotNull String message) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "report"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/jvm/compiler/JetCoreEnvironment", "report"));
        }
        MessageCollector messageCollector = this.configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (messageCollector == null) {
            throw new CompileEnvironmentException(message);
        }
        messageCollector.report(severity, message, CompilerMessageLocation.NO_LOCATION);
    }

    static {
        ourProjectCount = 0;
    }
}

