/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kotlin.Function0;
import kotlin.Function1;
import kotlin.Unit;
import kotlin.modules.AllModules;
import kotlin.modules.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.asJava.FilteredJvmDiagnostics;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CompilerPlugin;
import org.jetbrains.kotlin.cli.common.CompilerPluginContext;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.output.outputUtils.OutputUtilsPackage;
import org.jetbrains.kotlin.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.Progress;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.context.ContextPackage;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.load.kotlin.incremental.cache.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.cache.IncrementalCacheProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.parsing.JetScriptDefinition;
import org.jetbrains.kotlin.parsing.JetScriptDefinitionProvider;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.AnalyzerScriptParameter;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.ScriptNameUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.utils.KotlinPaths;

public class KotlinToJVMBytecodeCompiler {
    private KotlinToJVMBytecodeCompiler() {
    }

    @NotNull
    private static List<String> getAbsolutePaths(@NotNull File directory, @NotNull Module module) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "getAbsolutePaths"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "getAbsolutePaths"));
        }
        ArrayList<String> result2 = Lists.newArrayList();
        for (String sourceFile : module.getSourceFiles()) {
            File source = new File(sourceFile);
            if (!source.isAbsolute()) {
                source = new File(directory, sourceFile);
            }
            if (!source.exists()) {
                throw new CompileEnvironmentException("'" + source + "' does not exist in module " + module.getModuleName());
            }
            result2.add(source.getAbsolutePath());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "getAbsolutePaths"));
        }
        return arrayList;
    }

    private static void writeOutput(@NotNull CompilerConfiguration configuration, @NotNull ClassFileFactory outputFiles, @Nullable File outputDir, @Nullable File jarPath, boolean jarRuntime, @Nullable FqName mainClass) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "writeOutput"));
        }
        if (outputFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFiles", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "writeOutput"));
        }
        if (jarPath != null) {
            CompileEnvironmentUtil.writeToJar(jarPath, jarRuntime, mainClass, outputFiles);
        } else {
            MessageCollector messageCollector = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE);
            OutputUtilsPackage.writeAll((OutputFileCollection)outputFiles, outputDir == null ? new File(".") : outputDir, messageCollector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compileModules(@NotNull CompilerConfiguration configuration, @NotNull List<Module> chunk, @NotNull File directory, @Nullable File jarPath, boolean jarRuntime) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileModules"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileModules"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileModules"));
        }
        HashMap<Module, ClassFileFactory> outputFiles = Maps.newHashMap();
        CompilerConfiguration compilerConfiguration = KotlinToJVMBytecodeCompiler.createCompilerConfiguration(configuration, chunk, directory);
        Disposable parentDisposable = Disposer.newDisposable();
        JetCoreEnvironment environment = null;
        try {
            environment = JetCoreEnvironment.createForProduction(parentDisposable, compilerConfiguration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
            AnalysisResult result2 = KotlinToJVMBytecodeCompiler.analyze(environment);
            if (result2 == null) {
                boolean bl = false;
                return bl;
            }
            result2.throwIfError();
            for (Module module : chunk) {
                List<JetFile> jetFiles = CompileEnvironmentUtil.getJetFiles(environment.getProject(), KotlinToJVMBytecodeCompiler.getAbsolutePaths(directory, module), new Function1<String, Unit>(){

                    @Override
                    public Unit invoke(String s) {
                        throw new IllegalStateException("Should have been checked before: " + s);
                    }
                });
                GenerationState generationState = KotlinToJVMBytecodeCompiler.generate(environment, result2, jetFiles, module.getModuleName(), new File(module.getOutputDirectory()));
                outputFiles.put(module, generationState.getFactory());
            }
        }
        finally {
            if (environment != null) {
                Disposer.dispose(parentDisposable);
            }
        }
        for (Module module : chunk) {
            KotlinToJVMBytecodeCompiler.writeOutput(configuration, (ClassFileFactory)outputFiles.get(module), new File(module.getOutputDirectory()), jarPath, jarRuntime, null);
        }
        return true;
    }

    @NotNull
    private static CompilerConfiguration createCompilerConfiguration(@NotNull CompilerConfiguration base, @NotNull List<Module> chunk, @NotNull File directory) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "createCompilerConfiguration"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "createCompilerConfiguration"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "createCompilerConfiguration"));
        }
        CompilerConfiguration configuration = base.copy();
        for (Module module : chunk) {
            configuration.addAll(CommonConfigurationKeys.SOURCE_ROOTS_KEY, KotlinToJVMBytecodeCompiler.getAbsolutePaths(directory, module));
            for (String classpathRoot : module.getClasspathRoots()) {
                configuration.add(JVMConfigurationKeys.CLASSPATH_KEY, new File(classpathRoot));
            }
            for (String annotationsRoot : module.getAnnotationsRoots()) {
                configuration.add(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY, new File(annotationsRoot));
            }
            configuration.add(JVMConfigurationKeys.MODULE_IDS, module.getModuleName());
        }
        CompilerConfiguration compilerConfiguration = configuration;
        if (compilerConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "createCompilerConfiguration"));
        }
        return compilerConfiguration;
    }

    @Nullable
    private static FqName findMainClass(@NotNull GenerationState generationState, @NotNull List<JetFile> files) {
        if (generationState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generationState", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "findMainClass"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "findMainClass"));
        }
        MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(generationState.getBindingContext());
        FqName mainClass = null;
        for (JetFile file : files) {
            if (!mainFunctionDetector.hasMain(file.getDeclarations())) continue;
            if (mainClass != null) {
                return null;
            }
            FqName fqName2 = file.getPackageFqName();
            mainClass = PackageClassUtils.getPackageClassFqName(fqName2);
        }
        return mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compileBunchOfSources(@NotNull JetCoreEnvironment environment, @Nullable File jar, @Nullable File outputDir, boolean includeRuntime) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileBunchOfSources"));
        }
        GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(environment);
        if (generationState == null) {
            return false;
        }
        FqName mainClass = KotlinToJVMBytecodeCompiler.findMainClass(generationState, environment.getSourceFiles());
        try {
            KotlinToJVMBytecodeCompiler.writeOutput(environment.getConfiguration(), generationState.getFactory(), outputDir, jar, includeRuntime, mainClass);
            boolean bl = true;
            return bl;
        }
        finally {
            generationState.destroy();
        }
    }

    public static void compileAndExecuteScript(@NotNull KotlinPaths paths, @NotNull JetCoreEnvironment environment, @NotNull List<String> scriptArgs) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        if (scriptArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptArgs", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        Class<?> scriptClass = KotlinToJVMBytecodeCompiler.compileScript(paths, environment);
        if (scriptClass == null) {
            return;
        }
        try {
            scriptClass.getConstructor(String[].class).newInstance(new Object[]{ArrayUtil.toStringArray(scriptArgs)});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to evaluate script: " + e, e);
        }
    }

    @Nullable
    public static Class<?> compileScript(@NotNull KotlinPaths paths, @NotNull JetCoreEnvironment environment) {
        GenerationState state;
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileScript"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileScript"));
        }
        List<AnalyzerScriptParameter> scriptParameters = environment.getConfiguration().getList(JVMConfigurationKeys.SCRIPT_PARAMETERS);
        if (!scriptParameters.isEmpty()) {
            JetScriptDefinitionProvider.getInstance(environment.getProject()).addScriptDefinition(new JetScriptDefinition(".kts", scriptParameters));
        }
        if ((state = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(environment)) == null) {
            return null;
        }
        try {
            GeneratedClassLoader classLoader = new GeneratedClassLoader(state.getFactory(), (ClassLoader)new URLClassLoader(new URL[]{paths.getRuntimePath().toURI().toURL()}, AllModules.class.getClassLoader()), new URL[0]);
            FqName nameForScript = ScriptNameUtil.classNameForScript(environment.getSourceFiles().get(0).getScript());
            return classLoader.loadClass(nameForScript.asString());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to evaluate script: " + e, e);
        }
    }

    @Nullable
    public static GenerationState analyzeAndGenerate(@NotNull JetCoreEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "analyzeAndGenerate"));
        }
        AnalysisResult result2 = KotlinToJVMBytecodeCompiler.analyze(environment);
        if (result2 == null) {
            return null;
        }
        result2.throwIfError();
        return KotlinToJVMBytecodeCompiler.generate(environment, result2, environment.getSourceFiles(), null, null);
    }

    @Nullable
    private static AnalysisResult analyze(final @NotNull JetCoreEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "analyze"));
        }
        MessageCollector collector2 = environment.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        assert (collector2 != null);
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(collector2);
        analyzerWithCompilerReport.analyzeAndReport(environment.getSourceFiles(), new Function0<AnalysisResult>(){

            @Override
            @NotNull
            public AnalysisResult invoke() {
                CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace sharedTrace = new CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace();
                ModuleDescriptorImpl analyzeModule = TopDownAnalyzerFacadeForJVM.createSealedJavaModule();
                AnalysisResult analysisResult = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegrationWithCustomContext(environment.getProject(), ContextPackage.GlobalContext(), environment.getSourceFiles(), sharedTrace, Predicates.<PsiFile>alwaysTrue(), analyzeModule, environment.getConfiguration().get(JVMConfigurationKeys.MODULE_IDS), environment.getConfiguration().get(JVMConfigurationKeys.INCREMENTAL_CACHE_PROVIDER));
                if (analysisResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler$2", "invoke"));
                }
                return analysisResult;
            }
        });
        AnalysisResult result2 = analyzerWithCompilerReport.getAnalysisResult();
        assert (result2 != null) : "AnalysisResult should be non-null, compiling: " + environment.getSourceFiles();
        CompilerPluginContext context2 = new CompilerPluginContext(environment.getProject(), result2.getBindingContext(), environment.getSourceFiles());
        for (CompilerPlugin plugin : environment.getConfiguration().getList(CLIConfigurationKeys.COMPILER_PLUGINS)) {
            plugin.processFiles(context2);
        }
        return analyzerWithCompilerReport.hasErrors() ? null : result2;
    }

    @NotNull
    private static GenerationState generate(@NotNull JetCoreEnvironment environment, @NotNull AnalysisResult result2, @NotNull List<JetFile> sourceFiles, @Nullable String moduleId, File outputDirectory) {
        HashSet<FqName> packagesWithObsoleteParts;
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        CompilerConfiguration configuration = environment.getConfiguration();
        IncrementalCacheProvider incrementalCacheProvider = configuration.get(JVMConfigurationKeys.INCREMENTAL_CACHE_PROVIDER);
        if (moduleId == null || incrementalCacheProvider == null) {
            packagesWithObsoleteParts = null;
        } else {
            IncrementalCache incrementalCache = incrementalCacheProvider.getIncrementalCache(moduleId);
            packagesWithObsoleteParts = new HashSet<FqName>();
            for (String internalName : incrementalCache.getObsoletePackageParts()) {
                packagesWithObsoleteParts.add(JvmClassName.byInternalName(internalName).getPackageFqName());
            }
        }
        BindingTraceContext diagnosticHolder = new BindingTraceContext();
        GenerationState generationState = new GenerationState(environment.getProject(), ClassBuilderFactories.BINARIES, Progress.DEAF, result2.getModuleDescriptor(), result2.getBindingContext(), sourceFiles, configuration.get(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, false), configuration.get(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, false), GenerationState.GenerateClassFilter.GENERATE_ALL, configuration.get(JVMConfigurationKeys.DISABLE_INLINE, false), configuration.get(JVMConfigurationKeys.DISABLE_OPTIMIZATION, false), packagesWithObsoleteParts, moduleId, diagnosticHolder, outputDirectory);
        KotlinCodegenFacade.compileCorrectFiles(generationState, CompilationErrorHandler.THROW_EXCEPTION);
        AnalyzerWithCompilerReport.reportDiagnostics(new FilteredJvmDiagnostics(diagnosticHolder.getBindingContext().getDiagnostics(), result2.getBindingContext().getDiagnostics()), environment.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY));
        GenerationState generationState2 = generationState;
        if (generationState2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        return generationState2;
    }
}

