/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.LocalLookup;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;

public class ClassContext
extends FieldOwnerContext<ClassDescriptor> {
    private final JetTypeMapper typeMapper;

    public ClassContext(@NotNull JetTypeMapper typeMapper, @NotNull ClassDescriptor contextDescriptor, @NotNull OwnerKind contextKind, @Nullable CodegenContext parentContext, @Nullable LocalLookup localLookup) {
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/context/ClassContext", "<init>"));
        }
        if (contextDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDescriptor", "org/jetbrains/kotlin/codegen/context/ClassContext", "<init>"));
        }
        if (contextKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextKind", "org/jetbrains/kotlin/codegen/context/ClassContext", "<init>"));
        }
        super(contextDescriptor, contextKind, parentContext, typeMapper.getBindingContext().get(CodegenBinding.CLOSURE, contextDescriptor), contextDescriptor, localLookup);
        this.typeMapper = typeMapper;
    }

    @Override
    @Nullable
    protected StackValue.Field computeOuterExpression() {
        ClassDescriptor enclosingClass = this.getEnclosingClass();
        if (enclosingClass == null) {
            return null;
        }
        if (!CodegenBinding.canHaveOuter(this.typeMapper.getBindingContext(), (ClassDescriptor)this.getContextDescriptor())) {
            return null;
        }
        return StackValue.field(this.typeMapper.mapType(enclosingClass), this.typeMapper.mapType((ClassifierDescriptor)this.getContextDescriptor()), "this$0", false, StackValue.LOCAL_0);
    }

    @Nullable
    public CodegenContext getDefaultObjectContext() {
        if (((ClassDescriptor)this.getContextDescriptor()).getDefaultObjectDescriptor() != null) {
            return this.findChildContext(((ClassDescriptor)this.getContextDescriptor()).getDefaultObjectDescriptor());
        }
        return null;
    }

    public String toString() {
        return "Class: " + this.getContextDescriptor();
    }
}

