/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AccessorForFunctionDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingFieldInOuterClass;
import org.jetbrains.kotlin.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.AnonymousClassContext;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.ClosureContext;
import org.jetbrains.kotlin.codegen.context.ConstructorContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.LocalLookup;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.context.PackageFacadeContext;
import org.jetbrains.kotlin.codegen.context.RootContext;
import org.jetbrains.kotlin.codegen.context.ScriptContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.org.objectweb.asm.Type;

public abstract class CodegenContext<T extends DeclarationDescriptor> {
    public static final CodegenContext STATIC = new RootContext();
    private final T contextDescriptor;
    private final OwnerKind contextKind;
    private final CodegenContext parentContext;
    private final ClassDescriptor thisDescriptor;
    public final MutableClosure closure;
    private final LocalLookup enclosingLocalLookup;
    private final NullableLazyValue<StackValue.Field> outerExpression;
    private Map<DeclarationDescriptor, DeclarationDescriptor> accessors;
    private Map<DeclarationDescriptor, CodegenContext> childContexts;

    public CodegenContext(@NotNull T contextDescriptor, @NotNull OwnerKind contextKind, @Nullable CodegenContext parentContext, @Nullable MutableClosure closure, @Nullable ClassDescriptor thisDescriptor, @Nullable LocalLookup localLookup) {
        if (contextDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDescriptor", "org/jetbrains/kotlin/codegen/context/CodegenContext", "<init>"));
        }
        if (contextKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextKind", "org/jetbrains/kotlin/codegen/context/CodegenContext", "<init>"));
        }
        this.contextDescriptor = contextDescriptor;
        this.contextKind = contextKind;
        this.parentContext = parentContext;
        this.closure = closure;
        this.thisDescriptor = thisDescriptor;
        this.enclosingLocalLookup = localLookup;
        this.outerExpression = LockBasedStorageManager.NO_LOCKS.createNullableLazyValue(new Function0<StackValue.Field>(){

            @Override
            public StackValue.Field invoke() {
                return CodegenContext.this.computeOuterExpression();
            }
        });
        if (parentContext != null) {
            parentContext.addChild(this);
        }
    }

    @NotNull
    public final ClassDescriptor getThisDescriptor() {
        if (this.thisDescriptor == null) {
            throw new UnsupportedOperationException("Context doesn't have a \"this\": " + this);
        }
        ClassDescriptor classDescriptor = this.thisDescriptor;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "getThisDescriptor"));
        }
        return classDescriptor;
    }

    public final boolean hasThisDescriptor() {
        return this.thisDescriptor != null;
    }

    @NotNull
    public CodegenContext<? extends ClassOrPackageFragmentDescriptor> getClassOrPackageParentContext() {
        CodegenContext context2 = this;
        while (true) {
            if (context2.getContextDescriptor() instanceof ClassOrPackageFragmentDescriptor) {
                CodegenContext codegenContext = context2;
                if (codegenContext == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "getClassOrPackageParentContext"));
                }
                return codegenContext;
            }
            context2 = context2.getParentContext();
            assert (context2 != null) : "Context which is not top-level has no parent: " + this;
        }
    }

    @Nullable
    public final CallableDescriptor getCallableDescriptorWithReceiver() {
        if (this.contextDescriptor instanceof CallableDescriptor) {
            CallableDescriptor callableDescriptor = (CallableDescriptor)this.getContextDescriptor();
            return callableDescriptor.getExtensionReceiverParameter() != null ? callableDescriptor : null;
        }
        return null;
    }

    public StackValue getOuterExpression(@Nullable StackValue prefix, boolean ignoreNoOuter) {
        return this.getOuterExpression(prefix, ignoreNoOuter, true);
    }

    private StackValue getOuterExpression(@Nullable StackValue prefix, boolean ignoreNoOuter, boolean captureThis) {
        if (this.outerExpression.invoke() == null) {
            if (!ignoreNoOuter) {
                throw new UnsupportedOperationException("Don't know how to generate outer expression for " + this.getContextDescriptor());
            }
            return null;
        }
        if (captureThis) {
            if (this.closure == null) {
                throw new IllegalStateException("Can't capture this for context without closure: " + this.getContextDescriptor());
            }
            this.closure.setCaptureThis();
        }
        return StackValue.changeReceiverForFieldAndSharedVar((StackValue.StackValueWithSimpleReceiver)this.outerExpression.invoke(), prefix);
    }

    @NotNull
    public T getContextDescriptor() {
        T t = this.contextDescriptor;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "getContextDescriptor"));
        }
        return t;
    }

    @NotNull
    public OwnerKind getContextKind() {
        OwnerKind ownerKind = this.contextKind;
        if (ownerKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "getContextKind"));
        }
        return ownerKind;
    }

    @NotNull
    public PackageContext intoPackagePart(@NotNull PackageFragmentDescriptor descriptor, Type packagePartType) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoPackagePart"));
        }
        PackageContext packageContext = new PackageContext(descriptor, this, packagePartType);
        if (packageContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoPackagePart"));
        }
        return packageContext;
    }

    @NotNull
    public FieldOwnerContext intoPackageFacade(@NotNull Type delegateTo, @NotNull PackageFragmentDescriptor descriptor) {
        if (delegateTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateTo", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoPackageFacade"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoPackageFacade"));
        }
        PackageFacadeContext packageFacadeContext = new PackageFacadeContext(descriptor, this, delegateTo);
        if (packageFacadeContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoPackageFacade"));
        }
        return packageFacadeContext;
    }

    @NotNull
    public ClassContext intoClass(ClassDescriptor descriptor, OwnerKind kind, GenerationState state) {
        ClassContext classContext = new ClassContext(state.getTypeMapper(), descriptor, kind, this, null);
        if (classContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoClass"));
        }
        return classContext;
    }

    @NotNull
    public ClassContext intoAnonymousClass(@NotNull ClassDescriptor descriptor, @NotNull ExpressionCodegen codegen, @NotNull OwnerKind ownerKind) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoAnonymousClass"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoAnonymousClass"));
        }
        if (ownerKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerKind", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoAnonymousClass"));
        }
        AnonymousClassContext anonymousClassContext = new AnonymousClassContext(codegen.getState().getTypeMapper(), descriptor, ownerKind, this, codegen);
        if (anonymousClassContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoAnonymousClass"));
        }
        return anonymousClassContext;
    }

    @NotNull
    public MethodContext intoFunction(FunctionDescriptor descriptor) {
        MethodContext methodContext = new MethodContext(descriptor, this.getContextKind(), this, null, false);
        if (methodContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoFunction"));
        }
        return methodContext;
    }

    @NotNull
    public MethodContext intoInlinedLambda(FunctionDescriptor descriptor) {
        MethodContext methodContext = new MethodContext(descriptor, this.getContextKind(), this, null, true);
        if (methodContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoInlinedLambda"));
        }
        return methodContext;
    }

    @NotNull
    public ConstructorContext intoConstructor(@NotNull ConstructorDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoConstructor"));
        }
        ConstructorContext constructorContext = new ConstructorContext(descriptor, this.getContextKind(), this, this.closure);
        if (constructorContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoConstructor"));
        }
        return constructorContext;
    }

    @NotNull
    public ScriptContext intoScript(@NotNull ScriptDescriptor script, @NotNull List<ScriptDescriptor> earlierScripts, @NotNull ClassDescriptor classDescriptor) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoScript"));
        }
        if (earlierScripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earlierScripts", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoScript"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoScript"));
        }
        ScriptContext scriptContext = new ScriptContext(script, earlierScripts, classDescriptor, OwnerKind.IMPLEMENTATION, this, this.closure);
        if (scriptContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoScript"));
        }
        return scriptContext;
    }

    @NotNull
    public ClosureContext intoClosure(@NotNull FunctionDescriptor funDescriptor, @NotNull LocalLookup localLookup, @NotNull JetTypeMapper typeMapper) {
        if (funDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "funDescriptor", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoClosure"));
        }
        if (localLookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localLookup", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoClosure"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoClosure"));
        }
        ClosureContext closureContext = new ClosureContext(typeMapper, funDescriptor, this, localLookup);
        if (closureContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "intoClosure"));
        }
        return closureContext;
    }

    @Nullable
    public CodegenContext getParentContext() {
        return this.parentContext;
    }

    public ClassDescriptor getEnclosingClass() {
        CodegenContext cur;
        for (cur = this.getParentContext(); cur != null && !(cur.getContextDescriptor() instanceof ClassDescriptor); cur = cur.getParentContext()) {
        }
        return cur == null ? null : (ClassDescriptor)cur.getContextDescriptor();
    }

    @Nullable
    public CodegenContext findParentContextWithDescriptor(DeclarationDescriptor descriptor) {
        CodegenContext c;
        for (c = this; c != null && c.getContextDescriptor() != descriptor; c = c.getParentContext()) {
        }
        return c;
    }

    @NotNull
    public DeclarationDescriptor getAccessor(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/context/CodegenContext", "getAccessor"));
        }
        DeclarationDescriptor declarationDescriptor = this.getAccessor(descriptor, false, null);
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "getAccessor"));
        }
        return declarationDescriptor;
    }

    @NotNull
    public DeclarationDescriptor getAccessor(@NotNull DeclarationDescriptor descriptor, boolean isForBackingFieldInOuterClass, @Nullable JetType delegateType) {
        DeclarationDescriptor accessor;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/context/CodegenContext", "getAccessor"));
        }
        if (this.accessors == null) {
            this.accessors = new LinkedHashMap<DeclarationDescriptor, DeclarationDescriptor>();
        }
        if ((accessor = this.accessors.get(descriptor = descriptor.getOriginal())) != null) {
            assert (!isForBackingFieldInOuterClass || accessor instanceof AccessorForPropertyBackingFieldInOuterClass) : "There is already exists accessor with isForBackingFieldInOuterClass = false in this context";
            DeclarationDescriptor declarationDescriptor = accessor;
            if (declarationDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "getAccessor"));
            }
            return declarationDescriptor;
        }
        int accessorIndex = this.accessors.size();
        if (descriptor instanceof SimpleFunctionDescriptor || descriptor instanceof ConstructorDescriptor) {
            accessor = new AccessorForFunctionDescriptor((FunctionDescriptor)descriptor, (DeclarationDescriptor)this.contextDescriptor, accessorIndex);
        } else if (descriptor instanceof PropertyDescriptor) {
            accessor = isForBackingFieldInOuterClass ? new AccessorForPropertyBackingFieldInOuterClass((PropertyDescriptor)descriptor, (DeclarationDescriptor)this.contextDescriptor, accessorIndex, delegateType) : new AccessorForPropertyDescriptor((PropertyDescriptor)descriptor, (DeclarationDescriptor)this.contextDescriptor, accessorIndex);
        } else {
            throw new UnsupportedOperationException("Do not know how to create accessor for descriptor " + descriptor);
        }
        this.accessors.put(descriptor, accessor);
        DeclarationDescriptor declarationDescriptor = accessor;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "getAccessor"));
        }
        return declarationDescriptor;
    }

    @Nullable
    protected StackValue.Field computeOuterExpression() {
        return null;
    }

    public StackValue lookupInContext(DeclarationDescriptor d, @Nullable StackValue result2, GenerationState state, boolean ignoreNoOuter) {
        StackValue resultValue;
        StackValue myOuter = null;
        if (this.closure != null) {
            EnclosedValueDescriptor answer = this.closure.getCaptureVariables().get(d);
            if (answer != null) {
                return StackValue.changeReceiverForFieldAndSharedVar(answer.getInnerValue(), result2);
            }
            for (LocalLookup.LocalLookupCase aCase : LocalLookup.LocalLookupCase.values()) {
                if (!aCase.isCase(d)) continue;
                Type classType = state.getTypeMapper().mapType(this.getThisDescriptor());
                StackValue.StackValueWithSimpleReceiver innerValue = aCase.innerValue(d, this.enclosingLocalLookup, state, this.closure, classType);
                if (innerValue == null) break;
                return StackValue.changeReceiverForFieldAndSharedVar(innerValue, result2);
            }
            result2 = myOuter = this.getOuterExpression(result2, ignoreNoOuter, false);
        }
        if (myOuter != null && this.getEnclosingClass() == d) {
            resultValue = result2;
        } else {
            StackValue stackValue = resultValue = this.parentContext != null ? this.parentContext.lookupInContext(d, result2, state, ignoreNoOuter) : null;
        }
        if (myOuter != null && resultValue != null && !CodegenContext.isStaticField(resultValue)) {
            this.closure.setCaptureThis();
        }
        return resultValue;
    }

    @NotNull
    public Map<DeclarationDescriptor, DeclarationDescriptor> getAccessors() {
        Map<Object, Object> map = this.accessors == null ? Collections.emptyMap() : this.accessors;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "getAccessors"));
        }
        return map;
    }

    @NotNull
    public PropertyDescriptor accessiblePropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)this.accessibleDescriptorIfNeeded(propertyDescriptor, true);
        if (propertyDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "accessiblePropertyDescriptor"));
        }
        return propertyDescriptor2;
    }

    @NotNull
    public FunctionDescriptor accessibleFunctionDescriptor(FunctionDescriptor fd) {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.accessibleDescriptorIfNeeded(fd, true);
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "accessibleFunctionDescriptor"));
        }
        return functionDescriptor;
    }

    public void recordSyntheticAccessorIfNeeded(@NotNull FunctionDescriptor fd, @NotNull BindingContext bindingContext) {
        if (fd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fd", "org/jetbrains/kotlin/codegen/context/CodegenContext", "recordSyntheticAccessorIfNeeded"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/context/CodegenContext", "recordSyntheticAccessorIfNeeded"));
        }
        if (fd instanceof ConstructorDescriptor || CodegenContext.needSyntheticAccessorInBindingTrace(fd, bindingContext)) {
            this.accessibleDescriptorIfNeeded(fd, false);
        }
    }

    public void recordSyntheticAccessorIfNeeded(@NotNull PropertyDescriptor propertyDescriptor, @NotNull BindingContext typeMapper) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/context/CodegenContext", "recordSyntheticAccessorIfNeeded"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/context/CodegenContext", "recordSyntheticAccessorIfNeeded"));
        }
        if (CodegenContext.needSyntheticAccessorInBindingTrace(propertyDescriptor, typeMapper)) {
            this.accessibleDescriptorIfNeeded(propertyDescriptor, false);
        }
    }

    private static boolean needSyntheticAccessorInBindingTrace(@NotNull CallableMemberDescriptor descriptor, @NotNull BindingContext bindingContext) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/context/CodegenContext", "needSyntheticAccessorInBindingTrace"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/context/CodegenContext", "needSyntheticAccessorInBindingTrace"));
        }
        return Boolean.TRUE.equals(bindingContext.get(BindingContext.NEED_SYNTHETIC_ACCESSOR, descriptor));
    }

    private static int getAccessFlags(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/context/CodegenContext", "getAccessFlags"));
        }
        int flag = AsmUtil.getVisibilityAccessFlag(descriptor);
        if (descriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
            PropertySetterDescriptor setter = propertyDescriptor.getSetter();
            PropertyGetterDescriptor getter = propertyDescriptor.getGetter();
            flag |= (getter == null ? 0 : AsmUtil.getVisibilityAccessFlag(getter)) | (setter == null ? 0 : AsmUtil.getVisibilityAccessFlag(setter));
        }
        return flag;
    }

    @NotNull
    private MemberDescriptor accessibleDescriptorIfNeeded(CallableMemberDescriptor descriptor, boolean fromOutsideContext) {
        CallableMemberDescriptor unwrappedDescriptor = DescriptorUtils.unwrapFakeOverride(descriptor);
        int flag = CodegenContext.getAccessFlags(unwrappedDescriptor);
        if ((flag & 2) == 0 && (flag & 4) == 0) {
            CallableMemberDescriptor callableMemberDescriptor = descriptor;
            if (callableMemberDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "accessibleDescriptorIfNeeded"));
            }
            return callableMemberDescriptor;
        }
        CodegenContext descriptorContext = null;
        if (!fromOutsideContext || this.getClassOrPackageParentContext().getContextDescriptor() != descriptor.getContainingDeclaration()) {
            DeclarationDescriptor enclosed = descriptor.getContainingDeclaration();
            boolean isDefaultObjectMember = DescriptorUtils.isDefaultObject(enclosed);
            if (this.hasThisDescriptor() && (enclosed != this.getThisDescriptor() || !fromOutsideContext)) {
                for (CodegenContext currentContext = this; currentContext != null; currentContext = currentContext.getParentContext()) {
                    ClassContext classContext;
                    CodegenContext defaultObjectContext;
                    if (currentContext.getContextDescriptor() == enclosed) {
                        descriptorContext = currentContext;
                        break;
                    }
                    if (!isDefaultObjectMember || !(currentContext instanceof ClassContext) || (defaultObjectContext = (classContext = (ClassContext)currentContext).getDefaultObjectContext()) == null || defaultObjectContext.getContextDescriptor() != enclosed) continue;
                    descriptorContext = defaultObjectContext;
                    break;
                }
            }
        }
        if (descriptorContext == null) {
            CallableMemberDescriptor callableMemberDescriptor = descriptor;
            if (callableMemberDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "accessibleDescriptorIfNeeded"));
            }
            return callableMemberDescriptor;
        }
        if ((flag & 4) != 0) {
            boolean inSamePackage;
            PackageFragmentDescriptor unwrappedDescriptorPackage = DescriptorUtils.getParentOfType(unwrappedDescriptor, PackageFragmentDescriptor.class, false);
            PackageFragmentDescriptor contextDescriptorPackage = DescriptorUtils.getParentOfType(descriptorContext.getContextDescriptor(), PackageFragmentDescriptor.class, false);
            boolean bl = inSamePackage = contextDescriptorPackage != null && unwrappedDescriptorPackage != null && unwrappedDescriptorPackage.getFqName().equals(contextDescriptorPackage.getFqName());
            if (inSamePackage) {
                CallableMemberDescriptor callableMemberDescriptor = descriptor;
                if (callableMemberDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "accessibleDescriptorIfNeeded"));
                }
                return callableMemberDescriptor;
            }
        }
        MemberDescriptor memberDescriptor = (MemberDescriptor)descriptorContext.getAccessor(descriptor);
        if (memberDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/CodegenContext", "accessibleDescriptorIfNeeded"));
        }
        return memberDescriptor;
    }

    private void addChild(@NotNull CodegenContext child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/codegen/context/CodegenContext", "addChild"));
        }
        if (this.shouldAddChild(child)) {
            if (this.childContexts == null) {
                this.childContexts = new HashMap<DeclarationDescriptor, CodegenContext>();
            }
            T childContextDescriptor = child.getContextDescriptor();
            this.childContexts.put((DeclarationDescriptor)childContextDescriptor, child);
        }
    }

    protected boolean shouldAddChild(@NotNull CodegenContext child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/codegen/context/CodegenContext", "shouldAddChild"));
        }
        return DescriptorUtils.isDefaultObject(child.contextDescriptor);
    }

    @Nullable
    public CodegenContext findChildContext(@NotNull DeclarationDescriptor child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/codegen/context/CodegenContext", "findChildContext"));
        }
        return this.childContexts == null ? null : this.childContexts.get(child);
    }

    private static boolean isStaticField(@NotNull StackValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/context/CodegenContext", "isStaticField"));
        }
        return value instanceof StackValue.Field && ((StackValue.Field)value).isStaticPut;
    }
}

