/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import com.intellij.psi.PsiElement;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@KotlinClass(abiVersion=20, kind=KotlinClass.Kind.CLASS, data={"<\u0006)A!)\u001b8bef|\u0005OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u001d\u0019w\u000eZ3hK:T!\"\u001b8ue&t7/[2t\u0015=Ie\u000e\u001e:j]NL7-T3uQ>$'B\u0002\u001fj]&$hH\u0003\u0004pa\u000e|G-\u001a\u0006\u0004\u0013:$(\u0002D4f]\u0016\u0014\u0018\r^3J[Bd'\"E#yaJ,7o]5p]\u000e{G-Z4f]*\taO\u0003\nJ]N$(/^2uS>t\u0017\tZ1qi\u0016\u0014(\"C8cU\u0016\u001cGo^3c\u0015\r\t7/\u001c\u0006\bG>lWn\u001c8t\u0015)\u0011X\r^;s]RK\b/\u001a\u0006\u0005)f\u0004XMC\u0004fY\u0016lWM\u001c;\u000b\u0015A\u001b\u0018.\u00127f[\u0016tGOC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0004aNL'\"C1sOVlWM\u001c;t\u0015\u0011a\u0015n\u001d;\u000b\u001b)+G/\u0012=qe\u0016\u001c8/[8o\u0015!\u0011XmY3jm\u0016\u0014(BC*uC\u000e\\g+\u00197vK*!!.\u0019<b\u0015\u0011)H/\u001b7\u000b\u000bMD\u0017N\u001a;\u000b\u000f\t{w\u000e\\3b]R\u000f!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0004\t\tA1\u0001\u0004\u0001\u0006\u0003!\rQa\u0001C\u0004\u0011\u0013a\u0001!B\u0002\u0005\u0004!-A\u0002A\u0003\u0003\t\u0003A\t!\u0002\u0002\u0005\u000b!9QA\u0001C\u0006\u0011\u001f)!\u0001\u0002\u0004\t\u0011\u0015\u0019AQ\u0002E\u0007\u0019\u0001)1\u0001\u0002\u0004\t\u00131\u0001Q!\u0001E\u000b\u000b\t!\u0001\u0002C\u0006\u0006\u0005\u0011E\u0001rC\u0003\u0004\t%A!\u0002\u0004\u0001\u0006\u0007\u0011\u001d\u0001\u0012\u0004\u0007\u0001\u000b\t!\u0011\u0001c\u0006\u0006\u0007\u0011U\u0001\"\u0004\u0007\u0001\u000b\r!\u0019\u0001\u0003\b\r\u0001\u0015\u0011AA\u0002\u0005\n\u000b\t!\u0019\u0001c\u0003\u0006\u0005\u00115\u0001RB\u0003\u0003\t%A!\"B\u0001\t\u001e\u0015\u0011AA\u0004\u0005\u0010\u000b\t!i\u0002#\u0007\u0006\u0005\u0011\r\u0001BD\u0003\u0004\t\u000fA\u0001\u0003\u0004\u0001\u0005\u00071\u0015\u0011DA\u0003\u0002\u0011\ri3\u0002B1\u00051\u0011\t#!B\u0001\t\tU\u001bA!B\u0002\u0005\t%\tAQAWH\u0002\u0011Q\u0001$BO\u0007\t\u0001A!!\u0004\u0002\u0006\u0003!%\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001BB\u0007\u0003\u000b\u0005Aq\u0001UB\u0001;\u001b!\u0001\u0001#\u0005\u000e\u0005\u0015\t\u0001r\u0002)\u0004\u0003u=A\u0001\u0001E\n\u001b\r)\u0011\u0001c\u0005\r\u0002A\u001b\u0019!(\u0006\u0005\u0001!aQBB\u0003\u0002\u0011)I1!\u0003\u0002\u0006\u0003!Y\u0001k\u0001\u0002\u001e\u000e\u0011\u0001\u00012D\u0007\u0003\u000b\u0005A9\u0002UB\u0003C\t)\u0011\u0001c\u0004R\u0007=!Q!C\u0001\t\u00195\t\u0001\u0012D\u0007\u0002\u00115i\u0011\u0001\u0003\u0007\u000e\u0003!mQ\"\u0001\u0005\u0010\u001b\u0005Ay\"l\u0005\u0005\u0003a}\u0011EA\u0003\u0002\u0011A\t6a\u0001C\u0010\u0013\u0005!\t!.\u000b\u0006(\u0011\u0019\u000f\u0001g\u0002\u001e\u000e\u0011\u0001\u0001\u0002B\u0007\u0003\u000b\u0005AA\u0001U\u0002\u0001C\t)\u0011\u0001#\u0002R\u0007\u0015!9!C\u0001\u0005\u00015\tAQ\u0001"})
public final class BinaryOp
extends IntrinsicMethod
implements KObject {
    public static final /* synthetic */ KClass $kotlinClass;
    private final int opcode;

    static {
        $kotlinClass = Reflection.createKotlinClass(BinaryOp.class);
    }

    @NotNull
    protected Type generateImpl(@JetValueParameter(name="codegen") @NotNull ExpressionCodegen codegen, @JetValueParameter(name="v") @NotNull InstructionAdapter v, @JetValueParameter(name="returnType") @NotNull Type returnType, @JetValueParameter(name="element", type="?") @Nullable PsiElement element, @JetValueParameter(name="arguments") @NotNull List<? extends JetExpression> arguments2, @JetValueParameter(name="receiver") @NotNull StackValue receiver) {
        Intrinsics.checkParameterIsNotNull(codegen, "codegen");
        Intrinsics.checkParameterIsNotNull(v, "v");
        Intrinsics.checkParameterIsNotNull(returnType, "returnType");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(receiver, "receiver");
        boolean bl = AsmUtil.isPrimitive(returnType);
        if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
            String string = "Return type of BinaryOp intrinsic should be of primitive type : " + returnType;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Type operandType = AsmUtil.numberFunctionOperandType(returnType);
        if (arguments2.size() == 1) {
            if (Intrinsics.areEqual(receiver, StackValue.none()) ^ true) {
                receiver.put(operandType, v);
            }
            codegen.gen(arguments2.get(0), this.shift() ? Type.INT_TYPE : operandType);
        } else {
            codegen.gen(arguments2.get(0), operandType);
            codegen.gen(arguments2.get(1), this.shift() ? Type.INT_TYPE : operandType);
        }
        v.visitInsn(returnType.getOpcode(this.opcode));
        return returnType;
    }

    private final boolean shift() {
        boolean bl = !(this.opcode == Opcodes.ISHL) ? this.opcode == Opcodes.ISHR : true;
        return !bl ? this.opcode == Opcodes.IUSHR : true;
    }

    public BinaryOp(@JetValueParameter(name="opcode") int opcode) {
        this.opcode = opcode;
    }
}

