/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SubpackagesScope;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.scopes.ChainedScope;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class PackageViewDescriptorImpl
extends DeclarationDescriptorImpl
implements PackageViewDescriptor {
    private final ModuleDescriptor module;
    private final FqName fqName;
    private final JetScope memberScope;

    public PackageViewDescriptorImpl(@NotNull ModuleDescriptor module, @NotNull FqName fqName2, @NotNull List<PackageFragmentDescriptor> fragments) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/descriptors/impl/PackageViewDescriptorImpl", "<init>"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/descriptors/impl/PackageViewDescriptorImpl", "<init>"));
        }
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "org/jetbrains/kotlin/descriptors/impl/PackageViewDescriptorImpl", "<init>"));
        }
        super(Annotations.EMPTY, fqName2.shortNameOrSpecial());
        this.module = module;
        this.fqName = fqName2;
        ArrayList<JetScope> scopes = new ArrayList<JetScope>(fragments.size() + 1);
        assert (!fragments.isEmpty()) : fqName2 + " in " + module;
        for (PackageFragmentDescriptor fragment : fragments) {
            scopes.add(fragment.getMemberScope());
        }
        scopes.add(new SubpackagesScope(this));
        this.memberScope = new ChainedScope(this, "package view scope for " + fqName2 + " in " + module.getName(), scopes.toArray(new JetScope[scopes.size()]));
    }

    @Override
    @Nullable
    public PackageViewDescriptor getContainingDeclaration() {
        return this.fqName.isRoot() ? null : this.module.getPackage(this.fqName.parent());
    }

    @Override
    @Nullable
    public DeclarationDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/descriptors/impl/PackageViewDescriptorImpl", "substitute"));
        }
        return this;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitPackageViewDescriptor(this, data2);
    }

    @Override
    @NotNull
    public FqName getFqName() {
        FqName fqName2 = this.fqName;
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PackageViewDescriptorImpl", "getFqName"));
        }
        return fqName2;
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        JetScope jetScope = this.memberScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PackageViewDescriptorImpl", "getMemberScope"));
        }
        return jetScope;
    }

    @Override
    @NotNull
    public ModuleDescriptor getModule() {
        ModuleDescriptor moduleDescriptor = this.module;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/impl/PackageViewDescriptorImpl", "getModule"));
        }
        return moduleDescriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageViewDescriptorImpl that = (PackageViewDescriptorImpl)o;
        if (!this.fqName.equals(that.fqName)) {
            return false;
        }
        return this.module.equals(that.module);
    }

    public int hashCode() {
        int result2 = this.module.hashCode();
        result2 = 31 * result2 + this.fqName.hashCode();
        return result2;
    }
}

