/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.di;

import com.intellij.openapi.project.Project;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.context.ContextPackage;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.context.LazinessToken;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.resolve.AdditionalCheckerProvider;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.tasks.TaskPrioritizer;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DynamicTypesSettings;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ForLoopConventionsChecker;
import org.jetbrains.kotlin.types.expressions.LocalClassifierAnalyzer;
import org.jetbrains.kotlin.types.reflect.ReflectionTypes;

public class InjectorForMacros {
    private final Project project;
    private final ModuleDescriptor moduleDescriptor;
    private final KotlinBuiltIns kotlinBuiltIns;
    private final PlatformToKotlinClassMap platformToKotlinClassMap;
    private final ExpressionTypingServices expressionTypingServices;
    private final ExpressionTypingComponents expressionTypingComponents;
    private final CallResolver callResolver;
    private final TypeResolver typeResolver;
    private final GlobalContext globalContext;
    private final StorageManager storageManager;
    private final AdditionalCheckerProvider.DefaultProvider defaultProvider;
    private final AnnotationResolver annotationResolver;
    private final CallExpressionResolver callExpressionResolver;
    private final DescriptorResolver descriptorResolver;
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    private final StatementFilter statementFilter;
    private final ControlStructureTypingUtils controlStructureTypingUtils;
    private final DynamicTypesSettings dynamicTypesSettings;
    private final ExpressionTypingUtils expressionTypingUtils;
    private final ForLoopConventionsChecker forLoopConventionsChecker;
    private final LocalClassifierAnalyzer localClassifierAnalyzer;
    private final ReflectionTypes reflectionTypes;
    private final ArgumentTypeResolver argumentTypeResolver;
    private final CallCompleter callCompleter;
    private final CandidateResolver candidateResolver;
    private final TaskPrioritizer taskPrioritizer;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final TypeResolver.FlexibleTypeCapabilitiesProvider flexibleTypeCapabilitiesProvider;
    private final LazinessToken lazinessToken;

    public InjectorForMacros(@NotNull Project project, @NotNull ModuleDescriptor moduleDescriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/di/InjectorForMacros", "<init>"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/kotlin/di/InjectorForMacros", "<init>"));
        }
        this.project = project;
        this.moduleDescriptor = moduleDescriptor;
        this.kotlinBuiltIns = moduleDescriptor.getBuiltIns();
        this.platformToKotlinClassMap = moduleDescriptor.getPlatformToKotlinClassMap();
        this.expressionTypingComponents = new ExpressionTypingComponents();
        this.expressionTypingServices = new ExpressionTypingServices(this.getExpressionTypingComponents());
        this.callResolver = new CallResolver();
        this.annotationResolver = new AnnotationResolver();
        this.qualifiedExpressionResolver = new QualifiedExpressionResolver();
        this.flexibleTypeCapabilitiesProvider = new TypeResolver.FlexibleTypeCapabilitiesProvider();
        this.globalContext = ContextPackage.GlobalContext();
        this.storageManager = this.globalContext.getStorageManager();
        this.lazinessToken = new LazinessToken();
        this.dynamicTypesSettings = new DynamicTypesSettings();
        this.typeResolver = new TypeResolver(this.annotationResolver, this.qualifiedExpressionResolver, moduleDescriptor, this.flexibleTypeCapabilitiesProvider, this.storageManager, this.lazinessToken, this.dynamicTypesSettings);
        this.defaultProvider = AdditionalCheckerProvider.DefaultProvider.INSTANCE$;
        this.callExpressionResolver = new CallExpressionResolver();
        this.descriptorResolver = new DescriptorResolver();
        this.delegatedPropertyResolver = new DelegatedPropertyResolver();
        this.statementFilter = new StatementFilter();
        this.controlStructureTypingUtils = new ControlStructureTypingUtils(this.getExpressionTypingServices());
        this.expressionTypingUtils = new ExpressionTypingUtils(this.getExpressionTypingServices(), this.getCallResolver(), this.kotlinBuiltIns);
        this.forLoopConventionsChecker = new ForLoopConventionsChecker();
        this.localClassifierAnalyzer = new LocalClassifierAnalyzer(this.descriptorResolver, this.getTypeResolver(), this.annotationResolver);
        this.reflectionTypes = new ReflectionTypes(moduleDescriptor);
        this.argumentTypeResolver = new ArgumentTypeResolver();
        this.candidateResolver = new CandidateResolver();
        this.callCompleter = new CallCompleter(this.argumentTypeResolver, this.candidateResolver);
        this.taskPrioritizer = new TaskPrioritizer(this.storageManager);
        this.expressionTypingServices.setAnnotationResolver(this.annotationResolver);
        this.expressionTypingServices.setBuiltIns(this.kotlinBuiltIns);
        this.expressionTypingServices.setCallExpressionResolver(this.callExpressionResolver);
        this.expressionTypingServices.setCallResolver(this.callResolver);
        this.expressionTypingServices.setDescriptorResolver(this.descriptorResolver);
        this.expressionTypingServices.setProject(project);
        this.expressionTypingServices.setStatementFilter(this.statementFilter);
        this.expressionTypingServices.setTypeResolver(this.typeResolver);
        this.expressionTypingComponents.setAdditionalCheckerProvider(this.defaultProvider);
        this.expressionTypingComponents.setBuiltIns(this.kotlinBuiltIns);
        this.expressionTypingComponents.setCallResolver(this.callResolver);
        this.expressionTypingComponents.setControlStructureTypingUtils(this.controlStructureTypingUtils);
        this.expressionTypingComponents.setDynamicTypesSettings(this.dynamicTypesSettings);
        this.expressionTypingComponents.setExpressionTypingServices(this.expressionTypingServices);
        this.expressionTypingComponents.setExpressionTypingUtils(this.expressionTypingUtils);
        this.expressionTypingComponents.setForLoopConventionsChecker(this.forLoopConventionsChecker);
        this.expressionTypingComponents.setGlobalContext(this.globalContext);
        this.expressionTypingComponents.setLocalClassifierAnalyzer(this.localClassifierAnalyzer);
        this.expressionTypingComponents.setPlatformToKotlinClassMap(this.platformToKotlinClassMap);
        this.expressionTypingComponents.setReflectionTypes(this.reflectionTypes);
        this.callResolver.setArgumentTypeResolver(this.argumentTypeResolver);
        this.callResolver.setCallCompleter(this.callCompleter);
        this.callResolver.setCandidateResolver(this.candidateResolver);
        this.callResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.callResolver.setTaskPrioritizer(this.taskPrioritizer);
        this.callResolver.setTypeResolver(this.typeResolver);
        this.annotationResolver.setCallResolver(this.callResolver);
        this.annotationResolver.setStorageManager(this.storageManager);
        this.annotationResolver.setTypeResolver(this.typeResolver);
        this.callExpressionResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.descriptorResolver.setAnnotationResolver(this.annotationResolver);
        this.descriptorResolver.setBuiltIns(this.kotlinBuiltIns);
        this.descriptorResolver.setDelegatedPropertyResolver(this.delegatedPropertyResolver);
        this.descriptorResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.descriptorResolver.setStorageManager(this.storageManager);
        this.descriptorResolver.setTypeResolver(this.typeResolver);
        this.delegatedPropertyResolver.setBuiltIns(this.kotlinBuiltIns);
        this.delegatedPropertyResolver.setCallResolver(this.callResolver);
        this.delegatedPropertyResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.forLoopConventionsChecker.setBuiltIns(this.kotlinBuiltIns);
        this.forLoopConventionsChecker.setExpressionTypingServices(this.expressionTypingServices);
        this.forLoopConventionsChecker.setExpressionTypingUtils(this.expressionTypingUtils);
        this.forLoopConventionsChecker.setProject(project);
        this.argumentTypeResolver.setBuiltIns(this.kotlinBuiltIns);
        this.argumentTypeResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.argumentTypeResolver.setTypeResolver(this.typeResolver);
        this.candidateResolver.setArgumentTypeResolver(this.argumentTypeResolver);
    }

    @PreDestroy
    public void destroy() {
    }

    public ExpressionTypingServices getExpressionTypingServices() {
        return this.expressionTypingServices;
    }

    public ExpressionTypingComponents getExpressionTypingComponents() {
        return this.expressionTypingComponents;
    }

    public CallResolver getCallResolver() {
        return this.callResolver;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }
}

