/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Function1;
import kotlin.Function2;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.config.Config;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.utils.LibraryUtils;

public class LibrarySourcesConfig
extends Config {
    @NotNull
    public static final Key<String> EXTERNAL_MODULE_NAME = Key.create("externalModule");
    @NotNull
    public static final String UNKNOWN_EXTERNAL_MODULE_NAME = "<unknown>";
    public static final String STDLIB_JS_MODULE_NAME = "stdlib";
    public static final String BUILTINS_JS_MODULE_NAME = "builtins";
    public static final String BUILTINS_JS_FILE_NAME = "builtins.js";
    public static final String STDLIB_JS_FILE_NAME = "stdlib.js";
    @NotNull
    private final List<String> files;

    public LibrarySourcesConfig(@NotNull Project project, @NotNull String moduleId, @NotNull List<String> files, @NotNull EcmaVersion ecmaVersion, boolean sourcemap, boolean inlineEnabled) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "<init>"));
        }
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "<init>"));
        }
        if (ecmaVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ecmaVersion", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "<init>"));
        }
        super(project, moduleId, ecmaVersion, sourcemap, inlineEnabled);
        this.files = files;
    }

    @Override
    @NotNull
    protected List<JetFile> generateLibFiles() {
        if (this.files.isEmpty()) {
            List<JetFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "generateLibFiles"));
            }
            return list;
        }
        final ArrayList<JetFile> jetFiles = new ArrayList<JetFile>();
        final PsiManager psiManager = PsiManager.getInstance(this.getProject());
        Function1<String, Unit> report2 = new Function1<String, Unit>(){

            @Override
            public Unit invoke(String message) {
                throw new IllegalStateException(message);
            }
        };
        Function2<String, VirtualFile, Unit> action = new Function2<String, VirtualFile, Unit>(){

            @Override
            public Unit invoke(String moduleName, VirtualFile file) {
                JetFileCollector jetFileCollector = new JetFileCollector(jetFiles, moduleName, psiManager);
                VfsUtilCore.visitChildrenRecursively(file, jetFileCollector);
                return Unit.INSTANCE$;
            }
        };
        boolean hasErrors = this.checkLibFilesAndReportErrors(report2, action);
        assert (!hasErrors) : "hasErrors should be false";
        ArrayList<JetFile> arrayList = jetFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "generateLibFiles"));
        }
        return arrayList;
    }

    @Override
    public boolean checkLibFilesAndReportErrors(@NotNull Function1<String, Unit> report2) {
        if (report2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "checkLibFilesAndReportErrors"));
        }
        return this.checkLibFilesAndReportErrors(report2, null);
    }

    private boolean checkLibFilesAndReportErrors(@NotNull Function1<String, Unit> report2, @Nullable Function2<String, VirtualFile, Unit> action) {
        if (report2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "report", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig", "checkLibFilesAndReportErrors"));
        }
        if (this.files.isEmpty()) {
            return false;
        }
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        VirtualFileSystem jarFileSystem = VirtualFileManager.getInstance().getFileSystem("jar");
        String moduleName = null;
        for (String path : this.files) {
            String actualModuleName = moduleName;
            if (path.charAt(0) == '@') {
                moduleName = path.substring(1);
                continue;
            }
            File filePath = new File(path);
            if (!filePath.exists()) {
                report2.invoke("Path '" + path + "'does not exist");
                return true;
            }
            VirtualFile file = path.endsWith(".jar") || path.endsWith(".zip") ? jarFileSystem.findFileByPath(path + "!/") : fileSystem.findFileByPath(path);
            if (file == null) {
                report2.invoke("File '" + path + "'does not exist or could not be read");
                return true;
            }
            if (LibraryUtils.isKotlinJavascriptStdLibrary(filePath)) {
                actualModuleName = STDLIB_JS_MODULE_NAME;
            } else if (LibraryUtils.isKotlinJavascriptLibrary(filePath)) {
                actualModuleName = LibraryUtils.getKotlinJsModuleName(filePath);
            } else if (actualModuleName == null) {
                report2.invoke("'" + path + "' is not a valid Kotlin Javascript library");
                return true;
            }
            if (actualModuleName == null) {
                report2.invoke("Could not find Kotlin-JS-Module-Name for '" + path + "'");
                return true;
            }
            if (action != null) {
                action.invoke(actualModuleName, file);
            }
            moduleName = null;
        }
        return false;
    }

    protected JetFile getJetFileByVirtualFile(VirtualFile file, String moduleName, PsiManager psiManager) {
        PsiFile psiFile = psiManager.findFile(file);
        assert (psiFile != null);
        LibrarySourcesConfig.setupPsiFile(psiFile, moduleName);
        return (JetFile)psiFile;
    }

    protected static void setupPsiFile(PsiFile psiFile, String moduleName) {
        psiFile.putUserData(EXTERNAL_MODULE_NAME, moduleName);
    }

    private class JetFileCollector
    extends VirtualFileVisitor {
        private final List<JetFile> jetFiles;
        private final String moduleName;
        private final PsiManager psiManager;

        private JetFileCollector(List<JetFile> files, String name, PsiManager manager) {
            super(new VirtualFileVisitor.Option[0]);
            this.moduleName = name;
            this.psiManager = manager;
            this.jetFiles = files;
        }

        @Override
        public boolean visitFile(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/js/config/LibrarySourcesConfig$JetFileCollector", "visitFile"));
            }
            if (!file.isDirectory() && StringUtil.notNullize(file.getExtension()).equalsIgnoreCase("kt")) {
                this.jetFiles.add(LibrarySourcesConfig.this.getJetFileByVirtualFile(file, this.moduleName, this.psiManager));
            }
            return true;
        }
    }
}

