/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.translate.context.generator.Rule;

public class Generator<V> {
    @NotNull
    private final Map<DeclarationDescriptor, V> values = Maps.newHashMap();
    @NotNull
    private final List<Rule<V>> rules = Lists.newArrayList();

    public void addRule(@NotNull Rule<V> rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "org/jetbrains/kotlin/js/translate/context/generator/Generator", "addRule"));
        }
        this.rules.add(rule);
    }

    @Nullable
    public V get(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/generator/Generator", "get"));
        }
        V result2 = this.values.get(descriptor);
        if (result2 != null) {
            return result2;
        }
        result2 = this.generate(descriptor);
        this.values.put(descriptor, result2);
        return result2;
    }

    @Nullable
    private V generate(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/generator/Generator", "generate"));
        }
        for (Rule<V> rule : this.rules) {
            V result2 = rule.apply(descriptor);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }
}

