/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import gnu.trove.THashMap;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.CompareToBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.EqualsBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.LongCompareToBOIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.NO_INTRINSIC;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.psi.JetBinaryExpression;

@KotlinClass(abiVersion=20, kind=KotlinClass.Kind.CLASS, data={"9\b)I\")\u001b8bef|\u0005/\u001a:bi&|g.\u00138ue&t7/[2t\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'B\u00016t\u0015%!(/\u00198tY\u0006$XMC\u0005j]R\u0014\u0018N\\:jG*Iq\u000e]3sCRLwN\u001c\u0006\u0004\u0003:L(B\u0002\u001fj]&$hHC\u0005gC\u000e$xN]5fg*!A*[:u\u0015}\u0011\u0015N\\1ss>\u0003XM]1uS>t\u0017J\u001c;sS:\u001c\u0018n\u0019$bGR|'/\u001f\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'BD5oiJLgn]5d\u0007\u0006\u001c\u0007.\u001a\u0006\t)\"\u000b7\u000f['ba*\u0019qM\\;\u000b\u000bQ\u0014xN^3\u000b\tA\u000b\u0017N\u001d\u0006\t\u0015\u0016$Hk\\6f]*)A.\u001a=fe*\u0011b)\u001e8di&|g\u000eR3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b1\tKg.\u0019:z\u001fB,'/\u0019;j_:Le\u000e\u001e:j]NL7M\u0003\rd_6\u0004X\u000f^3B]\u0012\u001c\u0015m\u00195f\u0013:$(/\u001b8tS\u000eTQ\u0001^8lK:T!\u0002Z3tGJL\u0007\u000f^8s\u0015A\u0019w.\u001c9vi\u0016Le\u000e\u001e:j]NL7M\u0003\u0007hKRLe\u000e\u001e:j]NL7M\u0003\u0006fqB\u0014Xm]:j_:T1CS3u\u0005&t\u0017M]=FqB\u0014Xm]:j_:T1\u0001]:j\u0015\u001d\u0019wN\u001c;fqRT!\u0003\u0016:b]Nd\u0017\r^5p]\u000e{g\u000e^3yi*YAn\\8l+B\u001c\u0015m\u00195f5\bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015QA\u0001\u0003\u0003\u0011\r)!\u0001\"\u0002\t\b\u0015\u0019Aa\u0001\u0005\u0001\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011!\u0001\u0002\u0002\u0007\u0001\u000b\r!A\u0001c\u0003\r\u0001\u0015\u0019Aa\u0001\u0005\u0007\u0019\u0001)\u0011\u0001#\u0004\u0006\u0005\u00111\u0001bB\u0003\u0003\t\u001bAY!B\u0001\t\u0012\u0015\u0011Aq\u0002\u0005\n\u000b\r!\u0001\u0002\u0003\u0005\r\u0001\u0015\u0019A\u0001\u0002E\n\u0019\u0001)!\u0001B\u0001\t\u0016\u0015\u0019A1\u0003\u0005\u000b\u0019\u0001)!\u0001B\u0001\t\u0018\u0015\u0019AQ\u0003\u0005\f\u0019\u0001)1\u0001B\u0002\t\u00191\u0001QA\u0001\u0003\t\u0011!)!\u0001B\u0002\t\u0019\u0015\u0011A1\u0003\u0005\u000b\u000b\t!)\u0002C\u0006\u0006\u0005\u0011\t\u0001\u0002E\u0003\u0004\t9Ay\u0002\u0004\u0001\u0006\u0005\u0011\u0011\u0001\u0012E\u0003\u0004\t=A\u0011\u0003\u0004\u0001\u0006\u0005\u0011q\u0001rD\u0003\u0003\t=A\u0011\u0003B\u0002\r\be\u0011Q!\u0001E\u0005[=!\u0011\r\u0002\r\u0006C\u0019)\u0011\u0001C\u0003\n\u0007%\u0011Q!\u0001E\u0006+\u000e!Qa\u0001\u0003\u0006\u0013\u0005Aq!L\u000e\u0005C\u0012Az!\t\n\u0006\u0003!E\u0011bC\u0005\u000b\u000b\u0005A\u0011\"C\u0002\n\u0005\u0015\t\u0001BC\u0005\u0004\u0013\t)\u0011\u0001C\u0006\n\u0007%\u0011Q!\u0001E\f+\u000e!Qa\u0001C\b\u0013\u0005AA\",\u000f\u0005\u0003aeQT\u0002\u0003\u0001\u00115i!!B\u0001\t\u0015A\u001b\u0001!(\u0004\u0005\u0001!mQBA\u0003\u0002\u0011-\u00016\u0011A\u0011\u0003\u000b\u0005A9\"U\u0002\b\t3I\u0011\u0001#\u0007\u000e\u0003!iQ\"\u0001E\u000e[s!\u0011\u0001\u0007\b\u001e\u000e\u0011\u0001\u0001\"D\u0007\u0003\u000b\u0005A!\u0002U\u0002\u0001;\u001b!\u0001\u0001c\u0007\u000e\u0005\u0015\t\u0001b\u0003)\u0004\u0002\u0005\u0012Q!\u0001E\f#\u000e9AAD\u0005\u0002\u00113i\u0011\u0001C\u0007\u000e\u0003!mQ\u0016\b\u0003\u00041;ij\u0001\u0002\u0001\t\u001f5\u0011Q!\u0001E\u000f!\u000e\u0001QT\u0002\u0003\u0001\u0011Ci!!B\u0001\t A\u001b\t!\t\u0002\u0006\u0003!]\u0011kA\u0004\u0005\u001e%\t\u0001\u0012D\u0007\u0002\u0011Ai\u0011\u0001#\t.<\u0011\t\u00014EO\u0007\t\u0001AQ\"\u0004\u0002\u0006\u0003!Q\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u00012D\u0007\u0003\u000b\u0005A1\u0002UB\u0001C\r)\u0011\u0001c\u0006\r\u0002E\u001bq\u0001b\t\n\u0003!eQ\"\u0001\u0005\u000e\u001b\u0005AY\"N\u0006\u0006\u0015\u0011\u0019\u000f\u0001'\u0003\"\u0005\u0015\t\u0001rA)\u0004\u0007\u0011%\u0011\"\u0001\u0003\u0001"})
public final class BinaryOperationIntrinsics
implements KObject {
    public static final /* synthetic */ KClass $kotlinClass;
    private final THashMap<Pair<? extends JetToken, ? extends FunctionDescriptor>, BinaryOperationIntrinsic> intrinsicCache = new THashMap();
    private final List<? extends BinaryOperationIntrinsicFactory> factories = KotlinPackage.listOf(LongCompareToBOIF.INSTANCE$, EqualsBOIF.INSTANCE$, CompareToBOIF.INSTANCE$);

    static {
        $kotlinClass = Reflection.createKotlinClass(BinaryOperationIntrinsics.class);
    }

    @NotNull
    public final BinaryOperationIntrinsic getIntrinsic(@JetValueParameter(name="expression") @NotNull JetBinaryExpression expression, @JetValueParameter(name="context") @NotNull TranslationContext context2) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        JetToken token = PsiUtils.getOperationToken(expression);
        CallableDescriptor descriptor = BindingUtils.getCallableDescriptorForOperationExpression(context2.bindingContext(), expression);
        boolean bl = !(descriptor == null) ? !(descriptor instanceof FunctionDescriptor) : true;
        if (bl) {
            return NO_INTRINSIC.INSTANCE$;
        }
        JetToken jetToken = token;
        Intrinsics.checkExpressionValueIsNotNull(jetToken, "token");
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "descriptor");
        BinaryOperationIntrinsic binaryOperationIntrinsic = this.lookUpCache(jetToken, functionDescriptor);
        if (binaryOperationIntrinsic == null) {
            JetToken jetToken2 = token;
            Intrinsics.checkExpressionValueIsNotNull(jetToken2, "token");
            FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)descriptor;
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor2, "descriptor");
            binaryOperationIntrinsic = this.computeAndCacheIntrinsic(jetToken2, functionDescriptor2);
        }
        return binaryOperationIntrinsic;
    }

    private final BinaryOperationIntrinsic lookUpCache(@JetValueParameter(name="token") JetToken token, @JetValueParameter(name="descriptor") FunctionDescriptor descriptor) {
        return this.intrinsicCache.get(new Pair<JetToken, FunctionDescriptor>(token, descriptor));
    }

    private final BinaryOperationIntrinsic computeAndCacheIntrinsic(@JetValueParameter(name="token") JetToken token, @JetValueParameter(name="descriptor") FunctionDescriptor descriptor) {
        BinaryOperationIntrinsic result2 = this.computeIntrinsic(token, descriptor);
        this.intrinsicCache.put(new Pair<JetToken, FunctionDescriptor>(token, descriptor), result2);
        return result2;
    }

    private final BinaryOperationIntrinsic computeIntrinsic(@JetValueParameter(name="token") JetToken token, @JetValueParameter(name="descriptor") FunctionDescriptor descriptor) {
        for (BinaryOperationIntrinsicFactory binaryOperationIntrinsicFactory : this.factories) {
            BinaryOperationIntrinsic intrinsic;
            if (!binaryOperationIntrinsicFactory.getSupportTokens().contains(token) || !((intrinsic = binaryOperationIntrinsicFactory.getIntrinsic(descriptor)) != null)) continue;
            return intrinsic;
        }
        return NO_INTRINSIC.INSTANCE$;
    }
}

