/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.intellij.util.SmartList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;

public class CallArgumentTranslator
extends AbstractTranslator {
    @NotNull
    private final ResolvedCall<?> resolvedCall;
    @Nullable
    private final JsExpression receiver;
    private final boolean isNativeFunctionCall;

    @NotNull
    public static ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall, @Nullable JsExpression receiver, @NotNull TranslationContext context2) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translate"));
        }
        ArgumentsInfo argumentsInfo = CallArgumentTranslator.translate(resolvedCall, receiver, context2, context2.dynamicContext().jsBlock());
        if (argumentsInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translate"));
        }
        return argumentsInfo;
    }

    @NotNull
    public static ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall, @Nullable JsExpression receiver, @NotNull TranslationContext context2, @NotNull JsBlock block) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translate"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translate"));
        }
        TranslationContext innerContext = context2.innerBlock(block);
        CallArgumentTranslator argumentTranslator = new CallArgumentTranslator(resolvedCall, receiver, innerContext);
        ArgumentsInfo result2 = argumentTranslator.translate();
        context2.moveVarsFrom(innerContext);
        ArgumentsInfo argumentsInfo = result2;
        if (argumentsInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translate"));
        }
        return argumentsInfo;
    }

    @NotNull
    private static ArgumentsKind translateSingleArgument(@NotNull ResolvedValueArgument actualArgument, @NotNull List<JsExpression> result2, @NotNull TranslationContext context2) {
        if (actualArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualArgument", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
        }
        List<ValueArgument> valueArguments2 = actualArgument.getArguments();
        if (actualArgument instanceof DefaultValueArgument) {
            result2.add(context2.namer().getUndefinedExpression());
            ArgumentsKind argumentsKind = ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
            if (argumentsKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
            }
            return argumentsKind;
        }
        assert (actualArgument instanceof ExpressionValueArgument);
        assert (valueArguments2.size() == 1);
        JetExpression argumentExpression = valueArguments2.get(0).getArgumentExpression();
        assert (argumentExpression != null);
        JsExpression jsExpression = Translation.translateAsExpression(argumentExpression, context2);
        result2.add(jsExpression);
        if (JsAstUtils.isEmptyExpression(jsExpression)) {
            ArgumentsKind argumentsKind = ArgumentsKind.HAS_EMPTY_EXPRESSION_ARGUMENT;
            if (argumentsKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
            }
            return argumentsKind;
        }
        ArgumentsKind argumentsKind = ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
        if (argumentsKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translateSingleArgument"));
        }
        return argumentsKind;
    }

    @NotNull
    private static ArgumentsKind translateVarargArgument(@NotNull List<ValueArgument> arguments2, @NotNull List<JsExpression> result2, @NotNull TranslationContext context2, boolean shouldWrapVarargInArray) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translateVarargArgument"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translateVarargArgument"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translateVarargArgument"));
        }
        if (arguments2.isEmpty()) {
            if (shouldWrapVarargInArray) {
                result2.add(new JsArrayLiteral(Collections.<JsExpression>emptyList()));
            }
            ArgumentsKind argumentsKind = ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
            if (argumentsKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translateVarargArgument"));
            }
            return argumentsKind;
        }
        List<JsExpression> list = shouldWrapVarargInArray ? (arguments2.size() == 1 ? new SmartList() : new ArrayList(arguments2.size())) : result2;
        ArgumentsKind resultKind = CallArgumentTranslator.translateValueArguments(arguments2, list, context2);
        if (shouldWrapVarargInArray) {
            List<JsExpression> concatArguments = CallArgumentTranslator.prepareConcatArguments(arguments2, list);
            JsExpression concatExpression = CallArgumentTranslator.concatArgumentsIfNeeded(concatArguments);
            result2.add(concatExpression);
        }
        ArgumentsKind argumentsKind = resultKind;
        if (argumentsKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translateVarargArgument"));
        }
        return argumentsKind;
    }

    private static ArgumentsKind translateValueArguments(@NotNull List<ValueArgument> arguments2, @NotNull List<JsExpression> list, @NotNull TranslationContext context2) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translateValueArguments"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translateValueArguments"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "translateValueArguments"));
        }
        ArgumentsKind resultKind = ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
        SmartList<TranslationContext> argContexts = new SmartList<TranslationContext>();
        boolean argumentsShouldBeExtractedToTmpVars = false;
        for (ValueArgument argument : arguments2) {
            JetExpression argumentExpression = argument.getArgumentExpression();
            assert (argumentExpression != null);
            TranslationContext argContext = context2.innerBlock();
            JsExpression argExpression = Translation.translateAsExpression(argumentExpression, argContext);
            list.add(argExpression);
            context2.moveVarsFrom(argContext);
            argContexts.add(argContext);
            boolean bl = argumentsShouldBeExtractedToTmpVars = argumentsShouldBeExtractedToTmpVars || !argContext.currentBlockIsEmpty();
            if (!JsAstUtils.isEmptyExpression(argExpression)) continue;
            resultKind = ArgumentsKind.HAS_EMPTY_EXPRESSION_ARGUMENT;
            break;
        }
        if (argumentsShouldBeExtractedToTmpVars) {
            CallArgumentTranslator.extractArguments(list, argContexts, context2, resultKind == ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT);
        }
        return resultKind;
    }

    @NotNull
    private static JsExpression concatArgumentsIfNeeded(@NotNull List<JsExpression> concatArguments) {
        if (concatArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "concatArguments", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "concatArgumentsIfNeeded"));
        }
        assert (concatArguments.size() > 0) : "concatArguments.size should not be 0";
        if (concatArguments.size() > 1) {
            JsInvocation jsInvocation = new JsInvocation((JsExpression)new JsNameRef("concat", concatArguments.get(0)), concatArguments.subList(1, concatArguments.size()));
            if (jsInvocation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "concatArgumentsIfNeeded"));
            }
            return jsInvocation;
        }
        JsExpression jsExpression = concatArguments.get(0);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "concatArgumentsIfNeeded"));
        }
        return jsExpression;
    }

    @NotNull
    private static List<JsExpression> prepareConcatArguments(@NotNull List<ValueArgument> arguments2, @NotNull List<JsExpression> list) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "prepareConcatArguments"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "prepareConcatArguments"));
        }
        assert (arguments2.size() != 0) : "arguments.size should not be 0";
        assert (arguments2.size() == list.size()) : "arguments.size: " + arguments2.size() + " != list.size: " + list.size();
        SmartList<JsExpression> concatArguments = new SmartList<JsExpression>();
        SmartList<JsExpression> lastArrayContent = new SmartList<JsExpression>();
        int size = arguments2.size();
        for (int index2 = 0; index2 < size; ++index2) {
            ValueArgument valueArgument = arguments2.get(index2);
            JsExpression expressionArgument = list.get(index2);
            if (valueArgument.getSpreadElement() != null) {
                if (lastArrayContent.size() > 0) {
                    concatArguments.add(new JsArrayLiteral(lastArrayContent));
                    concatArguments.add(expressionArgument);
                    lastArrayContent = new SmartList();
                    continue;
                }
                concatArguments.add(expressionArgument);
                continue;
            }
            lastArrayContent.add(expressionArgument);
        }
        if (lastArrayContent.size() > 0) {
            concatArguments.add(new JsArrayLiteral(lastArrayContent));
        }
        SmartList<JsExpression> smartList = concatArguments;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "prepareConcatArguments"));
        }
        return smartList;
    }

    private static void extractArguments(@NotNull List<JsExpression> argExpressions, @NotNull List<TranslationContext> argContexts, @NotNull TranslationContext context2, boolean toTmpVars) {
        if (argExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argExpressions", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "extractArguments"));
        }
        if (argContexts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argContexts", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "extractArguments"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "extractArguments"));
        }
        for (int i = 0; i < argExpressions.size(); ++i) {
            TranslationContext argContext = argContexts.get(i);
            JsExpression jsArgExpression = argExpressions.get(i);
            if (argContext.currentBlockIsEmpty() && TranslationUtils.isCacheNeeded(jsArgExpression)) {
                if (toTmpVars) {
                    TemporaryVariable temporaryVariable = context2.declareTemporary(jsArgExpression);
                    context2.addStatementToCurrentBlock(temporaryVariable.assignmentExpression().makeStmt());
                    argExpressions.set(i, temporaryVariable.reference());
                    continue;
                }
                context2.addStatementToCurrentBlock(jsArgExpression.makeStmt());
                continue;
            }
            context2.addStatementsToCurrentBlockFrom(argContext);
        }
    }

    private CallArgumentTranslator(@NotNull ResolvedCall<?> resolvedCall, @Nullable JsExpression receiver, @NotNull TranslationContext context2) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "<init>"));
        }
        super(context2);
        this.resolvedCall = resolvedCall;
        this.receiver = receiver;
        this.isNativeFunctionCall = AnnotationsUtils.isNativeObject(resolvedCall.getCandidateDescriptor());
    }

    private void removeLastUndefinedArguments(@NotNull List<JsExpression> result2) {
        int i;
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator", "removeLastUndefinedArguments"));
        }
        for (i = result2.size() - 1; i >= 0 && result2.get(i) == this.context().namer().getUndefinedExpression(); --i) {
        }
        result2.subList(i + 1, result2.size()).clear();
    }

    private ArgumentsInfo translate() {
        List<ValueParameterDescriptor> valueParameters = this.resolvedCall.getResultingDescriptor().getValueParameters();
        if (valueParameters.isEmpty()) {
            return new ArgumentsInfo(Collections.<JsExpression>emptyList(), false, null);
        }
        boolean hasSpreadOperator = false;
        TemporaryConstVariable cachedReceiver = null;
        AbstractList result2 = new ArrayList<JsExpression>(valueParameters.size());
        List<ResolvedValueArgument> valueArgumentsByIndex = this.resolvedCall.getValueArgumentsByIndex();
        if (valueArgumentsByIndex == null) {
            throw new IllegalStateException("Failed to arrange value arguments by index: " + this.resolvedCall.getResultingDescriptor());
        }
        List argsBeforeVararg = null;
        boolean argumentsShouldBeExtractedToTmpVars = false;
        SmartList<TranslationContext> argContexts = new SmartList<TranslationContext>();
        ArgumentsKind kind = ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
        List<JsExpression> concatArguments = null;
        for (ValueParameterDescriptor parameterDescriptor : valueParameters) {
            ResolvedValueArgument actualArgument = valueArgumentsByIndex.get(parameterDescriptor.getIndex());
            TranslationContext argContext = this.context().innerBlock();
            if (actualArgument instanceof VarargValueArgument) {
                List<ValueArgument> arguments2 = actualArgument.getArguments();
                int size = arguments2.size();
                for (int i = 0; i != size; ++i) {
                    if (arguments2.get(i).getSpreadElement() == null) continue;
                    hasSpreadOperator = true;
                    break;
                }
                if (hasSpreadOperator) {
                    if (this.isNativeFunctionCall) {
                        argsBeforeVararg = result2;
                        result2 = new SmartList();
                        SmartList<JsExpression> list = new SmartList<JsExpression>();
                        kind = CallArgumentTranslator.translateValueArguments(arguments2, list, argContext);
                        concatArguments = CallArgumentTranslator.prepareConcatArguments(arguments2, list);
                    } else {
                        kind = CallArgumentTranslator.translateVarargArgument(arguments2, result2, argContext, size > 1);
                    }
                } else {
                    kind = CallArgumentTranslator.translateVarargArgument(arguments2, result2, argContext, !this.isNativeFunctionCall);
                }
            } else {
                kind = CallArgumentTranslator.translateSingleArgument(actualArgument, result2, argContext);
            }
            this.context().moveVarsFrom(argContext);
            argContexts.add(argContext);
            boolean bl = argumentsShouldBeExtractedToTmpVars = argumentsShouldBeExtractedToTmpVars || !argContext.currentBlockIsEmpty();
            if (kind != ArgumentsKind.HAS_EMPTY_EXPRESSION_ARGUMENT) continue;
            break;
        }
        if (argumentsShouldBeExtractedToTmpVars) {
            CallArgumentTranslator.extractArguments(result2, argContexts, this.context(), kind == ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT);
        }
        if (this.isNativeFunctionCall && hasSpreadOperator) {
            assert (argsBeforeVararg != null) : "argsBeforeVararg should not be null";
            assert (concatArguments != null) : "concatArguments should not be null";
            concatArguments.addAll(result2);
            if (!argsBeforeVararg.isEmpty()) {
                concatArguments.add(0, new JsArrayLiteral(argsBeforeVararg));
            }
            result2 = new SmartList<JsExpression>(CallArgumentTranslator.concatArgumentsIfNeeded(concatArguments));
            if (this.receiver != null) {
                cachedReceiver = this.context().getOrDeclareTemporaryConstVariable(this.receiver);
                result2.add(0, cachedReceiver.reference());
            } else {
                result2.add(0, (JsExpression)JsLiteral.NULL);
            }
        }
        this.removeLastUndefinedArguments(result2);
        return new ArgumentsInfo(result2, hasSpreadOperator, cachedReceiver);
    }

    private static enum ArgumentsKind {
        HAS_EMPTY_EXPRESSION_ARGUMENT,
        HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;

    }

    public static class ArgumentsInfo {
        private final List<JsExpression> translateArguments;
        private final boolean hasSpreadOperator;
        private final TemporaryConstVariable cachedReceiver;

        public ArgumentsInfo(List<JsExpression> arguments2, boolean operator, TemporaryConstVariable receiver) {
            this.translateArguments = arguments2;
            this.hasSpreadOperator = operator;
            this.cachedReceiver = receiver;
        }

        @NotNull
        public List<JsExpression> getTranslateArguments() {
            List<JsExpression> list = this.translateArguments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo", "getTranslateArguments"));
            }
            return list;
        }

        public boolean isHasSpreadOperator() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public TemporaryConstVariable getCachedReceiver() {
            return this.cachedReceiver;
        }
    }
}

