/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.intrinsic.objects.ObjectIntrinsic;
import org.jetbrains.kotlin.js.translate.reference.CachedAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public class DefaultObjectAccessTranslator
extends AbstractTranslator
implements CachedAccessTranslator {
    @NotNull
    private final JsExpression referenceToDefaultObject;

    @NotNull
    static DefaultObjectAccessTranslator newInstance(@NotNull JetSimpleNameExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "newInstance"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "newInstance"));
        }
        DeclarationDescriptor referenceDescriptor = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), expression);
        assert (referenceDescriptor != null) : "JetSimpleName expression must reference a descriptor " + expression.getText();
        DefaultObjectAccessTranslator defaultObjectAccessTranslator = new DefaultObjectAccessTranslator(referenceDescriptor, context2);
        if (defaultObjectAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "newInstance"));
        }
        return defaultObjectAccessTranslator;
    }

    static boolean isDefaultObjectReference(@NotNull JetReferenceExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "isDefaultObjectReference"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "isDefaultObjectReference"));
        }
        DeclarationDescriptor descriptor = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), expression);
        return descriptor instanceof ClassDescriptor && !AnnotationsUtils.isNativeObject(descriptor);
    }

    private DefaultObjectAccessTranslator(@NotNull DeclarationDescriptor descriptor, @NotNull TranslationContext context2) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "<init>"));
        }
        super(context2);
        this.referenceToDefaultObject = DefaultObjectAccessTranslator.generateReferenceToDefaultObject(descriptor, context2);
    }

    @NotNull
    private static JsExpression generateReferenceToDefaultObject(@NotNull DeclarationDescriptor descriptor, @NotNull TranslationContext context2) {
        ObjectIntrinsic objectIntrinsic;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "generateReferenceToDefaultObject"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "generateReferenceToDefaultObject"));
        }
        if (descriptor instanceof ClassDescriptor && (objectIntrinsic = context2.intrinsics().getObjectIntrinsic((ClassDescriptor)descriptor)).exists()) {
            JsExpression jsExpression = objectIntrinsic.apply(context2);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "generateReferenceToDefaultObject"));
            }
            return jsExpression;
        }
        JsExpression fqReference = ReferenceTranslator.translateAsFQReference(descriptor, context2);
        if (DescriptorUtils.isNonDefaultObject(descriptor) || DescriptorUtils.isEnumEntry(descriptor)) {
            JsExpression jsExpression = fqReference;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "generateReferenceToDefaultObject"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = Namer.getDefaultObjectAccessor(fqReference);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "generateReferenceToDefaultObject"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = this.referenceToDefaultObject;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression toSetTo) {
        if (toSetTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSetTo", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "translateAsSet"));
        }
        throw new IllegalStateException("default object can't be set");
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        DefaultObjectAccessTranslator defaultObjectAccessTranslator = this;
        if (defaultObjectAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "getCached"));
        }
        return defaultObjectAccessTranslator;
    }

    @Override
    @NotNull
    public List<TemporaryVariable> declaredTemporaries() {
        List<TemporaryVariable> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/DefaultObjectAccessTranslator", "declaredTemporaries"));
        }
        return list;
    }
}

