/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetExpressionImpl;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVisitor;

public class JetCallableReferenceExpression
extends JetExpressionImpl {
    public JetCallableReferenceExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetCallableReferenceExpression", "<init>"));
        }
        super(node);
    }

    @Nullable
    public JetTypeReference getTypeReference() {
        return (JetTypeReference)this.findChildByType(JetNodeTypes.TYPE_REFERENCE);
    }

    @NotNull
    public PsiElement getDoubleColonTokenReference() {
        Object t = this.findChildByType(JetTokens.COLONCOLON);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetCallableReferenceExpression", "getDoubleColonTokenReference"));
        }
        return t;
    }

    @NotNull
    public JetSimpleNameExpression getCallableReference() {
        for (PsiElement psi = this.getDoubleColonTokenReference(); psi != null; psi = psi.getNextSibling()) {
            if (!(psi instanceof JetSimpleNameExpression)) continue;
            JetSimpleNameExpression jetSimpleNameExpression = (JetSimpleNameExpression)psi;
            if (jetSimpleNameExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetCallableReferenceExpression", "getCallableReference"));
            }
            return jetSimpleNameExpression;
        }
        throw new IllegalStateException("Callable reference simple name shouldn't be parsed to null");
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetCallableReferenceExpression", "accept"));
        }
        return visitor.visitCallableReferenceExpression(this, data2);
    }
}

