/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetModifierListOwnerStub;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetPackageDirective
extends JetModifierListOwnerStub<KotlinPlaceHolderStub<JetPackageDirective>>
implements JetReferenceExpression {
    private String qualifiedNameCache;

    public JetPackageDirective(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetPackageDirective", "<init>"));
        }
        super(node);
        this.qualifiedNameCache = null;
    }

    public JetPackageDirective(@NotNull KotlinPlaceHolderStub<JetPackageDirective> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetPackageDirective", "<init>"));
        }
        super(stub, JetStubElementTypes.PACKAGE_DIRECTIVE);
        this.qualifiedNameCache = null;
    }

    @Nullable
    public JetExpression getPackageNameExpression() {
        return JetStubbedPsiUtil.getStubOrPsiChild(this, JetStubElementTypes.INSIDE_DIRECTIVE_EXPRESSIONS, JetExpression.ARRAY_FACTORY);
    }

    @NotNull
    public List<JetSimpleNameExpression> getPackageNames() {
        JetExpression nameExpression = this.getPackageNameExpression();
        if (nameExpression == null) {
            List<JetSimpleNameExpression> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPackageDirective", "getPackageNames"));
            }
            return list;
        }
        ArrayList<JetSimpleNameExpression> packageNames = ContainerUtil.newArrayList();
        while (nameExpression instanceof JetQualifiedExpression) {
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)nameExpression;
            JetExpression selector = qualifiedExpression.getSelectorExpression();
            if (selector instanceof JetSimpleNameExpression) {
                packageNames.add((JetSimpleNameExpression)selector);
            }
            nameExpression = qualifiedExpression.getReceiverExpression();
        }
        if (nameExpression instanceof JetSimpleNameExpression) {
            packageNames.add((JetSimpleNameExpression)nameExpression);
        }
        Collections.reverse(packageNames);
        ArrayList<JetSimpleNameExpression> arrayList = packageNames;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPackageDirective", "getPackageNames"));
        }
        return arrayList;
    }

    @Nullable
    public JetSimpleNameExpression getLastReferenceExpression() {
        JetExpression nameExpression = this.getPackageNameExpression();
        if (nameExpression == null) {
            return null;
        }
        return (JetSimpleNameExpression)PsiUtilPackage.getQualifiedElementSelector(nameExpression);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        JetSimpleNameExpression lastPart = this.getLastReferenceExpression();
        return lastPart != null ? lastPart.getIdentifier() : null;
    }

    @Override
    @NotNull
    public String getName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        String string = nameIdentifier == null ? "" : nameIdentifier.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPackageDirective", "getName"));
        }
        return string;
    }

    @NotNull
    public Name getNameAsName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        Name name = nameIdentifier == null ? SpecialNames.ROOT_PACKAGE : Name.identifier(nameIdentifier.getText());
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPackageDirective", "getNameAsName"));
        }
        return name;
    }

    public boolean isRoot() {
        return this.getName().length() == 0;
    }

    @NotNull
    public FqName getFqName() {
        String qualifiedName = this.getQualifiedName();
        FqName fqName2 = qualifiedName.isEmpty() ? FqName.ROOT : new FqName(qualifiedName);
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPackageDirective", "getFqName"));
        }
        return fqName2;
    }

    @NotNull
    public FqName getFqName(JetSimpleNameExpression nameExpression) {
        FqName fqName2 = new FqName(this.getQualifiedNameOf(nameExpression));
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPackageDirective", "getFqName"));
        }
        return fqName2;
    }

    @NotNull
    public String getQualifiedName() {
        if (this.qualifiedNameCache == null) {
            this.qualifiedNameCache = this.getQualifiedNameOf(null);
        }
        String string = this.qualifiedNameCache;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPackageDirective", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    private String getQualifiedNameOf(@Nullable JetSimpleNameExpression nameExpression) {
        StringBuilder builder = new StringBuilder();
        for (JetSimpleNameExpression e : this.getPackageNames()) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(e.getReferencedName());
            if (e != nameExpression) continue;
            break;
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPackageDirective", "getQualifiedNameOf"));
        }
        return string;
    }

    @Override
    public void subtreeChanged() {
        this.qualifiedNameCache = null;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetPackageDirective", "accept"));
        }
        return visitor.visitPackageDirective(this, data2);
    }
}

