/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.kdoc.psi.api.KDocElement;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.parsing.JetExpressionParsing;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetCatchClause;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetDotQualifiedExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPostfixExpression;
import org.jetbrains.kotlin.psi.JetPrefixExpression;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStatementExpression;
import org.jetbrains.kotlin.psi.JetTryExpression;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.psi.JetVariableDeclaration;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public class JetPsiUtil {
    public static final Predicate<JetElement> ANY_JET_ELEMENT = new Predicate<JetElement>(){

        @Override
        public boolean apply(@Nullable JetElement input) {
            return true;
        }
    };

    private JetPsiUtil() {
    }

    public static <D> void visitChildren(@NotNull JetElement element, @NotNull JetVisitor<Void, D> visitor, D data2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil", "visitChildren"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetPsiUtil", "visitChildren"));
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof JetElement)) continue;
            ((JetElement)child).accept(visitor, data2);
        }
    }

    @NotNull
    public static JetExpression safeDeparenthesize(@NotNull JetExpression expression, boolean deparenthesizeBinaryExpressionWithTypeRHS) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "safeDeparenthesize"));
        }
        JetExpression deparenthesized = JetPsiUtil.deparenthesize(expression, deparenthesizeBinaryExpressionWithTypeRHS);
        JetExpression jetExpression = deparenthesized != null ? deparenthesized : expression;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "safeDeparenthesize"));
        }
        return jetExpression;
    }

    @Nullable
    public static JetExpression deparenthesize(@Nullable JetExpression expression) {
        return JetPsiUtil.deparenthesize(expression, true);
    }

    @Nullable
    public static JetExpression deparenthesize(@Nullable JetExpression expression, boolean deparenthesizeBinaryExpressionWithTypeRHS) {
        return JetPsiUtil.deparenthesizeWithResolutionStrategy(expression, deparenthesizeBinaryExpressionWithTypeRHS, true, null);
    }

    @Nullable
    public static JetExpression deparenthesizeOnce(@Nullable JetExpression expression, boolean deparenthesizeBinaryExpressionWithTypeRHS) {
        return JetPsiUtil.deparenthesizeWithResolutionStrategy(expression, deparenthesizeBinaryExpressionWithTypeRHS, false, null);
    }

    @Nullable
    public static JetExpression deparenthesizeWithResolutionStrategy(@Nullable JetExpression expression, boolean deparenthesizeBinaryExpressionWithTypeRHS, @Nullable Function<JetTypeReference, Void> typeResolutionStrategy) {
        return JetPsiUtil.deparenthesizeWithResolutionStrategy(expression, true, true, typeResolutionStrategy);
    }

    @Nullable
    private static JetExpression deparenthesizeWithResolutionStrategy(@Nullable JetExpression expression, boolean deparenthesizeBinaryExpressionWithTypeRHS, boolean deparenthesizeRecursively, @Nullable Function<JetTypeReference, Void> typeResolutionStrategy) {
        if (deparenthesizeBinaryExpressionWithTypeRHS && expression instanceof JetBinaryExpressionWithTypeRHS) {
            JetBinaryExpressionWithTypeRHS binaryExpression = (JetBinaryExpressionWithTypeRHS)expression;
            JetSimpleNameExpression operationSign = binaryExpression.getOperationReference();
            if (JetTokens.COLON.equals(operationSign.getReferencedNameElementType())) {
                expression = binaryExpression.getLeft();
                JetTypeReference typeReference = binaryExpression.getRight();
                if (typeResolutionStrategy != null && typeReference != null) {
                    typeResolutionStrategy.apply(typeReference);
                }
            }
        } else if (expression instanceof JetLabeledExpression) {
            JetExpression baseExpression = ((JetLabeledExpression)expression).getBaseExpression();
            if (baseExpression != null) {
                expression = baseExpression;
            }
        } else if (expression instanceof JetExpressionWrapper) {
            expression = ((JetExpressionWrapper)((Object)expression)).getBaseExpression();
        }
        if (expression instanceof JetParenthesizedExpression) {
            JetExpression innerExpression = ((JetParenthesizedExpression)expression).getExpression();
            return innerExpression != null && deparenthesizeRecursively ? JetPsiUtil.deparenthesizeWithResolutionStrategy(innerExpression, deparenthesizeBinaryExpressionWithTypeRHS, true, typeResolutionStrategy) : innerExpression;
        }
        return expression;
    }

    @NotNull
    public static Name safeName(@Nullable String name) {
        Name name2 = name == null ? SpecialNames.NO_NAME_PROVIDED : Name.identifier(name);
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "safeName"));
        }
        return name2;
    }

    @NotNull
    public static Set<JetElement> findRootExpressions(@NotNull Collection<JetElement> unreachableElements) {
        if (unreachableElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unreachableElements", "org/jetbrains/kotlin/psi/JetPsiUtil", "findRootExpressions"));
        }
        HashSet<JetElement> rootElements = new HashSet<JetElement>();
        final HashSet shadowedElements = new HashSet();
        JetVisitorVoid shadowAllChildren = new JetVisitorVoid(){

            @Override
            public void visitJetElement(@NotNull JetElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil$1", "visitJetElement"));
                }
                if (shadowedElements.add(element)) {
                    element.acceptChildren(this);
                }
            }
        };
        for (JetElement element : unreachableElements) {
            if (shadowedElements.contains(element)) continue;
            element.acceptChildren(shadowAllChildren);
            rootElements.removeAll(shadowedElements);
            rootElements.add(element);
        }
        HashSet<JetElement> hashSet = rootElements;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "findRootExpressions"));
        }
        return hashSet;
    }

    @NotNull
    public static String unquoteIdentifier(@NotNull String quoted) {
        if (quoted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoted", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifier"));
        }
        if (quoted.indexOf(96) < 0) {
            String string = quoted;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifier"));
            }
            return string;
        }
        if (quoted.startsWith("`") && quoted.endsWith("`") && quoted.length() >= 2) {
            String string = quoted.substring(1, quoted.length() - 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifier"));
            }
            return string;
        }
        String string = quoted;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifier"));
        }
        return string;
    }

    @NotNull
    public static String unquoteIdentifierOrFieldReference(@NotNull String quoted) {
        if (quoted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoted", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifierOrFieldReference"));
        }
        if (quoted.indexOf(96) < 0) {
            String string = quoted;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifierOrFieldReference"));
            }
            return string;
        }
        if (quoted.startsWith("$")) {
            String string = "$" + JetPsiUtil.unquoteIdentifier(quoted.substring(1));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifierOrFieldReference"));
            }
            return string;
        }
        String string = JetPsiUtil.unquoteIdentifier(quoted);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifierOrFieldReference"));
        }
        return string;
    }

    @Nullable
    public static FqName toQualifiedName(@NotNull JetUserType userType) {
        if (userType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userType", "org/jetbrains/kotlin/psi/JetPsiUtil", "toQualifiedName"));
        }
        ArrayList<String> reversedNames = Lists.newArrayList();
        for (JetUserType current = userType; current != null; current = current.getQualifier()) {
            String name = current.getReferencedName();
            if (name == null) {
                return null;
            }
            reversedNames.add(name);
        }
        return FqName.fromSegments(ContainerUtil.reverse(reversedNames));
    }

    @Nullable
    public static Name getShortName(@NotNull JetAnnotationEntry annotation2) {
        JetUserType userType;
        String shortName;
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/psi/JetPsiUtil", "getShortName"));
        }
        JetTypeReference typeReference = annotation2.getTypeReference();
        assert (typeReference != null) : "Annotation entry hasn't typeReference " + annotation2.getText();
        JetTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement instanceof JetUserType && (shortName = (userType = (JetUserType)typeElement).getReferencedName()) != null) {
            return Name.identifier(shortName);
        }
        return null;
    }

    public static boolean isDeprecated(@NotNull JetModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/psi/JetPsiUtil", "isDeprecated"));
        }
        JetModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            List<JetAnnotationEntry> annotationEntries = modifierList.getAnnotationEntries();
            for (JetAnnotationEntry annotation2 : annotationEntries) {
                Name shortName = JetPsiUtil.getShortName(annotation2);
                if (!KotlinBuiltIns.getInstance().getDeprecatedAnnotation().getName().equals(shortName)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getDirectParentOfTypeForBlock(@NotNull JetBlockExpression block, @NotNull Class<T> aClass) {
        JetFunctionLiteral functionLiteral;
        JetIfExpression ifExpression;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/psi/JetPsiUtil", "getDirectParentOfTypeForBlock"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/psi/JetPsiUtil", "getDirectParentOfTypeForBlock"));
        }
        T parent = PsiTreeUtil.getParentOfType((PsiElement)block, aClass);
        if (parent instanceof JetIfExpression && ((ifExpression = (JetIfExpression)parent).getElse() == block || ifExpression.getThen() == block)) {
            return parent;
        }
        if (parent instanceof JetWhenExpression) {
            JetWhenExpression whenExpression = (JetWhenExpression)parent;
            for (JetWhenEntry whenEntry : whenExpression.getEntries()) {
                if (whenEntry.getExpression() != block) continue;
                return parent;
            }
        }
        if (parent instanceof JetFunctionLiteral && (functionLiteral = (JetFunctionLiteral)parent).getBodyExpression() == block) {
            return parent;
        }
        if (parent instanceof JetTryExpression) {
            JetTryExpression tryExpression = (JetTryExpression)parent;
            if (tryExpression.getTryBlock() == block) {
                return parent;
            }
            for (JetCatchClause clause : tryExpression.getCatchClauses()) {
                if (clause.getCatchBody() != block) continue;
                return parent;
            }
        }
        return null;
    }

    public static void deleteClass(@NotNull JetClassOrObject clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/psi/JetPsiUtil", "deleteClass"));
        }
        CheckUtil.checkWritable(clazz);
        JetFile file = clazz.getContainingJetFile();
        if (clazz.isLocal() || file.getDeclarations().size() > 1) {
            PsiElement parent = clazz.getParent();
            CodeEditUtil.removeChild(parent.getNode(), clazz.getNode());
        } else {
            file.delete();
        }
    }

    @Nullable
    public static Name getAliasName(@NotNull JetImportDirective importDirective) {
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/kotlin/psi/JetPsiUtil", "getAliasName"));
        }
        String aliasName = importDirective.getAliasName();
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null) {
            return null;
        }
        JetSimpleNameExpression referenceExpression = JetPsiUtil.getLastReference(importedReference);
        if (aliasName == null) {
            aliasName = referenceExpression != null ? referenceExpression.getReferencedName() : null;
        }
        return aliasName != null && !aliasName.isEmpty() ? Name.identifier(aliasName) : null;
    }

    @Nullable
    public static JetSimpleNameExpression getLastReference(@NotNull JetExpression importedReference) {
        if (importedReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedReference", "org/jetbrains/kotlin/psi/JetPsiUtil", "getLastReference"));
        }
        JetElement selector = PsiUtilPackage.getQualifiedElementSelector(importedReference);
        return selector instanceof JetSimpleNameExpression ? (JetSimpleNameExpression)selector : null;
    }

    public static boolean isSelectorInQualified(@NotNull JetSimpleNameExpression nameExpression) {
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/kotlin/psi/JetPsiUtil", "isSelectorInQualified"));
        }
        JetElement qualifiedElement = PsiUtilPackage.getQualifiedElement(nameExpression);
        return qualifiedElement instanceof JetQualifiedExpression || qualifiedElement instanceof JetUserType && ((JetUserType)qualifiedElement).getQualifier() != null;
    }

    public static boolean isLHSOfDot(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "isLHSOfDot"));
        }
        PsiElement parent = expression.getParent();
        if (!(parent instanceof JetQualifiedExpression)) {
            return false;
        }
        JetQualifiedExpression qualifiedParent = (JetQualifiedExpression)parent;
        return qualifiedParent.getReceiverExpression() == expression || JetPsiUtil.isLHSOfDot(qualifiedParent);
    }

    public static boolean isVoidType(@Nullable JetTypeReference typeReference) {
        if (typeReference == null) {
            return false;
        }
        return KotlinBuiltIns.getInstance().getUnit().getName().asString().equals(typeReference.getText());
    }

    public static boolean isScriptDeclaration(@NotNull JetDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/JetPsiUtil", "isScriptDeclaration"));
        }
        return JetPsiUtil.getScript(namedDeclaration) != null;
    }

    @Nullable
    public static JetScript getScript(@NotNull JetDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/JetPsiUtil", "getScript"));
        }
        PsiElement parent = namedDeclaration.getParent();
        if (parent != null && parent.getParent() instanceof JetScript) {
            return (JetScript)parent.getParent();
        }
        return null;
    }

    public static boolean isVariableNotParameterDeclaration(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/JetPsiUtil", "isVariableNotParameterDeclaration"));
        }
        if (!(declaration instanceof JetVariableDeclaration)) {
            return false;
        }
        if (declaration instanceof JetProperty) {
            return true;
        }
        assert (declaration instanceof JetMultiDeclarationEntry);
        JetMultiDeclarationEntry multiDeclarationEntry = (JetMultiDeclarationEntry)declaration;
        return !(multiDeclarationEntry.getParent().getParent() instanceof JetForExpression);
    }

    @Nullable
    public static Name getConventionName(@NotNull JetSimpleNameExpression simpleNameExpression) {
        IElementType elementType;
        if (simpleNameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleNameExpression", "org/jetbrains/kotlin/psi/JetPsiUtil", "getConventionName"));
        }
        if (simpleNameExpression.getIdentifier() != null) {
            return simpleNameExpression.getReferencedNameAsName();
        }
        PsiElement firstChild = simpleNameExpression.getFirstChild();
        if (firstChild != null && (elementType = firstChild.getNode().getElementType()) instanceof JetToken) {
            JetToken jetToken = (JetToken)elementType;
            return OperatorConventions.getNameForOperationSymbol(jetToken);
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement getTopmostParentOfTypes(@Nullable PsiElement element, Class<? extends PsiElement> ... parentTypes) {
        PsiElement next;
        if (parentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentTypes", "org/jetbrains/kotlin/psi/JetPsiUtil", "getTopmostParentOfTypes"));
        }
        PsiElement answer = PsiTreeUtil.getParentOfType(element, parentTypes);
        while ((next = PsiTreeUtil.getParentOfType(answer, parentTypes)) != null) {
            answer = next;
        }
        return answer;
    }

    public static boolean isNullConstant(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "isNullConstant"));
        }
        JetExpression deparenthesized = JetPsiUtil.deparenthesize(expression);
        return deparenthesized instanceof JetConstantExpression && deparenthesized.getNode().getElementType() == JetNodeTypes.NULL;
    }

    public static boolean isAbstract(@NotNull JetDeclarationWithBody declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/JetPsiUtil", "isAbstract"));
        }
        return declaration.getBodyExpression() == null;
    }

    public static boolean isBackingFieldReference(@NotNull JetSimpleNameExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "isBackingFieldReference"));
        }
        return expression.getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER;
    }

    public static boolean isBackingFieldReference(@Nullable JetElement element) {
        return element instanceof JetSimpleNameExpression && JetPsiUtil.isBackingFieldReference((JetSimpleNameExpression)element);
    }

    @Nullable
    public static JetElement getLastStatementInABlock(@Nullable JetBlockExpression blockExpression) {
        if (blockExpression == null) {
            return null;
        }
        List<JetElement> statements = blockExpression.getStatements();
        return statements.isEmpty() ? null : statements.get(statements.size() - 1);
    }

    public static boolean isTrait(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/psi/JetPsiUtil", "isTrait"));
        }
        return classOrObject instanceof JetClass && ((JetClass)classOrObject).isTrait();
    }

    @Nullable
    public static JetClassOrObject getOutermostClassOrObject(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/psi/JetPsiUtil", "getOutermostClassOrObject"));
        }
        JetClassOrObject current = classOrObject;
        while (true) {
            PsiElement parent = current.getParent();
            assert (classOrObject.getParent() != null) : "Class with no parent: " + classOrObject.getText();
            if (parent instanceof PsiFile) {
                return current;
            }
            if (!(parent instanceof JetClassBody)) {
                return current;
            }
            current = (JetClassOrObject)parent.getParent();
        }
    }

    @Nullable
    public static JetClass getClassIfParameterIsProperty(@NotNull JetParameter jetParameter) {
        PsiElement parent;
        if (jetParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetParameter", "org/jetbrains/kotlin/psi/JetPsiUtil", "getClassIfParameterIsProperty"));
        }
        if (jetParameter.hasValOrVarNode() && (parent = jetParameter.getParent()) instanceof JetParameterList && parent.getParent() instanceof JetClass) {
            return (JetClass)parent.getParent();
        }
        return null;
    }

    @Nullable
    private static IElementType getOperation(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "getOperation"));
        }
        if (expression instanceof JetQualifiedExpression) {
            return ((JetQualifiedExpression)expression).getOperationSign();
        }
        if (expression instanceof JetOperationExpression) {
            return ((JetOperationExpression)expression).getOperationReference().getReferencedNameElementType();
        }
        return null;
    }

    private static int getPriority(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "getPriority"));
        }
        int maxPriority = JetExpressionParsing.Precedence.values().length + 1;
        if (expression instanceof JetPostfixExpression || expression instanceof JetQualifiedExpression || expression instanceof JetCallExpression || expression instanceof JetArrayAccessExpression) {
            return maxPriority - 1;
        }
        if (expression instanceof JetPrefixExpression || expression instanceof JetLabeledExpression) {
            return maxPriority - 2;
        }
        if (expression instanceof JetIfExpression) {
            return JetExpressionParsing.Precedence.ASSIGNMENT.ordinal();
        }
        if (expression instanceof JetDeclaration || expression instanceof JetStatementExpression) {
            return 0;
        }
        IElementType operation = JetPsiUtil.getOperation(expression);
        for (JetExpressionParsing.Precedence precedence : JetExpressionParsing.Precedence.values()) {
            if (precedence == JetExpressionParsing.Precedence.PREFIX || precedence == JetExpressionParsing.Precedence.POSTFIX || !precedence.getOperations().contains(operation)) continue;
            return maxPriority - precedence.ordinal() - 1;
        }
        return maxPriority;
    }

    public static boolean areParenthesesUseless(@NotNull JetParenthesizedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "areParenthesesUseless"));
        }
        JetExpression innerExpression = expression.getExpression();
        if (innerExpression == null) {
            return true;
        }
        PsiElement parent = expression.getParent();
        if (!(parent instanceof JetExpression)) {
            return true;
        }
        return !JetPsiUtil.areParenthesesNecessary(innerExpression, expression, (JetExpression)parent);
    }

    public static boolean areParenthesesNecessary(@NotNull JetExpression innerExpression, @NotNull JetExpression currentInner, @NotNull JetExpression parentExpression) {
        int parentPriority;
        if (innerExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerExpression", "org/jetbrains/kotlin/psi/JetPsiUtil", "areParenthesesNecessary"));
        }
        if (currentInner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentInner", "org/jetbrains/kotlin/psi/JetPsiUtil", "areParenthesesNecessary"));
        }
        if (parentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentExpression", "org/jetbrains/kotlin/psi/JetPsiUtil", "areParenthesesNecessary"));
        }
        if (parentExpression instanceof JetParenthesizedExpression || innerExpression instanceof JetParenthesizedExpression) {
            return false;
        }
        if (parentExpression instanceof JetPackageDirective) {
            return false;
        }
        if (parentExpression instanceof JetWhenExpression || innerExpression instanceof JetWhenExpression) {
            return false;
        }
        if (innerExpression instanceof JetIfExpression) {
            PsiElement current = parentExpression;
            while (!(current instanceof JetBlockExpression || current instanceof JetDeclaration || current instanceof JetStatementExpression)) {
                if (current.getTextRange().getEndOffset() != currentInner.getTextRange().getEndOffset()) {
                    return current.getText().charAt(current.getTextLength() - 1) != ')';
                }
                current = current.getParent();
            }
        }
        IElementType innerOperation = JetPsiUtil.getOperation(innerExpression);
        IElementType parentOperation = JetPsiUtil.getOperation(parentExpression);
        if (parentExpression instanceof JetReturnExpression && innerExpression instanceof JetLabeledExpression) {
            return true;
        }
        if (innerExpression instanceof JetBinaryExpressionWithTypeRHS && parentOperation == JetTokens.LT) {
            return true;
        }
        int innerPriority = JetPsiUtil.getPriority(innerExpression);
        if (innerPriority == (parentPriority = JetPsiUtil.getPriority(parentExpression))) {
            if (parentExpression instanceof JetBinaryExpression) {
                if (innerOperation == JetTokens.ANDAND || innerOperation == JetTokens.OROR) {
                    return false;
                }
                return ((JetBinaryExpression)parentExpression).getRight() == currentInner;
            }
            if (parentExpression instanceof JetPrefixExpression && innerExpression instanceof JetPrefixExpression) {
                return innerOperation == parentOperation && (innerOperation == JetTokens.PLUS || innerOperation == JetTokens.MINUS);
            }
            return false;
        }
        return innerPriority < parentPriority;
    }

    public static boolean isAssignment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil", "isAssignment"));
        }
        return element instanceof JetBinaryExpression && JetTokens.ALL_ASSIGNMENTS.contains(((JetBinaryExpression)element).getOperationToken());
    }

    public static boolean isOrdinaryAssignment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil", "isOrdinaryAssignment"));
        }
        return element instanceof JetBinaryExpression && ((JetBinaryExpression)element).getOperationToken().equals(JetTokens.EQ);
    }

    @Nullable
    public static JetElement getOutermostLastBlockElement(@Nullable JetElement element, @NotNull Predicate<JetElement> checkElement) {
        if (checkElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkElement", "org/jetbrains/kotlin/psi/JetPsiUtil", "getOutermostLastBlockElement"));
        }
        if (element == null) {
            return null;
        }
        if (!(element instanceof JetBlockExpression)) {
            return checkElement.apply(element) ? element : null;
        }
        JetBlockExpression block = (JetBlockExpression)element;
        int n = block.getStatements().size();
        if (n == 0) {
            return null;
        }
        JetElement lastElement = block.getStatements().get(n - 1);
        return checkElement.apply(lastElement) ? lastElement : null;
    }

    public static boolean checkVariableDeclarationInBlock(@NotNull JetBlockExpression block, @NotNull String varName) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/psi/JetPsiUtil", "checkVariableDeclarationInBlock"));
        }
        if (varName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varName", "org/jetbrains/kotlin/psi/JetPsiUtil", "checkVariableDeclarationInBlock"));
        }
        for (JetElement element : block.getStatements()) {
            if (!(element instanceof JetVariableDeclaration) || !((JetVariableDeclaration)element).getNameAsSafeName().asString().equals(varName)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkWhenExpressionHasSingleElse(@NotNull JetWhenExpression whenExpression) {
        if (whenExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenExpression", "org/jetbrains/kotlin/psi/JetPsiUtil", "checkWhenExpressionHasSingleElse"));
        }
        int elseCount = 0;
        for (JetWhenEntry entry : whenExpression.getEntries()) {
            if (!entry.isElse()) continue;
            ++elseCount;
        }
        return elseCount == 1;
    }

    @Nullable
    public static PsiElement skipTrailingWhitespacesAndComments(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsForward(element, PsiWhiteSpace.class, PsiComment.class);
    }

    @NotNull
    public static String getText(@Nullable PsiElement element) {
        String string = element != null ? element.getText() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "getText"));
        }
        return string;
    }

    @Nullable
    public static String getNullableText(@Nullable PsiElement element) {
        return element != null ? element.getText() : null;
    }

    public static boolean isInComment(PsiElement element) {
        return CommentUtilCore.isComment(element) || element instanceof KDocElement;
    }

    @Nullable
    public static PsiElement getOutermostParent(@NotNull PsiElement element, @NotNull PsiElement upperBound, boolean strict) {
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil", "getOutermostParent"));
        }
        if (upperBound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperBound", "org/jetbrains/kotlin/psi/JetPsiUtil", "getOutermostParent"));
        }
        PsiElement psiElement = parent = strict ? element.getParent() : element;
        while (parent != null && parent.getParent() != upperBound) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static <T extends PsiElement> T getLastChildByType(@NotNull PsiElement root, Class<? extends T> ... elementTypes) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/psi/JetPsiUtil", "getLastChildByType"));
        }
        if (elementTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementTypes", "org/jetbrains/kotlin/psi/JetPsiUtil", "getLastChildByType"));
        }
        PsiElement[] children = root.getChildren();
        for (int i = children.length - 1; i >= 0; --i) {
            if (!PsiTreeUtil.instanceOf(children[i], elementTypes)) continue;
            return (T)children[i];
        }
        return null;
    }

    @Nullable
    public static JetElement getOutermostDescendantElement(@Nullable PsiElement root, boolean first, final @NotNull Predicate<JetElement> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "org/jetbrains/kotlin/psi/JetPsiUtil", "getOutermostDescendantElement"));
        }
        if (!(root instanceof JetElement)) {
            return null;
        }
        final ArrayList results = Lists.newArrayList();
        root.accept(new JetVisitorVoid(){

            @Override
            public void visitJetElement(@NotNull JetElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil$3", "visitJetElement"));
                }
                if (predicate.apply(element)) {
                    results.add(element);
                } else {
                    element.acceptChildren(this);
                }
            }
        });
        if (results.isEmpty()) {
            return null;
        }
        return first ? (JetElement)results.get(0) : (JetElement)results.get(results.size() - 1);
    }

    @Nullable
    public static PsiElement findChildByType(@NotNull PsiElement element, @NotNull IElementType type2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil", "findChildByType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/psi/JetPsiUtil", "findChildByType"));
        }
        ASTNode node = element.getNode().findChildByType(type2);
        return node == null ? null : node.getPsi();
    }

    @Nullable
    public static PsiElement skipSiblingsBackwardByPredicate(@Nullable PsiElement element, Predicate<PsiElement> elementsToSkip) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if (elementsToSkip.apply(e)) continue;
            return e;
        }
        return null;
    }

    @Nullable
    public static PsiElement skipSiblingsForwardByPredicate(@Nullable PsiElement element, Predicate<PsiElement> elementsToSkip) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (elementsToSkip.apply(e)) continue;
            return e;
        }
        return null;
    }

    public static void deleteElementWithDelimiters(@NotNull PsiElement element) {
        PsiElement to;
        PsiElement from;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil", "deleteElementWithDelimiters"));
        }
        Object paramBefore = PsiTreeUtil.getPrevSiblingOfType(element, element.getClass());
        if (paramBefore != null) {
            from = paramBefore.getNextSibling();
            to = element;
        } else {
            Object paramAfter = PsiTreeUtil.getNextSiblingOfType(element, element.getClass());
            from = element;
            to = paramAfter != null ? paramAfter.getPrevSibling() : element;
        }
        PsiElement parent = element.getParent();
        parent.deleteChildRange(from, to);
    }

    public static <T extends PsiElement> void deleteChildlessElement(PsiElement element, Class<T> childClass) {
        if (PsiTreeUtil.getChildrenOfType((PsiElement)element, childClass) == null) {
            element.delete();
        }
    }

    public static PsiElement ascendIfPropertyAccessor(PsiElement element) {
        if (element instanceof JetPropertyAccessor) {
            return element.getParent();
        }
        return element;
    }

    @NotNull
    public static String getElementTextWithContext(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil", "getElementTextWithContext"));
        }
        if (element instanceof PsiFile) {
            String string = element.getContainingFile().getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "getElementTextWithContext"));
            }
            return string;
        }
        PsiElement inFileParent = PsiTreeUtil.findFirstParent(element, new Condition<PsiElement>(){

            @Override
            public boolean value(PsiElement parentCandidate) {
                return parentCandidate != null && parentCandidate.getParent() instanceof PsiFile;
            }
        });
        assert (inFileParent != null) : "For non-file element we should always be able to find parent in file children";
        int startContextOffset = inFileParent.getTextRange().getStartOffset();
        int elementContextOffset = element.getTextRange().getStartOffset();
        int inFileParentOffset = elementContextOffset - startContextOffset;
        String string = new StringBuilder(inFileParent.getText()).insert(inFileParentOffset, "<caret>").insert(0, String.format("File name: %s\n", element.getContainingFile().getName())).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "getElementTextWithContext"));
        }
        return string;
    }

    @Nullable
    public static JetModifierList replaceModifierList(@NotNull JetModifierListOwner owner, @Nullable JetModifierList modifierList) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/psi/JetPsiUtil", "replaceModifierList"));
        }
        JetModifierList oldModifierList = owner.getModifierList();
        if (modifierList == null) {
            if (oldModifierList != null) {
                oldModifierList.delete();
            }
            return null;
        }
        if (oldModifierList == null) {
            PsiElement firstChild = owner.getFirstChild();
            return (JetModifierList)owner.addBefore(modifierList, firstChild);
        }
        return (JetModifierList)oldModifierList.replace(modifierList);
    }

    @Nullable
    public static String getPackageName(@NotNull JetElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil", "getPackageName"));
        }
        JetFile file = element.getContainingJetFile();
        JetPackageDirective header = PsiTreeUtil.findChildOfType(file, JetPackageDirective.class);
        return header != null ? header.getQualifiedName() : null;
    }

    @Nullable
    public static JetElement getEnclosingElementForLocalDeclaration(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/JetPsiUtil", "getEnclosingElementForLocalDeclaration"));
        }
        return JetPsiUtil.getEnclosingElementForLocalDeclaration(declaration, true);
    }

    @Nullable
    public static JetElement getEnclosingElementForLocalDeclaration(@NotNull JetDeclaration declaration, boolean skipParameters) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/JetPsiUtil", "getEnclosingElementForLocalDeclaration"));
        }
        if (declaration instanceof JetTypeParameter && skipParameters) {
            declaration = PsiTreeUtil.getParentOfType((PsiElement)declaration, JetNamedDeclaration.class);
        } else if (declaration instanceof JetParameter) {
            if (((JetParameter)declaration).getValOrVarNode() != null) {
                return null;
            }
            PsiElement parent = declaration.getParent();
            if (skipParameters && parent != null && parent.getParent() instanceof JetNamedFunction) {
                declaration = (JetNamedFunction)parent.getParent();
            }
        }
        PsiElement current = PsiTreeUtil.getStubOrPsiParent(declaration);
        while (current != null) {
            PsiElement parent = PsiTreeUtil.getStubOrPsiParent(current);
            if (parent instanceof JetScript) {
                return null;
            }
            if (current instanceof JetClassInitializer) {
                return ((JetClassInitializer)current).getBody();
            }
            if (current instanceof JetBlockExpression || current instanceof JetProperty || current instanceof JetParameter || current instanceof JetFunction) {
                return (JetElement)current;
            }
            current = parent;
        }
        return null;
    }

    public static boolean isLocal(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/JetPsiUtil", "isLocal"));
        }
        return JetPsiUtil.getEnclosingElementForLocalDeclaration(declaration) != null;
    }

    @Nullable
    public static JetToken getOperationToken(@NotNull JetOperationExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "getOperationToken"));
        }
        JetSimpleNameExpression operationExpression = expression.getOperationReference();
        IElementType elementType = operationExpression.getReferencedNameElementType();
        assert (elementType == null || elementType instanceof JetToken) : "JetOperationExpression should have operation token of type JetToken: " + expression;
        return (JetToken)elementType;
    }

    public static boolean isLabelIdentifierExpression(PsiElement element) {
        return element instanceof JetSimpleNameExpression && ((JetSimpleNameExpression)element).getReferencedNameElementType() == JetTokens.LABEL_IDENTIFIER;
    }

    @Nullable
    public static JetExpression getParentCallIfPresent(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "getParentCallIfPresent"));
        }
        PsiElement parent = expression.getParent();
        while (parent != null) {
            if (parent instanceof JetBinaryExpression || parent instanceof JetUnaryExpression || parent instanceof JetLabeledExpression || parent instanceof JetDotQualifiedExpression || parent instanceof JetCallExpression || parent instanceof JetArrayAccessExpression || parent instanceof JetMultiDeclaration) {
                if (parent instanceof JetLabeledExpression) {
                    parent = parent.getParent();
                    continue;
                }
                return (JetExpression)parent;
            }
            if (parent instanceof JetParenthesizedExpression || parent instanceof JetBinaryExpressionWithTypeRHS) {
                parent = parent.getParent();
                continue;
            }
            if (parent instanceof JetValueArgument || parent instanceof JetValueArgumentList) {
                parent = parent.getParent();
                continue;
            }
            return null;
        }
        return null;
    }

    public static interface JetExpressionWrapper {
        public JetExpression getBaseExpression();
    }
}

