/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.DefaultAnnotationArgumentVisitor;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorVisitorEmptyBodies;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameBase;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.KeywordStringsGenerated;
import org.jetbrains.kotlin.renderer.NameShortness;
import org.jetbrains.kotlin.renderer.RendererPackage;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.JavaClassValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.LazyType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.error.MissingDependencyErrorClass;
import org.jetbrains.kotlin.utils.UtilsPackage;

public class DescriptorRendererImpl
implements DescriptorRenderer {
    private final Function1<JetType, JetType> typeNormalizer;
    private final NameShortness nameShortness;
    private final boolean withDefinedIn;
    private final Set<DescriptorRenderer.Modifier> modifiers;
    private final boolean startFromName;
    private final boolean debugMode;
    private final boolean classWithPrimaryConstructor;
    private final boolean verbose;
    private final boolean unitReturnType;
    private final boolean normalizedVisibilities;
    private final boolean showInternalKeyword;
    private final boolean prettyFunctionTypes;
    private final boolean uninferredTypeParameterAsName;
    private final boolean includeSynthesizedParameterNames;
    private final boolean withoutFunctionParameterNames;
    private final boolean withoutTypeParameters;
    private final boolean renderDefaultObjectName;
    private final boolean withoutSuperTypes;
    private final boolean receiverAfterName;
    private final boolean renderDefaultValues;
    private final boolean flexibleTypesForCode;
    @NotNull
    private final DescriptorRenderer.OverrideRenderingPolicy overrideRenderingPolicy;
    @NotNull
    private final DescriptorRenderer.ValueParametersHandler handler;
    @NotNull
    private final DescriptorRenderer.TextFormat textFormat;
    private final boolean includePropertyConstant;
    @NotNull
    private final Set<FqName> excludedAnnotationClasses;

    DescriptorRendererImpl(NameShortness nameShortness, boolean withDefinedIn, Set<DescriptorRenderer.Modifier> modifiers, boolean startFromName, boolean debugMode, boolean classWithPrimaryConstructor, boolean verbose, boolean unitReturnType, boolean normalizedVisibilities, boolean showInternalKeyword, boolean prettyFunctionTypes, boolean uninferredTypeParameterAsName, @NotNull DescriptorRenderer.OverrideRenderingPolicy overrideRenderingPolicy, @NotNull DescriptorRenderer.ValueParametersHandler handler, @NotNull DescriptorRenderer.TextFormat textFormat, @NotNull Collection<FqName> excludedAnnotationClasses, boolean includePropertyConstant, boolean includeSynthesizedParameterNames, boolean withoutFunctionParameterNames, boolean withoutTypeParameters, boolean receiverAfterName, boolean renderDefaultObjectName, boolean withoutSuperTypes, @NotNull Function1<JetType, JetType> typeNormalizer, boolean renderDefaultValues, boolean flexibleTypesForCode) {
        if (overrideRenderingPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overrideRenderingPolicy", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "<init>"));
        }
        if (textFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFormat", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "<init>"));
        }
        if (excludedAnnotationClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedAnnotationClasses", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "<init>"));
        }
        if (typeNormalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeNormalizer", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "<init>"));
        }
        this.nameShortness = nameShortness;
        this.withDefinedIn = withDefinedIn;
        this.modifiers = modifiers;
        this.startFromName = startFromName;
        this.handler = handler;
        this.classWithPrimaryConstructor = classWithPrimaryConstructor;
        this.verbose = verbose;
        this.unitReturnType = unitReturnType;
        this.normalizedVisibilities = normalizedVisibilities;
        this.showInternalKeyword = showInternalKeyword;
        this.overrideRenderingPolicy = overrideRenderingPolicy;
        this.debugMode = debugMode;
        this.textFormat = textFormat;
        this.includePropertyConstant = includePropertyConstant;
        this.excludedAnnotationClasses = new HashSet<FqName>(excludedAnnotationClasses);
        this.prettyFunctionTypes = prettyFunctionTypes;
        this.uninferredTypeParameterAsName = uninferredTypeParameterAsName;
        this.includeSynthesizedParameterNames = includeSynthesizedParameterNames;
        this.withoutFunctionParameterNames = withoutFunctionParameterNames;
        this.withoutTypeParameters = withoutTypeParameters;
        this.receiverAfterName = receiverAfterName;
        this.renderDefaultObjectName = renderDefaultObjectName;
        this.withoutSuperTypes = withoutSuperTypes;
        this.typeNormalizer = typeNormalizer;
        this.renderDefaultValues = renderDefaultValues;
        this.flexibleTypesForCode = flexibleTypesForCode;
    }

    @NotNull
    private String renderKeyword(@NotNull String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderKeyword"));
        }
        switch (this.textFormat) {
            case PLAIN: {
                String string = keyword;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderKeyword"));
                }
                return string;
            }
            case HTML: {
                String string = "<b>" + keyword + "</b>";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderKeyword"));
                }
                return string;
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String renderError(@NotNull String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderError"));
        }
        switch (this.textFormat) {
            case PLAIN: {
                String string = keyword;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderError"));
                }
                return string;
            }
            case HTML: {
                String string = "<font color=red><b>" + keyword + "</b></font>";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderError"));
                }
                return string;
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String escape(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "escape"));
        }
        switch (this.textFormat) {
            case PLAIN: {
                String string2 = string;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "escape"));
                }
                return string2;
            }
            case HTML: {
                String string3 = string.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                if (string3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "escape"));
                }
                return string3;
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String lt() {
        String string = this.escape("<");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "lt"));
        }
        return string;
    }

    @NotNull
    private String gt() {
        String string = this.escape(">");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "gt"));
        }
        return string;
    }

    @NotNull
    private String arrow() {
        switch (this.textFormat) {
            case PLAIN: {
                String string = this.escape("->");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "arrow"));
                }
                return string;
            }
            case HTML: {
                if ("&rarr;" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "arrow"));
                }
                return "&rarr;";
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String renderMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderMessage"));
        }
        switch (this.textFormat) {
            case PLAIN: {
                String string = message;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderMessage"));
                }
                return string;
            }
            case HTML: {
                String string = "<i>" + message + "</i>";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderMessage"));
                }
                return string;
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    private static void renderSpaceIfNeeded(@NotNull StringBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderSpaceIfNeeded"));
        }
        int length = builder.length();
        if (length == 0 || builder.charAt(length - 1) != ' ') {
            builder.append(' ');
        }
    }

    @Override
    @NotNull
    public String renderName(@NotNull Name identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderName"));
        }
        String asString = identifier.asString();
        String string = this.escape(DescriptorRendererImpl.nameShouldBeEscaped(identifier) ? '`' + asString + '`' : asString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderName"));
        }
        return string;
    }

    private static boolean nameShouldBeEscaped(@NotNull Name identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "nameShouldBeEscaped"));
        }
        if (identifier.isSpecial()) {
            return false;
        }
        String name = identifier.asString();
        if (KeywordStringsGenerated.KEYWORDS.contains(name)) {
            return true;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return true;
        }
        return false;
    }

    private void renderName(@NotNull DeclarationDescriptor descriptor, @NotNull StringBuilder builder) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderName"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderName"));
        }
        builder.append(this.renderName(descriptor.getName()));
    }

    private void renderDefaultObjectName(@NotNull DeclarationDescriptor descriptor, @NotNull StringBuilder builder) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderDefaultObjectName"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderDefaultObjectName"));
        }
        if (this.renderDefaultObjectName) {
            if (this.startFromName) {
                builder.append("class object");
            }
            DescriptorRendererImpl.renderSpaceIfNeeded(builder);
            DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
            if (containingDeclaration != null) {
                builder.append("of ");
                builder.append(this.renderName(containingDeclaration.getName()));
            }
        }
        if (this.verbose) {
            if (!this.startFromName) {
                DescriptorRendererImpl.renderSpaceIfNeeded(builder);
            }
            builder.append(this.renderName(descriptor.getName()));
        }
    }

    @Override
    @NotNull
    public String renderFqName(@NotNull FqNameBase fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFqName"));
        }
        String string = this.renderFqName(fqName2.pathSegments());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFqName"));
        }
        return string;
    }

    @NotNull
    private String renderFqName(@NotNull List<Name> pathSegments) {
        if (pathSegments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathSegments", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFqName"));
        }
        StringBuilder buf = new StringBuilder();
        for (Name element : pathSegments) {
            if (buf.length() != 0) {
                buf.append(".");
            }
            buf.append(this.renderName(element));
        }
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFqName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String renderClassifierName(@NotNull ClassifierDescriptor klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderClassifierName"));
        }
        if (klass instanceof MissingDependencyErrorClass) {
            String string = ((MissingDependencyErrorClass)((Object)klass)).getFullFqName().asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderClassifierName"));
            }
            return string;
        }
        if (ErrorUtils.isError(klass)) {
            String string = klass.getTypeConstructor().toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderClassifierName"));
            }
            return string;
        }
        switch (this.nameShortness) {
            case SHORT: {
                ArrayList<Name> qualifiedNameElements = new ArrayList<Name>();
                DeclarationDescriptor current = klass;
                do {
                    qualifiedNameElements.add(current.getName());
                } while ((current = current.getContainingDeclaration()) instanceof ClassDescriptor);
                Collections.reverse(qualifiedNameElements);
                String string = this.renderFqName(qualifiedNameElements);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderClassifierName"));
                }
                return string;
            }
            case FULLY_QUALIFIED: {
                String string = this.renderFqName(DescriptorUtils.getFqName(klass));
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderClassifierName"));
                }
                return string;
            }
            case SOURCE_CODE_QUALIFIED: {
                String string = RendererPackage.qualifiedNameForSourceCode(klass);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderClassifierName"));
                }
                return string;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    @NotNull
    public String renderType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderType"));
        }
        String string = this.renderNormalizedType(this.typeNormalizer.invoke(type2));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderType"));
        }
        return string;
    }

    @NotNull
    private String renderNormalizedType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderNormalizedType"));
        }
        if (type2 instanceof LazyType && this.debugMode) {
            String string = type2.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderNormalizedType"));
            }
            return string;
        }
        if (TypesPackage.isDynamic(type2)) {
            if ("dynamic" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderNormalizedType"));
            }
            return "dynamic";
        }
        if (TypesPackage.isFlexible(type2)) {
            if (this.debugMode) {
                String string = this.renderFlexibleTypeWithBothBounds(TypesPackage.flexibility(type2).getLowerBound(), TypesPackage.flexibility(type2).getUpperBound());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderNormalizedType"));
                }
                return string;
            }
            if (this.flexibleTypesForCode) {
                String prefix = this.nameShortness == NameShortness.SHORT ? "" : Flexibility.FLEXIBLE_TYPE_CLASSIFIER.getPackageFqName().asString() + ".";
                String string = prefix + Flexibility.FLEXIBLE_TYPE_CLASSIFIER.getRelativeClassName() + this.lt() + this.renderNormalizedType(TypesPackage.flexibility(type2).getLowerBound()) + ", " + this.renderNormalizedType(TypesPackage.flexibility(type2).getUpperBound()) + this.gt();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderNormalizedType"));
                }
                return string;
            }
            String string = this.renderFlexibleType(type2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderNormalizedType"));
            }
            return string;
        }
        String string = this.renderInflexibleType(type2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderNormalizedType"));
        }
        return string;
    }

    private String renderFlexibleTypeWithBothBounds(@NotNull JetType lower, @NotNull JetType upper) {
        if (lower == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lower", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFlexibleTypeWithBothBounds"));
        }
        if (upper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upper", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFlexibleTypeWithBothBounds"));
        }
        return "(" + this.renderNormalizedType(lower) + ".." + this.renderNormalizedType(upper) + ")";
    }

    private String renderInflexibleType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderInflexibleType"));
        }
        assert (!TypesPackage.isFlexible(type2)) : "Flexible types not allowed here: " + this.renderNormalizedType(type2);
        if (type2 == TypeUtils.CANT_INFER_LAMBDA_PARAM_TYPE || TypeUtils.isDontCarePlaceholder(type2)) {
            return "???";
        }
        if (ErrorUtils.isUninferredParameter(type2)) {
            if (this.uninferredTypeParameterAsName) {
                return this.renderError(((ErrorUtils.UninferredParameterTypeConstructor)type2.getConstructor()).getTypeParameterDescriptor().getName().toString());
            }
            return "???";
        }
        if (type2.isError()) {
            return this.renderDefaultType(type2);
        }
        if (this.shouldRenderAsPrettyFunctionType(type2)) {
            return this.renderFunctionType(type2);
        }
        return this.renderDefaultType(type2);
    }

    private boolean shouldRenderAsPrettyFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "shouldRenderAsPrettyFunctionType"));
        }
        return KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(type2) && this.prettyFunctionTypes;
    }

    @NotNull
    private String renderFlexibleType(@NotNull JetType type2) {
        String upperRendered;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFlexibleType"));
        }
        JetType lower = TypesPackage.flexibility(type2).getLowerBound();
        JetType upper = TypesPackage.flexibility(type2).getUpperBound();
        String lowerRendered = this.renderInflexibleType(lower);
        if (DescriptorRendererImpl.differsOnlyInNullability(lowerRendered, upperRendered = this.renderInflexibleType(upper))) {
            if (upperRendered.startsWith("(")) {
                String string = "(" + lowerRendered + ")!";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFlexibleType"));
                }
                return string;
            }
            String string = lowerRendered + "!";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFlexibleType"));
            }
            return string;
        }
        String kotlinPrefix = this.nameShortness != NameShortness.SHORT ? "kotlin." : "";
        String mutablePrefix = "Mutable";
        String simpleCollection = DescriptorRendererImpl.replacePrefixes(lowerRendered, kotlinPrefix + mutablePrefix, upperRendered, kotlinPrefix, kotlinPrefix + "(" + mutablePrefix + ")");
        if (simpleCollection != null) {
            String string = simpleCollection;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFlexibleType"));
            }
            return string;
        }
        String mutableEntry = DescriptorRendererImpl.replacePrefixes(lowerRendered, kotlinPrefix + "MutableMap.MutableEntry", upperRendered, kotlinPrefix + "Map.Entry", kotlinPrefix + "(Mutable)Map.(Mutable)Entry");
        if (mutableEntry != null) {
            String string = mutableEntry;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFlexibleType"));
            }
            return string;
        }
        String array = DescriptorRendererImpl.replacePrefixes(lowerRendered, kotlinPrefix + this.escape("Array<"), upperRendered, kotlinPrefix + this.escape("Array<out "), kotlinPrefix + this.escape("Array<(out) "));
        if (array != null) {
            String string = array;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFlexibleType"));
            }
            return string;
        }
        String string = this.renderFlexibleTypeWithBothBounds(lower, upper);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFlexibleType"));
        }
        return string;
    }

    @Nullable
    private static String replacePrefixes(@NotNull String lowerRendered, @NotNull String lowerPrefix, @NotNull String upperRendered, @NotNull String upperPrefix, @NotNull String foldedPrefix) {
        String lowerWithoutPrefix;
        if (lowerRendered == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lowerRendered", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "replacePrefixes"));
        }
        if (lowerPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lowerPrefix", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "replacePrefixes"));
        }
        if (upperRendered == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperRendered", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "replacePrefixes"));
        }
        if (upperPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperPrefix", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "replacePrefixes"));
        }
        if (foldedPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldedPrefix", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "replacePrefixes"));
        }
        if (lowerRendered.startsWith(lowerPrefix) && upperRendered.startsWith(upperPrefix) && DescriptorRendererImpl.differsOnlyInNullability(lowerWithoutPrefix = lowerRendered.substring(lowerPrefix.length()), upperRendered.substring(upperPrefix.length()))) {
            return foldedPrefix + lowerWithoutPrefix + "!";
        }
        return null;
    }

    private static boolean differsOnlyInNullability(String lower, String upper) {
        return lower.equals(upper.replace("?", "")) || upper.endsWith("?") && (lower + "?").equals(upper) || ("(" + lower + ")?").equals(upper);
    }

    @Override
    @NotNull
    public String renderTypeArguments(@NotNull List<TypeProjection> typeArguments) {
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderTypeArguments"));
        }
        if (typeArguments.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderTypeArguments"));
            }
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.lt());
        this.appendTypeProjections(typeArguments, sb);
        sb.append(this.gt());
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderTypeArguments"));
        }
        return string;
    }

    @NotNull
    private String renderDefaultType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderDefaultType"));
        }
        StringBuilder sb = new StringBuilder();
        if (type2.isError()) {
            sb.append(type2.getConstructor().toString());
        } else {
            sb.append(this.renderTypeName(type2.getConstructor()));
        }
        sb.append(this.renderTypeArguments(type2.getArguments()));
        if (type2.isMarkedNullable()) {
            sb.append("?");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderDefaultType"));
        }
        return string;
    }

    @NotNull
    private String renderTypeName(@NotNull TypeConstructor typeConstructor2) {
        if (typeConstructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderTypeName"));
        }
        ClassifierDescriptor cd = typeConstructor2.getDeclarationDescriptor();
        if (cd instanceof TypeParameterDescriptor) {
            String string = this.renderName(cd.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderTypeName"));
            }
            return string;
        }
        if (cd instanceof ClassDescriptor) {
            String string = this.renderClassifierName((ClassDescriptor)cd);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderTypeName"));
            }
            return string;
        }
        assert (cd == null) : "Unexpected classifier: " + cd.getClass();
        String string = typeConstructor2.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderTypeName"));
        }
        return string;
    }

    private void appendTypeProjections(@NotNull List<TypeProjection> typeProjections, @NotNull StringBuilder builder) {
        if (typeProjections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjections", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "appendTypeProjections"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "appendTypeProjections"));
        }
        Iterator<TypeProjection> iterator2 = typeProjections.iterator();
        while (iterator2.hasNext()) {
            TypeProjection typeProjection = iterator2.next();
            if (typeProjection.isStarProjection()) {
                builder.append("*");
            } else {
                if (typeProjection.getProjectionKind() != Variance.INVARIANT) {
                    builder.append(typeProjection.getProjectionKind()).append(" ");
                }
                builder.append(this.renderNormalizedType(typeProjection.getType()));
            }
            if (!iterator2.hasNext()) continue;
            builder.append(", ");
        }
    }

    @NotNull
    private String renderFunctionType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFunctionType"));
        }
        StringBuilder sb = new StringBuilder();
        JetType receiverType = KotlinBuiltIns.getReceiverType(type2);
        if (receiverType != null) {
            sb.append(this.renderNormalizedType(receiverType));
            sb.append(".");
        }
        sb.append("(");
        this.appendTypeProjections(KotlinBuiltIns.getParameterTypeProjectionsFromFunctionType(type2), sb);
        sb.append(") ").append(this.arrow()).append(" ");
        sb.append(this.renderNormalizedType(KotlinBuiltIns.getReturnTypeFromFunctionType(type2)));
        if (type2.isMarkedNullable()) {
            String string = "(" + sb + ")?";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFunctionType"));
            }
            return string;
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFunctionType"));
        }
        return string;
    }

    private void appendDefinedIn(@NotNull DeclarationDescriptor descriptor, @NotNull StringBuilder builder) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "appendDefinedIn"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "appendDefinedIn"));
        }
        if (descriptor instanceof PackageFragmentDescriptor || descriptor instanceof PackageViewDescriptor) {
            return;
        }
        if (descriptor instanceof ModuleDescriptor) {
            builder.append(" is a module");
            return;
        }
        builder.append(" ").append(this.renderMessage("defined in")).append(" ");
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration != null) {
            FqNameUnsafe fqName2 = DescriptorUtils.getFqName(containingDeclaration);
            builder.append(FqName.ROOT.equalsTo(fqName2) ? "root package" : this.renderFqName(fqName2));
        }
    }

    private void renderAnnotations(@NotNull Annotated annotated, @NotNull StringBuilder builder) {
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderAnnotations"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderAnnotations"));
        }
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.ANNOTATIONS)) {
            return;
        }
        for (AnnotationDescriptor annotation2 : annotated.getAnnotations()) {
            ClassDescriptor annotationClass = (ClassDescriptor)annotation2.getType().getConstructor().getDeclarationDescriptor();
            assert (annotationClass != null);
            if (this.excludedAnnotationClasses.contains(DescriptorUtils.getFqNameSafe(annotationClass))) continue;
            builder.append(this.renderAnnotation(annotation2)).append(" ");
        }
    }

    @Override
    @NotNull
    public String renderAnnotation(@NotNull AnnotationDescriptor annotation2) {
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderAnnotation"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.renderType(annotation2.getType()));
        if (this.verbose) {
            sb.append("(").append(UtilsPackage.join(this.renderAndSortAnnotationArguments(annotation2), ", ")).append(")");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderAnnotation"));
        }
        return string;
    }

    @NotNull
    private List<String> renderAndSortAnnotationArguments(@NotNull AnnotationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderAndSortAnnotationArguments"));
        }
        Set<Map.Entry<ValueParameterDescriptor, CompileTimeConstant<?>>> valueArguments2 = descriptor.getAllValueArguments().entrySet();
        ArrayList<String> resultList = new ArrayList<String>(valueArguments2.size());
        for (Map.Entry<ValueParameterDescriptor, CompileTimeConstant<?>> entry : valueArguments2) {
            CompileTimeConstant<?> value = entry.getValue();
            String typeSuffix = ": " + this.renderType(value.getType(KotlinBuiltIns.getInstance()));
            resultList.add(entry.getKey().getName().asString() + " = " + this.renderConstant(value) + typeSuffix);
        }
        Collections.sort(resultList);
        ArrayList<String> arrayList = resultList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderAndSortAnnotationArguments"));
        }
        return arrayList;
    }

    @NotNull
    private String renderConstant(@NotNull CompileTimeConstant<?> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderConstant"));
        }
        String string = value.accept(new DefaultAnnotationArgumentVisitor<String, Void>(){

            @Override
            public String visitValue(@NotNull CompileTimeConstant<?> value, Void data2) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl$1", "visitValue"));
                }
                return value.toString();
            }

            @Override
            public String visitArrayValue(ArrayValue value, Void data2) {
                List renderedElements = KotlinPackage.map(value.getValue(), new Function1<CompileTimeConstant<?>, String>(){

                    @Override
                    public String invoke(CompileTimeConstant<?> constant) {
                        return DescriptorRendererImpl.this.renderConstant(constant);
                    }
                });
                return "{" + UtilsPackage.join(renderedElements, ", ") + "}";
            }

            @Override
            public String visitAnnotationValue(AnnotationValue value, Void data2) {
                return DescriptorRendererImpl.this.renderAnnotation(value.getValue());
            }

            @Override
            public String visitJavaClassValue(JavaClassValue value, Void data2) {
                return DescriptorRendererImpl.this.renderType(value.getValue()) + ".class";
            }
        }, null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderConstant"));
        }
        return string;
    }

    private void renderVisibility(@NotNull Visibility visibility, @NotNull StringBuilder builder) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderVisibility"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderVisibility"));
        }
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.VISIBILITY)) {
            return;
        }
        if (this.normalizedVisibilities) {
            visibility = visibility.normalize();
        }
        if (!this.showInternalKeyword && visibility == Visibilities.INTERNAL) {
            return;
        }
        builder.append(this.renderKeyword(visibility.toString())).append(" ");
    }

    private void renderModality(@NotNull Modality modality, @NotNull StringBuilder builder) {
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderModality"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderModality"));
        }
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.MODALITY)) {
            return;
        }
        String keyword = modality.name().toLowerCase();
        builder.append(this.renderKeyword(keyword)).append(" ");
    }

    private void renderInner(boolean isInner, @NotNull StringBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderInner"));
        }
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.INNER)) {
            return;
        }
        if (isInner) {
            builder.append(this.renderKeyword("inner")).append(" ");
        }
    }

    private void renderModalityForCallable(@NotNull CallableMemberDescriptor callable2, @NotNull StringBuilder builder) {
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderModalityForCallable"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderModalityForCallable"));
        }
        if (!DescriptorUtils.isTopLevelDeclaration(callable2) || callable2.getModality() != Modality.FINAL) {
            if (DescriptorRendererImpl.overridesSomething(callable2) && this.overrideRenderingPolicy == DescriptorRenderer.OverrideRenderingPolicy.RENDER_OVERRIDE && callable2.getModality() == Modality.OPEN) {
                return;
            }
            this.renderModality(callable2.getModality(), builder);
        }
    }

    private static boolean overridesSomething(CallableMemberDescriptor callable2) {
        return !callable2.getOverriddenDescriptors().isEmpty();
    }

    private void renderOverride(@NotNull CallableMemberDescriptor callableMember, @NotNull StringBuilder builder) {
        if (callableMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMember", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderOverride"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderOverride"));
        }
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.OVERRIDE)) {
            return;
        }
        if (DescriptorRendererImpl.overridesSomething(callableMember) && this.overrideRenderingPolicy != DescriptorRenderer.OverrideRenderingPolicy.RENDER_OPEN) {
            builder.append("override ");
            if (this.verbose) {
                builder.append("/*").append(callableMember.getOverriddenDescriptors().size()).append("*/ ");
            }
        }
    }

    private void renderMemberKind(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.MEMBER_KIND)) {
            return;
        }
        if (this.verbose && callableMember.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            builder.append("/*").append(callableMember.getKind().name().toLowerCase()).append("*/ ");
        }
    }

    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "render"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        declarationDescriptor.accept(new RenderDeclarationDescriptorVisitor(), stringBuilder);
        if (this.withDefinedIn) {
            this.appendDefinedIn(declarationDescriptor, stringBuilder);
        }
        String string = stringBuilder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "render"));
        }
        return string;
    }

    private void renderTypeParameter(@NotNull TypeParameterDescriptor typeParameter, @NotNull StringBuilder builder, boolean topLevel) {
        String variance;
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderTypeParameter"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderTypeParameter"));
        }
        if (topLevel) {
            builder.append(this.lt());
        }
        if (this.verbose) {
            builder.append("/*").append(typeParameter.getIndex()).append("*/ ");
        }
        if (typeParameter.isReified()) {
            builder.append(this.renderKeyword("reified")).append(" ");
        }
        if (!(variance = typeParameter.getVariance().getLabel()).isEmpty()) {
            builder.append(this.renderKeyword(variance)).append(" ");
        }
        this.renderName(typeParameter, builder);
        int upperBoundsCount = typeParameter.getUpperBounds().size();
        if (upperBoundsCount > 1 && !topLevel || upperBoundsCount == 1) {
            JetType upperBound = typeParameter.getUpperBounds().iterator().next();
            if (!((Object)KotlinBuiltIns.getInstance().getDefaultBound()).equals(upperBound)) {
                builder.append(" : ").append(this.renderType(upperBound));
            }
        } else if (topLevel) {
            boolean first = true;
            for (JetType upperBound : typeParameter.getUpperBounds()) {
                if (((Object)upperBound).equals(KotlinBuiltIns.getInstance().getDefaultBound())) continue;
                if (first) {
                    builder.append(" : ");
                } else {
                    builder.append(" & ");
                }
                builder.append(this.renderType(upperBound));
                first = false;
            }
        }
        if (topLevel) {
            builder.append(this.gt());
        }
    }

    private void renderTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull StringBuilder builder, boolean withSpace) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderTypeParameters"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderTypeParameters"));
        }
        if (this.withoutTypeParameters) {
            return;
        }
        if (!typeParameters.isEmpty()) {
            builder.append(this.lt());
            Iterator<TypeParameterDescriptor> iterator2 = typeParameters.iterator();
            while (iterator2.hasNext()) {
                TypeParameterDescriptor typeParameterDescriptor = iterator2.next();
                this.renderTypeParameter(typeParameterDescriptor, builder, false);
                if (!iterator2.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(this.gt());
            if (withSpace) {
                builder.append(" ");
            }
        }
    }

    private void renderFunction(@NotNull FunctionDescriptor function, @NotNull StringBuilder builder) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFunction"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFunction"));
        }
        if (!this.startFromName) {
            this.renderAnnotations(function, builder);
            this.renderVisibility(function.getVisibility(), builder);
            this.renderModalityForCallable(function, builder);
            this.renderOverride(function, builder);
            this.renderMemberKind(function, builder);
            builder.append(this.renderKeyword("fun")).append(" ");
            this.renderTypeParameters(function.getTypeParameters(), builder, true);
            this.renderReceiver(function, builder);
        }
        this.renderName(function, builder);
        this.renderValueParameters(function, builder);
        this.renderReceiverAfterName(function, builder);
        JetType returnType = function.getReturnType();
        if (this.unitReturnType || returnType == null || !KotlinBuiltIns.isUnit(returnType)) {
            builder.append(": ").append(returnType == null ? "[NULL]" : this.escape(this.renderType(returnType)));
        }
        this.renderWhereSuffix(function.getTypeParameters(), builder);
    }

    private void renderReceiverAfterName(CallableDescriptor callableDescriptor, StringBuilder builder) {
        if (!this.receiverAfterName) {
            return;
        }
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            builder.append(" on ").append(this.escape(this.renderType(receiver.getType())));
        }
    }

    private void renderReceiver(CallableDescriptor callableDescriptor, StringBuilder builder) {
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            JetType type2 = receiver.getType();
            String result2 = this.escape(this.renderType(type2));
            if (this.shouldRenderAsPrettyFunctionType(type2) && !TypeUtils.isNullableType(type2)) {
                result2 = "(" + result2 + ")";
            }
            builder.append(result2).append(".");
        }
    }

    private void renderConstructor(@NotNull ConstructorDescriptor constructor2, @NotNull StringBuilder builder) {
        if (constructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderConstructor"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderConstructor"));
        }
        this.renderAnnotations(constructor2, builder);
        this.renderVisibility(constructor2.getVisibility(), builder);
        this.renderMemberKind(constructor2, builder);
        builder.append(this.renderKeyword("constructor")).append(" ");
        ClassDescriptor classDescriptor = constructor2.getContainingDeclaration();
        this.renderName(classDescriptor, builder);
        this.renderTypeParameters(classDescriptor.getTypeConstructor().getParameters(), builder, false);
        this.renderValueParameters(constructor2, builder);
        this.renderWhereSuffix(constructor2.getTypeParameters(), builder);
    }

    private void renderWhereSuffix(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull StringBuilder builder) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderWhereSuffix"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderWhereSuffix"));
        }
        if (this.withoutTypeParameters) {
            return;
        }
        ArrayList<String> upperBoundStrings = new ArrayList<String>(0);
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            if (typeParameter.getUpperBounds().size() <= 1) continue;
            boolean first = true;
            for (JetType upperBound : typeParameter.getUpperBounds()) {
                if (!first) {
                    upperBoundStrings.add(this.renderName(typeParameter.getName()) + " : " + this.escape(this.renderType(upperBound)));
                }
                first = false;
            }
        }
        if (!upperBoundStrings.isEmpty()) {
            builder.append(" ").append(this.renderKeyword("where")).append(" ");
            builder.append(UtilsPackage.join(upperBoundStrings, ", "));
        }
    }

    @Override
    @NotNull
    public String renderFunctionParameters(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFunctionParameters"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.renderValueParameters(functionDescriptor, stringBuilder);
        String string = stringBuilder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderFunctionParameters"));
        }
        return string;
    }

    private void renderValueParameters(@NotNull FunctionDescriptor function, @NotNull StringBuilder builder) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderValueParameters"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderValueParameters"));
        }
        boolean includeNames = !this.withoutFunctionParameterNames && (this.includeSynthesizedParameterNames || !function.hasSynthesizedParameterNames());
        this.handler.appendBeforeValueParameters(function, builder);
        for (ValueParameterDescriptor parameter : function.getValueParameters()) {
            this.handler.appendBeforeValueParameter(parameter, builder);
            this.renderValueParameter(parameter, includeNames, builder, false);
            this.handler.appendAfterValueParameter(parameter, builder);
        }
        this.handler.appendAfterValueParameters(function, builder);
    }

    private void renderValueParameter(@NotNull ValueParameterDescriptor valueParameter, boolean includeName, @NotNull StringBuilder builder, boolean topLevel) {
        boolean withDefaultValue;
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderValueParameter"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderValueParameter"));
        }
        if (topLevel) {
            builder.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.verbose) {
            builder.append("/*").append(valueParameter.getIndex()).append("*/ ");
        }
        this.renderAnnotations(valueParameter, builder);
        this.renderVariable(valueParameter, includeName, builder, topLevel);
        boolean bl = this.renderDefaultValues && (this.debugMode ? valueParameter.declaresDefaultValue() : valueParameter.hasDefaultValue()) ? true : (withDefaultValue = false);
        if (withDefaultValue) {
            builder.append(" = ...");
        }
    }

    private void renderValVarPrefix(@NotNull VariableDescriptor variable, @NotNull StringBuilder builder) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderValVarPrefix"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderValVarPrefix"));
        }
        builder.append(this.renderKeyword(variable.isVar() ? "var" : "val")).append(" ");
    }

    private void renderVariable(@NotNull VariableDescriptor variable, boolean includeName, @NotNull StringBuilder builder, boolean topLevel) {
        JetType typeToRender;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderVariable"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderVariable"));
        }
        JetType realType = variable.getType();
        JetType varargElementType = variable instanceof ValueParameterDescriptor ? ((ValueParameterDescriptor)variable).getVarargElementType() : null;
        JetType jetType = typeToRender = varargElementType != null ? varargElementType : realType;
        if (varargElementType != null) {
            builder.append(this.renderKeyword("vararg")).append(" ");
        }
        if (topLevel && !this.startFromName) {
            this.renderValVarPrefix(variable, builder);
        }
        if (includeName) {
            this.renderName(variable, builder);
            builder.append(": ");
        }
        builder.append(this.escape(this.renderType(typeToRender)));
        this.renderInitializer(variable, builder);
        if (this.verbose && varargElementType != null) {
            builder.append(" /*").append(this.escape(this.renderType(realType))).append("*/");
        }
    }

    private void renderProperty(@NotNull PropertyDescriptor property2, @NotNull StringBuilder builder) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderProperty"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderProperty"));
        }
        if (!this.startFromName) {
            this.renderAnnotations(property2, builder);
            this.renderVisibility(property2.getVisibility(), builder);
            this.renderModalityForCallable(property2, builder);
            this.renderOverride(property2, builder);
            this.renderMemberKind(property2, builder);
            this.renderValVarPrefix(property2, builder);
            this.renderTypeParameters(property2.getTypeParameters(), builder, true);
            this.renderReceiver(property2, builder);
        }
        this.renderName(property2, builder);
        builder.append(": ").append(this.escape(this.renderType(property2.getType())));
        this.renderReceiverAfterName(property2, builder);
        this.renderInitializer(property2, builder);
        this.renderWhereSuffix(property2.getTypeParameters(), builder);
    }

    private void renderInitializer(@NotNull VariableDescriptor variable, @NotNull StringBuilder builder) {
        CompileTimeConstant<?> initializer;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderInitializer"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderInitializer"));
        }
        if (this.includePropertyConstant && (initializer = variable.getCompileTimeInitializer()) != null) {
            builder.append(" = ").append(this.escape(this.renderConstant(initializer)));
        }
    }

    private void renderClass(@NotNull ClassDescriptor klass, @NotNull StringBuilder builder) {
        ConstructorDescriptor primaryConstructor2;
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderClass"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderClass"));
        }
        if (!this.startFromName) {
            this.renderAnnotations(klass, builder);
            this.renderVisibility(klass.getVisibility(), builder);
            if (!(klass.getKind() == ClassKind.TRAIT && klass.getModality() == Modality.ABSTRACT || klass.getKind().isSingleton() && klass.getModality() == Modality.FINAL)) {
                this.renderModality(klass.getModality(), builder);
            }
            this.renderInner(klass.isInner(), builder);
            this.renderClassKindPrefix(klass, builder);
        }
        if (!DescriptorUtils.isDefaultObject(klass)) {
            if (!this.startFromName) {
                DescriptorRendererImpl.renderSpaceIfNeeded(builder);
            }
            this.renderName(klass, builder);
        } else {
            this.renderDefaultObjectName(klass, builder);
        }
        List<TypeParameterDescriptor> typeParameters = klass.getTypeConstructor().getParameters();
        this.renderTypeParameters(typeParameters, builder, false);
        if (!klass.getKind().isSingleton() && this.classWithPrimaryConstructor && (primaryConstructor2 = klass.getUnsubstitutedPrimaryConstructor()) != null) {
            this.renderValueParameters(primaryConstructor2, builder);
        }
        this.renderSuperTypes(klass, builder);
        this.renderWhereSuffix(typeParameters, builder);
    }

    private void renderSuperTypes(@NotNull ClassDescriptor klass, @NotNull StringBuilder builder) {
        Collection<JetType> supertypes2;
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderSuperTypes"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderSuperTypes"));
        }
        if (this.withoutSuperTypes) {
            return;
        }
        if (!(klass.equals(KotlinBuiltIns.getInstance().getNothing()) || (supertypes2 = klass.getTypeConstructor().getSupertypes()).isEmpty() || supertypes2.size() == 1 && KotlinBuiltIns.isAnyOrNullableAny(supertypes2.iterator().next()))) {
            DescriptorRendererImpl.renderSpaceIfNeeded(builder);
            builder.append(": ");
            Iterator<JetType> iterator2 = supertypes2.iterator();
            while (iterator2.hasNext()) {
                JetType supertype = iterator2.next();
                builder.append(this.renderType(supertype));
                if (!iterator2.hasNext()) continue;
                builder.append(", ");
            }
        }
    }

    private void renderClassKindPrefix(ClassDescriptor klass, StringBuilder builder) {
        builder.append(this.renderKeyword(DescriptorRendererImpl.getClassKindPrefix(klass)));
    }

    @NotNull
    public static String getClassKindPrefix(@NotNull ClassDescriptor klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
        }
        if (klass.isDefaultObject()) {
            if ("class object" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
            }
            return "class object";
        }
        switch (klass.getKind()) {
            case CLASS: {
                if ("class" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
                }
                return "class";
            }
            case TRAIT: {
                if ("trait" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
                }
                return "trait";
            }
            case ENUM_CLASS: {
                if ("enum class" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
                }
                return "enum class";
            }
            case OBJECT: {
                if ("object" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
                }
                return "object";
            }
            case ANNOTATION_CLASS: {
                if ("annotation class" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
                }
                return "annotation class";
            }
            case ENUM_ENTRY: {
                if ("enum entry" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "getClassKindPrefix"));
                }
                return "enum entry";
            }
        }
        throw new IllegalStateException("unknown class kind: " + (Object)((Object)klass.getKind()));
    }

    private void renderModuleOrScript(@NotNull DeclarationDescriptor moduleOrScript, @NotNull StringBuilder builder) {
        if (moduleOrScript == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleOrScript", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderModuleOrScript"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderModuleOrScript"));
        }
        this.renderName(moduleOrScript, builder);
    }

    private void renderPackageView(@NotNull PackageViewDescriptor packageView, @NotNull StringBuilder builder) {
        if (packageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageView", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderPackageView"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderPackageView"));
        }
        builder.append(this.renderKeyword("package")).append(" ");
        builder.append(this.renderFqName(packageView.getFqName()));
        if (this.debugMode) {
            builder.append(" in context of ");
            this.renderName(packageView.getModule(), builder);
        }
    }

    private void renderPackageFragment(@NotNull PackageFragmentDescriptor fragment, @NotNull StringBuilder builder) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderPackageFragment"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/renderer/DescriptorRendererImpl", "renderPackageFragment"));
        }
        builder.append(this.renderKeyword("package-fragment")).append(" ");
        builder.append(this.renderFqName(fragment.getFqName()));
        if (this.debugMode) {
            builder.append(" in ");
            this.renderName(fragment.getContainingDeclaration(), builder);
        }
    }

    private class RenderDeclarationDescriptorVisitor
    extends DeclarationDescriptorVisitorEmptyBodies<Void, StringBuilder> {
        private RenderDeclarationDescriptorVisitor() {
        }

        @Override
        public Void visitValueParameterDescriptor(ValueParameterDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderValueParameter(descriptor, true, builder, true);
            return null;
        }

        @Override
        public Void visitVariableDescriptor(VariableDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderVariable(descriptor, true, builder, true);
            return null;
        }

        @Override
        public Void visitPropertyDescriptor(PropertyDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderProperty(descriptor, builder);
            return null;
        }

        @Override
        public Void visitFunctionDescriptor(FunctionDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderFunction(descriptor, builder);
            return null;
        }

        @Override
        public Void visitReceiverParameterDescriptor(ReceiverParameterDescriptor descriptor, StringBuilder data2) {
            throw new UnsupportedOperationException("Don't render receiver parameters");
        }

        @Override
        public Void visitConstructorDescriptor(ConstructorDescriptor constructorDescriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderConstructor(constructorDescriptor, builder);
            return null;
        }

        @Override
        public Void visitTypeParameterDescriptor(TypeParameterDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderTypeParameter(descriptor, builder, true);
            return null;
        }

        @Override
        public Void visitPackageFragmentDescriptor(PackageFragmentDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderPackageFragment(descriptor, builder);
            return null;
        }

        @Override
        public Void visitPackageViewDescriptor(PackageViewDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderPackageView(descriptor, builder);
            return null;
        }

        @Override
        public Void visitModuleDeclaration(ModuleDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderModuleOrScript(descriptor, builder);
            return null;
        }

        @Override
        public Void visitScriptDescriptor(ScriptDescriptor scriptDescriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderModuleOrScript(scriptDescriptor, builder);
            return null;
        }

        @Override
        public Void visitClassDescriptor(ClassDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderClass(descriptor, builder);
            return null;
        }
    }
}

