/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.InlineUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

public class InlineDescriptorUtils {
    public static boolean checkNonLocalReturnUsage(@NotNull DeclarationDescriptor fromFunction, @NotNull JetExpression startExpression, @NotNull BindingTrace trace) {
        if (fromFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFunction", "org/jetbrains/kotlin/resolve/InlineDescriptorUtils", "checkNonLocalReturnUsage"));
        }
        if (startExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startExpression", "org/jetbrains/kotlin/resolve/InlineDescriptorUtils", "checkNonLocalReturnUsage"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/InlineDescriptorUtils", "checkNonLocalReturnUsage"));
        }
        Object containingFunction = PsiTreeUtil.getParentOfType((PsiElement)startExpression, JetClassOrObject.class, JetDeclarationWithBody.class);
        if (containingFunction == null) {
            return false;
        }
        DeclarationDescriptor containingFunctionDescriptor = trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, containingFunction);
        if (containingFunctionDescriptor == null) {
            return false;
        }
        BindingContext bindingContext = trace.getBindingContext();
        while (containingFunction instanceof JetFunctionLiteral && fromFunction != containingFunctionDescriptor) {
            if (!InlineDescriptorUtils.isInlineLambda((JetFunctionLiteralExpression)(containingFunction = containingFunction.getParent()), bindingContext, true)) {
                return false;
            }
            containingFunction = (containingFunctionDescriptor = InlineDescriptorUtils.getContainingClassOrFunctionDescriptor(containingFunctionDescriptor, true)) != null ? DescriptorToSourceUtils.descriptorToDeclaration(containingFunctionDescriptor) : null;
        }
        return fromFunction == containingFunctionDescriptor;
    }

    public static boolean isInlineLambda(@NotNull JetFunctionLiteralExpression lambdaExpression, @NotNull BindingContext bindingContext, boolean checkNonLocalReturn) {
        if (lambdaExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "org/jetbrains/kotlin/resolve/InlineDescriptorUtils", "isInlineLambda"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/InlineDescriptorUtils", "isInlineLambda"));
        }
        JetExpression call = JetPsiUtil.getParentCallIfPresent(lambdaExpression);
        if (call != null) {
            ValueParameterDescriptor parameter;
            ArgumentMapping mapping2;
            ValueArgument argument;
            CallableDescriptor resultingDescriptor;
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(call, bindingContext);
            CallableDescriptor callableDescriptor = resultingDescriptor = resolvedCall == null ? null : resolvedCall.getResultingDescriptor();
            if (resultingDescriptor instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)resultingDescriptor).getInlineStrategy().isInline() && (argument = CallUtilPackage.getValueArgumentForExpression(resolvedCall.getCall(), lambdaExpression)) != null && (mapping2 = resolvedCall.getArgumentMapping(argument)) instanceof ArgumentMatch && !InlineUtil.hasNoinlineAnnotation(parameter = ((ArgumentMatch)mapping2).getValueParameter())) {
                return !checkNonLocalReturn || InlineDescriptorUtils.allowsNonLocalReturns(parameter);
            }
        }
        return false;
    }

    @Nullable
    public static DeclarationDescriptor getContainingClassOrFunctionDescriptor(@NotNull DeclarationDescriptor descriptor, boolean strict) {
        DeclarationDescriptor currentDescriptor;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/InlineDescriptorUtils", "getContainingClassOrFunctionDescriptor"));
        }
        DeclarationDescriptor declarationDescriptor = currentDescriptor = strict ? descriptor.getContainingDeclaration() : descriptor;
        while (currentDescriptor != null) {
            if (currentDescriptor instanceof FunctionDescriptor || currentDescriptor instanceof ClassDescriptor) {
                return currentDescriptor;
            }
            currentDescriptor = currentDescriptor.getContainingDeclaration();
        }
        return null;
    }

    public static boolean allowsNonLocalReturns(@NotNull CallableDescriptor lambdaDescriptor) {
        if (lambdaDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaDescriptor", "org/jetbrains/kotlin/resolve/InlineDescriptorUtils", "allowsNonLocalReturns"));
        }
        return !(lambdaDescriptor instanceof ValueParameterDescriptor) || !InlineUtil.hasOnlyLocalReturn((ValueParameterDescriptor)lambdaDescriptor);
    }
}

