/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function0;
import kotlin.Function1;
import kotlin.Function2;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage$callUtil$cc0355c8;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.JavaClassValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.BinaryOperationKey;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.EvaluatePackage$ConstantExpressionEvaluator$dd0d3756;
import org.jetbrains.kotlin.resolve.constants.evaluate.EvaluatePackage$OperationsMapGenerated$84f0a886;
import org.jetbrains.kotlin.resolve.constants.evaluate.EvaluatorContext;
import org.jetbrains.kotlin.resolve.constants.evaluate.UnaryOperationKey;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@KotlinClass(abiVersion=20, kind=KotlinClass.Kind.CLASS, data={"/\u001a)Y2i\u001c8ti\u0006tG/\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_JT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\be\u0016\u001cx\u000e\u001c<f\u0015%\u0019wN\\:uC:$8O\u0003\u0005fm\u0006dW/\u0019;f\u0015)QU\r\u001e,jg&$xN\u001d\u0006\u0004aNL'bE\"p[BLG.\u001a+j[\u0016\u001cuN\\:uC:$(bA!os*9!*\u001a;UsB,'\"\u0002;za\u0016\u001c(B\u0002\u001fj]&$hHC\u0003ue\u0006\u001cWM\u0003\u0007CS:$\u0017N\\4Ue\u0006\u001cWMC\rtiJLgnZ#yaJ,7o]5p]\u00163\u0018\r\\;bi>\u0014(bN\"p]N$\u0018M\u001c;FqB\u0014Xm]:j_:,e/\u00197vCR|'\u000fJ:ue&tw-\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_J$\u0013G\u0003\u0005hKR$&/Y2f\u0015U\u0019\u0017M\u001c\"f+N,G-\u00138B]:|G/\u0019;j_:T!\"\u001a=qe\u0016\u001c8/[8o\u00155QU\r^#yaJ,7o]5p]*9!i\\8mK\u0006t'\"G2sK\u0006$XmQ8na&dW\rV5nK\u000e{gn\u001d;b]RTQA^1mk\u0016TA\"\u001a=qK\u000e$X\r\u001a+za\u0016Ta![:QkJ,'BF;tKN4\u0016M]5bE2,\u0017i]\"p]N$\u0018M\u001c;\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\u0004PE*,7\r\u001e\u0006\u0018GJ,\u0017\r^3Pa\u0016\u0014\u0018\r^5p]\u0006\u0013x-^7f]RTa\"\u001a=qe\u0016\u001c8/[8o)f\u0004XMC\bd_6\u0004\u0018\u000e\\3US6,G+\u001f9f\u0015=\u0019u.\u001c9jY\u0016$\u0016.\\3UsB,'\"E(qKJ\fG/[8o\u0003J<W/\\3oi*i3i\u001c8ti\u0006tG/\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_J$s\n]3sCRLwN\\!sOVlWM\u001c;\u000bQ\r\u0014X-\u0019;f\u001fB,'/\u0019;j_:\f%oZ;nK:$hi\u001c:GSJ\u001cH\u000fU1sC6,G/\u001a:\u000b\u0011\u0005\u0014x-^7f]RTQCU3t_24X\r\u001a,bYV,\u0017I]4v[\u0016tGOC\u0003dC2d7OC\u0003n_\u0012,GNC\u0005qCJ\fW.\u001a;fe*Ab+\u00197vKB\u000b'/Y7fi\u0016\u0014H)Z:de&\u0004Ho\u001c:\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006#GJ,\u0017\r^3Pa\u0016\u0014\u0018\r^5p]\u0006\u0013x-^7f]R4uN\u001d*fG\u0016Lg/\u001a:\u000b\u0019I,7o\u001c7wK\u0012\u001c\u0015\r\u001c7\u000b\u0019I+7o\u001c7wK\u0012\u001c\u0015\r\u001c7\u000b%\r\u000bG\u000e\\1cY\u0016$Um]2sSB$xN\u001d\u0006\u0018W>$H.\u001b8/UZlg\u0006\u00157bi\u001a|'/\u001c+za\u0016Ta#\u001a<bYV\fG/\u001a\"j]\u0006\u0014\u00180\u00118e\u0007\",7m\u001b\u0006\te\u0016\u001cW-\u001b<fe*!a.Y7f\u0015\u0019\u0019FO]5oO*q1-\u00197m\u000bb\u0004(/Z:tS>t'\u0002D3wC2,\u0018\r^3DC2d'B\u0005:fG\u0016Lg/\u001a:FqB\u0014Xm]:j_:TQ#\u001a<bYV\fG/Z+oCJL\u0018I\u001c3DQ\u0016\u001c7N\u0003\tjg\u0012Kg/[:j_:\u0014\u0015PW3s_*q\u0011n\u001d)ve\u0016\u001cuN\\:uC:$(\u0002\u0005:fg>dg/Z!sOVlWM\u001c;t\u001591\u0018\r\\;f\u0003J<W/\\3oiNTA\u0001T5ti*ia+\u00197vK\u0006\u0013x-^7f]RTA!\u001e;jY*)b/[:ji\nKg.\u0019:z\u000bb\u0004(/Z:tS>t'b\u0005&fi\nKg.\u0019:z\u000bb\u0004(/Z:tS>t'\u0002\t<jg&$()\u001b8bef<\u0016\u000e\u001e5UsB,'\u000bS*FqB\u0014Xm]:j_:TaDS3u\u0005&t\u0017M]=FqB\u0014Xm]:j_:<\u0016\u000e\u001e5UsB,'\u000bS*\u000b'YL7/\u001b;DC2dW\t\u001f9sKN\u001c\u0018n\u001c8\u000b#)+GoQ1mY\u0016C\bO]3tg&|gNC\fwSNLGoQ8ogR\fg\u000e^#yaJ,7o]5p]*)\"*\u001a;D_:\u001cH/\u00198u\u000bb\u0004(/Z:tS>t'b\u0004<jg&$(*\u001a;FY\u0016lWM\u001c;\u000b\u000f\u0015dW-\\3oi*Q!*\u001a;FY\u0016lWM\u001c;\u000b-YL7/\u001b;MC\n,G.\u001a3FqB\u0014Xm]:j_:TACS3u\u0019\u0006\u0014W\r\\3e\u000bb\u0004(/Z:tS>t'\u0002\b<jg&$\b+\u0019:f]RDWm]5{K\u0012,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u001b\u0015\u0016$\b+\u0019:f]RDWm]5{K\u0012,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0019m&\u001c\u0018\u000e^)vC2Lg-[3e\u000bb\u0004(/Z:tS>t'B\u0006&fiF+\u0018\r\\5gS\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8\u000b3YL7/\u001b;TS6\u0004H.\u001a(b[\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0018\u0015\u0016$8+[7qY\u0016t\u0015-\\3FqB\u0014Xm]:j_:TQD^5tSR\u001cFO]5oOR+W\u000e\u001d7bi\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u001c\u0015\u0016$8\u000b\u001e:j]\u001e$V-\u001c9mCR,W\t\u001f9sKN\u001c\u0018n\u001c8\u000b)YL7/\u001b;V]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o\u0015IQU\r^+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u000f\u0011+g-Y;mi*\u001f!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!\u0002\u0002\u0005\u0003!!Qa\u0001C\u0004\u0011\u000fa\u0001!B\u0002\u0005\u0005!%A\u0002A\u0003\u0002\u0011\u0007)1\u0001B\u0003\t\u000b1\u0001QA\u0001\u0003\u0002\u0011\u0019)1\u0001\u0002\u0004\t\f1\u0001Qa\u0001C\u0002\u0011\u001fa\u0001!\u0002\u0002\u0005\u0004!=QA\u0001E\t\u0019\u0005)!\u0001\"\u0002\t\u0012\u0015\u0019Aq\u0001E\u000b\u0019\u0001)1\u0001B\u0003\t\u00171\u0001QA\u0001C\u0004\u0011+)!\u0001\u0002\u0002\t\n\u0015\t\u0001BD\u0003\u0003\t-Ai\"\u0002\u0002\u0005\u0018!yQA\u0001\u0003\u0007\u0011\u0017)1\u0001\"\u0002\t#1\u0001Qa\u0001\u0003\u0004\u0011Ga\u0001!\u0002\u0002\u0005\u0006!\u0011RA\u0001C\u0003\u0011E)!\u0001b\u0001\t)\u0015\u0011Aa\u0004E\u0015\u000b\r!y\u0002c\n\r\u0001\u0015\u0011A!\u0001\u0005\u0017\u000b\r!\t\u0003c\u000b\r\u0001\u0015\u0011Aq\u0004E\u0014\u000b\t!\t\u0003c\u000b\u0006\u0007\u0011}\u0001r\u0006\u0007\u0001\u000b\r!\t\u0003\u0003\r\r\u0001\u0015\u0011Aq\u0004E\u0018\u000b\r!Q\u0001#\u000e\r\u0001\u0015\u0011Aq\u0003E\u001b\u000b\r!Q\u0001C\u0010\r\u0001\u0015\u0019Aq\u0001E \u0019\u0001)!\u0001B\u0006\tA\u0015\u0011AA\u0006\u0005 \u000b\r!9\u0001C\u0011\r\u0001\u0015\u0011Aq\u0001\u0005\"\u000b\r!9\u0001\u0003\u0012\r\u0001\u0015\u0011Aq\u0001\u0005#\u000b\r!9\u0001C\u0012\r\u0001\u0015\u0011Aq\u0001\u0005$\u000b\r!9\u0001\u0003\u0013\r\u0001\u0015\u0011Aq\u0001\u0005%\u000b\r!9\u0001c\u0013\r\u0001\u0015\u0011Aq\u0001E&\u000b\r!9\u0001#\u0014\r\u0001\u0015\u0011Aq\u0001E'\u000b\r!9\u0001c\u0014\r\u0001\u0015\u0011Aq\u0001E(\u000b\r!9\u0001#\u0015\r\u0001\u0015\u0011Aq\u0001E)\u000b\r!9\u0001c\u0015\r\u0001\u0015\u0011Aq\u0001E*\u000b\r!9\u0001#\u0016\r\u0001\u0015\u0011Aq\u0001E+\u000b\r!9\u0001c\u0016\r\u0001\u0015\u0011Aq\u0001E,\t\ra1\u0001\u0005\u0017\u001a!\u0015\t\u0001\u0002B\u0005\n\u0013!)\u0011\u0001#\u0003\n\u000b\u0011\r\u0011bA\u0003\u0002\u0011\u0017a\t!C\u0002\n\u0005\u0015\t\u0001R\u0002\u000f-9Gi3\u0002B1\u00051!\t#!B\u0001\t\u0011U\u001bA!B\u0002\u0005\u0011%\t\u0001\u0012C\u0017\u0010\t\u0001$\u0001dB\u0011\u0003\u000b\u0005Aq!V\u0002\t\u000b\r!q!C\u0001\t\u00105\u0019A!C\u0005\u0002\u0011\u001fi3\u0003B\u0001\u0019\u0014u5A\u0001\u0001\u0005\u000b\u001b\t)\u0011\u0001C\u0005Q\u0007\u0001\t#!B\u0001\t\u0014E\u001bQ\u0001b\u0005\n\u0003\u0011\u0005Q\"\u0001\u0005\u000b[\t\u0007A\u0001\u0001M\f;\u001f!\u0001\u0001\u0003\u0007\u000e\u0007\u0015\t\u00012\u0002G\u0001!\u000e\u0001Qt\u0002\u0003\u0001\u00113i1!B\u0001\t\u000e1\u0005\u0001k!\u0001\u001e\u000e\u0011\t\u0001\"D\u0007\u0003\u000b\u0005A\u0019\u0002U\u0002\u0002;\u001b!\u0011\u0001c\u0005\u000e\u0005\u0015\t\u00012\u0003)\u0004\u0004u5A!\u0001E\u000e\u001b\t)\u0011\u0001c\u0005Q\u0007\t\t\u0013\"B\u0001\t\n%)A1A\u0005\u0004\u000b\u0005AY\u0001$\u0001\r\u0002E\u001bQ\u0002b\u0006\n\u0003!UQ\"\u0001\u0005\r\u001b\u0005AI\"D\u0001\u0005\u00025\tA\u0011A\u0007\u0002\t\u0003iS\u0006B\u0001\u0019 u5A\u0001\u0001\u0005\u000b\u001b\t)\u0011\u0001C\u0005Q\u0007\u0001ij\u0001\u0002\u0001\t!5\u0011Q!\u0001E\u0007!\u000e\u0005Q\u0014\u0004\u0003\u0001\u0011Ci\u0001\"B\u0001\t\u001b%)A1A\u0005\u0004\u000b\u0005AY\u0001$\u0001Q\u0007\u0005\t3!B\u0001\t\u001c1\u0005\u0011kA\u0005\u0005 %\t\u0001BD\u0007\u0002\u0011)i\u0011\u0001#\u0007\u000e\u0003!uQ6\b\u0003\u00021Kij\u0001\u0002\u0001\t'5\u0011Q!\u0001\u0005\u0011!\u000e\u0001QT\u0002\u0003\u0001\u0011Ui!!B\u0001\t#A\u001b\t!I\u0002\u0006\u0003!mA\u0012A)\u0004\u000f\u0011\u0015\u0012\"\u0001\u0005\u000f\u001b\u0005A\u0019#D\u0001\t%5>C!\u0001M\u0017;C!\u0001\u0001C\f\u000e\u0019\u0015\t\u0001RE\u0005\n\t\u0007Iq!B\u0001\t'AERcA\u0003\u0002\u0011Ma\t\u0001U\u0002\u0001;\u001b!\u0001\u0001\u0003\u0006\u000e\u0005\u0015\t\u0001\"\u0003)\u0004\u0002\u0005\u001aQ!\u0001E\u000e\u0019\u0003\t6a\u0002C\u0017\u0013\u0005Aa\"D\u0001\t(5\t\u0001BCW%\t\u0005A2!(\u0004\u0005\u0001!QQBA\u0003\u0002\u0011%\u00016\u0001AO\b\t\u0001AI\"D\u0002\u0006\u0003!5A\u0012\u0001)\u0004\u0002\u0005JQ!\u0001E\u0005\u0013\u0015!\u0019!C\u0002\u0006\u0003!-A\u0012\u0001G\u0001#\u000e9AaA\u0005\u0002\u0011+i\u0011\u0001\u0003\u0006\u000e\u0003!eQ\u0016\r\u0003\u00021eij\u0001\u0002\u0001\t45\u0011Q!\u0001E\u000e!\u000e\u0001QT\u0002\u0003\u0001\u0011Ui!!B\u0001\t\u001cA\u001b\t!(\u0004\u0005\u0001!QRBA\u0003\u0002\u0011Q\u00016!AO\u0007\t\u0001A1$\u0004\u0002\u0006\u0003!I\u0001ka\u0001\"\u0007\u0015\t\u00012\u0002G\u0001#\u000eYA!G\u0005\u0002\u00111i\u0011\u0001\u0003\b\u000e\u0003!qQ\"\u0001E\u0015\u001b\u0005A!\"\f\u0018\u0005\u0003a]RT\u0002\u0003\u0001\u0011mi!!B\u0001\t\u0013A\u001b\u0001!(\u0004\u0005\u0001!aRBA\u0003\u0002\u0011%\u00016\u0011AO\b\t\u0001AI\"D\u0002\u0006\u0003!5A\u0012\u0001)\u0004\u0003\u0005JQ!\u0001E\u0005\u0013\u0015!\u0019!C\u0002\u0006\u0003!-A\u0012\u0001G\u0001#\u000eIAqG\u0005\u0002\u0011+i\u0011\u0001\u0003\u0006\u000e\u0003!QQ\"\u0001E\r[\u001d\"\u0011\u0001'\u000f\u001e\u000e\u0011\u0001\u00012G\u0007\u0003\u000b\u0005AY\u0002U\u0002\u0001;\u001b!\u0001\u0001\u0003\u000e\u000e\u0005\u0015\t\u0001\u0002\u0006)\u0004\u0002u5A\u0001\u0001\u0005\u001c\u001b\t)\u0011\u0001C\u0005Q\u0007\u0005\t3!B\u0001\t\f1\u0005\u0011kA\u0005\u0005:%\t\u0001\u0002D\u0007\u0002\u00119i\u0011\u0001#\u000b\u000e\u0003!QQ6\b\u0003\u00021uij\u0001\u0002\u0001\t55\u0011Q!\u0001\u0005\u0015!\u000e\u0001Qt\u0002\u0003\u0001\u0011Ui1!B\u0001\t\f1\u0005\u0001k!\u0001\"\u0005\u0015\t\u00012C)\u0004\u000f\u0011i\u0012\"\u0001C\u0001\u001b\u0005AI#D\u0001\t\u00195\u001aB!\u0001M\u001e;\u001b!\u0001\u0001\u0003\u0006\u000e\u0005\u0015\t\u0001\"\u0003)\u0004\u0001\u0005\u0012Q!\u0001E\n#\u000e)A1H\u0005\u0002\t\u0003i\u0011\u0001\u0003\u0006.V\u0011\t\u0001DHO\u000b\t\u0001Ai$\u0004\u0004\u0006\u0003!)\u0012bA\u0005\u0003\u000b\u0005AY\u0003U\u0002\u0001;\u001b!\u0001\u0001#\u0007\u000e\u0005\u0015\t\u0001R\u0002)\u0004\u0002\u0005bQ!\u0001\u0005\u0016\u0013%I\u0001\"B\u0001\t\n%)A1A\u0005\u0004\u000b\u0005AY\u0001$\u0001R\u0007\u001d!a$C\u0001\t.5\t\u0001RF\u0007\u0002\u00113i3\u0003B\u0001\u0019\u001cu5A\u0001\u0001\u0005\u000b\u001b\t)\u0011\u0001C\u0005Q\u0007\u0001\t#!B\u0001\t\u0014E\u001bQ\u0001b\u0007\n\u0003\u0011\u0005Q\"\u0001\u0005\u000b[\u0013\"1\u0002'\u0011\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005Aq\u0003U\u0002\u0001;\u001f!\u0001\u0001#\u0007\u000e\u0007\u0015\t\u0001R\u0002G\u0001!\u000e\u0005\u0011%C\u0003\u0002\u0011\u0013IQ\u0001b\u0001\n\u0007\u0015\t\u00012\u0002G\u0001\u0019\u0003\t6a\u0002C!\u0013\u0005A)\"D\u0001\t05\t\u0001\u0012DW%\t-A\u001a%(\u0004\u0005\u0001!QQBA\u0003\u0002\u0011a\u00016\u0001AO\b\t\u0001AI\"D\u0002\u0006\u0003!5A\u0012\u0001)\u0004\u0002\u0005JQ!\u0001E\u0005\u0013\u0015!\u0019!C\u0002\u0006\u0003!-A\u0012\u0001G\u0001#\u000e9A1I\u0005\u0002\u0011+i\u0011\u0001#\r\u000e\u0003!eQ\u0016\n\u0003\f1\u000bjj\u0001\u0002\u0001\t\u00155\u0011Q!\u0001\u0005\u001a!\u000e\u0001Qt\u0002\u0003\u0001\u00113i1!B\u0001\t\u000e1\u0005\u0001k!\u0001\"\u0013\u0015\t\u0001\u0012B\u0005\u0006\t\u0007I1!B\u0001\t\f1\u0005A\u0012A)\u0004\u000f\u0011\u0015\u0013\"\u0001E\u000b\u001b\u0005A\u0019$D\u0001\t\u001a5&Ca\u0003M$;\u001b!\u0001\u0001\u0003\u0006\u000e\u0005\u0015\t\u0001B\u0007)\u0004\u0001u=A\u0001\u0001E\r\u001b\r)\u0011\u0001#\u0004\r\u0002A\u001b\t!I\u0005\u0006\u0003!%\u0011\"\u0002C\u0002\u0013\r)\u0011\u0001c\u0003\r\u00021\u0005\u0011kA\u0004\u0005H%\t\u0001RC\u0007\u0002\u0011ki\u0011\u0001#\u0007.J\u0011Y\u0001\u0014JO\u0007\t\u0001AQ%\u0004\u0002\u0006\u0003!Y\u0002k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0012D\u0007\u0004\u000b\u0005Ai\u0001$\u0001Q\u0007\u0003\t\u0013\"B\u0001\t\n%)A1A\u0005\u0004\u000b\u0005AY\u0001$\u0001\r\u0002E\u001bq\u0001\"\u0013\n\u0003!UQ\"\u0001E\u001c\u001b\u0005AI\",\u0013\u0005\u0017a1ST\u0002\u0003\u0001\u0011)i!!B\u0001\t9A\u001b\u0001!h\u0004\u0005\u0001!eQbA\u0003\u0002\u0011\u001ba\t\u0001UB\u0001C%)\u0011\u0001#\u0003\n\u000b\u0011\r\u0011bA\u0003\u0002\u0011\u0017a\t\u0001$\u0001R\u0007\u001d!a%C\u0001\t\u00165\t\u0001\u0012H\u0007\u0002\u00113iK\u0005B\u0006\u0019Ou5A\u0001\u0001\u0005\u000b\u001b\t)\u0011\u0001C\u000fQ\u0007\u0001iz\u0001\u0002\u0001\t\u001a5\u0019Q!\u0001E\u0007\u0019\u0003\u00016\u0011A\u0011\n\u000b\u0005AI!C\u0003\u0005\u0004%\u0019Q!\u0001E\u0006\u0019\u0003a\t!U\u0002\b\t\u001dJ\u0011\u0001#\u0006\u000e\u0003!mR\"\u0001E\r[\u0013\"1\u0002\u0007\u0015\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005Aa\u0004U\u0002\u0001;\u001f!\u0001\u0001#\u0007\u000e\u0007\u0015\t\u0001R\u0002G\u0001!\u000e\u0005\u0011%C\u0003\u0002\u0011\u0013IQ\u0001b\u0001\n\u0007\u0015\t\u00012\u0002G\u0001\u0019\u0003\t6a\u0002\u0003)\u0013\u0005A)\"D\u0001\t>5\t\u0001\u0012DW%\t-A\u0012&(\u0004\u0005\u0001!QQBA\u0003\u0002\u0011}\u00016\u0001AO\b\t\u0001AI\"D\u0002\u0006\u0003!5A\u0012\u0001)\u0004\u0002\u0005JQ!\u0001E\u0005\u0013\u0015!\u0019!C\u0002\u0006\u0003!-A\u0012\u0001G\u0001#\u000e9A!K\u0005\u0002\u0011+i\u0011\u0001c\u0010\u000e\u0003!eQ\u0016\n\u0003\f1)jj\u0001\u0002\u0001\t\u00155\u0011Q!\u0001\u0005!!\u000e\u0001Qt\u0002\u0003\u0001\u00113i1!B\u0001\t\u000e1\u0005\u0001k!\u0001\"\u0013\u0015\t\u0001\u0012B\u0005\u0006\t\u0007I1!B\u0001\t\f1\u0005A\u0012A)\u0004\u000f\u0011Q\u0013\"\u0001E\u000b\u001b\u0005A\t%D\u0001\t\u001a5&Ca\u0003\r,;\u001b!\u0001\u0001\u0003\u0006\u000e\u0005\u0015\t\u0001\"\t)\u0004\u0001u=A\u0001\u0001E\r\u001b\r)\u0011\u0001#\u0004\r\u0002A\u001b\t!I\u0005\u0006\u0003!%\u0011\"\u0002C\u0002\u0013\r)\u0011\u0001c\u0003\r\u00021\u0005\u0011kA\u0004\u0005W%\t\u0001RC\u0007\u0002\u0011\u0007j\u0011\u0001#\u00076*\u0015\u001dB!9\u0001\u0019\u000eu5A\u0001\u0001\u0005\b\u001b\t)\u0011\u0001C\u0004Q\u0007\u0001\t#!B\u0001\t\u0007E\u001bQ\u0001\"\u0004\n\u0003\u0011\u0001Q\"\u0001E\b"})
public final class ConstantExpressionEvaluator
extends JetVisitor<CompileTimeConstant<?>, JetType>
implements KObject {
    public static final /* synthetic */ KClass $kotlinClass;
    private final stringExpressionEvaluator.1 stringExpressionEvaluator;
    @NotNull
    private final BindingTrace trace;
    public static final Default Default;
    @Deprecated
    public static final Default OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(ConstantExpressionEvaluator.class);
        OBJECT$ = Default = org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator$Default.access$init$0();
    }

    private final CompileTimeConstant<?> evaluate(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="expectedType", type="?") JetType expectedType) {
        CompileTimeConstant recordedCompileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        if (recordedCompileTimeConstant != null) {
            return recordedCompileTimeConstant;
        }
        JetVisitor jetVisitor = this;
        JetType jetType = expectedType;
        if (jetType == null) {
            jetType = TypeUtils.NO_EXPECTED_TYPE;
        }
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)expression.accept(jetVisitor, jetType);
        if (compileTimeConstant != null) {
            this.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, compileTimeConstant);
            return compileTimeConstant;
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitConstantExpression(@JetValueParameter(name="expression") @NotNull JetConstantExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Object object;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        String text = expression.getText();
        if (text == null) {
            return null;
        }
        IElementType nodeElementType = expression.getNode().getElementType();
        if (Intrinsics.areEqual(nodeElementType, JetNodeTypes.NULL)) {
            return NullValue.NULL;
        }
        Function0<Boolean> function0 = nodeElementType;
        if (Intrinsics.areEqual(function0, JetNodeTypes.INTEGER_CONSTANT)) {
            object = EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.parseLong(text);
        } else if (Intrinsics.areEqual(function0, JetNodeTypes.FLOAT_CONSTANT)) {
            object = EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.parseFloatingLiteral(text);
        } else if (Intrinsics.areEqual(function0, JetNodeTypes.BOOLEAN_CONSTANT)) {
            object = EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.parseBoolean(text);
        } else if (Intrinsics.areEqual(function0, JetNodeTypes.CHARACTER_CONSTANT)) {
            object = CompileTimeConstantChecker.parseChar(expression);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported constant: " + expression);
        }
        Long result2 = object;
        if (result2 == null) {
            return null;
        }
        function0 = new Function0<Boolean>(nodeElementType, text){
            final /* synthetic */ IElementType $nodeElementType;
            final /* synthetic */ String $text;

            public final boolean invoke() {
                return Intrinsics.areEqual(this.$nodeElementType, JetNodeTypes.INTEGER_CONSTANT) ? EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.hasLongSuffix(this.$text) : false;
            }
            {
                this.$nodeElementType = iElementType;
                this.$text = string;
            }
        };
        return this.createCompileTimeConstant(result2, expectedType, !(function0).invoke(), true, false);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitParenthesizedExpression(@JetValueParameter(name="expression") @NotNull JetParenthesizedExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression deparenthesizedExpression = JetPsiUtil.deparenthesize(expression);
        if (deparenthesizedExpression != null ? Intrinsics.areEqual(deparenthesizedExpression, expression) ^ true : false) {
            return this.evaluate(deparenthesizedExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitLabeledExpression(@JetValueParameter(name="expression") @NotNull JetLabeledExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression != null) {
            return this.evaluate(baseExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitStringTemplateExpression(@JetValueParameter(name="expression") @NotNull JetStringTemplateExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        StringBuilder sb = new StringBuilder();
        int interupted = 0;
        int canBeUsedInAnnotation = 1;
        int usesVariableAsConstant = 0;
        JetStringTemplateEntry[] jetStringTemplateEntryArray = expression.getEntries();
        for (int i = 0; i < jetStringTemplateEntryArray.length; ++i) {
            JetStringTemplateEntry entry;
            JetStringTemplateEntry jetStringTemplateEntry = entry = jetStringTemplateEntryArray[i];
            Intrinsics.checkExpressionValueIsNotNull(jetStringTemplateEntry, "entry");
            StringValue constant = this.stringExpressionEvaluator.evaluate(jetStringTemplateEntry);
            if (constant == null) {
                interupted = 1;
                break;
            }
            if (!constant.canBeUsedInAnnotations()) {
                canBeUsedInAnnotation = 0;
            }
            if (constant.usesVariableAsConstant()) {
                usesVariableAsConstant = 1;
            }
            sb.append((String)constant.getValue());
        }
        return interupted == 0 ? this.createCompileTimeConstant(sb.toString(), expectedType, true, canBeUsedInAnnotation != 0, usesVariableAsConstant != 0) : (CompileTimeConstant<?>)null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryWithTypeRHSExpression(@JetValueParameter(name="expression") @NotNull JetBinaryExpressionWithTypeRHS expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression jetExpression = expression.getLeft();
        Intrinsics.checkExpressionValueIsNotNull(jetExpression, "expression.getLeft()");
        return this.evaluate(jetExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryExpression(@JetValueParameter(name="expression") @NotNull JetBinaryExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression leftExpression = expression.getLeft();
        if (leftExpression == null) {
            return null;
        }
        IElementType operationToken = expression.getOperationToken();
        if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationToken)) {
            boolean bl;
            JetType booleanType = KotlinBuiltIns.getInstance().getBooleanType();
            CompileTimeConstant<?> leftConstant = this.evaluate(leftExpression, booleanType);
            if (leftConstant == null) {
                return null;
            }
            JetExpression rightExpression = expression.getRight();
            if (rightExpression == null) {
                return null;
            }
            CompileTimeConstant<?> rightConstant = this.evaluate(rightExpression, booleanType);
            if (rightConstant == null) {
                return null;
            }
            Object leftValue = leftConstant.getValue();
            Object rightValue = rightConstant.getValue();
            boolean bl2 = !(!(leftValue instanceof Boolean)) ? !(rightValue instanceof Boolean) : true;
            if (bl2) {
                return null;
            }
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, JetTokens.ANDAND)) {
                bl = ((Boolean)leftValue).booleanValue() ? (Boolean)rightValue : false;
            } else if (Intrinsics.areEqual(iElementType, JetTokens.OROR)) {
                bl = !((Boolean)leftValue).booleanValue() ? (Boolean)rightValue : true;
            } else {
                throw (Throwable)new IllegalArgumentException("Unknown boolean operation token " + operationToken);
            }
            boolean result2 = bl;
            boolean usesVariableAsConstant = !leftConstant.usesVariableAsConstant() ? rightConstant.usesVariableAsConstant() : true;
            return this.createCompileTimeConstant(result2, expectedType, true, true, usesVariableAsConstant);
        }
        JetExpression jetExpression = expression.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull(jetExpression, "expression.getOperationReference()");
        return this.evaluateCall(jetExpression, leftExpression, expectedType);
    }

    /*
     * WARNING - void declaration
     */
    private final CompileTimeConstant<?> evaluateCall(@JetValueParameter(name="callExpression") JetExpression callExpression, @JetValueParameter(name="receiverExpression") JetExpression receiverExpression, @JetValueParameter(name="expectedType", type="?") JetType expectedType) {
        JetElement jetElement = callExpression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage$callUtil$cc0355c8.getResolvedCall(jetElement, bindingContext);
        if (resolvedCall == null) {
            return null;
        }
        Name resultingDescriptorName = resolvedCall.getResultingDescriptor().getName();
        OperationArgument argumentForReceiver = this.createOperationArgumentForReceiver(resolvedCall, receiverExpression);
        if (argumentForReceiver == null) {
            return null;
        }
        Set<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> argumentsEntrySet = resolvedCall.getValueArguments().entrySet();
        if (argumentsEntrySet.isEmpty()) {
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "resultingDescriptorName.asString()");
            Object result2 = this.evaluateUnaryAndCheck(argumentForReceiver, string, callExpression);
            if (result2 == null) {
                return null;
            }
            boolean isArgumentPure = this.isPureConstant(argumentForReceiver.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression());
            boolean isNumberConversionMethod = OperatorConventions.NUMBER_CONVERSIONS.contains(resultingDescriptorName);
            return this.createCompileTimeConstant(result2, expectedType, !isNumberConversionMethod ? isArgumentPure : false, canBeUsedInAnnotation, usesVariableAsConstant);
        }
        if (argumentsEntrySet.size() == 1) {
            void parameter;
            void argument;
            Map.Entry canBeUsedInAnnotation = (Map.Entry)KotlinPackage.first((Iterable)argumentsEntrySet);
            ValueParameterDescriptor result2 = (ValueParameterDescriptor)KotlinPackage.component1(canBeUsedInAnnotation);
            ResolvedValueArgument isArgumentPure = (ResolvedValueArgument)KotlinPackage.component2(canBeUsedInAnnotation);
            canBeUsedInAnnotation = null;
            void v3 = argument;
            Intrinsics.checkExpressionValueIsNotNull(v3, "argument");
            void v4 = parameter;
            Intrinsics.checkExpressionValueIsNotNull(v4, "parameter");
            OperationArgument argumentForParameter = this.createOperationArgumentForFirstParameter((ResolvedValueArgument)v3, (ValueParameterDescriptor)v4);
            if (argumentForParameter == null) {
                return null;
            }
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "resultingDescriptorName.asString()");
            if (this.isDivisionByZero(string, argumentForParameter.getValue())) {
                return ErrorValue.create("Division by zero");
            }
            String string2 = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "resultingDescriptorName.asString()");
            Object result3 = this.evaluateBinaryAndCheck(argumentForReceiver, argumentForParameter, string2, callExpression);
            if (result3 == null) {
                return null;
            }
            boolean areArgumentsPure = this.isPureConstant(argumentForReceiver.getExpression()) ? this.isPureConstant(argumentForParameter.getExpression()) : false;
            boolean canBeUsedInAnnotation2 = this.canBeUsedInAnnotation(argumentForReceiver.getExpression()) ? this.canBeUsedInAnnotation(argumentForParameter.getExpression()) : false;
            boolean usesVariableAsConstant = !this.usesVariableAsConstant(argumentForReceiver.getExpression()) ? this.usesVariableAsConstant(argumentForParameter.getExpression()) : true;
            EvaluatorContext c = new EvaluatorContext(canBeUsedInAnnotation2, areArgumentsPure, usesVariableAsConstant);
            Name name = resultingDescriptorName;
            return Intrinsics.areEqual(name, OperatorConventions.COMPARE_TO) ? EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.createCompileTimeConstantForCompareTo(result3, callExpression, c) : (Intrinsics.areEqual(name, OperatorConventions.EQUALS) ? EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.createCompileTimeConstantForEquals(result3, callExpression, c) : this.createCompileTimeConstant(result3, expectedType, areArgumentsPure, canBeUsedInAnnotation2, usesVariableAsConstant));
        }
        return null;
    }

    private final boolean usesVariableAsConstant(@JetValueParameter(name="expression") JetExpression expression) {
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        return compileTimeConstant != null ? compileTimeConstant.usesVariableAsConstant() : false;
    }

    private final boolean canBeUsedInAnnotation(@JetValueParameter(name="expression") JetExpression expression) {
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        return compileTimeConstant != null ? compileTimeConstant.canBeUsedInAnnotations() : false;
    }

    private final boolean isPureConstant(@JetValueParameter(name="expression") JetExpression expression) {
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        if (compileTimeConstant instanceof IntegerValueConstant) {
            return ((IntegerValueConstant)compileTimeConstant).isPure();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Object evaluateUnaryAndCheck(@JetValueParameter(name="receiver") OperationArgument receiver, @JetValueParameter(name="name") String name, @JetValueParameter(name="callExpression") JetExpression callExpression) {
        void check;
        void function;
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> functions2 = EvaluatePackage$OperationsMapGenerated$84f0a886.getUnaryOperations().get(new UnaryOperationKey(receiver.getCtcType(), name));
        if (functions2 == null) {
            return null;
        }
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> pair = functions2;
        Function1<? super Object, ? extends Object> function1 = pair.component1();
        Function1<? super Long, ? extends Long> function12 = pair.component2();
        pair = null;
        Object result2 = function.invoke(receiver.getValue());
        if (Intrinsics.areEqual(check, EvaluatePackage$OperationsMapGenerated$84f0a886.getEmptyUnaryFun())) {
            return result2;
        }
        KotlinPackage.assert(EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.isIntegerType(receiver.getValue()), "Only integer constants should be checked for overflow");
        KotlinPackage.assert(Intrinsics.areEqual(name, "minus"), "Only negation should be checked for overflow");
        if (Intrinsics.areEqual(receiver.getValue(), result2)) {
            PsiElement psiElement = callExpression;
            DiagnosticFactory0<JetExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
            BindingTrace bindingTrace = this.trace;
            JetExpression jetExpression = PsiTreeUtil.getParentOfType(psiElement, JetExpression.class, true);
            JetExpression jetExpression2 = jetExpression;
            if (jetExpression2 == null) {
                jetExpression2 = callExpression;
            }
            bindingTrace.report(diagnosticFactory0.on((JetExpression)((PsiElement)jetExpression2)));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Object evaluateBinaryAndCheck(@JetValueParameter(name="receiver") OperationArgument receiver, @JetValueParameter(name="parameter") OperationArgument parameter, @JetValueParameter(name="name") String name, @JetValueParameter(name="callExpression") JetExpression callExpression) {
        boolean bl;
        void checker;
        Object var9_9;
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> functions2 = EvaluatePackage$OperationsMapGenerated$84f0a886.getBinaryOperations().get(new BinaryOperationKey(receiver.getCtcType(), parameter.getCtcType(), name));
        if (functions2 == null) {
            return null;
        }
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> pair = functions2;
        Function2<? super Object, ? super Object, ? extends Object> function2 = pair.component1();
        Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> function22 = pair.component2();
        pair = null;
        try {
            void function;
            var9_9 = function.invoke(receiver.getValue(), parameter.getValue());
        }
        catch (Exception e) {
            var9_9 = null;
        }
        Object actualResult = var9_9;
        if (Intrinsics.areEqual(checker, EvaluatePackage$OperationsMapGenerated$84f0a886.getEmptyBinaryFun())) {
            return actualResult;
        }
        boolean bl2 = bl = EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.isIntegerType(receiver.getValue()) ? EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.isIntegerType(parameter.getValue()) : false;
        if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
            String e = "Only integer constants should be checked for overflow";
            throw (Throwable)((Object)new AssertionError((Object)e));
        }
        evaluateBinaryAndCheck.2 var9_11 = evaluateBinaryAndCheck.2.INSTANCE$;
        Object object = var9_11.invoke(receiver.getValue());
        Intrinsics.checkExpressionValueIsNotNull(object, "toBigInteger(receiver.value)");
        Object object2 = var9_11.invoke(parameter.getValue());
        Intrinsics.checkExpressionValueIsNotNull(object2, "toBigInteger(parameter.value)");
        BigInteger resultInBigIntegers = (BigInteger)checker.invoke(object, object2);
        if (Intrinsics.areEqual(var9_11.invoke((Object)actualResult), resultInBigIntegers) ^ true) {
            PsiElement psiElement = callExpression;
            DiagnosticFactory0<JetExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
            BindingTrace bindingTrace = this.trace;
            JetExpression jetExpression = PsiTreeUtil.getParentOfType(psiElement, JetExpression.class, true);
            JetExpression jetExpression2 = jetExpression;
            if (jetExpression2 == null) {
                jetExpression2 = callExpression;
            }
            bindingTrace.report(diagnosticFactory0.on((JetExpression)((PsiElement)jetExpression2)));
        }
        return actualResult;
    }

    private final boolean isDivisionByZero(@JetValueParameter(name="name") String name, @JetValueParameter(name="parameter", type="?") Object parameter) {
        Object v = OperatorConventions.BINARY_OPERATION_NAMES.get(JetTokens.DIV);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual(name, ((Name)v).asString())) {
            if (EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.isIntegerType(parameter)) {
                Object object = parameter;
                if (object == null) {
                    throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Number");
                }
                return ((Number)object).longValue() == (long)0;
            }
            if (!(parameter instanceof Float) ? parameter instanceof Double : true) {
                Object object = parameter;
                if (object == null) {
                    throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Number");
                }
                return ((Number)object).doubleValue() == 0.0;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitUnaryExpression(@JetValueParameter(name="expression") @NotNull JetUnaryExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression leftExpression = expression.getBaseExpression();
        if (leftExpression == null) {
            return null;
        }
        JetExpression jetExpression = expression.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull(jetExpression, "expression.getOperationReference()");
        return this.evaluateCall(jetExpression, leftExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitSimpleNameExpression(@JetValueParameter(name="expression") @NotNull JetSimpleNameExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        CallableDescriptor callableDescriptor;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        DeclarationDescriptor enumDescriptor = (DeclarationDescriptor)this.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression);
        if (enumDescriptor != null ? DescriptorUtils.isEnumEntry(enumDescriptor) : false) {
            DeclarationDescriptor declarationDescriptor = enumDescriptor;
            if (declarationDescriptor == null) {
                throw new TypeCastException("org.jetbrains.kotlin.descriptors.DeclarationDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return new EnumValue((ClassDescriptor)declarationDescriptor, false);
        }
        JetElement jetElement = expression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage$callUtil$cc0355c8.getResolvedCall(jetElement, bindingContext);
        if (resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) instanceof VariableDescriptor) {
            Object object;
            CompileTimeConstant<?> compileTimeConstant = ((VariableDescriptor)callableDescriptor).getCompileTimeInitializer();
            if (compileTimeConstant == null) {
                return null;
            }
            if (compileTimeConstant instanceof IntegerValueTypeConstant) {
                IntegerValueTypeConstant integerValueTypeConstant = (IntegerValueTypeConstant)compileTimeConstant;
                JetType jetType = expectedType;
                if (jetType == null) {
                    jetType = TypeUtils.NO_EXPECTED_TYPE;
                }
                object = integerValueTypeConstant.getValue(jetType);
            } else {
                object = compileTimeConstant.getValue();
            }
            Object value = object;
            VariableDescriptor variableDescriptor = (VariableDescriptor)callableDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(variableDescriptor, "callableDescriptor");
            return this.createCompileTimeConstant(value, expectedType, false, Default.isPropertyCompileTimeConstant(variableDescriptor), true);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitQualifiedExpression(@JetValueParameter(name="expression") @NotNull JetQualifiedExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression selectorExpression = expression.getSelectorExpression();
        if (selectorExpression instanceof JetCallExpression) {
            JetExpression receiverExpression;
            CompileTimeConstant<?> qualifiedCallValue = this.evaluate(selectorExpression, expectedType);
            if (qualifiedCallValue != null) {
                return qualifiedCallValue;
            }
            JetExpression calleeExpression = ((JetCallExpression)selectorExpression).getCalleeExpression();
            if (!(calleeExpression instanceof JetSimpleNameExpression)) {
                return null;
            }
            JetExpression jetExpression = receiverExpression = expression.getReceiverExpression();
            Intrinsics.checkExpressionValueIsNotNull(jetExpression, "receiverExpression");
            return this.evaluateCall(calleeExpression, jetExpression, expectedType);
        }
        if (selectorExpression != null) {
            return this.evaluate(selectorExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitCallExpression(@JetValueParameter(name="expression") @NotNull JetCallExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetElement jetElement = expression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> call = CallUtilPackage$callUtil$cc0355c8.getResolvedCall(jetElement, bindingContext);
        if (call == null) {
            return null;
        }
        CallableDescriptor resultingDescriptor = call.getResultingDescriptor();
        if (CompileTimeConstantUtils.isArrayMethodCall(call)) {
            boolean bl;
            ArrayValue arrayValue;
            ArrayValue arrayValue2;
            List list;
            JetType jetType;
            boolean bl2;
            block10: {
                ArrayValue arrayValue3;
                JetType jetType2 = KotlinPackage.first(resultingDescriptor.getValueParameters()).getVarargElementType();
                if (jetType2 == null) {
                    Intrinsics.throwNpe();
                }
                JetType varargType = jetType2;
                Iterable iterable = call.getValueArguments().values();
                Iterable iterable2 = iterable;
                Collection collection2 = new ArrayList();
                Iterator iterator2 = iterable2.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    ResolvedValueArgument it = (ResolvedValueArgument)t;
                    List<ValueArgument> list2 = it.getArguments();
                    Intrinsics.checkExpressionValueIsNotNull(list2, "it.getArguments()");
                    Iterable iterable3 = this.resolveArguments(list2, varargType);
                    KotlinPackage.addAll(collection2, iterable3);
                }
                List arguments2 = (ArrayList)collection2;
                JetType jetType3 = resultingDescriptor.getReturnType();
                if (jetType3 == null) {
                    Intrinsics.throwNpe();
                }
                iterable = arguments2;
                bl2 = true;
                jetType = jetType3;
                list = arguments2;
                arrayValue2 = arrayValue3;
                arrayValue = arrayValue3;
                for (Collection collection2 : iterable) {
                    CompileTimeConstant it = (CompileTimeConstant)((Object)collection2);
                    if (!it.usesVariableAsConstant()) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            boolean bl3 = bl;
            arrayValue2(list, jetType, bl2, bl3);
            return arrayValue;
        }
        if (resultingDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)resultingDescriptor).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "resultingDescriptor.getContainingDeclaration()");
            ClassDescriptor classDescriptor2 = classDescriptor;
            if (DescriptorUtils.isAnnotationClass(classDescriptor2)) {
                AnnotationDescriptorImpl descriptor = new AnnotationDescriptorImpl(classDescriptor2.getDefaultType(), AnnotationResolver.resolveAnnotationArguments(call, this.trace));
                return new AnnotationValue(descriptor);
            }
        }
        if (CompileTimeConstantUtils.isJavaClassMethodCall(call)) {
            JetType jetType = resultingDescriptor.getReturnType();
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            return new JavaClassValue(jetType);
        }
        return null;
    }

    private final List<CompileTimeConstant<?>> resolveArguments(@JetValueParameter(name="valueArguments") List<? extends ValueArgument> valueArguments2, @JetValueParameter(name="expectedType") JetType expectedType) {
        ArrayList<CompileTimeConstant> constants = KotlinPackage.arrayListOf(new CompileTimeConstant[0]);
        for (ValueArgument valueArgument : valueArguments2) {
            CompileTimeConstant<?> compileTimeConstant;
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (!(argumentExpression != null) || !((compileTimeConstant = this.evaluate(argumentExpression, expectedType)) != null)) continue;
            constants.add(compileTimeConstant);
        }
        return constants;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitJetElement(@JetValueParameter(name="element") @NotNull JetElement element, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return null;
    }

    private final OperationArgument createOperationArgumentForReceiver(@JetValueParameter(name="resolvedCall") ResolvedCall<?> resolvedCall, @JetValueParameter(name="expression") JetExpression expression) {
        JetType receiverExpressionType = EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.getReceiverExpressionType(resolvedCall);
        if (receiverExpressionType == null) {
            return null;
        }
        CompileTimeType<? extends Object> receiverCompileTimeType = EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.getCompileTimeType(receiverExpressionType);
        if (receiverCompileTimeType == null) {
            return null;
        }
        return this.createOperationArgument(expression, receiverExpressionType, receiverCompileTimeType);
    }

    private final OperationArgument createOperationArgumentForFirstParameter(@JetValueParameter(name="argument") ResolvedValueArgument argument, @JetValueParameter(name="parameter") ValueParameterDescriptor parameter) {
        JetType jetType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(jetType, "parameter.getType()");
        CompileTimeType<? extends Object> argumentCompileTimeType = EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.getCompileTimeType(jetType);
        if (argumentCompileTimeType == null) {
            return null;
        }
        List<ValueArgument> arguments2 = argument.getArguments();
        if (arguments2.size() != 1) {
            return null;
        }
        JetExpression argumentExpression = KotlinPackage.first(arguments2).getArgumentExpression();
        if (argumentExpression == null) {
            return null;
        }
        JetType jetType2 = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(jetType2, "parameter.getType()");
        return this.createOperationArgument(argumentExpression, jetType2, argumentCompileTimeType);
    }

    private final OperationArgument createOperationArgument(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="expressionType") JetType expressionType, @JetValueParameter(name="compileTimeType") CompileTimeType<?> compileTimeType) {
        CompileTimeConstant<?> evaluatedConstant = this.evaluate(expression, expressionType);
        if (evaluatedConstant == null) {
            return null;
        }
        if (evaluatedConstant instanceof IntegerValueTypeConstant) {
            Number evaluationResultWithNewType;
            Number number = evaluationResultWithNewType = ((IntegerValueTypeConstant)evaluatedConstant).getValue(expressionType);
            Intrinsics.checkExpressionValueIsNotNull(number, "evaluationResultWithNewType");
            return new OperationArgument(number, compileTimeType, expression);
        }
        Object evaluationResult = evaluatedConstant.getValue();
        if (evaluationResult == null) {
            return null;
        }
        return new OperationArgument(evaluationResult, compileTimeType, expression);
    }

    @Nullable
    public final CompileTimeConstant<?> createCompileTimeConstant(@JetValueParameter(name="value", type="?") @Nullable Object value, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType, @JetValueParameter(name="isPure") boolean isPure, @JetValueParameter(name="canBeUsedInAnnotation") boolean canBeUsedInAnnotation, @JetValueParameter(name="usesVariableAsConstant") boolean usesVariableAsConstant) {
        JetType jetType;
        EvaluatorContext c = new EvaluatorContext(canBeUsedInAnnotation, isPure, usesVariableAsConstant);
        if (isPure) {
            jetType = expectedType;
            if (jetType == null) {
                jetType = TypeUtils.NO_EXPECTED_TYPE;
            }
        } else {
            jetType = null;
        }
        return EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.createCompileTimeConstant(value, c, jetType);
    }

    /*
     * WARNING - void declaration
     */
    public static CompileTimeConstant createCompileTimeConstant$default(ConstantExpressionEvaluator constantExpressionEvaluator, Object object, JetType jetType, boolean bl, boolean bl2, boolean bl3, int n) {
        int n2;
        int n3;
        int n4;
        void var6_9;
        if ((var6_9 & 4) != 0) {
            n4 = 1;
        }
        if ((var6_9 & 8) != 0) {
            n3 = 1;
        }
        if ((var6_9 & 0x10) != 0) {
            n2 = 0;
        }
        return constantExpressionEvaluator.createCompileTimeConstant(object, jetType, n4 != 0, n3 != 0, n2 != 0);
    }

    @NotNull
    public final BindingTrace getTrace() {
        return this.trace;
    }

    private ConstantExpressionEvaluator(@JetValueParameter(name="trace") BindingTrace trace) {
        this.trace = trace;
        this.stringExpressionEvaluator = new KObject(this){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ ConstantExpressionEvaluator this$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(stringExpressionEvaluator.1.class);
            }

            @Nullable
            public final StringValue evaluate(@JetValueParameter(name="entry") @NotNull JetStringTemplateEntry entry) {
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                return (StringValue)entry.accept(this, null);
            }

            @Nullable
            public StringValue visitStringTemplateEntryWithExpression(@JetValueParameter(name="entry") @NotNull JetStringTemplateEntryWithExpression entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                JetExpression expression = entry.getExpression();
                if (expression == null) {
                    return null;
                }
                return EvaluatePackage$ConstantExpressionEvaluator$dd0d3756.createStringConstant(ConstantExpressionEvaluator.access$evaluate$1(this.this$0, expression, KotlinBuiltIns.getInstance().getStringType()));
            }

            @NotNull
            public StringValue visitLiteralStringTemplateEntry(@JetValueParameter(name="entry") @NotNull JetLiteralStringTemplateEntry entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                return new StringValue(entry.getText(), true, false);
            }

            @NotNull
            public StringValue visitEscapeStringTemplateEntry(@JetValueParameter(name="entry") @NotNull JetEscapeStringTemplateEntry entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                return new StringValue(entry.getUnescapedValue(), true, false);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ ConstantExpressionEvaluator access$init$0(@JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        return new ConstantExpressionEvaluator(trace);
    }

    @platformStatic
    @Nullable
    public static final CompileTimeConstant<?> evaluate(@JetValueParameter(name="expression") @NotNull JetExpression expression, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        return Default.evaluate(expression, trace, expectedType);
    }

    @platformStatic
    public static final boolean isPropertyCompileTimeConstant(@JetValueParameter(name="descriptor") @NotNull VariableDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        return Default.isPropertyCompileTimeConstant(descriptor);
    }

    @KotlinClass(abiVersion=20, kind=KotlinClass.Kind.CLASS, data={"\u001f\u0006)9A)\u001a4bk2$(bG\"p]N$\u0018M\u001c;FqB\u0014Xm]:j_:,e/\u00197vCR|'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u001d\u0011Xm]8mm\u0016T\u0011bY8ogR\fg\u000e^:\u000b\u0011\u00154\u0018\r\\;bi\u0016T1!\u00118z\u0015))\u0007\u0010\u001d:fgNLwN\u001c\u0006\u000e\u0015\u0016$X\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u0007A\u001c\u0018NC\u0003ue\u0006\u001cWM\u0003\u0007CS:$\u0017N\\4Ue\u0006\u001cWM\u0003\u0007fqB,7\r^3e)f\u0004XMC\u0004KKR$\u0016\u0010]3\u000b\u000bQL\b/Z:\u000b'\r{W\u000e]5mKRKW.Z\"p]N$\u0018M\u001c;\u000b;%\u001c\bK]8qKJ$\u0018pQ8na&dW\rV5nK\u000e{gn\u001d;b]RT!\u0002Z3tGJL\u0007\u000f^8s\u0015I1\u0016M]5bE2,G)Z:de&\u0004Ho\u001c:\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006\b\u0005>|G.Z1o=\u0007Q!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!\u0002\u0002\u0005\u0004!\u0019QA\u0001\u0003\u0003\u0011\u000f)1\u0001\"\u0002\t\u00021\u0001Qa\u0001\u0003\u0004\u0011\u0001a\u0001!B\u0001\t\u0005\u0015\u0019A\u0001\u0002\u0005\u0005\u0019\u0001)!\u0001B\u0001\t\f\u0015\u0019A!\u0002\u0005\u0006\u0019\u0001)1\u0001b\u0001\t\u000e1\u0001QA\u0001\u0003\u0002\u0011!)1\u0001\"\u0004\t\u00101\u0001Qa\u0001\u0003\u0003\u0011#a\u0001!\u0002\u0002\u0005\u0005!EQA\u0001\u0003\u0006\u0011\u0015)!\u0001b\u0001\t\u000e\u0015\u0011AQ\u0002E\b\u000b\t!\u0011\u0001#\u0006\u0006\u0007\u0011Q\u0001B\u0003\u0007\u0001\u000b\r!A\u0001C\u0006\r\u0001\u0015\u0011AA\u0003\u0005\u000b\t\r\u000fArA\r\u0003\u000b\u0005AI!\f\u0018\u0005\ba\u001dQT\u0002\u0003\u0001\u0011\u0013i!!B\u0001\t\fA\u001b\u0001!(\u0004\u0005\u0001!1QBA\u0003\u0002\u0011\u0019\u00016\u0011AO\b\t\u0005Aq!D\u0002\u0006\u0003!9A\u0012\u0001)\u0004\u0003\u0005JQ!\u0001E\b\u0013\u0015!\u0019!C\u0002\u0006\u0003!%A\u0012\u0001G\u0001#\u000eIAqA\u0005\u0002\u0011!i\u0011\u0001#\u0005\u000e\u0003!IQ\"\u0001E\n[M!9\u0001G\u0005\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005A)\u0002U\u0002\u0001C\t)\u0011\u0001C\u0006R\u0007\u0015!\u0011\"C\u0001\u0005\u00025\t\u0001rC\u001b\u0001"})
    public static final class Default
    implements KObject {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Default.class);
        }

        @platformStatic
        @Nullable
        public final CompileTimeConstant<?> evaluate(@JetValueParameter(name="expression") @NotNull JetExpression expression, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            ConstantExpressionEvaluator evaluator = ConstantExpressionEvaluator.access$init$0(trace);
            return evaluator.evaluate(expression, expectedType);
        }

        public static CompileTimeConstant evaluate$default(Default default_, JetExpression jetExpression, BindingTrace bindingTrace, JetType jetType, int n) {
            if ((n & 4) != 0) {
                jetType = TypeUtils.NO_EXPECTED_TYPE;
            }
            return default_.evaluate(jetExpression, bindingTrace, jetType);
        }

        @platformStatic
        public final boolean isPropertyCompileTimeConstant(@JetValueParameter(name="descriptor") @NotNull VariableDescriptor descriptor) {
            Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
            if (descriptor.isVar()) {
                return false;
            }
            if (!DescriptorUtils.isObject(descriptor.getContainingDeclaration()) ? DescriptorUtils.isStaticDeclaration(descriptor) : true) {
                JetType returnType = descriptor.getType();
                return !KotlinBuiltIns.isPrimitiveType(returnType) ? KotlinBuiltIns.isString(returnType) : true;
            }
            return false;
        }

        private Default() {
        }

        @NotNull
        public static final /* synthetic */ Default access$init$0() {
            return new Default();
        }
    }

    @KotlinClass(abiVersion=20, kind=KotlinClass.Kind.CLASS, data={"n\u0004)\tr\n]3sCRLwN\\!sOVlWM\u001c;\u000b7\r{gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u0002:fg>dg/\u001a\u0006\nG>t7\u000f^1oiNT\u0001\"\u001a<bYV\fG/\u001a\u0006\u0004\u0003:L(B\u0002\u001fj]&$hHC\u0003wC2,XMC\u0004di\u000e$\u0016\u0010]3\u000b\u001f\r{W\u000e]5mKRKW.\u001a+za\u0016T!\"\u001a=qe\u0016\u001c8/[8o\u00155QU\r^#yaJ,7o]5p]*\u0019\u0001o]5\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\u0004PE*,7\r\u001e\u0006\u000bO\u0016$8\t^2UsB,'\"D4fi\u0016C\bO]3tg&|gN\u0003\u0005hKR4\u0016\r\\;fa*\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015QA\u0001C\u0002\u0011\r)!\u0001\u0002\u0002\t\b\u0015\u0019AQ\u0001E\u0001\u0019\u0001)1\u0001B\u0002\t\u00011\u0001Q!\u0001\u0005\u0003\u000b\r!A\u0001\u0003\u0003\r\u0001\u0015\u0019AQ\u0001\u0005\u0007\u0019\u0001)!\u0001B\u0001\t\u0010\u0015\u0019A1\u0002\u0005\b\u0019\u0001)\u0011\u0001\u0003\u0005\u0006\u0005\u00115\u0001\u0012C\u0003\u0003\t\u001dA\u0011\"\u0002\u0002\u0005\u0006!1QA\u0001C\u0006\u0011\u001d!\u0011\u0001d\u0002\u001a\u0005\u0015\t\u0001\u0012B\u0017\u0016\t\u0001$\u00014B\u0011\t\u000b\u0005AQ!C\u0003\u0005\u0004%\u0019Q!\u0001E\u0005\u0019\u0003)6\u0001C\u0003\u0004\t\u0017I\u0011\u0001\u0003\u0005\u000e\u0007\u0011M\u0011\"\u0001\u0005\t[=!\u0001\r\u0002M\u0007C\t)\u0011\u0001\u0003\u0004V\u0007!)1\u0001\"\u0004\n\u0003!EQb\u0001\u0003\u000b\u0013\u0005A\t\"L\b\u0005A\u0012AR!\t\u0002\u0006\u0003!%Qk\u0001\u0005\u0006\u0007\u0011)\u0011\"\u0001E\b\u001b\r!)\"C\u0001\t\u0010UnS\u0011\f\u0003d\u0002a%QT\u0002\u0003\u0001\u0011\u0015i!!B\u0001\t\nA\u001b\u0001!(\u0007\u0005\u0001!-Q\u0002C\u0003\u0002\u0011\u0015IQ\u0001b\u0001\n\u0007\u0015\t\u0001\u0012\u0002G\u0001!\u000e\u0005QT\u0002\u0003\u0001\u0011\u001bi!!B\u0001\t\rA\u001b\u0011!\t\u0002\u0006\u0003!\u001d\u0011kA\u0005\u0005\n%\tA\u0001A\u0007\u0002\u0011\u001fi\u0011\u0001\u0003\u0005\u000e\u0003!E\u0001"})
    private static final class OperationArgument
    implements KObject {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final Object value;
        @NotNull
        private final CompileTimeType<?> ctcType;
        @NotNull
        private final JetExpression expression;

        static {
            $kotlinClass = Reflection.createKotlinClass(OperationArgument.class);
        }

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        @NotNull
        public final CompileTimeType<?> getCtcType() {
            return this.ctcType;
        }

        @NotNull
        public final JetExpression getExpression() {
            return this.expression;
        }

        public OperationArgument(@JetValueParameter(name="value") @NotNull Object value, @JetValueParameter(name="ctcType") @NotNull CompileTimeType<?> ctcType, @JetValueParameter(name="expression") @NotNull JetExpression expression) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            Intrinsics.checkParameterIsNotNull(ctcType, "ctcType");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            this.value = value;
            this.ctcType = ctcType;
            this.expression = expression;
        }
    }
}

