/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.descriptorUtil;

import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@KotlinSyntheticClass(abiVersion=20, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class DescriptorUtilPackage$DescriptorUtils$ad1fea2d {
    @NotNull
    public static final ClassDescriptor getClassObjectReferenceTarget(@JetValueParameter(name="$receiver") ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassDescriptor classDescriptor = $receiver.getDefaultObjectDescriptor();
        if (classDescriptor == null) {
            classDescriptor = $receiver;
        }
        return classDescriptor;
    }

    @NotNull
    public static final DeclarationDescriptor getImportableDescriptor(@JetValueParameter(name="$receiver") DeclarationDescriptor $receiver) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver instanceof ConstructorDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = ((ConstructorDescriptor)$receiver).getContainingDeclaration();
            declarationDescriptor = declarationDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "getContainingDeclaration()");
        } else if ($receiver instanceof PropertyAccessorDescriptor) {
            DeclarationDescriptor declarationDescriptor3 = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            declarationDescriptor = declarationDescriptor3;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor3, "getCorrespondingProperty()");
        } else {
            declarationDescriptor = $receiver;
        }
        return declarationDescriptor;
    }

    public static final boolean getIsExtension(@JetValueParameter(name="$receiver") DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof CallableDescriptor ? ((CallableDescriptor)$receiver).getExtensionReceiverParameter() != null : false;
    }

    @NotNull
    public static final ModuleDescriptor getModule(@JetValueParameter(name="$receiver") DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule($receiver);
        Intrinsics.checkExpressionValueIsNotNull(moduleDescriptor, "DescriptorUtils.getContainingModule(this)");
        return moduleDescriptor;
    }

    @Nullable
    public static final ClassDescriptor resolveTopLevelClass(@JetValueParameter(name="$receiver") ModuleDescriptor $receiver, @JetValueParameter(name="topLevelClassFqName") @NotNull FqName topLevelClassFqName) {
        ClassifierDescriptor classifierDescriptor;
        ClassifierDescriptor classifierDescriptor2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(topLevelClassFqName, "topLevelClassFqName");
        KotlinPackage.assert$default(!topLevelClassFqName.isRoot(), null, 2);
        FqName fqName2 = topLevelClassFqName.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "topLevelClassFqName.parent()");
        Object object = $receiver.getPackage(fqName2);
        if (object != null && (object = object.getMemberScope()) != null) {
            Name name = topLevelClassFqName.shortName();
            Intrinsics.checkExpressionValueIsNotNull(name, "topLevelClassFqName.shortName()");
            classifierDescriptor2 = object.getClassifier(name);
        } else {
            classifierDescriptor2 = classifierDescriptor = null;
        }
        if (!(classifierDescriptor2 instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        return (ClassDescriptor)classifierDescriptor;
    }

    @NotNull
    public static final ClassId getClassId(@JetValueParameter(name="$receiver") ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        DeclarationDescriptor owner = $receiver.getContainingDeclaration();
        if (owner instanceof PackageFragmentDescriptor) {
            return new ClassId(((PackageFragmentDescriptor)owner).getFqName(), $receiver.getName());
        }
        if (owner instanceof ClassDescriptor) {
            ClassId classId = DescriptorUtilPackage$DescriptorUtils$ad1fea2d.getClassId((ClassDescriptor)owner).createNestedClassId($receiver.getName());
            Intrinsics.checkExpressionValueIsNotNull(classId, "owner.classId.createNestedClassId(getName())");
            return classId;
        }
        throw (Throwable)new IllegalStateException("Illegal container: " + owner);
    }

    @Nullable
    public static final ClassDescriptor getClassObjectDescriptor(@JetValueParameter(name="$receiver") ClassDescriptor $receiver) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassKind classKind = $receiver.getKind();
        if (Intrinsics.areEqual((Object)classKind, (Object)ClassKind.OBJECT)) {
            classDescriptor = $receiver;
        } else if (Intrinsics.areEqual((Object)classKind, (Object)ClassKind.ENUM_ENTRY)) {
            DeclarationDescriptor container = $receiver.getContainingDeclaration();
            KotlinPackage.assert$default(container instanceof ClassDescriptor ? Intrinsics.areEqual((Object)((ClassDescriptor)container).getKind(), (Object)ClassKind.ENUM_CLASS) : false, null, 2);
            DeclarationDescriptor declarationDescriptor = container;
            if (declarationDescriptor == null) {
                throw new TypeCastException("org.jetbrains.kotlin.descriptors.DeclarationDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            classDescriptor = (ClassDescriptor)declarationDescriptor;
        } else {
            classDescriptor = $receiver.getDefaultObjectDescriptor();
        }
        return classDescriptor;
    }
}

