/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import com.google.common.base.Predicate;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.di.InjectorForTopDownAnalyzerForJvm;
import org.jetbrains.kotlin.load.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.kotlin.load.kotlin.incremental.cache.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.cache.IncrementalCacheProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.TopDownAnalysisParameters;
import org.jetbrains.kotlin.resolve.jvm.JvmAnalyzerFacade;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;

public enum TopDownAnalyzerFacadeForJVM {
    INSTANCE;

    public static final List<ImportPath> DEFAULT_IMPORTS;

    private static List<ImportPath> buildDefaultImports() {
        ArrayList<ImportPath> list = new ArrayList<ImportPath>();
        list.add(new ImportPath("java.lang.*"));
        list.add(new ImportPath("kotlin.*"));
        list.add(new ImportPath("kotlin.jvm.*"));
        list.add(new ImportPath("kotlin.io.*"));
        for (ClassDescriptor descriptor : JavaToKotlinClassMap.INSTANCE.allKotlinClasses()) {
            FqName fqName2 = DescriptorUtils.getFqNameSafe(descriptor);
            if (!fqName2.parent().equals(new FqName("kotlin"))) continue;
            list.add(new ImportPath(fqName2, false));
        }
        return list;
    }

    @NotNull
    public static AnalysisResult analyzeFilesWithJavaIntegrationNoIncremental(@NotNull Project project, @NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @NotNull TopDownAnalysisParameters topDownAnalysisParameters, @NotNull ModuleDescriptorImpl module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        if (topDownAnalysisParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisParameters", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        AnalysisResult analysisResult = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, trace, topDownAnalysisParameters, module, null, null);
        if (analysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationNoIncremental"));
        }
        return analysisResult;
    }

    @NotNull
    public static AnalysisResult analyzeFilesWithJavaIntegrationWithCustomContext(@NotNull Project project, @NotNull GlobalContext globalContext, @NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull ModuleDescriptorImpl module, @Nullable List<String> moduleIds, @Nullable IncrementalCacheProvider incrementalCacheProvider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (filesToAnalyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToAnalyzeCompletely", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        TopDownAnalysisParameters topDownAnalysisParameters = TopDownAnalysisParameters.create(globalContext.getStorageManager(), globalContext.getExceptionTracker(), filesToAnalyzeCompletely, false, false);
        AnalysisResult analysisResult = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, trace, topDownAnalysisParameters, module, moduleIds, incrementalCacheProvider);
        if (analysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationWithCustomContext"));
        }
        return analysisResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static AnalysisResult analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, BindingTrace trace, TopDownAnalysisParameters topDownAnalysisParameters, ModuleDescriptorImpl module, @Nullable List<String> moduleIds, @Nullable IncrementalCacheProvider incrementalCacheProvider) {
        List<JetFile> allFiles = JvmAnalyzerFacade.getAllFilesToAnalyze(project, null, files);
        FileBasedDeclarationProviderFactory providerFactory = new FileBasedDeclarationProviderFactory(topDownAnalysisParameters.getStorageManager(), allFiles);
        InjectorForTopDownAnalyzerForJvm injector = new InjectorForTopDownAnalyzerForJvm(project, topDownAnalysisParameters, trace, module, providerFactory, GlobalSearchScope.allScope(project));
        ArrayList<PackageFragmentProvider> additionalProviders = new ArrayList<PackageFragmentProvider>();
        if (moduleIds != null && incrementalCacheProvider != null) {
            for (String moduleId : moduleIds) {
                IncrementalCache incrementalCache = incrementalCacheProvider.getIncrementalCache(moduleId);
                additionalProviders.add(new IncrementalPackageFragmentProvider(files, module, topDownAnalysisParameters.getStorageManager(), injector.getDeserializationComponentsForJava().getComponents(), incrementalCache, moduleId));
            }
        }
        additionalProviders.add(injector.getJavaDescriptorResolver().getPackageFragmentProvider());
        injector.getLazyTopDownAnalyzerForTopLevel().analyzeFiles(topDownAnalysisParameters, allFiles, additionalProviders);
        AnalysisResult analysisResult = AnalysisResult.success(trace.getBindingContext(), module);
        AnalysisResult analysisResult2 = analysisResult;
        if (analysisResult2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        return analysisResult2;
        finally {
            injector.destroy();
        }
    }

    @NotNull
    public static ModuleDescriptorImpl createJavaModule(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "createJavaModule"));
        }
        ModuleDescriptorImpl moduleDescriptorImpl = new ModuleDescriptorImpl(Name.special(name), DEFAULT_IMPORTS, JavaToKotlinClassMap.INSTANCE);
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "createJavaModule"));
        }
        return moduleDescriptorImpl;
    }

    @NotNull
    public static ModuleDescriptorImpl createSealedJavaModule() {
        ModuleDescriptorImpl module = TopDownAnalyzerFacadeForJVM.createJavaModule("<shared-module>");
        module.addDependencyOnModule(module);
        module.addDependencyOnModule(KotlinBuiltIns.getInstance().getBuiltInsModule());
        module.seal();
        ModuleDescriptorImpl moduleDescriptorImpl = module;
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/TopDownAnalyzerFacadeForJVM", "createSealedJavaModule"));
        }
        return moduleDescriptorImpl;
    }

    static {
        DEFAULT_IMPORTS = TopDownAnalyzerFacadeForJVM.buildDefaultImports();
    }
}

