/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import jet.runtime.typeinfo.JetValueParameter;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(abiVersion=20, kind=KotlinClass.Kind.CLASS, data={"6\u0006)Aa+\u0019:jC:\u001cWMC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0015!\u0018\u0010]3t\u0015\u0011)e.^7\u000b\rqJg.\u001b;?\u0015\u0015a\u0017MY3m\u0015\u0019\u0019FO]5oO*\u0001\u0012\r\u001c7poNLe\u000eU8tSRLwN\u001c\u0006\b\u0005>|G.Z1o\u0015E\tG\u000e\\8xg>+H\u000fU8tSRLwN\u001c\u0006\u0014gV\u0004XM\u001d9pg&$\u0018n\u001c8GC\u000e$xN\u001d\u0006\u0004\u0013:$(\u0002\u00026bm\u0006TA\u0001\\1oO*\u0019r-\u001a;BY2|wo]%o!>\u001c\u0018\u000e^5p]*!r-\u001a;BY2|wo](viB{7/\u001b;j_:T\u0001bZ3u\u0019\u0006\u0014W\r\u001c\u0006\u000fC2dwn^:Q_NLG/[8o\u0015!\u0001xn]5uS>t'\u0002C8qa>\u001c\u0018\u000e^3\u000b\u0013M,\b/\u001a:q_N,'\"B8uQ\u0016\u0014(\u0002\u0003;p'R\u0014\u0018N\\4\u000b\u0013%se+\u0011*J\u0003:#&bC%O?Z\u000b%+S!O\u0007\u0016SAbT+U?Z\u000b%+S!O\u0007\u0016C&B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0004\t\u0007A\u0001\u0001\u0004\u0001\u0006\u0003!\rQa\u0001C\u0003\u0011\u000ba\u0001!B\u0002\u0005\u0006!!A\u0002A\u0003\u0004\t\u000bAQ\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001R\u0002\u0007\u0001\u000b\u0005Aq!\u0002\u0002\u0005\u000b!=QA\u0001C\u0006\u0011\u0011)!\u0001b\u0001\t\u0001\u0011\u0019\r\u0001\u0004\u0002\u001a\r\u0015\t\u0001bA\u0005\u0004\u0013\t)\u0011\u0001\u0003\u0002.\u001f\u0011\u0019G\u0001'\u0003\"\u0005\u0015\t\u0001\u0002B+\u0004\u0011\u0015\u0019A\u0011B\u0005\u0002\t\u0003i1\u0001\u0002\u0005\n\u0003\u0011\u0005Qf\u0004\u0003d\ta-\u0011EA\u0003\u0002\u0011\u0011)6\u0001C\u0003\u0004\t\u0017I\u0011\u0001\"\u0001\u000e\u0007\u0011E\u0011\"\u0001C\u0001[=!1\r\u0002M\u0004C\t)\u0011\u0001c\u0002V\u0007!)1\u0001b\u0002\n\u0003!1Qb\u0001\u0003\n\u0013\u0005Aa!L\u0006\u0005C\u0012Ab!\t\u0002\u0006\u0003!%Qk\u0001\u0003\u0006\u0007\u00111\u0011\"\u0001C\u0003[M!1\u0001g\u0005\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005A!\u0001U\u0002\u0001C\t)\u0011\u0001\u0003\u0003R\u0007\u0015!\u0019\"C\u0001\u0005\u00025\t\u0001RBW\n\t\rA*\"\t\u0002\u0006\u0003!\u0011\u0011kA\u0002\u0005\u0016%\t\u0001RB\u0017\u0014\t\rA2\"(\u0004\u0005\u0001!]QBA\u0003\u0002\u0011\t\u00016\u0001A\u0011\u0003\u000b\u0005A!!U\u0002\u0006\t-I\u0011\u0001#\u0004\u000e\u0003!5Q6\u0003\u0003\f11\t#!B\u0001\t\bE\u001b1\u0001\u0002\u0007\n\u0003!1\u0001\u0017\u0004\u0019\u000ea7)T'\u0002\u001b\u0005C\u0004A2!(\u0004\u0005\u0001!\u001dQBA\u0003\u0002\u0011\u000f\u00016!AO\u0007\t\u0001AI!\u0004\u0002\u0006\u0003!!\u0001ka\u0001\u001e\u000e\u0011\u0001\u00012B\u0007\u0003\u000b\u0005AA\u0001U\u0002\u0003;\u001b!\u0001\u0001\u0003\u0004\u000e\u0005\u0015\t\u0001\u0012\u0002)\u0004\u0006\u0005\u0012Q!\u0001\u0005\u0003#\u000eyAaA\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0004\u000e\u0003\u0011\u0015Q\"\u0001\u0005\u0007\u001b\u0005!\t!D\u0001\u0005\u00025\tAQ\u0001"})
public final class Variance
extends Enum<Variance>
implements KObject {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final /* enum */ Variance INVARIANT;
    public static final /* enum */ Variance IN_VARIANCE;
    public static final /* enum */ Variance OUT_VARIANCE;
    @NotNull
    private final String label;
    private final boolean allowsInPosition;
    private final boolean allowsOutPosition;
    private final int superpositionFactor;
    private static final /* synthetic */ Variance[] $VALUES;

    static {
        $kotlinClass = Reflection.createKotlinClass(Variance.class);
        Variance[] varianceArray = new Variance[3];
        Variance[] varianceArray2 = varianceArray;
        varianceArray[0] = INVARIANT = new Variance("", true, true, 0);
        varianceArray[1] = IN_VARIANCE = new Variance("in", true, false, -1);
        varianceArray[2] = OUT_VARIANCE = new Variance("out", false, true, 1);
        $VALUES = varianceArray;
    }

    public final boolean allowsPosition(@JetValueParameter(name="position") @NotNull Variance position) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(position, "position");
        Variance variance = position;
        if (Intrinsics.areEqual(variance, IN_VARIANCE)) {
            bl = this.allowsInPosition;
        } else if (Intrinsics.areEqual(variance, OUT_VARIANCE)) {
            bl = this.allowsOutPosition;
        } else if (Intrinsics.areEqual(variance, INVARIANT)) {
            bl = this.allowsInPosition ? this.allowsOutPosition : false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public final Variance superpose(@JetValueParameter(name="other") @NotNull Variance other) {
        Variance variance;
        Intrinsics.checkParameterIsNotNull(other, "other");
        int r = this.superpositionFactor * other.superpositionFactor;
        switch (r) {
            case 0: {
                variance = INVARIANT;
                break;
            }
            case -1: {
                variance = IN_VARIANCE;
                break;
            }
            case 1: {
                variance = OUT_VARIANCE;
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Illegal factor: " + r);
            }
        }
        return variance;
    }

    @NotNull
    public final Variance opposite() {
        Variance variance;
        Variance variance2 = this;
        if (Intrinsics.areEqual(variance2, INVARIANT)) {
            variance = INVARIANT;
        } else if (Intrinsics.areEqual(variance2, IN_VARIANCE)) {
            variance = OUT_VARIANCE;
        } else if (Intrinsics.areEqual(variance2, OUT_VARIANCE)) {
            variance = IN_VARIANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return variance;
    }

    @NotNull
    public String toString() {
        return this.label;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final boolean getAllowsInPosition() {
        return this.allowsInPosition;
    }

    public final boolean getAllowsOutPosition() {
        return this.allowsOutPosition;
    }

    protected Variance(@JetValueParameter(name="label") @NotNull String label, @JetValueParameter(name="allowsInPosition") boolean allowsInPosition, @JetValueParameter(name="allowsOutPosition") boolean allowsOutPosition, @JetValueParameter(name="superpositionFactor") int superpositionFactor) {
        Intrinsics.checkParameterIsNotNull(label, "label");
        this.label = label;
        this.allowsInPosition = allowsInPosition;
        this.allowsOutPosition = allowsOutPosition;
        this.superpositionFactor = superpositionFactor;
    }

    public static Variance[] values() {
        return (Variance[])$VALUES.clone();
    }

    public static Variance valueOf(String string) {
        return Enum.valueOf(Variance.class, string);
    }
}

