/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetBreakExpression;
import org.jetbrains.kotlin.psi.JetCatchClause;
import org.jetbrains.kotlin.psi.JetContinueExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFinallySection;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetLoopExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThrowExpression;
import org.jetbrains.kotlin.psi.JetTreeVisitor;
import org.jetbrains.kotlin.psi.JetTryExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetWhileExpression;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.InlineDescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.WritableScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeInfo;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.LabelResolver;

public class ControlStructureTypingVisitor
extends ExpressionTypingVisitor {
    public static final String RETURN_NOT_ALLOWED_MESSAGE = "Return not allowed";

    protected ControlStructureTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "<init>"));
        }
        super(facade);
    }

    @NotNull
    private DataFlowInfo checkCondition(@NotNull JetScope scope2, @Nullable JetExpression condition, ExpressionTypingContext context2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "checkCondition"));
        }
        if (condition != null) {
            JetTypeInfo typeInfo = this.facade.getTypeInfo(condition, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceScope(scope2)).replaceExpectedType(this.components.builtIns.getBooleanType())).replaceContextDependency(ContextDependency.INDEPENDENT));
            JetType conditionType = typeInfo.getType();
            if (conditionType != null && !this.components.builtIns.isBooleanOrSubtype(conditionType)) {
                context2.trace.report(Errors.TYPE_MISMATCH_IN_CONDITION.on(condition, conditionType));
            }
            DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "checkCondition"));
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "checkCondition"));
        }
        return dataFlowInfo;
    }

    @Override
    public JetTypeInfo visitIfExpression(@NotNull JetIfExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitIfExpression"));
        }
        return this.visitIfExpression(expression, context2, false);
    }

    public JetTypeInfo visitIfExpression(JetIfExpression ifExpression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        boolean jumpInElse;
        ExpressionTypingContext context2 = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression condition = ifExpression.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(context2.scope, condition, context2);
        JetExpression elseBranch = ifExpression.getElse();
        JetExpression thenBranch = ifExpression.getThen();
        WritableScopeImpl thenScope = ExpressionTypingUtils.newWritableScopeImpl(context2, "Then scope");
        WritableScopeImpl elseScope = ExpressionTypingUtils.newWritableScopeImpl(context2, "Else scope");
        DataFlowInfo thenInfo = DataFlowUtils.extractDataFlowInfoFromCondition(condition, true, context2).and(conditionDataFlowInfo);
        DataFlowInfo elseInfo = DataFlowUtils.extractDataFlowInfoFromCondition(condition, false, context2).and(conditionDataFlowInfo);
        if (elseBranch == null) {
            if (thenBranch != null) {
                return this.getTypeInfoWhenOnlyOneBranchIsPresent(thenBranch, thenScope, thenInfo, elseInfo, contextWithExpectedType, ifExpression, isStatement);
            }
            return DataFlowUtils.checkImplicitCast(this.components.builtIns.getUnitType(), ifExpression, contextWithExpectedType, isStatement, thenInfo.or(elseInfo));
        }
        if (thenBranch == null) {
            return this.getTypeInfoWhenOnlyOneBranchIsPresent(elseBranch, elseScope, elseInfo, thenInfo, contextWithExpectedType, ifExpression, isStatement);
        }
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory(ifExpression);
        JetBlockExpression thenBlock = psiFactory.wrapInABlock(thenBranch);
        JetBlockExpression elseBlock = psiFactory.wrapInABlock(elseBranch);
        Call callForIf = ControlStructureTypingUtils.createCallForSpecialConstruction(ifExpression, ifExpression, Lists.newArrayList(thenBlock, elseBlock));
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = ControlStructureTypingUtils.createDataFlowInfoForArgumentsForIfCall(callForIf, thenInfo, elseInfo);
        ResolvedCall<FunctionDescriptor> resolvedCall = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(callForIf, "If", Lists.newArrayList("thenBranch", "elseBranch"), Lists.newArrayList(false, false), contextWithExpectedType, dataFlowInfoForArguments);
        JetTypeInfo thenTypeInfo = BindingContextUtils.getRecordedTypeInfo(thenBranch, context2.trace.getBindingContext());
        JetTypeInfo elseTypeInfo = BindingContextUtils.getRecordedTypeInfo(elseBranch, context2.trace.getBindingContext());
        assert (thenTypeInfo != null) : "'Then' branch of if expression  was not processed: " + ifExpression;
        assert (elseTypeInfo != null) : "'Else' branch of if expression  was not processed: " + ifExpression;
        JetType thenType = thenTypeInfo.getType();
        JetType elseType = elseTypeInfo.getType();
        DataFlowInfo thenDataFlowInfo = thenTypeInfo.getDataFlowInfo();
        DataFlowInfo elseDataFlowInfo = elseTypeInfo.getDataFlowInfo();
        boolean jumpInThen = thenType != null && KotlinBuiltIns.isNothing(thenType);
        boolean bl = jumpInElse = elseType != null && KotlinBuiltIns.isNothing(elseType);
        DataFlowInfo resultDataFlowInfo = thenType == null && elseType == null ? thenDataFlowInfo.or(elseDataFlowInfo) : (thenType == null || jumpInThen && !jumpInElse ? elseDataFlowInfo : (elseType == null || jumpInElse && !jumpInThen ? thenDataFlowInfo : thenDataFlowInfo.or(elseDataFlowInfo)));
        JetType resultType = resolvedCall.getResultingDescriptor().getReturnType();
        return DataFlowUtils.checkImplicitCast(resultType, ifExpression, contextWithExpectedType, isStatement, resultDataFlowInfo);
    }

    @NotNull
    private JetTypeInfo getTypeInfoWhenOnlyOneBranchIsPresent(@NotNull JetExpression presentBranch, @NotNull WritableScopeImpl presentScope, @NotNull DataFlowInfo presentInfo, @NotNull DataFlowInfo otherInfo, @NotNull ExpressionTypingContext context2, @NotNull JetIfExpression ifExpression, boolean isStatement) {
        if (presentBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentBranch", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (presentScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentScope", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (presentInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentInfo", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (otherInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherInfo", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (ifExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifExpression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceDataFlowInfo(presentInfo)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetTypeInfo typeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(presentScope, Collections.singletonList(presentBranch), CoercionStrategy.NO_COERCION, newContext);
        JetType type2 = typeInfo.getType();
        DataFlowInfo dataFlowInfo = type2 != null && KotlinBuiltIns.isNothing(type2) ? otherInfo : typeInfo.getDataFlowInfo().or(otherInfo);
        JetType typeForIfExpression = DataFlowUtils.checkType(this.components.builtIns.getUnitType(), (JetExpression)ifExpression, (ResolutionContext)context2);
        JetTypeInfo jetTypeInfo = DataFlowUtils.checkImplicitCast(typeForIfExpression, ifExpression, context2, isStatement, dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        return jetTypeInfo;
    }

    @Override
    public JetTypeInfo visitWhileExpression(@NotNull JetWhileExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitWhileExpression"));
        }
        return this.visitWhileExpression(expression, context2, false);
    }

    public JetTypeInfo visitWhileExpression(JetWhileExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        if (!isStatement) {
            return DataFlowUtils.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression condition = expression.getCondition();
        DataFlowInfo dataFlowInfo = this.checkCondition(context2.scope, condition, context2);
        JetExpression body = expression.getBody();
        if (body != null) {
            WritableScopeImpl scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context2, "Scope extended in while's condition");
            DataFlowInfo conditionInfo = DataFlowUtils.extractDataFlowInfoFromCondition(condition, true, context2).and(dataFlowInfo);
            this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(scopeToExtend, Collections.singletonList(body), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context2.replaceDataFlowInfo(conditionInfo));
        }
        if (!this.containsJumpOutOfLoop(expression, context2)) {
            dataFlowInfo = DataFlowUtils.extractDataFlowInfoFromCondition(condition, false, context2).and(dataFlowInfo);
        }
        return DataFlowUtils.checkType(this.components.builtIns.getUnitType(), (JetExpression)expression, (ResolutionContext)contextWithExpectedType, dataFlowInfo);
    }

    private boolean containsJumpOutOfLoop(final JetLoopExpression loopExpression, final ExpressionTypingContext context2) {
        final boolean[] result2 = new boolean[]{false};
        loopExpression.accept(new JetTreeVisitor<List<JetLoopExpression>>(){

            @Override
            public Void visitBreakExpression(@NotNull JetBreakExpression breakExpression, List<JetLoopExpression> outerLoops) {
                PsiElement element;
                if (breakExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakExpression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor$1", "visitBreakExpression"));
                }
                JetSimpleNameExpression targetLabel = breakExpression.getTargetLabel();
                PsiElement psiElement = element = targetLabel != null ? context2.trace.get(BindingContext.LABEL_TARGET, targetLabel) : null;
                if (element == loopExpression || targetLabel == null && outerLoops.get(outerLoops.size() - 1) == loopExpression) {
                    result2[0] = true;
                }
                return null;
            }

            @Override
            public Void visitContinueExpression(@NotNull JetContinueExpression expression, List<JetLoopExpression> outerLoops) {
                PsiElement element;
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor$1", "visitContinueExpression"));
                }
                JetSimpleNameExpression targetLabel = expression.getTargetLabel();
                if (targetLabel != null && (element = context2.trace.get(BindingContext.LABEL_TARGET, targetLabel)) instanceof JetLoopExpression && !outerLoops.contains(element)) {
                    result2[0] = true;
                }
                return null;
            }

            @Override
            public Void visitLoopExpression(@NotNull JetLoopExpression loopExpression2, List<JetLoopExpression> outerLoops) {
                if (loopExpression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExpression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor$1", "visitLoopExpression"));
                }
                ArrayList<JetLoopExpression> newOuterLoops = Lists.newArrayList(outerLoops);
                newOuterLoops.add(loopExpression2);
                return (Void)super.visitLoopExpression(loopExpression2, newOuterLoops);
            }
        }, Lists.newArrayList(loopExpression));
        return result2[0];
    }

    @Override
    public JetTypeInfo visitDoWhileExpression(@NotNull JetDoWhileExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitDoWhileExpression"));
        }
        return this.visitDoWhileExpression(expression, context2, false);
    }

    public JetTypeInfo visitDoWhileExpression(JetDoWhileExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        if (!isStatement) {
            return DataFlowUtils.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression body = expression.getBody();
        JetScope conditionScope = context2.scope;
        if (body instanceof JetFunctionLiteralExpression) {
            JetFunctionLiteralExpression function = (JetFunctionLiteralExpression)body;
            JetFunctionLiteral functionLiteral = function.getFunctionLiteral();
            if (!functionLiteral.hasParameterSpecification()) {
                WritableScopeImpl writableScope = ExpressionTypingUtils.newWritableScopeImpl(context2, "do..while body scope");
                conditionScope = writableScope;
                this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(writableScope, functionLiteral.getBodyExpression().getStatements(), CoercionStrategy.NO_COERCION, context2);
                context2.trace.record(BindingContext.BLOCK, function);
            } else {
                this.facade.getTypeInfo(body, (ExpressionTypingContext)context2.replaceScope(context2.scope));
            }
        } else if (body != null) {
            WritableScopeImpl writableScope = ExpressionTypingUtils.newWritableScopeImpl(context2, "do..while body scope");
            conditionScope = writableScope;
            List<JetElement> block = body instanceof JetBlockExpression ? ((JetBlockExpression)body).getStatements() : Collections.singletonList(body);
            this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(writableScope, block, CoercionStrategy.NO_COERCION, context2);
        }
        JetExpression condition = expression.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(conditionScope, condition, context2);
        DataFlowInfo dataFlowInfo = !this.containsJumpOutOfLoop(expression, context2) ? DataFlowUtils.extractDataFlowInfoFromCondition(condition, false, context2).and(conditionDataFlowInfo) : context2.dataFlowInfo;
        return DataFlowUtils.checkType(this.components.builtIns.getUnitType(), (JetExpression)expression, (ResolutionContext)contextWithExpectedType, dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitForExpression(@NotNull JetForExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitForExpression"));
        }
        return this.visitForExpression(expression, context2, false);
    }

    public JetTypeInfo visitForExpression(JetForExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        if (!isStatement) {
            return DataFlowUtils.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression loopRange = expression.getLoopRange();
        JetType expectedParameterType = null;
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        if (loopRange != null) {
            ExpressionReceiver loopRangeReceiver = ExpressionTypingUtils.getExpressionReceiver(this.facade, loopRange, (ExpressionTypingContext)context2.replaceScope(context2.scope));
            dataFlowInfo = this.facade.getTypeInfo(loopRange, context2).getDataFlowInfo();
            if (loopRangeReceiver != null) {
                expectedParameterType = this.components.forLoopConventionsChecker.checkIterableConvention(loopRangeReceiver, context2);
            }
        }
        WritableScopeImpl loopScope = ExpressionTypingUtils.newWritableScopeImpl(context2, "Scope with for-loop index");
        JetParameter loopParameter = expression.getLoopParameter();
        if (loopParameter != null) {
            VariableDescriptor variableDescriptor = this.createLoopParameterDescriptor(loopParameter, expectedParameterType, context2);
            loopScope.addVariableDescriptor(variableDescriptor);
        } else {
            JetMultiDeclaration multiParameter = expression.getMultiParameter();
            if (multiParameter != null && loopRange != null) {
                JetType elementType = expectedParameterType == null ? ErrorUtils.createErrorType("Loop range has no type") : expectedParameterType;
                TransientReceiver iteratorNextAsReceiver = new TransientReceiver(elementType);
                this.components.expressionTypingUtils.defineLocalVariablesFromMultiDeclaration(loopScope, multiParameter, iteratorNextAsReceiver, loopRange, context2);
            }
        }
        JetExpression body = expression.getBody();
        if (body != null) {
            this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(loopScope, Collections.singletonList(body), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo));
        }
        return DataFlowUtils.checkType(this.components.builtIns.getUnitType(), (JetExpression)expression, (ResolutionContext)contextWithExpectedType, dataFlowInfo);
    }

    private VariableDescriptor createLoopParameterDescriptor(JetParameter loopParameter, JetType expectedParameterType, ExpressionTypingContext context2) {
        VariableDescriptor variableDescriptor;
        DescriptorResolver.checkParameterHasNoValOrVar(context2.trace, loopParameter, Errors.VAL_OR_VAR_ON_LOOP_PARAMETER);
        JetTypeReference typeReference = loopParameter.getTypeReference();
        if (typeReference != null) {
            variableDescriptor = this.components.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptor(context2.scope, loopParameter, context2.trace);
            JetType actualParameterType = variableDescriptor.getType();
            if (expectedParameterType != null && !JetTypeChecker.DEFAULT.isSubtypeOf(expectedParameterType, actualParameterType)) {
                context2.trace.report(Errors.TYPE_MISMATCH_IN_FOR_LOOP.on(typeReference, expectedParameterType, actualParameterType));
            }
        } else {
            if (expectedParameterType == null) {
                expectedParameterType = ErrorUtils.createErrorType("Error");
            }
            variableDescriptor = this.components.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptor(loopParameter, expectedParameterType, context2.trace, context2.scope);
        }
        VariableDescriptor olderVariable = context2.scope.getLocalVariable(variableDescriptor.getName());
        if (olderVariable != null && ExpressionTypingUtils.isLocal(context2.scope.getContainingDeclaration(), olderVariable)) {
            PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(variableDescriptor);
            context2.trace.report(Errors.NAME_SHADOWING.on(declaration, variableDescriptor.getName().asString()));
        }
        return variableDescriptor;
    }

    @Override
    public JetTypeInfo visitTryExpression(@NotNull JetTryExpression expression, ExpressionTypingContext typingContext) {
        JetType type2;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitTryExpression"));
        }
        ExpressionTypingContext context2 = (ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT);
        JetBlockExpression tryBlock = expression.getTryBlock();
        List<JetCatchClause> catchClauses = expression.getCatchClauses();
        JetFinallySection finallyBlock = expression.getFinallyBlock();
        ArrayList<JetType> types = new ArrayList<JetType>();
        for (JetCatchClause catchClause : catchClauses) {
            JetParameter catchParameter = catchClause.getCatchParameter();
            JetExpression catchBody = catchClause.getCatchBody();
            if (catchParameter == null) continue;
            DescriptorResolver.checkParameterHasNoValOrVar(context2.trace, catchParameter, Errors.VAL_OR_VAR_ON_CATCH_PARAMETER);
            DescriptorResolver.checkParameterHasNoModifier(context2.trace, catchParameter);
            VariableDescriptor variableDescriptor = this.components.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptor(context2.scope, catchParameter, context2.trace);
            JetType throwableType = this.components.builtIns.getThrowable().getDefaultType();
            DataFlowUtils.checkType(variableDescriptor.getType(), (JetExpression)catchParameter, context2.replaceExpectedType(throwableType));
            if (catchBody == null) continue;
            WritableScopeImpl catchScope = ExpressionTypingUtils.newWritableScopeImpl(context2, "Catch scope");
            catchScope.addVariableDescriptor(variableDescriptor);
            JetType type3 = this.facade.getTypeInfo(catchBody, (ExpressionTypingContext)context2.replaceScope(catchScope)).getType();
            if (type3 == null) continue;
            types.add(type3);
        }
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        if (finallyBlock != null) {
            dataFlowInfo = this.facade.getTypeInfo(finallyBlock.getFinalExpression(), (ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).getDataFlowInfo();
        }
        if ((type2 = this.facade.getTypeInfo(tryBlock, context2).getType()) != null) {
            types.add(type2);
        }
        if (types.isEmpty()) {
            return JetTypeInfo.create(null, dataFlowInfo);
        }
        return JetTypeInfo.create(CommonSupertypes.commonSupertype(types), dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitThrowExpression(@NotNull JetThrowExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitThrowExpression"));
        }
        JetExpression thrownExpression = expression.getThrownExpression();
        if (thrownExpression != null) {
            JetType throwableType = this.components.builtIns.getThrowable().getDefaultType();
            this.facade.getTypeInfo(thrownExpression, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(throwableType)).replaceScope(context2.scope)).replaceContextDependency(ContextDependency.INDEPENDENT));
        }
        return DataFlowUtils.checkType(this.components.builtIns.getNothingType(), (JetExpression)expression, (ResolutionContext)context2, context2.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitReturnExpression(@NotNull JetReturnExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitReturnExpression"));
        }
        JetElement labelTargetElement = LabelResolver.INSTANCE.resolveControlLabel(expression, context2);
        JetExpression returnedExpression = expression.getReturnedExpression();
        JetType expectedType = TypeUtils.NO_EXPECTED_TYPE;
        JetType resultType = this.components.builtIns.getNothingType();
        JetDeclaration parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)expression, JetDeclaration.class);
        if (parentDeclaration instanceof JetParameter) {
            context2.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
        }
        if (expression.getTargetLabel() == null) {
            assert (parentDeclaration != null);
            DeclarationDescriptor declarationDescriptor = context2.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, parentDeclaration);
            Pair<FunctionDescriptor, PsiElement> containingFunInfo = BindingContextUtils.getContainingFunctionSkipFunctionLiterals(declarationDescriptor, false);
            FunctionDescriptor containingFunctionDescriptor = containingFunInfo.getFirst();
            if (containingFunctionDescriptor != null) {
                if (!InlineDescriptorUtils.checkNonLocalReturnUsage(containingFunctionDescriptor, expression, context2.trace) || containingFunctionDescriptor instanceof ConstructorDescriptor) {
                    context2.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
                    resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
                }
                expectedType = ControlStructureTypingVisitor.getFunctionExpectedReturnType(containingFunctionDescriptor, (JetElement)containingFunInfo.getSecond(), context2);
            } else {
                context2.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
                resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
            }
        } else if (labelTargetElement != null) {
            SimpleFunctionDescriptor functionDescriptor = context2.trace.get(BindingContext.FUNCTION, labelTargetElement);
            if (functionDescriptor != null) {
                expectedType = ControlStructureTypingVisitor.getFunctionExpectedReturnType(functionDescriptor, labelTargetElement, context2);
                if (!InlineDescriptorUtils.checkNonLocalReturnUsage(functionDescriptor, expression, context2.trace)) {
                    context2.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
                    resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
                }
            } else {
                context2.trace.report(Errors.NOT_A_RETURN_LABEL.on(expression, expression.getLabelName()));
            }
        }
        if (returnedExpression != null) {
            this.facade.getTypeInfo(returnedExpression, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(expectedType)).replaceScope(context2.scope)).replaceContextDependency(ContextDependency.INDEPENDENT));
        } else if (!(expectedType == null || TypeUtils.noExpectedType(expectedType) || KotlinBuiltIns.isUnit(expectedType) || TypeUtils.isDontCarePlaceholder(expectedType))) {
            context2.trace.report(Errors.RETURN_TYPE_MISMATCH.on(expression, expectedType));
        }
        return DataFlowUtils.checkType(resultType, (JetExpression)expression, (ResolutionContext)context2, context2.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitBreakExpression(@NotNull JetBreakExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitBreakExpression"));
        }
        LabelResolver.INSTANCE.resolveControlLabel(expression, context2);
        return DataFlowUtils.checkType(this.components.builtIns.getNothingType(), (JetExpression)expression, (ResolutionContext)context2, context2.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitContinueExpression(@NotNull JetContinueExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitContinueExpression"));
        }
        LabelResolver.INSTANCE.resolveControlLabel(expression, context2);
        return DataFlowUtils.checkType(this.components.builtIns.getNothingType(), (JetExpression)expression, (ResolutionContext)context2, context2.dataFlowInfo);
    }

    @NotNull
    private static JetType getFunctionExpectedReturnType(@NotNull FunctionDescriptor descriptor, @NotNull JetElement function, @NotNull ExpressionTypingContext context2) {
        JetType expectedType;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        if (function instanceof JetFunction) {
            JetFunction jetFunction = (JetFunction)function;
            expectedType = context2.trace.get(BindingContext.EXPECTED_RETURN_TYPE, jetFunction);
            if (expectedType == null && (jetFunction.getTypeReference() != null || jetFunction.hasBlockBody())) {
                expectedType = descriptor.getReturnType();
            }
        } else {
            expectedType = descriptor.getReturnType();
        }
        JetType jetType = expectedType != null ? expectedType : TypeUtils.NO_EXPECTED_TYPE;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        return jetType;
    }
}

