/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import com.google.dart.compiler.util.AstUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsVars
extends SourceInfoAwareJsNode
implements JsStatement,
Iterable<JsVar> {
    private final List<JsVar> vars;
    private final boolean multiline;

    public JsVars() {
        this(new SmartList<JsVar>(), false);
    }

    public JsVars(boolean multiline) {
        this(new SmartList<JsVar>(), multiline);
    }

    public JsVars(List<JsVar> vars, boolean multiline) {
        this.vars = vars;
        this.multiline = multiline;
    }

    public JsVars(JsVar var) {
        this(Collections.singletonList(var), false);
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void add(JsVar var) {
        this.vars.add(var);
    }

    public void addAll(JsVars otherVars) {
        this.vars.addAll(otherVars.vars);
    }

    public void addIfHasInitializer(JsVar var) {
        if (var.getInitExpression() != null) {
            this.add(var);
        }
    }

    @Override
    public Iterator<JsVar> iterator() {
        return this.vars.iterator();
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitVars(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor) {
        visitor.acceptWithInsertRemove(this.vars);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptList(this.vars);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsVars deepCopy() {
        JsVars jsVars = new JsVars(AstUtil.deepCopy(this.vars), this.multiline).withMetadataFrom(this);
        if (jsVars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsVars", "deepCopy"));
        }
        return jsVars;
    }

    public static class JsVar
    extends SourceInfoAwareJsNode
    implements HasName {
        private final JsName name;
        private JsExpression initExpression;

        public JsVar(JsName name) {
            this.name = name;
        }

        public JsVar(JsName name, @Nullable JsExpression initExpression) {
            this.name = name;
            this.initExpression = initExpression;
        }

        public JsExpression getInitExpression() {
            return this.initExpression;
        }

        @Override
        public JsName getName() {
            return this.name;
        }

        public void setInitExpression(JsExpression initExpression) {
            this.initExpression = initExpression;
        }

        @Override
        public void accept(JsVisitor v) {
            v.visit(this);
        }

        @Override
        public void acceptChildren(JsVisitor visitor) {
            if (this.initExpression != null) {
                visitor.accept(this.initExpression);
            }
        }

        @Override
        public void traverse(JsVisitorWithContext v, JsContext ctx) {
            if (v.visit(this, ctx) && this.initExpression != null) {
                this.initExpression = v.accept(this.initExpression);
            }
            v.endVisit(this, ctx);
        }

        @Override
        @NotNull
        public JsVar deepCopy() {
            if (this.initExpression == null) {
                JsVar jsVar = new JsVar(this.name);
                if (jsVar == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsVars$JsVar", "deepCopy"));
                }
                return jsVar;
            }
            JsVar jsVar = new JsVar(this.name, this.initExpression.deepCopy()).withMetadataFrom(this);
            if (jsVar == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsVars$JsVar", "deepCopy"));
            }
            return jsVar;
        }
    }
}

