/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EncodingRegistry {
    public static Getter<EncodingRegistry> ourInstanceGetter;

    public abstract boolean isNative2AsciiForPropertiesFiles();

    @Nullable
    public abstract Charset getDefaultCharset();

    @Nullable
    public abstract Charset getEncoding(@Nullable VirtualFile var1, boolean var2);

    public abstract void setEncoding(@Nullable(value="null means project") VirtualFile var1, @Nullable(value="null means remove mapping") Charset var2);

    public static EncodingRegistry getInstance() {
        if (ourInstanceGetter == null) {
            return (EncodingRegistry)ApplicationManager.getApplication().getPicoContainer().getComponentInstance("com.intellij.openapi.vfs.encoding.EncodingManager");
        }
        return ourInstanceGetter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Throwable> VirtualFile doActionAndRestoreEncoding(@NotNull VirtualFile fileBefore, @NotNull ThrowableComputable<VirtualFile, E> action) throws E {
        if (fileBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBefore", "com/intellij/openapi/vfs/encoding/EncodingRegistry", "doActionAndRestoreEncoding"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/vfs/encoding/EncodingRegistry", "doActionAndRestoreEncoding"));
        }
        EncodingRegistry registry = EncodingRegistry.getInstance();
        Charset charsetBefore = registry.getEncoding(fileBefore, true);
        VirtualFile fileAfter = null;
        try {
            VirtualFile virtualFile = fileAfter = action.compute();
            return virtualFile;
        }
        finally {
            Charset actual;
            if (fileAfter != null && !Comparing.equal(actual = registry.getEncoding(fileAfter, true), charsetBefore)) {
                registry.setEncoding(fileAfter, charsetBefore);
            }
        }
    }
}

