/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InferenceVariable
extends LightTypeParameter {
    private PsiElement myContext;
    private boolean myThrownBound = false;
    private final Map<InferenceBound, List<PsiType>> myBounds = new HashMap<InferenceBound, List<PsiType>>();
    private PsiType myInstantiation = PsiType.NULL;

    public PsiTypeParameter getParameter() {
        return this.getDelegate();
    }

    InferenceVariable(PsiElement context2, PsiTypeParameter parameter) {
        super(parameter);
        this.myContext = context2;
    }

    public PsiType getInstantiation() {
        return this.myInstantiation;
    }

    public void setInstantiation(PsiType instantiation) {
        this.myInstantiation = instantiation;
    }

    public boolean addBound(PsiType classType, InferenceBound inferenceBound) {
        int idx;
        if (inferenceBound == InferenceBound.EQ && PsiUtil.resolveClassInClassTypeOnly(classType) == this) {
            return false;
        }
        List<PsiType> list = this.myBounds.get((Object)inferenceBound);
        if (list == null) {
            list = new ArrayList<PsiType>();
            this.myBounds.put(inferenceBound, list);
        }
        if ((idx = list.indexOf(classType)) < 0) {
            list.add(classType);
            return true;
        }
        return false;
    }

    public List<PsiType> getBounds(InferenceBound inferenceBound) {
        List<PsiType> bounds = this.myBounds.get((Object)inferenceBound);
        return bounds != null ? new ArrayList<PsiType>(bounds) : Collections.emptyList();
    }

    public Set<InferenceVariable> getDependencies(InferenceSession session) {
        LinkedHashSet<InferenceVariable> dependencies = new LinkedHashSet<InferenceVariable>();
        for (List<PsiType> boundTypes : this.myBounds.values()) {
            if (boundTypes == null) continue;
            for (PsiType psiType : boundTypes) {
                session.collectDependencies(psiType, dependencies);
            }
        }
        if (!session.hasCapture(this) && dependencies.isEmpty()) {
            return dependencies;
        }
        block2: for (InferenceVariable variable : session.getInferenceVariables()) {
            if (dependencies.contains(variable) || variable == this) continue;
            for (List list : variable.myBounds.values()) {
                if (list == null) continue;
                for (PsiType bound : list) {
                    InferenceVariable inferenceVariable = session.getInferenceVariable(bound);
                    if (inferenceVariable != this) continue;
                    dependencies.add(variable);
                    continue block2;
                }
            }
        }
        if (!session.hasCapture(this)) {
            return dependencies;
        }
        Iterator iterator2 = dependencies.iterator();
        while (iterator2.hasNext()) {
            if (session.hasCapture((InferenceVariable)iterator2.next())) continue;
            iterator2.remove();
        }
        session.collectCaptureDependencies(this, dependencies);
        return dependencies;
    }

    public boolean hasInstantiation(InferenceSession session) {
        List<PsiType> bounds = this.getBounds(InferenceBound.EQ);
        if (bounds != null) {
            for (PsiType bound : bounds) {
                if (!session.isProperType(bound)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isThrownBound() {
        return this.myThrownBound;
    }

    public void setThrownBound() {
        this.myThrownBound = true;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another || this.getDelegate() == another;
    }

    @Override
    public boolean useDelegateToSubstitute() {
        return false;
    }

    @Override
    public String toString() {
        return this.getDelegate().toString();
    }

    public PsiElement getCallContext() {
        return this.myContext;
    }
}

