/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.SubstitutedFileType;
import org.jetbrains.annotations.Nullable;

public class StubTreeBuilder {
    private static final Key<Stub> stubElementKey = Key.create("stub.tree.for.file.content");

    private StubTreeBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Stub buildStubTree(FileContent inputData) {
        Stub data2 = inputData.getUserData(stubElementKey);
        if (data2 != null) {
            return data2;
        }
        FileContent fileContent = inputData;
        synchronized (fileContent) {
            data2 = inputData.getUserData(stubElementKey);
            if (data2 != null) {
                return data2;
            }
            FileType fileType = inputData.getFileType();
            BinaryFileStubBuilder builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
            if (builder != null) {
                data2 = builder.buildStubTree(inputData);
            } else {
                LanguageFileType languageFileType = (LanguageFileType)fileType;
                Language l = languageFileType.getLanguage();
                IFileElementType type2 = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l)).getFileNodeType();
                CharSequence contentAsText = inputData.getContentAsText();
                PsiFile psi = ((FileContentImpl)inputData).getPsiFileAccountingForUnsavedDocument();
                psi = psi.getViewProvider().getStubBindingRoot();
                psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, contentAsText);
                psi.getManager().startBatchFilesProcessingMode();
                try {
                    SubstitutedFileType substituted;
                    LanguageFileType original;
                    IFileElementType originalType;
                    IStubFileElementType stubFileElementType = type2 instanceof IStubFileElementType ? (IStubFileElementType)type2 : (languageFileType instanceof SubstitutedFileType ? ((originalType = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((original = (LanguageFileType)(substituted = (SubstitutedFileType)languageFileType).getOriginalFileType()).getLanguage())).getFileNodeType()) instanceof IStubFileElementType ? (IStubFileElementType)originalType : null) : null);
                    if (stubFileElementType != null) {
                        data2 = stubFileElementType.getBuilder().buildStubTree(psi);
                    }
                }
                finally {
                    psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, null);
                    psi.getManager().finishBatchFilesProcessingMode();
                }
            }
            inputData.putUserData(stubElementKey, data2);
            return data2;
        }
    }
}

