/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.asJava.ClsWrapperStubPsiFactory;
import org.jetbrains.jet.asJava.InnerKotlinClassLightClassData;
import org.jetbrains.jet.asJava.KotlinLightClassBuilderFactory;
import org.jetbrains.jet.asJava.KotlinPackageLightClassData;
import org.jetbrains.jet.asJava.LightClassConstructionContext;
import org.jetbrains.jet.asJava.LightClassGenerationSupport;
import org.jetbrains.jet.asJava.LightClassUtil;
import org.jetbrains.jet.asJava.OutermostKotlinClassLightClassData;
import org.jetbrains.jet.asJava.WithFileStubAndExtraDiagnostics;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.KotlinCodegenFacade;
import org.jetbrains.jet.codegen.PackageCodegen;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.Progress;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.Diagnostics;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.org.objectweb.asm.Type;

public class KotlinJavaFileStubProvider<T extends WithFileStubAndExtraDiagnostics>
implements CachedValueProvider<T> {
    private static final Logger LOG = Logger.getInstance(KotlinJavaFileStubProvider.class);
    private final Project project;
    private final StubGenerationStrategy<T> stubGenerationStrategy;
    private final boolean local;

    @NotNull
    public static KotlinJavaFileStubProvider<KotlinPackageLightClassData> createForPackageClass(final @NotNull Project project, final @NotNull FqName packageFqName, final @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "createForPackageClass"));
        }
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "createForPackageClass"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "createForPackageClass"));
        }
        KotlinJavaFileStubProvider<KotlinPackageLightClassData> kotlinJavaFileStubProvider = new KotlinJavaFileStubProvider<KotlinPackageLightClassData>(project, false, new StubGenerationStrategy<KotlinPackageLightClassData>(){

            @Override
            @NotNull
            public LightClassConstructionContext getContext(@NotNull Collection<JetFile> files) {
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$1", "getContext"));
                }
                LightClassConstructionContext lightClassConstructionContext = LightClassGenerationSupport.getInstance(project).getContextForPackage(files);
                if (lightClassConstructionContext == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$1", "getContext"));
                }
                return lightClassConstructionContext;
            }

            @Override
            @NotNull
            public Collection<JetFile> getFiles() {
                Collection<JetFile> collection = LightClassGenerationSupport.getInstance(project).findFilesForPackage(packageFqName, searchScope);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$1", "getFiles"));
                }
                return collection;
            }

            @Override
            @NotNull
            public KotlinPackageLightClassData createLightClassData(PsiJavaFileStub javaFileStub, BindingContext bindingContext, Diagnostics extraDiagnostics) {
                KotlinPackageLightClassData kotlinPackageLightClassData = new KotlinPackageLightClassData(javaFileStub, extraDiagnostics);
                if (kotlinPackageLightClassData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$1", "createLightClassData"));
                }
                return kotlinPackageLightClassData;
            }

            @Override
            @NotNull
            public FqName getPackageFqName() {
                FqName fqName2 = packageFqName;
                if (fqName2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$1", "getPackageFqName"));
                }
                return fqName2;
            }

            @Override
            public GenerationState.GenerateClassFilter getGenerateClassFilter() {
                return new GenerationState.GenerateClassFilter(){

                    @Override
                    public boolean shouldProcess(JetClassOrObject classOrObject) {
                        return JetPsiUtil.isLocal(classOrObject);
                    }
                };
            }

            @Override
            public void generate(@NotNull GenerationState state, @NotNull Collection<JetFile> files) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$1", "generate"));
                }
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$1", "generate"));
                }
                PackageCodegen codegen = state.getFactory().forPackage(packageFqName, files);
                codegen.generate(CompilationErrorHandler.THROW_EXCEPTION);
                state.getFactory().asList();
            }

            public String toString() {
                return StubGenerationStrategy.class.getName() + " for package class";
            }
        });
        if (kotlinJavaFileStubProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "createForPackageClass"));
        }
        return kotlinJavaFileStubProvider;
    }

    @NotNull
    public static KotlinJavaFileStubProvider<OutermostKotlinClassLightClassData> createForDeclaredClass(final @NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "createForDeclaredClass"));
        }
        KotlinJavaFileStubProvider<OutermostKotlinClassLightClassData> kotlinJavaFileStubProvider = new KotlinJavaFileStubProvider<OutermostKotlinClassLightClassData>(classOrObject.getProject(), classOrObject.isLocal(), new StubGenerationStrategy<OutermostKotlinClassLightClassData>(){

            private JetFile getFile() {
                return classOrObject.getContainingJetFile();
            }

            @Override
            @NotNull
            public LightClassConstructionContext getContext(@NotNull Collection<JetFile> files) {
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$2", "getContext"));
                }
                LightClassConstructionContext lightClassConstructionContext = LightClassGenerationSupport.getInstance(classOrObject.getProject()).getContextForClassOrObject(classOrObject);
                if (lightClassConstructionContext == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$2", "getContext"));
                }
                return lightClassConstructionContext;
            }

            @Override
            @NotNull
            public OutermostKotlinClassLightClassData createLightClassData(PsiJavaFileStub javaFileStub, BindingContext bindingContext, Diagnostics extraDiagnostics) {
                ClassDescriptor classDescriptor = bindingContext.get(BindingContext.CLASS, classOrObject);
                if (classDescriptor == null) {
                    OutermostKotlinClassLightClassData outermostKotlinClassLightClassData = new OutermostKotlinClassLightClassData(javaFileStub, extraDiagnostics, FqName.ROOT, classOrObject, null, Collections.emptyMap());
                    if (outermostKotlinClassLightClassData == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$2", "createLightClassData"));
                    }
                    return outermostKotlinClassLightClassData;
                }
                FqName fqName2 = this.predictClassFqName(bindingContext, classDescriptor);
                Collection<ClassDescriptor> allInnerClasses = CodegenBinding.getAllInnerClasses(bindingContext, classDescriptor);
                HashMap<JetClassOrObject, InnerKotlinClassLightClassData> innerClassesMap = ContainerUtil.newHashMap();
                for (ClassDescriptor innerClassDescriptor : allInnerClasses) {
                    PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(innerClassDescriptor);
                    if (!(declaration instanceof JetClassOrObject)) continue;
                    JetClassOrObject innerClass = (JetClassOrObject)declaration;
                    InnerKotlinClassLightClassData innerLightClassData = new InnerKotlinClassLightClassData(this.predictClassFqName(bindingContext, innerClassDescriptor), innerClass, innerClassDescriptor);
                    innerClassesMap.put(innerClass, innerLightClassData);
                }
                OutermostKotlinClassLightClassData outermostKotlinClassLightClassData = new OutermostKotlinClassLightClassData(javaFileStub, extraDiagnostics, fqName2, classOrObject, classDescriptor, innerClassesMap);
                if (outermostKotlinClassLightClassData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$2", "createLightClassData"));
                }
                return outermostKotlinClassLightClassData;
            }

            @NotNull
            private FqName predictClassFqName(BindingContext bindingContext, ClassDescriptor classDescriptor) {
                Type asmType = CodegenBinding.getAsmType(bindingContext, classDescriptor);
                FqName fqName2 = JvmClassName.byInternalName(asmType.getClassName().replace('.', '/')).getFqNameForClassNameWithoutDollars();
                if (fqName2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$2", "predictClassFqName"));
                }
                return fqName2;
            }

            @Override
            @NotNull
            public Collection<JetFile> getFiles() {
                List<JetFile> list = Collections.singletonList(this.getFile());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$2", "getFiles"));
                }
                return list;
            }

            @Override
            @NotNull
            public FqName getPackageFqName() {
                FqName fqName2 = this.getFile().getPackageFqName();
                if (fqName2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$2", "getPackageFqName"));
                }
                return fqName2;
            }

            @Override
            public GenerationState.GenerateClassFilter getGenerateClassFilter() {
                return new GenerationState.GenerateClassFilter(){

                    @Override
                    public boolean shouldProcess(JetClassOrObject generatedClassOrObject) {
                        if (generatedClassOrObject == classOrObject) {
                            return true;
                        }
                        if (PsiTreeUtil.isAncestor(generatedClassOrObject, classOrObject, true) || PsiTreeUtil.isAncestor(classOrObject, generatedClassOrObject, true)) {
                            return true;
                        }
                        if (generatedClassOrObject.isLocal() && classOrObject.isLocal()) {
                            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)generatedClassOrObject, (PsiElement)classOrObject);
                            return commonParent != null && !(commonParent instanceof PsiFile);
                        }
                        return false;
                    }
                };
            }

            @Override
            public void generate(@NotNull GenerationState state, @NotNull Collection<JetFile> files) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$2", "generate"));
                }
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$2", "generate"));
                }
                PackageCodegen packageCodegen = state.getFactory().forPackage(this.getPackageFqName(), files);
                packageCodegen.generateClassOrObject(classOrObject);
                state.getFactory().asList();
            }

            public String toString() {
                return StubGenerationStrategy.class.getName() + " for explicit class " + classOrObject.getName();
            }
        });
        if (kotlinJavaFileStubProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "createForDeclaredClass"));
        }
        return kotlinJavaFileStubProvider;
    }

    private KotlinJavaFileStubProvider(@NotNull Project project, boolean local, @NotNull StubGenerationStrategy<T> stubGenerationStrategy) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "<init>"));
        }
        if (stubGenerationStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubGenerationStrategy", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "<init>"));
        }
        this.project = project;
        this.stubGenerationStrategy = stubGenerationStrategy;
        this.local = local;
    }

    @Override
    @Nullable
    public CachedValueProvider.Result<T> compute() {
        BindingContext bindingContext;
        FqName packageFqName = this.stubGenerationStrategy.getPackageFqName();
        Collection<JetFile> files = this.stubGenerationStrategy.getFiles();
        KotlinJavaFileStubProvider.checkForBuiltIns(packageFqName, files);
        LightClassConstructionContext context2 = this.stubGenerationStrategy.getContext(files);
        PsiJavaFileStub javaFileStub = this.createJavaFileStub(packageFqName, KotlinJavaFileStubProvider.getRepresentativeVirtualFile(files));
        BindingTraceContext forExtraDiagnostics = new BindingTraceContext();
        try {
            Stack<StubElement> stubStack = new Stack<StubElement>();
            stubStack.push(javaFileStub);
            GenerationState state = new GenerationState(this.project, new KotlinLightClassBuilderFactory(stubStack), Progress.DEAF, context2.getModule(), context2.getBindingContext(), Lists.newArrayList(files), false, false, this.stubGenerationStrategy.getGenerateClassFilter(), false, false, null, null, forExtraDiagnostics, null);
            KotlinCodegenFacade.prepareForCompilation(state);
            bindingContext = state.getBindingContext();
            this.stubGenerationStrategy.generate(state, files);
            StubElement pop = stubStack.pop();
            if (pop != javaFileStub) {
                LOG.error("Unbalanced stack operations: " + pop);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            KotlinJavaFileStubProvider.logErrorWithOSInfo(e, packageFqName, null);
            throw e;
        }
        Diagnostics extraDiagnostics = forExtraDiagnostics.getBindingContext().getDiagnostics();
        return CachedValueProvider.Result.create(this.stubGenerationStrategy.createLightClassData(javaFileStub, bindingContext, extraDiagnostics), this.local ? PsiModificationTracker.MODIFICATION_COUNT : PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
    }

    @NotNull
    private PsiJavaFileStub createJavaFileStub(final @NotNull FqName packageFqName, @NotNull VirtualFile virtualFile) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "createJavaFileStub"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "createJavaFileStub"));
        }
        PsiManager manager = PsiManager.getInstance(this.project);
        final PsiJavaFileStubImpl javaFileStub = new PsiJavaFileStubImpl(packageFqName.asString(), true);
        javaFileStub.setPsiFactory(new ClsWrapperStubPsiFactory());
        ClsFileImpl fakeFile = new ClsFileImpl((PsiManagerImpl)manager, new ClassFileViewProvider(manager, virtualFile)){

            @Override
            @NotNull
            public PsiClassHolderFileStub getStub() {
                PsiJavaFileStubImpl psiJavaFileStubImpl = javaFileStub;
                if (psiJavaFileStubImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$3", "getStub"));
                }
                return psiJavaFileStubImpl;
            }

            @Override
            @NotNull
            public String getPackageName() {
                String string = packageFqName.asString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider$3", "getPackageName"));
                }
                return string;
            }
        };
        fakeFile.setPhysical(false);
        javaFileStub.setPsi(fakeFile);
        PsiJavaFileStubImpl psiJavaFileStubImpl = javaFileStub;
        if (psiJavaFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "createJavaFileStub"));
        }
        return psiJavaFileStubImpl;
    }

    @NotNull
    private static VirtualFile getRepresentativeVirtualFile(@NotNull Collection<JetFile> files) {
        VirtualFile virtualFile;
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "getRepresentativeVirtualFile"));
        }
        JetFile firstFile = files.iterator().next();
        VirtualFile virtualFile2 = virtualFile = files.size() == 1 ? firstFile.getVirtualFile() : new LightVirtualFile();
        assert (virtualFile != null) : "No virtual file for " + firstFile;
        VirtualFile virtualFile3 = virtualFile;
        if (virtualFile3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "getRepresentativeVirtualFile"));
        }
        return virtualFile3;
    }

    private static void checkForBuiltIns(@NotNull FqName fqName2, @NotNull Collection<JetFile> files) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "checkForBuiltIns"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "checkForBuiltIns"));
        }
        for (JetFile file : files) {
            if (!LightClassUtil.belongsToKotlinBuiltIns(file)) continue;
            KotlinJavaFileStubProvider.logErrorWithOSInfo(null, fqName2, file.getVirtualFile());
        }
    }

    private static void logErrorWithOSInfo(@Nullable Throwable cause, @NotNull FqName fqName2, @Nullable VirtualFile virtualFile) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/asJava/KotlinJavaFileStubProvider", "logErrorWithOSInfo"));
        }
        String path = virtualFile == null ? "<null>" : virtualFile.getPath();
        LOG.error("Could not generate LightClass for " + fqName2 + " declared in " + path + "\n" + "built-ins dir URL is " + LightClassUtil.getBuiltInsDirUrl() + "\n" + "System: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + " Java Runtime: " + SystemInfo.JAVA_RUNTIME_VERSION, cause);
    }

    private static interface StubGenerationStrategy<T extends WithFileStubAndExtraDiagnostics> {
        @NotNull
        public Collection<JetFile> getFiles();

        @NotNull
        public FqName getPackageFqName();

        @NotNull
        public LightClassConstructionContext getContext(@NotNull Collection<JetFile> var1);

        @NotNull
        public T createLightClassData(PsiJavaFileStub var1, BindingContext var2, Diagnostics var3);

        public GenerationState.GenerateClassFilter getGenerateClassFilter();

        public void generate(@NotNull GenerationState var1, @NotNull Collection<JetFile> var2);
    }
}

