/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.light.AbstractLightClass;
import com.intellij.psi.impl.light.LightField;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.asJava.ClsWrapperStubPsiFactory;
import org.jetbrains.jet.asJava.KotlinLightClass;
import org.jetbrains.jet.asJava.KotlinLightClassForEnumEntry;
import org.jetbrains.jet.asJava.KotlinLightEnumConstant;
import org.jetbrains.jet.asJava.KotlinLightFieldForDeclaration;
import org.jetbrains.jet.asJava.KotlinLightMethodForDeclaration;
import org.jetbrains.jet.asJava.KotlinLightMethodForTraitFakeOverride;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.plugin.JetLanguage;

public abstract class KotlinWrappingLightClass
extends AbstractLightClass
implements PsiExtensibleClass,
KotlinLightClass {
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache(this);

    protected KotlinWrappingLightClass(PsiManager manager) {
        super(manager, JetLanguage.INSTANCE);
    }

    @Override
    @NotNull
    public abstract PsiClass getDelegate();

    @Override
    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = this.myInnersCache.getFields();
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "getFields"));
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "getMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getConstructors();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "getConstructors"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = this.myInnersCache.getInnerClasses();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "getInnerClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "getAllFields"));
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses(this);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "getAllInnerClasses"));
        }
        return psiClassArray;
    }

    @Override
    public PsiField findFieldByName(String name, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name, checkBases);
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.myInnersCache.findMethodsByName(name, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    @Override
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name, checkBases);
    }

    @Override
    @NotNull
    public List<PsiField> getOwnFields() {
        List<PsiField> list = ContainerUtil.map(this.getDelegate().getFields(), new Function<PsiField, PsiField>(){

            @Override
            public PsiField fun(PsiField field) {
                JetDeclaration declaration = ClsWrapperStubPsiFactory.getOriginalDeclaration(field);
                if (declaration instanceof JetEnumEntry) {
                    assert (field instanceof PsiEnumConstant) : "Field delegate should be an enum constant (" + field.getName() + "):\n" + JetPsiUtil.getElementTextWithContext(declaration);
                    JetEnumEntry enumEntry = (JetEnumEntry)declaration;
                    PsiEnumConstant enumConstant = (PsiEnumConstant)field;
                    FqName enumConstantFqName = new FqName(KotlinWrappingLightClass.this.getFqName().asString() + "." + enumEntry.getName());
                    KotlinLightClassForEnumEntry initializingClass = enumEntry.getDeclarations().isEmpty() ? null : new KotlinLightClassForEnumEntry(KotlinWrappingLightClass.this.myManager, enumConstantFqName, enumEntry, enumConstant);
                    return new KotlinLightEnumConstant(KotlinWrappingLightClass.this.myManager, enumEntry, enumConstant, KotlinWrappingLightClass.this, initializingClass);
                }
                if (declaration != null) {
                    return new KotlinLightFieldForDeclaration(KotlinWrappingLightClass.this.myManager, declaration, field, (PsiClass)KotlinWrappingLightClass.this);
                }
                return new LightField(KotlinWrappingLightClass.this.myManager, field, KotlinWrappingLightClass.this);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "getOwnFields"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List<PsiMethod> list = KotlinPackage.map(this.getDelegate().getMethods(), new Function1<PsiMethod, PsiMethod>(){

            @Override
            public PsiMethod invoke(PsiMethod method) {
                JetDeclaration declaration = ClsWrapperStubPsiFactory.getOriginalDeclaration(method);
                if (declaration != null) {
                    return !KotlinWrappingLightClass.this.isTraitFakeOverride(declaration) ? new KotlinLightMethodForDeclaration(KotlinWrappingLightClass.this.myManager, method, declaration, KotlinWrappingLightClass.this) : new KotlinLightMethodForTraitFakeOverride(KotlinWrappingLightClass.this.myManager, method, declaration, KotlinWrappingLightClass.this);
                }
                return new LightMethod(KotlinWrappingLightClass.this.myManager, method, KotlinWrappingLightClass.this);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "getOwnMethods"));
        }
        return list;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "processDeclarations"));
        }
        if (this.isEnum() && !PsiClassImplUtil.processDeclarationsInEnum(processor, state, this.myInnersCache)) {
            return false;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    public String getText() {
        JetClassOrObject origin = (JetClassOrObject)this.getOrigin();
        return origin == null ? null : origin.getText();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JetLanguage jetLanguage = JetLanguage.INSTANCE;
        if (jetLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "getLanguage"));
        }
        return jetLanguage;
    }

    private boolean isTraitFakeOverride(@NotNull JetDeclaration originMethodDeclaration) {
        if (originMethodDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originMethodDeclaration", "org/jetbrains/jet/asJava/KotlinWrappingLightClass", "isTraitFakeOverride"));
        }
        if (!(originMethodDeclaration instanceof JetNamedFunction || originMethodDeclaration instanceof JetPropertyAccessor || originMethodDeclaration instanceof JetProperty)) {
            return false;
        }
        JetClassOrObject parentOfMethodOrigin = PsiTreeUtil.getParentOfType((PsiElement)originMethodDeclaration, JetClassOrObject.class);
        JetClassOrObject thisClassDeclaration = (JetClassOrObject)this.getOrigin();
        return parentOfMethodOrigin != null && thisClassDeclaration != parentOfMethodOrigin && JetPsiUtil.isTrait(parentOfMethodOrigin);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }
}

