/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;

public class RangeCodegenUtil {
    private static final ImmutableMap<FqName, PrimitiveType> RANGE_TO_ELEMENT_TYPE;
    private static final ImmutableMap<FqName, PrimitiveType> PROGRESSION_TO_ELEMENT_TYPE;

    private RangeCodegenUtil() {
    }

    public static boolean isRange(JetType rangeType) {
        return !rangeType.isMarkedNullable() && RangeCodegenUtil.getPrimitiveRangeElementType(rangeType) != null;
    }

    public static boolean isProgression(JetType rangeType) {
        return !rangeType.isMarkedNullable() && RangeCodegenUtil.getPrimitiveProgressionElementType(rangeType) != null;
    }

    @Nullable
    public static BinaryCall getRangeAsBinaryCall(@NotNull JetForExpression forExpression) {
        if (forExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/jet/codegen/RangeCodegenUtil", "getRangeAsBinaryCall"));
        }
        JetExpression rangeExpression = forExpression.getLoopRange();
        assert (rangeExpression != null);
        JetExpression loopRange = JetPsiUtil.deparenthesize(rangeExpression);
        if (loopRange instanceof JetQualifiedExpression) {
            JetCallExpression callExpression;
            List<? extends ValueArgument> arguments2;
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)loopRange;
            JetExpression selector = qualifiedExpression.getSelectorExpression();
            if (selector instanceof JetCallExpression && (arguments2 = (callExpression = (JetCallExpression)selector).getValueArguments()).size() == 1) {
                return new BinaryCall(qualifiedExpression.getReceiverExpression(), callExpression.getCalleeExpression(), arguments2.get(0).getArgumentExpression());
            }
        } else if (loopRange instanceof JetBinaryExpression) {
            JetBinaryExpression binaryExpression = (JetBinaryExpression)loopRange;
            return new BinaryCall(binaryExpression.getLeft(), binaryExpression.getOperationReference(), binaryExpression.getRight());
        }
        return null;
    }

    @Nullable
    private static PrimitiveType getPrimitiveRangeElementType(JetType rangeType) {
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(rangeType, RANGE_TO_ELEMENT_TYPE);
    }

    @Nullable
    private static PrimitiveType getPrimitiveProgressionElementType(JetType rangeType) {
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(rangeType, PROGRESSION_TO_ELEMENT_TYPE);
    }

    @Nullable
    private static PrimitiveType getPrimitiveRangeOrProgressionElementType(@NotNull JetType rangeOrProgression, @NotNull ImmutableMap<FqName, PrimitiveType> map) {
        if (rangeOrProgression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeOrProgression", "org/jetbrains/jet/codegen/RangeCodegenUtil", "getPrimitiveRangeOrProgressionElementType"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/jet/codegen/RangeCodegenUtil", "getPrimitiveRangeOrProgressionElementType"));
        }
        ClassifierDescriptor declarationDescriptor = rangeOrProgression.getConstructor().getDeclarationDescriptor();
        assert (declarationDescriptor != null);
        if (declarationDescriptor != KotlinBuiltIns.getInstance().getBuiltInsPackageScope().getClassifier(declarationDescriptor.getName())) {
            return null;
        }
        return map.get(DescriptorUtils.getFqNameSafe(declarationDescriptor));
    }

    @Nullable
    public static PrimitiveType getPrimitiveRangeOrProgressionElementType(@NotNull FqName rangeOrProgressionName) {
        if (rangeOrProgressionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeOrProgressionName", "org/jetbrains/jet/codegen/RangeCodegenUtil", "getPrimitiveRangeOrProgressionElementType"));
        }
        PrimitiveType result2 = RANGE_TO_ELEMENT_TYPE.get(rangeOrProgressionName);
        return result2 != null ? result2 : PROGRESSION_TO_ELEMENT_TYPE.get(rangeOrProgressionName);
    }

    public static boolean isRangeOrProgression(@NotNull FqName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/codegen/RangeCodegenUtil", "isRangeOrProgression"));
        }
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(className) != null;
    }

    public static boolean isOptimizableRangeTo(CallableDescriptor rangeTo) {
        return "rangeTo".equals(rangeTo.getName().asString()) && AsmUtil.isPrimitiveNumberClassDescriptor(rangeTo.getContainingDeclaration());
    }

    static {
        ImmutableMap.Builder<FqName, PrimitiveType> rangeBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<FqName, PrimitiveType> progressionBuilder = ImmutableMap.builder();
        for (PrimitiveType primitiveType : PrimitiveType.values()) {
            FqName rangeClassFqName = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(primitiveType.getTypeName() + "Range"));
            FqName progressionClassFqName = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(primitiveType.getTypeName() + "Progression"));
            rangeBuilder.put(rangeClassFqName, primitiveType);
            progressionBuilder.put(progressionClassFqName, primitiveType);
        }
        RANGE_TO_ELEMENT_TYPE = rangeBuilder.build();
        PROGRESSION_TO_ELEMENT_TYPE = progressionBuilder.build();
    }

    public static class BinaryCall {
        public final JetExpression left;
        public final JetExpression op;
        public final JetExpression right;

        private BinaryCall(JetExpression left, JetExpression op, JetExpression right) {
            this.left = left;
            this.op = op;
            this.right = right;
        }
    }
}

