/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypesPackage;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class OverloadUtil {
    public static OverloadCompatibilityInfo isOverloadable(CallableDescriptor a, CallableDescriptor b) {
        int bbc;
        int abc = OverloadUtil.braceCount(a);
        if (abc != (bbc = OverloadUtil.braceCount(b))) {
            return OverloadCompatibilityInfo.success();
        }
        OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverloadUtil.isOverloadableBy(a, b);
        switch (overrideCompatibilityInfo.getResult()) {
            case OVERRIDABLE: 
            case CONFLICT: {
                return OverloadCompatibilityInfo.someError();
            }
            case INCOMPATIBLE: {
                return OverloadCompatibilityInfo.success();
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    private static OverridingUtil.OverrideCompatibilityInfo isOverloadableBy(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superDescriptor", "org/jetbrains/jet/lang/resolve/OverloadUtil", "isOverloadableBy"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDescriptor", "org/jetbrains/jet/lang/resolve/OverloadUtil", "isOverloadableBy"));
        }
        OverridingUtil.OverrideCompatibilityInfo receiverAndParameterResult = OverridingUtil.checkReceiverAndParameterCount(superDescriptor, subDescriptor);
        if (receiverAndParameterResult != null) {
            OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = receiverAndParameterResult;
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverloadUtil", "isOverloadableBy"));
            }
            return overrideCompatibilityInfo;
        }
        List<JetType> superValueParameters = OverridingUtil.compiledValueParameters(superDescriptor);
        List<JetType> subValueParameters = OverridingUtil.compiledValueParameters(subDescriptor);
        for (int i = 0; i < superValueParameters.size(); ++i) {
            JetType subValueParameterType;
            JetType superValueParameterType = OverridingUtil.getUpperBound(superValueParameters.get(i));
            if (JetTypeChecker.DEFAULT.equalTypes(superValueParameterType, subValueParameterType = OverridingUtil.getUpperBound(subValueParameters.get(i))) && !TypesPackage.oneMoreSpecificThanAnother(subValueParameterType, superValueParameterType)) continue;
            OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.valueParameterTypeMismatch(superValueParameterType, subValueParameterType, OverridingUtil.OverrideCompatibilityInfo.Result.INCOMPATIBLE);
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverloadUtil", "isOverloadableBy"));
            }
            return overrideCompatibilityInfo;
        }
        OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.success();
        if (overrideCompatibilityInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverloadUtil", "isOverloadableBy"));
        }
        return overrideCompatibilityInfo;
    }

    private static int braceCount(CallableDescriptor a) {
        if (a instanceof PropertyDescriptor) {
            return 0;
        }
        if (a instanceof SimpleFunctionDescriptor) {
            return 1;
        }
        if (a instanceof ConstructorDescriptor) {
            return 1;
        }
        throw new IllegalStateException();
    }

    public static class OverloadCompatibilityInfo {
        private static final OverloadCompatibilityInfo SUCCESS = new OverloadCompatibilityInfo(true, "SUCCESS");
        private final boolean isSuccess;
        private final String message;

        public static OverloadCompatibilityInfo success() {
            return SUCCESS;
        }

        public static OverloadCompatibilityInfo someError() {
            return new OverloadCompatibilityInfo(false, "XXX");
        }

        public OverloadCompatibilityInfo(boolean success, String message) {
            this.isSuccess = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

