/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueConstant;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.Qualifier;
import org.jetbrains.jet.lang.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiversPackage;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

public class CallExpressionResolver {
    @NotNull
    private ExpressionTypingServices expressionTypingServices;

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Nullable
    public ResolvedCall<FunctionDescriptor> getResolvedCallForFunction(@NotNull Call call, @NotNull JetExpression callExpression, @NotNull ResolutionContext context2, @NotNull CheckValueArgumentsMode checkArguments, @NotNull boolean[] result2) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (checkArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkArguments", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        CallResolver callResolver = this.expressionTypingServices.getCallResolver();
        OverloadResolutionResults<FunctionDescriptor> results = callResolver.resolveFunctionCall(BasicCallResolutionContext.create(context2, call, checkArguments));
        if (!results.isNothing()) {
            CallExpressionResolver.checkSuper(call.getExplicitReceiver(), results, context2.trace, callExpression);
            result2[0] = true;
            return OverloadResolutionResultsUtil.getResultingCall(results, context2.contextDependency);
        }
        result2[0] = false;
        return null;
    }

    @Nullable
    private JetType getVariableType(@NotNull JetSimpleNameExpression nameExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context2, @NotNull boolean[] result2) {
        QualifierReceiver qualifier;
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context2, "trace to resolve as local variable or property", nameExpression);
        CallResolver callResolver = this.expressionTypingServices.getCallResolver();
        Call call = CallMaker.makePropertyCall(receiver, callOperationNode, nameExpression);
        BasicCallResolutionContext contextForVariable = BasicCallResolutionContext.create(context2.replaceTraceAndCache(temporaryForVariable), call, CheckValueArgumentsMode.ENABLED);
        OverloadResolutionResults<VariableDescriptor> resolutionResult = callResolver.resolveSimpleProperty(contextForVariable);
        boolean isLHSOfDot = JetPsiUtil.isLHSOfDot(nameExpression);
        if (!resolutionResult.isNothing()) {
            boolean isQualifier;
            boolean bl = isQualifier = isLHSOfDot && resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject;
            if (!isQualifier) {
                result2[0] = true;
                temporaryForVariable.commit();
                CallExpressionResolver.checkSuper(receiver, resolutionResult, context2.trace, nameExpression);
                return resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null;
            }
        }
        if ((qualifier = ReceiversPackage.createQualifier(nameExpression, receiver, context2)) != null) {
            result2[0] = true;
            if (!isLHSOfDot) {
                ReceiversPackage.resolveAsStandaloneExpression(qualifier, context2);
            }
            return null;
        }
        temporaryForVariable.commit();
        result2[0] = !resolutionResult.isNothing();
        return resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null;
    }

    @NotNull
    public JetTypeInfo getSimpleNameExpressionTypeInfo(@NotNull JetSimpleNameExpression nameExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context2) {
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        boolean[] result2 = new boolean[1];
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context2, "trace to resolve as variable", nameExpression);
        JetType type2 = this.getVariableType(nameExpression, receiver, callOperationNode, (ExpressionTypingContext)context2.replaceTraceAndCache(temporaryForVariable), result2);
        if (result2[0]) {
            temporaryForVariable.commit();
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(type2, context2.dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
            }
            return jetTypeInfo;
        }
        Call call = CallMaker.makeCall(nameExpression, receiver, callOperationNode, nameExpression, Collections.emptyList());
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context2, "trace to resolve as function", nameExpression);
        Object newContext = context2.replaceTraceAndCache(temporaryForFunction);
        ResolvedCall<FunctionDescriptor> resolvedCall = this.getResolvedCallForFunction(call, nameExpression, (ResolutionContext)newContext, CheckValueArgumentsMode.ENABLED, result2);
        if (result2[0]) {
            FunctionDescriptor functionDescriptor = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
            context2.trace.report(Errors.FUNCTION_CALL_EXPECTED.on(nameExpression, nameExpression, hasValueParameters));
            type2 = functionDescriptor != null ? functionDescriptor.getReturnType() : null;
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(type2, context2.dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
            }
            return jetTypeInfo;
        }
        temporaryForVariable.commit();
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context2.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getCallExpressionTypeInfo(@NotNull JetCallExpression callExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context2) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        JetTypeInfo typeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck(callExpression, receiver, callOperationNode, context2);
        if (context2.contextDependency == ContextDependency.INDEPENDENT) {
            DataFlowUtils.checkType(typeInfo, (JetExpression)callExpression, (ResolutionContext)context2);
        }
        JetTypeInfo jetTypeInfo = typeInfo;
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getCallExpressionTypeInfoWithoutFinalTypeCheck(@NotNull JetCallExpression callExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context2) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        boolean[] result2 = new boolean[1];
        Call call = CallMaker.makeCall(receiver, callOperationNode, callExpression);
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context2, "trace to resolve as function call", callExpression);
        ResolvedCall<FunctionDescriptor> resolvedCall = this.getResolvedCallForFunction(call, callExpression, (ResolutionContext)context2.replaceTraceAndCache(temporaryForFunction), CheckValueArgumentsMode.ENABLED, result2);
        if (result2[0]) {
            FunctionDescriptor functionDescriptor = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            if (callExpression.getValueArgumentList() == null && callExpression.getFunctionLiteralArguments().isEmpty()) {
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context2.trace.report(Errors.FUNCTION_CALL_EXPECTED.on(callExpression, callExpression, hasValueParameters));
            }
            if (functionDescriptor == null) {
                JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context2.dataFlowInfo);
                if (jetTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
                }
                return jetTypeInfo;
            }
            if (functionDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isAnnotationClass(functionDescriptor.getContainingDeclaration()) && !CallExpressionResolver.canInstantiateAnnotationClass(callExpression)) {
                context2.trace.report(Errors.ANNOTATION_CLASS_CONSTRUCTOR_CALL.on(callExpression));
            }
            JetType type2 = functionDescriptor.getReturnType();
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(type2, resolvedCall.getDataFlowInfoForArguments().getResultInfo());
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
            }
            return jetTypeInfo;
        }
        JetExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof JetSimpleNameExpression && callExpression.getTypeArgumentList() == null) {
            TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context2, "trace to resolve as variable with 'invoke' call", callExpression);
            JetType type3 = this.getVariableType((JetSimpleNameExpression)calleeExpression, receiver, callOperationNode, (ExpressionTypingContext)context2.replaceTraceAndCache(temporaryForVariable), result2);
            Qualifier qualifier = temporaryForVariable.trace.get(BindingContext.QUALIFIER, calleeExpression);
            if (result2[0] && (qualifier == null || qualifier.getPackageView() == null)) {
                temporaryForVariable.commit();
                context2.trace.report(Errors.FUNCTION_EXPECTED.on(calleeExpression, calleeExpression, type3 != null ? type3 : ErrorUtils.createErrorType("")));
                JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context2.dataFlowInfo);
                if (jetTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
                }
                return jetTypeInfo;
            }
        }
        temporaryForFunction.commit();
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context2.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        return jetTypeInfo;
    }

    private static boolean canInstantiateAnnotationClass(@NotNull JetCallExpression expression) {
        JetClass jetClass;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "canInstantiateAnnotationClass"));
        }
        Object parent = PsiTreeUtil.getParentOfType((PsiElement)expression, JetValueArgument.class, JetParameter.class);
        if (parent instanceof JetValueArgument) {
            return PsiTreeUtil.getParentOfType(parent, JetAnnotationEntry.class) != null;
        }
        if (parent instanceof JetParameter && (jetClass = PsiTreeUtil.getParentOfType(parent, JetClass.class)) != null) {
            return jetClass.hasModifier(JetTokens.ANNOTATION_KEYWORD);
        }
        return false;
    }

    private static void checkSuper(@NotNull ReceiverValue receiverValue, @NotNull OverloadResolutionResults<?> results, @NotNull BindingTrace trace, @NotNull JetExpression expression) {
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "checkSuper"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "checkSuper"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "checkSuper"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "checkSuper"));
        }
        if (!results.isSingleResult()) {
            return;
        }
        if (!(receiverValue instanceof ExpressionReceiver)) {
            return;
        }
        JetExpression receiver = ((ExpressionReceiver)receiverValue).getExpression();
        Object descriptor = results.getResultingDescriptor();
        if (receiver instanceof JetSuperExpression && descriptor instanceof MemberDescriptor && ((MemberDescriptor)descriptor).getModality() == Modality.ABSTRACT) {
            trace.report(Errors.ABSTRACT_SUPER_CALL.on(expression));
        }
    }

    @NotNull
    private JetTypeInfo getSelectorReturnTypeInfo(@NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @Nullable JetExpression selectorExpression, @NotNull ExpressionTypingContext context2) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        if (selectorExpression instanceof JetCallExpression) {
            JetTypeInfo jetTypeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck((JetCallExpression)selectorExpression, receiver, callOperationNode, context2);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
            }
            return jetTypeInfo;
        }
        if (selectorExpression instanceof JetSimpleNameExpression) {
            JetTypeInfo jetTypeInfo = this.getSimpleNameExpressionTypeInfo((JetSimpleNameExpression)selectorExpression, receiver, callOperationNode, context2);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
            }
            return jetTypeInfo;
        }
        if (selectorExpression != null) {
            context2.trace.report(Errors.ILLEGAL_SELECTOR.on(selectorExpression, selectorExpression.getText()));
        }
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context2.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getQualifiedExpressionTypeInfo(@NotNull JetQualifiedExpression expression, @NotNull ExpressionTypingContext context2) {
        CompileTimeConstant<? extends Object> value;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        JetExpression selectorExpression = expression.getSelectorExpression();
        JetExpression receiverExpression = expression.getReceiverExpression();
        Object contextForReceiver = ((ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetTypeInfo receiverTypeInfo = this.expressionTypingServices.getTypeInfo(receiverExpression, (ResolutionContext)contextForReceiver);
        JetType receiverType = receiverTypeInfo.getType();
        QualifierReceiver qualifierReceiver = (QualifierReceiver)context2.trace.get(BindingContext.QUALIFIER, receiverExpression);
        if (receiverType == null) {
            receiverType = ErrorUtils.createErrorType("Type for " + expression.getText());
        }
        context2 = (ExpressionTypingContext)context2.replaceDataFlowInfo(receiverTypeInfo.getDataFlowInfo());
        ReceiverValue receiver = qualifierReceiver == null ? new ExpressionReceiver(receiverExpression, receiverType) : qualifierReceiver;
        JetTypeInfo selectorReturnTypeInfo = this.getSelectorReturnTypeInfo(receiver, expression.getOperationTokenNode(), selectorExpression, context2);
        JetType selectorReturnType = selectorReturnTypeInfo.getType();
        CallExpressionResolver.resolveDeferredReceiverInQualifiedExpression(qualifierReceiver, expression, context2);
        CallExpressionResolver.checkNestedClassAccess(expression, context2);
        if (expression.getOperationSign() == JetTokens.SAFE_ACCESS && selectorReturnType != null && !KotlinBuiltIns.isUnit(selectorReturnType) && TypeUtils.isNullableType(receiverType)) {
            selectorReturnType = TypeUtils.makeNullable(selectorReturnType);
        }
        if (selectorReturnType != null) {
            context2.trace.record(BindingContext.EXPRESSION_TYPE, selectorExpression, selectorReturnType);
        }
        if ((value = ConstantExpressionEvaluator.OBJECT$.evaluate(expression, context2.trace, context2.expectedType)) instanceof IntegerValueConstant && ((IntegerValueConstant)value).isPure()) {
            JetTypeInfo jetTypeInfo = BasicExpressionTypingVisitor.createCompileTimeConstantTypeInfo(value, expression, context2);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo typeInfo = JetTypeInfo.create(selectorReturnType, selectorReturnTypeInfo.getDataFlowInfo());
        if (context2.contextDependency == ContextDependency.INDEPENDENT) {
            DataFlowUtils.checkType(typeInfo, (JetExpression)expression, (ResolutionContext)context2);
        }
        JetTypeInfo jetTypeInfo = typeInfo;
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        return jetTypeInfo;
    }

    private static void resolveDeferredReceiverInQualifiedExpression(@Nullable QualifierReceiver qualifierReceiver, @NotNull JetQualifiedExpression qualifiedExpression, @NotNull ExpressionTypingContext context2) {
        if (qualifiedExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedExpression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "resolveDeferredReceiverInQualifiedExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "resolveDeferredReceiverInQualifiedExpression"));
        }
        if (qualifierReceiver == null) {
            return;
        }
        JetExpression calleeExpression = JetPsiUtil.deparenthesize(CallUtilPackage.getCalleeExpressionIfAny(qualifiedExpression.getSelectorExpression()), false);
        DeclarationDescriptor selectorDescriptor = calleeExpression instanceof JetReferenceExpression ? context2.trace.get(BindingContext.REFERENCE_TARGET, (JetReferenceExpression)calleeExpression) : null;
        ReceiversPackage.resolveAsReceiverInQualifiedExpression(qualifierReceiver, context2, selectorDescriptor);
    }

    private static void checkNestedClassAccess(@NotNull JetQualifiedExpression expression, @NotNull ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "checkNestedClassAccess"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallExpressionResolver", "checkNestedClassAccess"));
        }
        JetExpression selectorExpression = expression.getSelectorExpression();
        if (selectorExpression == null) {
            return;
        }
        Qualifier expressionQualifier = context2.trace.get(BindingContext.QUALIFIER, expression);
        Qualifier receiverQualifier = context2.trace.get(BindingContext.QUALIFIER, expression.getReceiverExpression());
        if (receiverQualifier == null && expressionQualifier != null) {
            assert (expressionQualifier.getClassifier() instanceof ClassDescriptor) : "Only class can (package cannot) be accessed by instance reference: " + expressionQualifier;
            context2.trace.report(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE.on(selectorExpression, (ClassDescriptor)expressionQualifier.getClassifier()));
        }
    }
}

