/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTaskHolder;
import org.jetbrains.jet.lang.resolve.calls.tasks.TaskPrioritizer$addCandidatesForDynamicReceiver$1;
import org.jetbrains.jet.lang.resolve.calls.tasks.TaskPrioritizer$addExtensionCandidates$1;
import org.jetbrains.jet.lang.resolve.calls.tasks.TaskPrioritizer$addMemberExtensionCandidates$1;
import org.jetbrains.jet.lang.resolve.calls.tasks.TaskPrioritizer$addMembers$1;
import org.jetbrains.jet.lang.resolve.calls.tasks.TaskPrioritizer$computePrioritizedTasksFromCandidates$1;
import org.jetbrains.jet.lang.resolve.calls.tasks.TasksPackage$dynamicCalls$cd034e6b;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.tasks.collectors.CallableDescriptorCollector;
import org.jetbrains.jet.lang.resolve.calls.tasks.collectors.CallableDescriptorCollectors;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeUtils;
import org.jetbrains.jet.lang.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.TypesPackage$dynamicTypes$b6f342e3;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.storage.StorageManager;

@KotlinClass(abiVersion=19, data={"\u0007\u0018)yA+Y:l!JLwN]5uSj,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\u0007),GO\u0003\u0003mC:<'b\u0002:fg>dg/\u001a\u0006\u0006G\u0006dGn\u001d\u0006\u0006i\u0006\u001c8n\u001d\u0006\u0004\u0003:L(BB6pi2LgN\u0003\u0004=S:LGO\u0010\u0006\u000fgR|'/Y4f\u001b\u0006t\u0017mZ3s\u00159\u0019Fo\u001c:bO\u0016l\u0015M\\1hKJTqa\u001d;pe\u0006<WMC\u0001E\u0015I\u0019\u0015\r\u001c7bE2,G)Z:de&\u0004Ho\u001c:\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006\u0002\r*y\u0012\r\u001a3DC:$\u0017\u000eZ1uKN4uN\u001d#z]\u0006l\u0017n\u0019*fG\u0016Lg/\u001a:\u000b!\u0015D\b\u000f\\5dSR\u0014VmY3jm\u0016\u0014(\"\u0004*fG\u0016Lg/\u001a:WC2,XM\u0003\u0004tG>\u0004Xm\u001d\u0006\ne\u0016\u001cW-\u001b<feNT\u0011#[7qY&\u001c\u0017\u000e\u001e*fG\u0016Lg/\u001a:t\u0015)\u0019u\u000e\u001c7fGRLwN\u001c\u0006\u0002G*1B+Y:l!JLwN]5uSj,'oQ8oi\u0016DHO\u0003\u0006jg\u0016C\b\u000f\\5dSRTqAQ8pY\u0016\fgN\u0003\u0003V]&$(\u0002\u00026bm\u0006TA!\u001e;jY*1C+Y:l!JLwN]5uSj,'\u000f\n+bg.\u0004&/[8sSRL'0\u001a:D_:$X\r\u001f;\u000bA\u0005$GmQ1oI&$\u0017\r^3t\r>\u0014X\t\u001f9mS\u000eLGOU3dK&4XM\u001d\u0006\u0017C\u0012$7)\u00198eS\u0012\fG/Z:G_JLeN^8lK*Q\u0012\r\u001a3DC:$\u0017\u000eZ1uKN4uN\u001d(p%\u0016\u001cW-\u001b<fe*i\u0014\r\u001a3DC:$\u0017\u000eZ1uKN<\u0006.\u001a8J]Z|7.Z%t\u001b\u0016l'-\u001a:B]\u0012,\u0005\u0010^3og&|g\u000eV8FqBd\u0017nY5u%\u0016\u001cW-\u001b<fe*\u0001B-[:qCR\u001c\u0007NU3dK&4XM\u001d\u0006\u0012e\u0016\u001cW-\u001b<feB\u000b'/Y7fi\u0016\u0014(\u0002\u0004:fG\u0016Lg/\u001a:LS:$'\u0002F#ya2L7-\u001b;SK\u000e,\u0017N^3s\u0017&tGM\u0003\fbI\u0012,\u0005\u0010^3og&|gnQ1oI&$\u0017\r^3t\u0015q\tG\rZ'f[\n,'/\u0012=uK:\u001c\u0018n\u001c8DC:$\u0017\u000eZ1uKNT1dY1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe\u000e{G\u000e\\3di>\u0014(bG\"bY2\f'\r\\3EKN\u001c'/\u001b9u_J\u001cu\u000e\u001c7fGR|'O\u0003\u0006d_2dWm\u0019;peNT!\"\u00193e\u001b\u0016l'-\u001a:t\u00155\u0019H/\u0019;jG6+WNY3sg*92m\\7qkR,\u0007K]5pe&$\u0018N_3e)\u0006\u001c8n\u001d\u0006\bG>tG/\u001a=u\u0015i\u0011\u0015m]5d\u0007\u0006dGNU3t_2,H/[8o\u0007>tG/\u001a=u\u0015\u0011q\u0017-\\3\u000b\t9\u000bW.\u001a\u0006\biJ\f7-\u001b8h\u0015=!&/Y2j]\u001e\u001cFO]1uK\u001eL(\u0002H2bY2\f'\r\\3EKN\u001c'/\u001b9u_J\u001cu\u000e\u001c7fGR|'o\u001d\u0006\u001d\u0007\u0006dG.\u00192mK\u0012+7o\u0019:jaR|'oQ8mY\u0016\u001cGo\u001c:t\u0015\u0011a\u0015n\u001d;\u000b\u001dI+7o\u001c7vi&|g\u000eV1tW*)3m\\7qkR,\u0007K]5pe&$\u0018N_3e)\u0006\u001c8n\u001d$s_6\u001c\u0015M\u001c3jI\u0006$Xm\u001d\u0006\u000bG\u0006tG-\u001b3bi\u0016\u001c(b\u0005*fg>dW\u000f^5p]\u000e\u000bg\u000eZ5eCR,'BF2p]Z,'\u000f^,ji\"LU\u000e\u001d7jK\u0012$\u0006.[:\u000b\u000bM\u001cw\u000e]3\u000b\u0011)+GoU2pa\u0016TAaY1mY*!1)\u00197m\u0015\r\u00018/\u001b\u0006$G>tg/\u001a:u/&$\b.S7qY&,G\r\u00165jg\u0006sGMT8SK\u000e,\u0017N^3s\u0015Q\u0019wN\u001c<feR<\u0016\u000e\u001e5SK\u000e,\u0017N^3sg*\tR\r\u001f;f]NLwN\u001c*fG\u0016Lg/\u001a:\u000b\rI,7/\u001e7u\u0015EiU\u000f^1cY\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0006\u0015Kb\u0004H.[2jiJ+7-Z5wKJ\\\u0015N\u001c3\u000b\u0015\r\u0014X-\u0019;f\u0017&tGM\u0003\u0003lS:$'B\u00043p\u0007>l\u0007/\u001e;f)\u0006\u001c8n\u001d\u0006\te\u0016\u001cW-\u001b<fe*q1/\u001a;J[Bd\u0017.\u001a3UQ&\u001c(\"C2b]\u0012LG-\u0019;f\u0015y\u0019\b\u000f\\5u\u0019\u0016D\u0018nY1mYfdunY1m\t\u0016\u001c8M]5qi>\u00148O\u0003\bbY2$Um]2sSB$xN]:\u000b;\r|g\u000e^1j]\u0016\u0014xJ\u001a+iK\u000e+(O]3oi2{7-\u00197jifTQ\u0003R3dY\u0006\u0014\u0018\r^5p]\u0012+7o\u0019:jaR|'OC\u0003m_\u000e\fGN\u0003\u0005o_:dwnY1m\u0015Q\u0001&/[8sSRL\bK]8wS\u0012,'/S7qYB\u0018!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019QA\u0001C\u0003\u0011\u000f)1\u0001B\u0002\t\u00011\u0001Q!\u0001E\u0005\u000b\r!A\u0001\u0003\u0003\r\u0001\u0015\u0011A!\u0001E\u0007\u000b\r!Q\u0001\u0003\u0004\r\u0001\u0015\u0011A!\u0002\u0005\u0007\u000b\t!\u0019\u0001\u0003\u0005\u0006\u0007\u00115\u0001r\u0002\u0007\u0001\u000b\t!!\u0001#\u0006\u0006\u0005\u0011=\u0001bC\u0003\u0004\t!A!\u0002\u0004\u0001\u0006\u0007\u0011!\u0001\u0002\u0004\u0007\u0001\u000b\r!9\u0001C\u0007\r\u0001\u0015\u0019A\u0001\u0002\u0005\u000f\u0019\u0001)1\u0001\u0002\u0003\t\u001e1\u0001QA\u0001\u0003\t\u0011))\u0011\u0001C\b\u0006\u0005\u0011]\u0001rD\u0003\u0003\t1AA\"\u0002\u0002\u0005\u0007!\u0001Ra\u0001\u0003\u0004\u0011Qa\u0001!\u0002\u0002\u0005\u0007!!RA\u0001\u0003\u0004\u0011[)1\u0001\"\b\t-1\u0001QA\u0001C\u000f\u0011Y)!\u0001\"\u0002\t2\u0015\u0019A\u0001\u0005\u0005\u001a\u0019\u0001)!\u0001\u0002\u0002\t4\u0015\u0019A!\u0005\u0005\u001b\u0019\u0001)1\u0001B\u0002\t71\u0001Qa\u0001C\u000f\u0011qa\u0001!B\u0002\u0005\t!eB\u0002A\u0003\u0004\t\rAQ\u0004\u0004\u0001\u0006\u0005\u0011a\u0001\u0012H\u0003\u0003\tAA\u0011$\u0002\u0002\u0005#!QRA\u0001\u0003\u0004\u0011m)!\u0001\"\b\t9\u0015\u0019Aa\u0001E\u001f\u0019\u0001)1\u0001b\u0004\tA1\u0001QA\u0001C\u0002\u0011\u0007*1\u0001b\f\tC1\u0001QA\u0001C\b\u0011\u0001*!\u0001b\f\tC\u0015\u0019A\u0001\u0002\u0005%\u0019\u0001)!\u0001B\u0002\t>\u0015\u0019AQ\u0002E*\u0019\u0001)!\u0001\"\u0004\tT\u0011\u0019ArA\r\u0003\u000b\u0005AI\u0001H\u0016\u001d\u001b5ZA!\u0019\u0003\u0019\f\u0005\u0012Q!\u0001E\u0006+\u000e!Qa\u0001C\u0006\u0013\u0005Aa!,f\u0001\t\u0005\tR\u0001\u0002\u0001\t\u000fU\u0011Q!\u0001\u0005\b#\u0019!\t\u0001#\u0005\u0016\u0007\u0015\u0011A\u0011\u0001\u0005\u00011%ij\u0001\u0002\u0001\t\u00145\u0011Q!\u0001E\t!\u000e\u0001QT\u0003\u0003\u0001\u0011/ia!B\u0001\t\u0013%\u0019\u0011BA\u0003\u0002\u0011#\u00016\u0011AO\u0011\t\u0001AI\"\u0004\u0007\u0006\u0003!M\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001\n\t%\u0019QA\u0001C\u0001\u0011\u0003\u00016!AO\u0007\t\u0001AY\"\u0004\u0002\u0006\u0003!Q\u0001ka\u0001\"\u0005\u0015\t\u0001RC)\u0004\u0017\u0011I\u0011\"\u0001\u0003\u0001\u001b\u0005A1\"D\u0001\t\u001a5\t\u0001\"D\u0007\u0002\t\u0003i+\u001a\u0001\u0003\u0002#\u0015!\u0001\u0001C\u0004\u0016\u0005\u0015\t\u0001bB\t\u0007\t\u0003A\t\"F\u0002\u0006\u0005\u0011\u0005\u0001\u0002\u0001M\u0011;\u001b!\u0001\u0001c\u0005\u000e\u0005\u0015\t\u0001\u0012\u0003)\u0004\u0001uUA\u0001\u0001E\f\u001b\u0019)\u0011\u0001C\u0005\n\u0007%\u0011Q!\u0001E\t!\u000e\u0005Q\u0014\u0005\u0003\u0001\u00113iA\"B\u0001\t\u0014%!\u0011bA\u0003\u0003\t\u0003A\u0001!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001E\u0001!\u000e\tQT\u0002\u0003\u0001\u00117i!!B\u0001\t\u0015A\u001b\u0019!\t\u0002\u0006\u0003!U\u0011kA\u0006\u0005\"%\tA\u0001A\u0007\u0002\u0011-i\u0011\u0001#\u0007\u000e\u0003!iQ\"\u0001C\u0001[O\"\u0011!E\u0003\u0005\u0001!9QCA\u0003\u0002\u0011\u001d\tb\u0001\"\u0001\t\u0012U\u0019QA\u0001C\u0001\u0011\u0001A\u0012#(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011#\u00016\u0001AO\u0011\t\u0001AI\"\u0004\u0007\u0006\u0003!M\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001\n\t%\u0019QA\u0001C\u0001\u0011\u0003\u00016\u0011A\u0011\u0003\u000b\u0005A)\"U\u0002\b\tEI\u0011\u0001\u0002\u0001\u000e\u0003!YQ\"\u0001\u0005\u000e[_\"\u0011!E\u0003\u0005\u0001!9QCA\u0003\u0002\u0011\u001d\tb\u0001\"\u0001\t\u0012U\u0019QA\u0001C\u0001\u0011\u0001A\u001a#(\u0006\u0005\u0001!]QBB\u0003\u0002\u0011%I1!\u0003\u0002\u0006\u0003!E\u0001k\u0001\u0001\u001e\"\u0011\u0001\u0001\u0012D\u0007\r\u000b\u0005A\u0019\"\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0005\u0001k!\u0001\"\u0005\u0015\t\u0001RC)\u0004\u000f\u0011\r\u0012\"\u0001\u0003\u0001\u001b\u0005AI\"D\u0001\t\u001b56\r\u0001B\u0001\u0012\u000b\u0011\u0001\u0001bB\u000b\u0003\u000b\u0005Aq!\u0005\u0004\u0005\u0002!EQcA\u0003\u0003\t\u0003A\u0001\u0001\u0007\n\u001e\u000e\u0011\u0001\u0001RE\u0007\u0003\u000b\u0005A\t\u0002U\u0002\u0001;\u001b!\u0001\u0001C\n\u000e\u0005\u0015\t\u0001\u0012\u0003)\u0004\u0002u\u0005B\u0001\u0001E\r\u001b1)\u0011\u0001c\u0005\n\t%\u0019QA\u0001C\u0001\u0011\u0001IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0012\u0001)\u0004\u0003u5A\u0001\u0001E\u0014\u001b\t)\u0011\u0001c\u0007Q\u0007\u0007\t#!B\u0001\t\u0016E\u001b1\u0002\u0002\n\n\u0003\u0011\u0001Q\"\u0001\u0005\f\u001b\u0005A1\"D\u0001\t\u001b5\t\u0001BDWK\u0002\u0011\t\u0011#\u0002\u0003\u0001\u0011\u001d)\"!B\u0001\t\u000fE1A\u0011\u0001E\t+\r)!\u0001\"\u0001\t\u0001a%RT\u0002\u0003\u0001\u0011'i!!B\u0001\t\u0012A\u001b\u0001!(\u0006\u0005\u0001!]QBB\u0003\u0002\u0011%I1!\u0003\u0002\u0006\u0003!E\u0001k!\u0001\u001e\"\u0011\u0001\u0001\u0012D\u0007\r\u000b\u0005A\u0019\"\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0005\u0001kA\u0001\u001e\u000e\u0011\u0001\u00012D\u0007\u0003\u000b\u0005A!\u0002UB\u0002C\t)\u0011\u0001#\u0006R\u0007-!I#C\u0001\u0005\u00015\t\u0001bC\u0007\u0002\u00113i\u0011\u0001C\u0007\u000e\u0003\u0011\u0005Q&6\u0001\u0005\u0003E)A\u0001\u0001\u0005\b+\t)\u0011\u0001C\u0004\u0012\r\u0011\u0005\u0001\u0012C\u000b\u0004\u000b\t!\t\u0001\u0003\u0001\u0019+u5A\u0001\u0001E\u0013\u001b\t)\u0011\u0001#\u0005Q\u0007\u0001ij\u0001\u0002\u0001\t'5\u0011Q!\u0001E\t!\u000e\u0005Qt\u0003\u0003\u0001\u0011Wiq!B\u0001\t\u001f%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001U\u0002\u0002;C!\u0001\u0001#\u0007\u000e\u0019\u0015\t\u00012C\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001%!\u0011bA\u0003\u0003\t\u0003A\t\u0001UB\u0002;\u001b!\u0001\u0001c\n\u000e\u0005\u0015\t\u00012\u0004)\u0004\u0005\u0005\u0012Q!\u0001E\u000b#\u000eiA!F\u0005\u0002\t\u0001i\u0011\u0001C\u0006\u000e\u0003!YQ\"\u0001E\u0010\u001b\u0005AQ\"D\u0001\t\u001d56\r\u0001B\u0001\u0012\u000b\u0011\u0001\u0001bB\u000b\u0003\u000b\u0005Aq!\u0005\u0004\u0005\u0002!EQcA\u0003\u0003\t\u0003A\u0001\u0001G\f\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005A\t\u0002U\u0002\u0001;C!\u0001\u0001#\u0007\u000e\u0019\u0015\t\u00012C\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001%!\u0011bA\u0003\u0003\t\u0003A\t\u0001UB\u0001;\u001b!\u0001\u0001c\f\u000e\u0005\u0015\t\u0001B\u0003)\u0004\u0003u5A\u0001\u0001E\u000e\u001b\t)\u0011\u0001\u0003\u0006Q\u0007\u0007\t#!B\u0001\t\u0016E\u001b1\u0002B\f\n\u0003\u0011\u0001Q\"\u0001\u0005\f\u001b\u0005AQ\"D\u0001\u0005\u00025\tA\u0011AWP\u0002\u0011\u0019\u0011#\u0002\u0003\u0001\u0011\u001d)\"!B\u0001\t\u000fE1A\u0011\u0001E\t+\r)!\u0001\"\u0001\t\u0001aART\u0002\u0003\u0001\u0011ci!!B\u0001\t\"A\u001b\u0001!(\u0004\u0005\u0001!MRBA\u0003\u0002\u0011G\u00016\u0011AO\u0007\t\u0001A)$\u0004\u0002\u0006\u0003!\u0011\u0002kA\u0001\u001e\u0018\u0011\u0001\u0001rG\u0007\b\u000b\u0005A)#\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001!\u000e\r\u0011\u0005E\u0003\u0002\u0011MIQ\"\u0003\u0007\u0006\u0003!\u001d\u0012\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001\n\t%\u0019QA\u0001C\u0001\u0011\u0003\t6a\u0003\u0003\u0019\u0013\u0005AA#D\u0001\t*5\t\u0001\"F\u0007\u0002\u0011Wi\u0011\u0001\u0003\f.\u0015\u0004!1!E\u0003\u0005\u0001!9QCA\u0003\u0002\u0011\u001d\tb\u0001\"\u0001\t\u0012U\u0019QA\u0001C\u0001\u0011\u0001AZ$(\u0004\u0005\u0001!ERBA\u0003\u0002\u0011C\u00016\u0001AO\u0010\t\u0001Aa$D\u0006\u0006\u0003!I\u0011\u0002C\u0005\b\u000b\u0005Ai#\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001!\u000e\u0005QT\u0002\u0003\u0001\u0011ki!!B\u0001\t%A\u001b\u0011!\t\t\u0006\u0003!\u0019\u0012\"D\u0005\r\u000b\u0005A9#\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0005\u0011kA\u0005\u0005<%\t\u0001\u0002F\u0007\u0002\u0011Si\u0011\u0001#\u0007\u000e\u0003!-R&4\u0001\u0005\u0007E)A\u0001\u0001\u0005\b+\t)\u0011\u0001C\u0004\u0019?u5A\u0001\u0001E \u001b\t)\u0011\u0001C\fQ\u0007\u0001ij\u0001\u0002\u0001\t'5\u0011Q!\u0001E\t!\u000e\u0005Qt\u0003\u0003\u0001\u0011!iq!B\u0001\t\u0013%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001U\u0002\u0002;\u001b!\u0001\u0001c\n\u000e\u0005\u0015\t\u00012\u0004)\u0004\u0004u5A\u0001\u0001E!\u001b\t)\u0011\u0001\u0003\rQ\u0007\t\t3\"B\u0001\t\u0013%A\u0011bB\u0003\u0002\u0011[IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002A)\u0004\u001b\u0011y\u0012\"\u0001E\r\u001b\u0005A\t$D\u0001\t\u00175\t\u0001\u0012D\u0007\u0002\u00119i\u0011\u0001C\r.u\u0011\u0019\u0011#\u0002\u0003\u0001\u0011\u001d)\"!B\u0001\t\u000fa\u0011ST\u0002\u0003\u0001\u0011\u007fi!!B\u0001\t/A\u001b\u0001!h\u0006\u0005\u0001!AQbB\u0003\u0002\u0011%IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002\u0001)\u0004\u0002u5A\u0001\u0001E!\u001b\t)\u0011\u0001\u0003\rQ\u0007\u0005\t3\"B\u0001\t\u0013%A\u0011bB\u0003\u0002\u0011[IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002A)\u0004\u0013\u0011\u0011\u0013\"\u0001E\r\u001b\u0005A\t$D\u0001\t\u001a5\t\u0001\"GWW\u0002\u0011\t\u0011#\u0002\u0003\u0001\u0011\u001d)\"!B\u0001\t\u000fa\u0015St\u0003\u0003\u0001\u0011!iq!B\u0001\t\u0013%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001U\u0002\u0001;\u001b!\u0001\u0001#\n\u000e\u0005\u0015\t\u0001\u0012\u0003)\u0004\u0002u5A\u0001\u0001\u0005$\u001b\t)\u0011\u0001#\u0005Q\u0007\u0005iz\u0002\u0002\u0001\tH5YQ!\u0001E\u001a\u0013!Iq!B\u0001\t.%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001UB\u0002;\u001b!\u0001\u0001#\u0013\u000e\u0005\u0015\t\u00012\u0004)\u0004\u0005u5A\u0001\u0001E!\u001b\t)\u0011\u0001\u0003\rQ\u0007\u000b\t#!B\u0001\t\u0016E\u001bq\u0002\"\u0012\n\u0003\u0011\u0001Q\"\u0001E\r\u001b\u0005A1\"D\u0001\t\u00175\t\u0001\u0012D\u0007\u0002\u00119i\u0011\u0001C\r.\u001b\u0004!\u0011!E\u0003\u0005\u0001!9QCA\u0003\u0002\u0011\u001dA*%h\u0006\u0005\u0001!AQbB\u0003\u0002\u0011%IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002\u0001)\u0004\u0001u5A\u0001\u0001E\u0013\u001b\t)\u0011\u0001#\u0005Q\u0007\u0003ij\u0001\u0002\u0001\tG5\u0011Q!\u0001E\t!\u000e\tQT\u0002\u0003\u0001\u0011\u0013j!!B\u0001\t\u001cA\u001b\u0019!(\u0004\u0005\u0001!\u0005SBA\u0003\u0002\u0011a\u00016AA\u0011\f\u000b\u0005A\u0011\"\u0003\u0005\n\u000f\u0015\t\u0001RF\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001E\u001bQ\u0002\"\u0012\n\u0003!eQ\"\u0001E\r\u001b\u0005A1\"D\u0001\t\u00175\t\u0001BD\u0007\u0002\u0011eiK\u0004B\u0001\u0019Ku5A\u0001\u0001E&\u001b\t)\u0011\u0001c\u0007Q\u0007\u0001ij\u0001\u0002\u0001\t\u001c5\u0011Q!\u0001\u0005\u000b!\u000e\u0005\u0011EA\u0003\u0002\u00117\t6a\u0002\u0003&\u0013\u0005Aa\"D\u0001\t\u001d5\tA\u0011AW4\t\u0005\tR\u0001\u0002\u0001\t\u000fU\u0011Q!\u0001\u0005\b#\u0019!\t\u0001#\u0005\u0016\u0007\u0015\u0011A\u0011\u0001\u0005\u00011\u0019jj\u0001\u0002\u0001\tN5\u0011Q!\u0001E\t!\u000e\u0001Q\u0014\u0005\u0003\u0001\u00113iA\"B\u0001\t\u0014%!\u0011bA\u0003\u0003\t\u0003A\u0001!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001E\u0001!\u000e\u0005\u0011EA\u0003\u0002\u0011+\t6a\u0002\u0003'\u0013\u0005!\u0001!D\u0001\t\u00175\t\u0001\"DW(\t\u0005\tR\u0001\u0002\u0001\t\u000fU\u0011Q!\u0001\u0005\b1\u001djj\u0001\u0002\u0001\t@5\u0011Q!\u0001\u0005\u0018!\u000e\u0001Qt\u0003\u0003\u0001\u0011\u001fjq!B\u0001\t.%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001UB\u0001C\t)\u0011\u0001\u0003\u0006R\u0007\u001d!q%C\u0001\u0005\u00025\t\u0001\u0012G\u0007\u0002\u0011ii\u000b\u001b\u0001\u0003\u0004#\u0015!\u0001\u0001C\u0004\u0016\u0005\u0015\t\u0001b\u0002\r);?!\u0001\u0001#\u0015\u000e\u0017\u0015\t\u0001\"C\u0005\t\u0013\u001d)\u0011\u0001#\f\n\t%\u0019QA\u0001C\u0001\u0011\u0001\u00016\u0001AO\u0007\t\u0001A\u0011&\u0004\u0002\u0006\u0003!U\u0002k!\u0001\u001e \u0011\u0001\u0001BK\u0007\f\u000b\u0005A\u0019$\u0003\u0005\n\u000f\u0015\t\u0001RF\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001A\u001b\u0011!h\b\u0005\u0001!USbC\u0003\u0002\u0011gI\u0001\"C\u0004\u0006\u0003!5\u0012\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001Q\u0007\u0007\t#!B\u0001\t\u0016E\u001b1\u0002\u0002\u0015\n\u0003\u0011\u0001Q\"\u0001E\r\u001b\u0005A1$D\u0001\t\u001a5\t\u0001\u0012D[\u0015\u000bO!1\u001d\u0001\r\u0006;\u001b!\u0001\u0001c\u0003\u000e\u0005\u0015\t\u00012\u0002)\u0004\u0001\u0005\u0012Q!\u0001E\u0004#\u000e)A!B\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0004"})
public final class TaskPrioritizer
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    private final StorageManager storageManager;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(TaskPrioritizer.class);
    }

    public final <D extends CallableDescriptor> void splitLexicallyLocalDescriptors(@JetValueParameter(name="allDescriptors") @NotNull Collection<? extends ResolutionCandidate<D>> allDescriptors2, @JetValueParameter(name="containerOfTheCurrentLocality") @NotNull DeclarationDescriptor containerOfTheCurrentLocality, @JetValueParameter(name="local") @NotNull Collection<ResolutionCandidate<D>> local, @JetValueParameter(name="nonlocal") @NotNull Collection<ResolutionCandidate<D>> nonlocal) {
        if (allDescriptors2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDescriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "splitLexicallyLocalDescriptors"));
        }
        if (containerOfTheCurrentLocality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerOfTheCurrentLocality", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "splitLexicallyLocalDescriptors"));
        }
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "splitLexicallyLocalDescriptors"));
        }
        if (nonlocal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonlocal", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "splitLexicallyLocalDescriptors"));
        }
        Intrinsics.checkParameterIsNotNull(allDescriptors2, "allDescriptors");
        Intrinsics.checkParameterIsNotNull(containerOfTheCurrentLocality, "containerOfTheCurrentLocality");
        Intrinsics.checkParameterIsNotNull(local, "local");
        Intrinsics.checkParameterIsNotNull(nonlocal, "nonlocal");
        for (ResolutionCandidate<D> resolvedCall : allDescriptors2) {
            if (ExpressionTypingUtils.isLocal(containerOfTheCurrentLocality, (DeclarationDescriptor)resolvedCall.getDescriptor())) {
                local.add(resolvedCall);
                continue;
            }
            nonlocal.add(resolvedCall);
        }
    }

    @NotNull
    public final <D extends CallableDescriptor, F extends D> List<ResolutionTask<D, F>> computePrioritizedTasks(@JetValueParameter(name="context") @NotNull BasicCallResolutionContext context2, @JetValueParameter(name="name") @NotNull Name name, @JetValueParameter(name="tracing") @NotNull TracingStrategy tracing, @JetValueParameter(name="callableDescriptorCollectors") @NotNull CallableDescriptorCollectors<D> callableDescriptorCollectors) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasks"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasks"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasks"));
        }
        if (callableDescriptorCollectors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptorCollectors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasks"));
        }
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(tracing, "tracing");
        Intrinsics.checkParameterIsNotNull(callableDescriptorCollectors, "callableDescriptorCollectors");
        ReceiverValue explicitReceiver = ((CallResolutionContext)context2).call.getExplicitReceiver();
        ResolutionTaskHolder result2 = new ResolutionTaskHolder(this.storageManager, context2, new PriorityProviderImpl(context2), tracing);
        JetScope jetScope = ((ResolutionContext)context2).scope;
        Intrinsics.checkExpressionValueIsNotNull(jetScope, "context.scope");
        TaskPrioritizerContext taskPrioritizerContext = new TaskPrioritizerContext(name, result2, context2, jetScope, callableDescriptorCollectors);
        if (explicitReceiver instanceof QualifierReceiver) {
            QualifierReceiver qualifierReceiver = (QualifierReceiver)explicitReceiver;
            ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "NO_RECEIVER");
            this.doComputeTasks(receiverValue, taskPrioritizerContext.replaceScope(qualifierReceiver.getNestedClassesAndPackageMembersScope()));
            ReceiverValue classObjectReceiver = qualifierReceiver.getClassObjectReceiver();
            if (classObjectReceiver.exists()) {
                this.doComputeTasks(classObjectReceiver, taskPrioritizerContext);
            }
        } else {
            ReceiverValue receiverValue = explicitReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "explicitReceiver");
            this.doComputeTasks(receiverValue, taskPrioritizerContext);
        }
        List list = result2.getTasks();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasks"));
        }
        return list;
    }

    private final <D extends CallableDescriptor, F extends D> void doComputeTasks(@JetValueParameter(name="receiver") ReceiverValue receiver, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c) {
        ProgressIndicatorProvider.checkCanceled();
        boolean resolveInvoke = ((CallResolutionContext)c.getContext()).call.getDispatchReceiver().exists();
        if (resolveInvoke) {
            this.addCandidatesForInvoke(receiver, c);
            return;
        }
        LinkedHashSet implicitReceivers = Sets.newLinkedHashSet((Iterable)JetScopeUtils.getImplicitReceiversHierarchyValues(c.getScope()));
        if (receiver.exists()) {
            Collection collection = implicitReceivers;
            Intrinsics.checkExpressionValueIsNotNull(collection, "implicitReceivers");
            this.addCandidatesForExplicitReceiver(receiver, collection, c, true);
            this.addMembers(receiver, c, true, true);
            return;
        }
        Collection collection = implicitReceivers;
        Intrinsics.checkExpressionValueIsNotNull(collection, "implicitReceivers");
        this.addCandidatesForNoReceiver(collection, c);
    }

    private final <D extends CallableDescriptor, F extends D> void addCandidatesForExplicitReceiver(@JetValueParameter(name="explicitReceiver") ReceiverValue explicitReceiver, @JetValueParameter(name="implicitReceivers") Collection<? extends ReceiverValue> implicitReceivers, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c, @JetValueParameter(name="isExplicit") boolean isExplicit) {
        this.addMembers(explicitReceiver, c, false, isExplicit);
        if (TypesPackage$dynamicTypes$b6f342e3.isDynamic(explicitReceiver.getType())) {
            this.addCandidatesForDynamicReceiver(explicitReceiver, implicitReceivers, c, isExplicit);
        } else {
            this.addExtensionCandidates(explicitReceiver, implicitReceivers, c, isExplicit);
        }
    }

    private final <D extends CallableDescriptor, F extends D> void addExtensionCandidates(@JetValueParameter(name="explicitReceiver") ReceiverValue explicitReceiver, @JetValueParameter(name="implicitReceivers") Collection<? extends ReceiverValue> implicitReceivers, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c, @JetValueParameter(name="isExplicit") boolean isExplicit) {
        for (CallableDescriptorCollector<D> callableDescriptorCollector : c.getCallableDescriptorCollectors()) {
            for (ReceiverValue receiverValue : implicitReceivers) {
                this.addMemberExtensionCandidates(receiverValue, explicitReceiver, callableDescriptorCollector, c, this.createKind(ExplicitReceiverKind.EXTENSION_RECEIVER, isExplicit));
            }
            c.getResult().addCandidates(new TaskPrioritizer$addExtensionCandidates$1(this, c, explicitReceiver, callableDescriptorCollector, isExplicit));
        }
    }

    private final <D extends CallableDescriptor, F extends D> void addMembers(@JetValueParameter(name="explicitReceiver") ReceiverValue explicitReceiver, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c, @JetValueParameter(name="staticMembers") boolean staticMembers, @JetValueParameter(name="isExplicit") boolean isExplicit) {
        for (CallableDescriptorCollector<D> callableDescriptorCollector : c.getCallableDescriptorCollectors()) {
            c.getResult().addCandidates(new TaskPrioritizer$addMembers$1(this, explicitReceiver, c, staticMembers, callableDescriptorCollector, isExplicit));
        }
    }

    private final <D extends CallableDescriptor, F extends D> void addCandidatesForDynamicReceiver(@JetValueParameter(name="explicitReceiver") ReceiverValue explicitReceiver, @JetValueParameter(name="implicitReceivers") Collection<? extends ReceiverValue> implicitReceivers, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c, @JetValueParameter(name="isExplicit") boolean isExplicit) {
        TaskPrioritizerContext<D, F> onlyDynamicReceivers = c.replaceCollectors(TasksPackage$dynamicCalls$cd034e6b.onlyDynamicReceivers(c.getCallableDescriptorCollectors()));
        this.addExtensionCandidates(explicitReceiver, implicitReceivers, onlyDynamicReceivers, isExplicit);
        c.getResult().addCandidates(new TaskPrioritizer$addCandidatesForDynamicReceiver$1(this, c, explicitReceiver, isExplicit));
    }

    private final ExplicitReceiverKind createKind(@JetValueParameter(name="kind") ExplicitReceiverKind kind, @JetValueParameter(name="isExplicit") boolean isExplicit) {
        if (isExplicit) {
            return kind;
        }
        return ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
    }

    private final <D extends CallableDescriptor, F extends D> void addMemberExtensionCandidates(@JetValueParameter(name="dispatchReceiver") ReceiverValue dispatchReceiver, @JetValueParameter(name="receiverParameter") ReceiverValue receiverParameter, @JetValueParameter(name="callableDescriptorCollector") CallableDescriptorCollector<D> callableDescriptorCollector, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c, @JetValueParameter(name="receiverKind") ExplicitReceiverKind receiverKind) {
        c.getResult().addCandidates(new TaskPrioritizer$addMemberExtensionCandidates$1(this, callableDescriptorCollector, dispatchReceiver, c, receiverParameter, receiverKind));
    }

    private final <D extends CallableDescriptor, F extends D> void addCandidatesForNoReceiver(@JetValueParameter(name="implicitReceivers") Collection<? extends ReceiverValue> implicitReceivers, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c) {
        ArrayList localsList = Lists.newArrayList();
        ArrayList nonlocalsList = Lists.newArrayList();
        for (CallableDescriptorCollector<D> callableDescriptorCollector : c.getCallableDescriptorCollectors()) {
            JetScope jetScope = c.getScope();
            JetScope jetScope2 = c.getScope();
            Name name = c.getName();
            BindingTrace bindingTrace = ((ResolutionContext)c.getContext()).trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.context.trace");
            Collection<D> collection = callableDescriptorCollector.getNonExtensionsByName(jetScope2, name, bindingTrace);
            Call call = ((CallResolutionContext)c.getContext()).call;
            Intrinsics.checkExpressionValueIsNotNull(call, "c.context.call");
            Collection<ResolutionCandidate<D>> members = this.convertWithImpliedThisAndNoReceiver(jetScope, collection, call);
            ArrayList nonlocals = Lists.newArrayList();
            ArrayList locals = Lists.newArrayList();
            DeclarationDescriptor declarationDescriptor = c.getScope().getContainingDeclaration();
            Collection collection2 = locals;
            Intrinsics.checkExpressionValueIsNotNull(collection2, "locals");
            Collection collection3 = nonlocals;
            Intrinsics.checkExpressionValueIsNotNull(collection3, "nonlocals");
            this.splitLexicallyLocalDescriptors(members, declarationDescriptor, collection2, collection3);
            localsList.add(locals);
            nonlocalsList.add(nonlocals);
        }
        ResolutionTaskHolder<D, F> resolutionTaskHolder = c.getResult();
        List list = localsList;
        Intrinsics.checkExpressionValueIsNotNull(list, "localsList");
        resolutionTaskHolder.addCandidates(list);
        for (ReceiverValue receiverValue : implicitReceivers) {
            this.addCandidatesForExplicitReceiver(receiverValue, implicitReceivers, c, false);
        }
        ResolutionTaskHolder<D, F> resolutionTaskHolder2 = c.getResult();
        List list2 = nonlocalsList;
        Intrinsics.checkExpressionValueIsNotNull(list2, "nonlocalsList");
        resolutionTaskHolder2.addCandidates(list2);
        for (ReceiverValue receiverValue : implicitReceivers) {
            this.addMembers(receiverValue, c, true, false);
        }
    }

    private final <D extends CallableDescriptor, F extends D> void addCandidatesForInvoke(@JetValueParameter(name="explicitReceiver") ReceiverValue explicitReceiver, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c) {
        List<ReceiverValue> implicitReceivers = JetScopeUtils.getImplicitReceiversHierarchyValues(c.getScope());
        ReceiverValue variableReceiver = ((CallResolutionContext)c.getContext()).call.getDispatchReceiver();
        KotlinPackage.assert(variableReceiver.exists(), "'Invoke' call hasn't got variable receiver");
        if (!explicitReceiver.exists()) {
            ReceiverValue receiverValue = variableReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "variableReceiver");
            Collection collection = implicitReceivers;
            Intrinsics.checkExpressionValueIsNotNull(collection, "implicitReceivers");
            this.addCandidatesForExplicitReceiver(receiverValue, collection, c, true);
        }
        if (explicitReceiver.exists()) {
            ReceiverValue receiverValue = variableReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "variableReceiver");
            this.addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver(receiverValue, explicitReceiver, c, ExplicitReceiverKind.BOTH_RECEIVERS);
            return;
        }
        for (ReceiverValue implicitReceiver : implicitReceivers) {
            ReceiverValue receiverValue = variableReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "variableReceiver");
            ReceiverValue receiverValue2 = implicitReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "implicitReceiver");
            this.addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver(receiverValue, receiverValue2, c, ExplicitReceiverKind.DISPATCH_RECEIVER);
        }
    }

    private final <D extends CallableDescriptor, F extends D> void addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver(@JetValueParameter(name="dispatchReceiver") ReceiverValue dispatchReceiver, @JetValueParameter(name="receiverParameter") ReceiverValue receiverParameter, @JetValueParameter(name="c") TaskPrioritizerContext<D, F> c, @JetValueParameter(name="receiverKind") ExplicitReceiverKind receiverKind) {
        for (CallableDescriptorCollector<D> callableDescriptorCollector : c.getCallableDescriptorCollectors()) {
            this.addMemberExtensionCandidates(dispatchReceiver, receiverParameter, callableDescriptorCollector, c, receiverKind);
        }
    }

    private final <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithReceivers(@JetValueParameter(name="descriptors") Collection<? extends D> descriptors, @JetValueParameter(name="dispatchReceiver") ReceiverValue dispatchReceiver, @JetValueParameter(name="extensionReceiver") ReceiverValue extensionReceiver2, @JetValueParameter(name="explicitReceiverKind") ExplicitReceiverKind explicitReceiverKind, @JetValueParameter(name="call") Call call) {
        ArrayList result2 = Lists.newArrayList();
        Collection collection = result2;
        Intrinsics.checkExpressionValueIsNotNull(collection, "result");
        this.convertWithReceivers(descriptors, dispatchReceiver, extensionReceiver2, collection, explicitReceiverKind, call);
        Collection collection2 = result2;
        Intrinsics.checkExpressionValueIsNotNull(collection2, "result");
        return collection2;
    }

    private final <D extends CallableDescriptor> void convertWithReceivers(@JetValueParameter(name="descriptors") Collection<? extends D> descriptors, @JetValueParameter(name="dispatchReceiver") ReceiverValue dispatchReceiver, @JetValueParameter(name="extensionReceiver") ReceiverValue extensionReceiver2, @JetValueParameter(name="result") Collection<ResolutionCandidate<D>> result2, @JetValueParameter(name="explicitReceiverKind") ExplicitReceiverKind explicitReceiverKind, @JetValueParameter(name="call") Call call) {
        for (CallableDescriptor descriptor : descriptors) {
            ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(call, descriptor);
            candidate.setDispatchReceiver(dispatchReceiver);
            candidate.setExtensionReceiver(extensionReceiver2);
            candidate.setExplicitReceiverKind(explicitReceiverKind);
            ResolutionCandidate<CallableDescriptor> resolutionCandidate = candidate;
            Intrinsics.checkExpressionValueIsNotNull(resolutionCandidate, "candidate");
            result2.add(resolutionCandidate);
        }
    }

    @NotNull
    public final <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithImpliedThisAndNoReceiver(@JetValueParameter(name="scope") @NotNull JetScope scope2, @JetValueParameter(name="descriptors") @NotNull Collection<? extends D> descriptors, @JetValueParameter(name="call") @NotNull Call call) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThisAndNoReceiver"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThisAndNoReceiver"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThisAndNoReceiver"));
        }
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        Intrinsics.checkParameterIsNotNull(call, "call");
        ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "NO_RECEIVER");
        Collection<ResolutionCandidate<D>> collection = this.convertWithImpliedThis(scope2, receiverValue, descriptors, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, call);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThisAndNoReceiver"));
        }
        return collection;
    }

    @NotNull
    public final <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithImpliedThis(@JetValueParameter(name="scope") @NotNull JetScope scope2, @JetValueParameter(name="receiverParameter") @NotNull ReceiverValue receiverParameter, @JetValueParameter(name="descriptors") @NotNull Collection<? extends D> descriptors, @JetValueParameter(name="receiverKind") @NotNull ExplicitReceiverKind receiverKind, @JetValueParameter(name="call") @NotNull Call call) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThis"));
        }
        if (receiverParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameter", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThis"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThis"));
        }
        if (receiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverKind", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThis"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThis"));
        }
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(receiverParameter, "receiverParameter");
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        Intrinsics.checkParameterIsNotNull((Object)receiverKind, "receiverKind");
        Intrinsics.checkParameterIsNotNull(call, "call");
        ArrayList<ResolutionCandidate<CallableDescriptor>> result2 = Lists.newArrayList();
        for (CallableDescriptor descriptor : descriptors) {
            ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(call, descriptor);
            candidate.setExtensionReceiver(receiverParameter);
            candidate.setExplicitReceiverKind(receiverKind);
            ResolutionCandidate<CallableDescriptor> resolutionCandidate = candidate;
            Intrinsics.checkExpressionValueIsNotNull(resolutionCandidate, "candidate");
            if (!this.setImpliedThis(scope2, resolutionCandidate)) continue;
            result2.add(candidate);
        }
        Collection collection = result2;
        Intrinsics.checkExpressionValueIsNotNull(collection, "result");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithImpliedThis"));
        }
        return collection;
    }

    private final <D extends CallableDescriptor> boolean setImpliedThis(@JetValueParameter(name="scope") JetScope scope2, @JetValueParameter(name="candidate") ResolutionCandidate<D> candidate) {
        ReceiverParameterDescriptor dispatchReceiver = candidate.getDescriptor().getDispatchReceiverParameter();
        if (dispatchReceiver == null) {
            return true;
        }
        List<ReceiverParameterDescriptor> receivers = scope2.getImplicitReceiversHierarchy();
        for (ReceiverParameterDescriptor receiver : receivers) {
            if (!JetTypeChecker.DEFAULT.isSubtypeOf(receiver.getType(), dispatchReceiver.getType())) continue;
            candidate.setDispatchReceiver(dispatchReceiver.getValue());
            return true;
        }
        return false;
    }

    @NotNull
    public final <D extends CallableDescriptor, F extends D> List<ResolutionTask<D, F>> computePrioritizedTasksFromCandidates(@JetValueParameter(name="context") @NotNull BasicCallResolutionContext context2, @JetValueParameter(name="candidates") @NotNull Collection<? extends ResolutionCandidate<D>> candidates, @JetValueParameter(name="tracing") @NotNull TracingStrategy tracing) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasksFromCandidates"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasksFromCandidates"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasksFromCandidates"));
        }
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(candidates, "candidates");
        Intrinsics.checkParameterIsNotNull(tracing, "tracing");
        ResolutionTaskHolder result2 = new ResolutionTaskHolder(this.storageManager, context2, new PriorityProviderImpl(context2), tracing);
        result2.addCandidates(new TaskPrioritizer$computePrioritizedTasksFromCandidates$1(candidates));
        List list = result2.getTasks();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "computePrioritizedTasksFromCandidates"));
        }
        return list;
    }

    public TaskPrioritizer(@JetValueParameter(name="storageManager") @NotNull StorageManager storageManager) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "<init>"));
        }
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        this.storageManager = storageManager;
    }

    @NotNull
    public static final /* synthetic */ ExplicitReceiverKind createKind$b$0(@JetValueParameter(name="$this", type="?") TaskPrioritizer $this, @JetValueParameter(name="kind") @NotNull ExplicitReceiverKind kind, @JetValueParameter(name="isExplicit") boolean isExplicit) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "createKind$b$0"));
        }
        ExplicitReceiverKind explicitReceiverKind = $this.createKind(kind, isExplicit);
        if (explicitReceiverKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "createKind$b$0"));
        }
        return explicitReceiverKind;
    }

    public static final /* synthetic */ <D extends CallableDescriptor> void convertWithReceivers$b$1(@JetValueParameter(name="$this", type="?") TaskPrioritizer $this, @JetValueParameter(name="descriptors") @NotNull Collection<? extends D> descriptors, @JetValueParameter(name="dispatchReceiver") @NotNull ReceiverValue dispatchReceiver, @JetValueParameter(name="extensionReceiver") @NotNull ReceiverValue extensionReceiver2, @JetValueParameter(name="result") @NotNull Collection<ResolutionCandidate<D>> result2, @JetValueParameter(name="explicitReceiverKind") @NotNull ExplicitReceiverKind explicitReceiverKind, @JetValueParameter(name="call") @NotNull Call call) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers$b$1"));
        }
        if (dispatchReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatchReceiver", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers$b$1"));
        }
        if (extensionReceiver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionReceiver", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers$b$1"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers$b$1"));
        }
        if (explicitReceiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers$b$1"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers$b$1"));
        }
        $this.convertWithReceivers(descriptors, dispatchReceiver, extensionReceiver2, result2, explicitReceiverKind, call);
    }

    @NotNull
    public static final /* synthetic */ <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithReceivers$b$2(@JetValueParameter(name="$this", type="?") TaskPrioritizer $this, @JetValueParameter(name="descriptors") @NotNull Collection<? extends D> descriptors, @JetValueParameter(name="dispatchReceiver") @NotNull ReceiverValue dispatchReceiver, @JetValueParameter(name="extensionReceiver") @NotNull ReceiverValue extensionReceiver2, @JetValueParameter(name="explicitReceiverKind") @NotNull ExplicitReceiverKind explicitReceiverKind, @JetValueParameter(name="call") @NotNull Call call) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers$b$2"));
        }
        if (dispatchReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatchReceiver", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers$b$2"));
        }
        if (extensionReceiver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionReceiver", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers$b$2"));
        }
        if (explicitReceiverKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiverKind", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers$b$2"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers$b$2"));
        }
        Collection<ResolutionCandidate<D>> collection = $this.convertWithReceivers(descriptors, dispatchReceiver, extensionReceiver2, explicitReceiverKind, call);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer", "convertWithReceivers$b$2"));
        }
        return collection;
    }

    @KotlinClass(abiVersion=19, data={"\\\u0006)!\u0002K]5pe&$\u0018\u0010\u0015:pm&$WM]%na2Tq\u0002V1tWB\u0013\u0018n\u001c:ji&TXM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\rQW\r\u001e\u0006\u0005Y\u0006twMC\u0004sKN|GN^3\u000b\u000b\r\fG\u000e\\:\u000b\u000bQ\f7o[:\u000b\u0003\u0011S!cQ1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*YA-Z:de&\u0004Ho\u001c:t\u0015A\u0001&/[8sSRL\bK]8wS\u0012,'O\u0003\u000bSKN|G.\u001e;j_:$\u0016m]6I_2$WM\u001d\u0006\u0014%\u0016\u001cx\u000e\\;uS>t7)\u00198eS\u0012\fG/\u001a\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000f\r|g\u000e^3yi*Q\")Y:jG\u000e\u000bG\u000e\u001c*fg>dW\u000f^5p]\u000e{g\u000e^3yi*qq-\u001a;NCb\u0004&/[8sSRL(bA%oi*11n\u001c;mS:T1bZ3u!JLwN]5us*I1-\u00198eS\u0012\fG/\u001a\u0006\u001bQ\u0006\u001c\u0018*\u001c9mS\u000eLG\u000fR=oC6L7MU3dK&4XM\u001d\u0006\b\u0005>|G.Z1o\u00155I7oU=oi\",7/\u001b>fI*I\u0011n\u001d,jg&\u0014G.\u001aG\u0002\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)!\u0001b\u0001\t\u0007\u0015\u0011AA\u0001E\u0004\u000b\t!)\u0001\u0003\u0003\u0006\u0007\u0011\u0019\u0001\u0012\u0001\u0007\u0001\u000b\r!9\u0001\u0003\u0001\r\u0001\u0015\u0011A1\u0001E\u0006\u000b\r!I\u0001C\u0003\r\u0001\u0015\u0019Aa\u0001E\u0007\u0019\u0001)1\u0001b\u0003\t\r1\u0001Qa\u0001\u0003\u0004\u0011\u001da\u0001!\u0002\u0002\u0005\u0006!AQa\u0001\u0003\b\u0011#a\u0001!\u0002\u0002\u0005\u000f!EQ!\u0001\u0005\u000b\u000b\r!\t\u0002c\u0005\r\u0001\u0015\u0011Aa\u0001\u0005\b\u000b\r!\t\u0002\u0003\u0007\r\u0001\u0011\tA\u0002B\u000b\u0006\t\u0001AI!\u0006\u0002\u0006\u0003!)\u0011dC\u0003\u0002\u0011\u0019I\u0001\"C\u0004\u0006\u0003!5\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001\u0003\u0001.\u0017\u0011\tG\u0001\u0007\u0005\"\u0005\u0015\t\u0001rB+\u0004\t\u0015\u0019A\u0001C\u0005\u0002\u0011!i\u001b\u0002B\u0006\u0019\u0013\u0005\u0012Q!\u0001\u0005\n#\u000e\u0019A!C\u0005\u0002\t\u000bi\u0003\u0004B\u0006\u0019\u0016u]A\u0001\u0001\u0005\f\u001b\u001d)\u0011\u0001#\u0004\n\t%\u0019QA\u0001C\u0001\u0011\u0001\u00016\u0001A\u0011\u0003\u000b\u0005A\u0011\"U\u0002\u0006\t+I\u0011\u0001\"\u0002\u000e\u0003!MQ\u0006\u0007\u0003\u00011/i:\u0002\u0002\u0001\t\u001759Q!\u0001E\u0007\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0001k\u0001\u0001\"\u0005\u0015\t\u0001BC)\u0004\u000b\u0011]\u0011\"\u0001C\u0001\u001b\u0005A\u0019\"\f\r\u0005\u0003aeQt\u0003\u0003\u0001\u0011-iq!B\u0001\t\u000e%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001U\u0002\u0001C\t)\u0011\u0001\u0003\u0006R\u0007\u0015!I\"C\u0001\u0005\u00025\t\u00012C\u0017\u001a\t\u0005AR\"(\u0007\u0005\u0001!YQ\u0002C\u0003\u0002\u0011\u001bIA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002\u0001G\u0001!\u000e\u0001\u0011EA\u0003\u0002\u0011)\t6!\u0002\u0003\u000e\u0013\u0005!\t!D\u0001\t\u0014U~RQ\b\u0003d\u0002E)A\u0001\u0001E\u0005+\t)\u0011\u0001C\u0003\u0019\u0010u5A\u0001\u0001\u0005\t\u001b\t)\u0011\u0001c\u0004Q\u0007\u0001\ts!B\u0001\t\t%!\u0011bA\u0003\u0003\t\u0003A\u0001!U\u0002\u0006\t\u001fI\u0011\u0001\u0002\u0001\u000e\u0003!A\u0001"})
    private static final class PriorityProviderImpl<D extends CallableDescriptor>
    implements KObject,
    ResolutionTaskHolder.PriorityProvider<ResolutionCandidate<D>> {
        public static final /* synthetic */ KClassImpl $kotlinClass;
        private final BasicCallResolutionContext context;

        static {
            $kotlinClass = InternalPackage.kClassFromKotlin(PriorityProviderImpl.class);
        }

        @Override
        public int getPriority(@JetValueParameter(name="candidate") @NotNull ResolutionCandidate<D> candidate) {
            if (candidate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$PriorityProviderImpl", "getPriority"));
            }
            Intrinsics.checkParameterIsNotNull(candidate, "candidate");
            return this.hasImplicitDynamicReceiver(candidate) ? 0 : (this.isVisible(candidate) ? 2 : 0) + (this.isSynthesized(candidate) ? 0 : 1);
        }

        @Override
        public int getMaxPriority() {
            return 3;
        }

        private final boolean isVisible(@JetValueParameter(name="candidate", type="?") ResolutionCandidate<D> candidate) {
            if (candidate == null) {
                return false;
            }
            D candidateDescriptor = candidate.getDescriptor();
            if (ErrorUtils.isError((DeclarationDescriptor)candidateDescriptor)) {
                return true;
            }
            ReceiverValue receiverValue = ExpressionTypingUtils.normalizeReceiverValueForVisibility(candidate.getDispatchReceiver(), ((ResolutionContext)this.context).trace.getBindingContext());
            return Visibilities.isVisible(receiverValue, (DeclarationDescriptorWithVisibility)candidateDescriptor, ((ResolutionContext)this.context).scope.getContainingDeclaration());
        }

        private final boolean isSynthesized(@JetValueParameter(name="candidate") ResolutionCandidate<D> candidate) {
            D descriptor = candidate.getDescriptor();
            return descriptor instanceof CallableMemberDescriptor ? CallResolverUtil.isOrOverridesSynthesized((CallableMemberDescriptor)descriptor) : false;
        }

        public final boolean hasImplicitDynamicReceiver(@JetValueParameter(name="candidate") @NotNull ResolutionCandidate<D> candidate) {
            if (candidate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$PriorityProviderImpl", "hasImplicitDynamicReceiver"));
            }
            Intrinsics.checkParameterIsNotNull(candidate, "candidate");
            return (!(!candidate.getExplicitReceiverKind().isDispatchReceiver()) ? !candidate.getCall().getExplicitReceiver().exists() : true) ? TasksPackage$dynamicCalls$cd034e6b.isDynamic((DeclarationDescriptor)candidate.getDescriptor()) : false;
        }

        public PriorityProviderImpl(@JetValueParameter(name="context") @NotNull BasicCallResolutionContext context2) {
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$PriorityProviderImpl", "<init>"));
            }
            Intrinsics.checkParameterIsNotNull(context2, "context");
            this.context = context2;
        }
    }

    @KotlinClass(abiVersion=19, data={"u\b)1B+Y:l!JLwN]5uSj,'oQ8oi\u0016DHOC\bUCN\\\u0007K]5pe&$\u0018N_3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NT1A[3u\u0015\u0011a\u0017M\\4\u000b\u000fI,7o\u001c7wK*)1-\u00197mg*)A/Y:lg*\tAI\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNT\u0011A\u0012\u0006\u0004\u0003:L(BB6pi2LgN\u0003\u0004=S:LGO\u0010\u0006\u0005]\u0006lWM\u0003\u0003OC6,'B\u0002:fgVdGO\u0003\u000bSKN|G.\u001e;j_:$\u0016m]6I_2$WM\u001d\u0006\bG>tG/\u001a=u\u0015i\u0011\u0015m]5d\u0007\u0006dGNU3t_2,H/[8o\u0007>tG/\u001a=u\u0015\u0015\u00198m\u001c9f\u0015!QU\r^*d_B,'BB:d_B,7O\u0003\u000fdC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u00148i\u001c7mK\u000e$xN]:\u000b9\r\u000bG\u000e\\1cY\u0016$Um]2sSB$xN]\"pY2,7\r^8sg*Q1m\u001c7mK\u000e$xN]:\u000b?\u001d,GoQ1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe\u000e{G\u000e\\3di>\u00148O\u0003\u0006hKR\u001cuN\u001c;fqRTqaZ3u\u001d\u0006lWMC\u0005hKR\u0014Vm];mi*Aq-\u001a;TG>\u0004XMC\tsKBd\u0017mY3D_2dWm\u0019;peNTQB\\3x\u0007>dG.Z2u_J\u001c(B\n+bg.\u0004&/[8sSRL'0\u001a:%)\u0006\u001c8\u000e\u0015:j_JLG/\u001b>fe\u000e{g\u000e^3yi*a!/\u001a9mC\u000e,7kY8qK*Aa.Z<TG>\u0004XMn\u0001\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0011A1\u0001\u0005\u0004\u000b\t!!\u0001c\u0002\u0006\u0005\u0011\u0015\u0001\u0002B\u0003\u0004\t\rA\t\u0001\u0004\u0001\u0006\u0007\u0011\u001d\u0001\u0002\u0001\u0007\u0001\u000b\t!\u0019\u0001c\u0003\u0006\u0007\u0011%\u0001\"\u0002\u0007\u0001\u000b\u0005Aq!B\u0002\u0005\f!5A\u0002A\u0003\u0003\t\tA\u0001\"B\u0002\u0005\u000e!EA\u0002A\u0003\u0004\t\rA\u0019\u0002\u0004\u0001\u0006\u0005\u0011\u0015\u0001BC\u0003\u0004\t!A)\u0002\u0004\u0001\u0006\u0005\u0011\u0011\u0001\u0002D\u0003\u0004\t%A9\u0002\u0004\u0001\u0006\u0005\u0011\u0019\u00012D\u0003\u0004\t)AQ\u0002\u0004\u0001\u0006\u0005\u00115\u0001\u0012C\u0003\u0003\t\rA\u0019\"\u0002\u0002\u0005\u0011!UQA\u0001\u0003\n\u0011/)!\u0001\u0002\u0006\t\u001b\u0015\u0011Aa\u0001E\u0012\t\u0005aA!F\u0003\u0005\u0001!%QCA\u0003\u0002\u0011\u0015)b\u0001\"\u0001\t\rU\u0019QA\u0001C\u0001\u0011\u0001I\"!B\u0001\t\r5\"B\u0001\u0019\u0003\u0019\u001a\u0005:Q!\u0001E\u000b\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001Qk\u0001\u0005\u0006\u0007\u0011e\u0011\"\u0001\u0005\u000e\u001b\r!a\"C\u0001\t\u001b5zA\u0001\u0019\u0003\u0019\u0015\u0005\u0012Q!\u0001E\t+\u000eAQa\u0001\u0003\u000b\u0013\u0005AA\"D\u0002\u0005\u001e%\t\u0001\u0002D\u0017\u0010\t\u0001$\u0001\u0004C\u0011\u0003\u000b\u0005Aq!V\u0002\t\u000b\r!\u0001\"C\u0001\t\u00175\u0019AaD\u0005\u0002\u0011-i\u0013\u0004\u00021\u00051%\tC\"B\u0001\t\u0010%!\u0011bA\u0003\u0003\t\u0003A\u0001!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001E\u0001+\u000eAQa\u0001\u0003\n\u0013\u0005A9\"D\u0002\u0005 %\t\u0001rC\u0017\u0010\t\u0001$\u0001dC\u0011\u0003\u000b\u0005A\u0019\"V\u0002\t\u000b\r!1\"C\u0001\t\u001a5\u0019A\u0001E\u0005\u0002\u00113i#\u0005\u0002\u0001\u0019\"u]A\u0001\u0001\u0005\u0012\u001b\u001d)\u0011\u0001#\u0006\n\t%\u0019QA\u0001C\u0001\u0011\u0001\u00016\u0001A\u0011\r\u000b\u0005AA!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0005\u0011kA\u0003\u0005\"%\t\u00012D\u0007\u0002\u00115iS\u0004\u0002\u0001\u0019%u5A\u0001\u0001E\u0013\u001b\t)\u0011\u0001c\u0005Q\u0007\u0001\tC\"B\u0001\t\t%!\u0011bA\u0003\u0003\t\u0003A\u0001!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001E\u0001#\u000e)AAE\u0005\u0002\u00117i\u0011\u0001#\u00076C\u0004)y\u001c\u0001\u0003d\u0002E)A\u0001\u0001E\u0005+\t)\u0011\u0001C\u0003\u0012\r\u0011\u0005\u0001BB\u000b\u0004\u000b\t!\t\u0001\u0003\u0001\u0019\u0010u5A\u0001\u0001\u0005\t\u001b\t)\u0011\u0001C\u0004Q\u0007\u0001i\n\u0003\u0002\u0001\t\u00135aQ!\u0001E\b\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001#\u0001Q\u0007\u0003ij\u0001\u0002\u0001\t\u00155\u0011Q!\u0001E\t!\u000e\tQT\u0002\u0003\u0001\u0011-i!!B\u0001\t\u0014A\u001b\u0019!h\u0006\u0005\u0001!eQbB\u0003\u0002\u0011+IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002\u0001)\u0004\u0005\u0005bQ!\u0001\u0005\u0005\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001#\u0001R\u00075!y!C\u0001\u0005\u00015\t\u0001bC\u0007\u0002\u0011/i\u0011\u0001\u0003\u0007\u000e\u0003!eQ\"\u0001\u0005\u000e"})
    private static final class TaskPrioritizerContext<D extends CallableDescriptor, F extends D>
    implements KObject {
        public static final /* synthetic */ KClassImpl $kotlinClass;
        @NotNull
        private final Name name;
        @NotNull
        private final ResolutionTaskHolder<D, F> result;
        @NotNull
        private final BasicCallResolutionContext context;
        @NotNull
        private final JetScope scope;
        @NotNull
        private final CallableDescriptorCollectors<D> callableDescriptorCollectors;

        static {
            $kotlinClass = InternalPackage.kClassFromKotlin(TaskPrioritizerContext.class);
        }

        @NotNull
        public final TaskPrioritizerContext<D, F> replaceScope(@JetValueParameter(name="newScope") @NotNull JetScope newScope) {
            if (newScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newScope", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "replaceScope"));
            }
            Intrinsics.checkParameterIsNotNull(newScope, "newScope");
            TaskPrioritizerContext<D, F> taskPrioritizerContext = new TaskPrioritizerContext<D, F>(this.name, this.result, this.context, newScope, this.callableDescriptorCollectors);
            if (taskPrioritizerContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "replaceScope"));
            }
            return taskPrioritizerContext;
        }

        @NotNull
        public final TaskPrioritizerContext<D, F> replaceCollectors(@JetValueParameter(name="newCollectors") @NotNull CallableDescriptorCollectors<D> newCollectors) {
            if (newCollectors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newCollectors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "replaceCollectors"));
            }
            Intrinsics.checkParameterIsNotNull(newCollectors, "newCollectors");
            TaskPrioritizerContext<D, F> taskPrioritizerContext = new TaskPrioritizerContext<D, F>(this.name, this.result, this.context, this.scope, newCollectors);
            if (taskPrioritizerContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "replaceCollectors"));
            }
            return taskPrioritizerContext;
        }

        @NotNull
        public final Name getName() {
            Name name = this.name;
            if (name == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "getName"));
            }
            return name;
        }

        @NotNull
        public final ResolutionTaskHolder<D, F> getResult() {
            ResolutionTaskHolder<D, F> resolutionTaskHolder = this.result;
            if (resolutionTaskHolder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "getResult"));
            }
            return resolutionTaskHolder;
        }

        @NotNull
        public final BasicCallResolutionContext getContext() {
            BasicCallResolutionContext basicCallResolutionContext = this.context;
            if (basicCallResolutionContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "getContext"));
            }
            return basicCallResolutionContext;
        }

        @NotNull
        public final JetScope getScope() {
            JetScope jetScope = this.scope;
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "getScope"));
            }
            return jetScope;
        }

        @NotNull
        public final CallableDescriptorCollectors<D> getCallableDescriptorCollectors() {
            CallableDescriptorCollectors<D> callableDescriptorCollectors = this.callableDescriptorCollectors;
            if (callableDescriptorCollectors == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "getCallableDescriptorCollectors"));
            }
            return callableDescriptorCollectors;
        }

        public TaskPrioritizerContext(@JetValueParameter(name="name") @NotNull Name name, @JetValueParameter(name="result") @NotNull ResolutionTaskHolder<D, F> result2, @JetValueParameter(name="context") @NotNull BasicCallResolutionContext context2, @JetValueParameter(name="scope") @NotNull JetScope scope2, @JetValueParameter(name="callableDescriptorCollectors") @NotNull CallableDescriptorCollectors<D> callableDescriptorCollectors) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "<init>"));
            }
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "<init>"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "<init>"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "<init>"));
            }
            if (callableDescriptorCollectors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptorCollectors", "org/jetbrains/jet/lang/resolve/calls/tasks/TaskPrioritizer$TaskPrioritizerContext", "<init>"));
            }
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(result2, "result");
            Intrinsics.checkParameterIsNotNull(context2, "context");
            Intrinsics.checkParameterIsNotNull(scope2, "scope");
            Intrinsics.checkParameterIsNotNull(callableDescriptorCollectors, "callableDescriptorCollectors");
            this.name = name;
            this.result = result2;
            this.context = context2;
            this.scope = scope2;
            this.callableDescriptorCollectors = callableDescriptorCollectors;
        }
    }
}

