/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public abstract class CompileTimeConstant<T> {
    protected final T value;
    private final int flags;

    protected CompileTimeConstant(T value, boolean canBeUsedInAnnotations, boolean isPure, boolean usesVariableAsConstant) {
        this.value = value;
        this.flags = (isPure ? 1 : 0) | (canBeUsedInAnnotations ? 2 : 0) | (usesVariableAsConstant ? 4 : 0);
    }

    public boolean canBeUsedInAnnotations() {
        return (this.flags & 2) != 0;
    }

    public boolean isPure() {
        return (this.flags & 1) != 0;
    }

    public boolean usesVariableAsConstant() {
        return (this.flags & 4) != 0;
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    @NotNull
    public abstract JetType getType(@NotNull KotlinBuiltIns var1);

    public abstract <R, D> R accept(AnnotationArgumentVisitor<R, D> var1, D var2);
}

