/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.mapping;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMapBuilder;
import org.jetbrains.jet.lang.resolve.java.mapping.PrimitiveTypesUtil;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;

public class KotlinToJavaTypesMap
extends JavaToKotlinClassMapBuilder {
    private static KotlinToJavaTypesMap instance = null;
    private final Map<FqName, Type> asmTypes = new HashMap<FqName, Type>();
    private final Map<FqName, Type> asmNullableTypes = new HashMap<FqName, Type>();
    private final Map<FqName, FqName> kotlinToJavaFqName = new HashMap<FqName, FqName>();

    @NotNull
    public static KotlinToJavaTypesMap getInstance() {
        if (instance == null) {
            instance = new KotlinToJavaTypesMap();
        }
        KotlinToJavaTypesMap kotlinToJavaTypesMap = instance;
        if (kotlinToJavaTypesMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "getInstance"));
        }
        return kotlinToJavaTypesMap;
    }

    private KotlinToJavaTypesMap() {
        this.init();
        this.initPrimitives();
    }

    private void initPrimitives() {
        FqName builtInsFqName = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
            Type asmType = PrimitiveTypesUtil.asmTypeForPrimitive(jvmPrimitiveType);
            FqName fqName2 = builtInsFqName.child(primitiveType.getTypeName());
            this.register(fqName2, asmType);
            FqName wrapperFqName = jvmPrimitiveType.getWrapperFqName();
            this.registerNullable(fqName2, Type.getObjectType(JvmClassName.byFqNameWithoutInnerClasses(wrapperFqName).getInternalName()));
            this.registerFqName(fqName2, wrapperFqName);
            this.register(builtInsFqName.child(primitiveType.getArrayTypeName()), Type.getType("[" + asmType.getDescriptor()));
        }
    }

    @Nullable
    public Type getJavaAnalog(@NotNull FqName fqName2, boolean isNullable) {
        Type nullableType;
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "getJavaAnalog"));
        }
        if (isNullable && (nullableType = this.asmNullableTypes.get(fqName2)) != null) {
            return nullableType;
        }
        return this.asmTypes.get(fqName2);
    }

    @Nullable
    public FqName getKotlinToJavaFqName(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "getKotlinToJavaFqName"));
        }
        return this.kotlinToJavaFqName.get(fqName2);
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.KOTLIN_TO_JAVA) {
            FqName fqName2 = DescriptorUtils.getFqNameSafe(kotlinDescriptor);
            this.register(fqName2, AsmTypeConstants.getType(javaClass));
            this.registerFqName(fqName2, new FqName(javaClass.getCanonicalName()));
        }
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (kotlinMutableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinMutableDescriptor", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.KOTLIN_TO_JAVA) {
            this.register(javaClass, kotlinDescriptor);
            this.register(javaClass, kotlinMutableDescriptor);
        }
    }

    private void register(@NotNull FqName fqName2, @NotNull Type type2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "register"));
        }
        this.asmTypes.put(fqName2, type2);
    }

    private void registerNullable(@NotNull FqName fqName2, @NotNull Type nullableType) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "registerNullable"));
        }
        if (nullableType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullableType", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "registerNullable"));
        }
        this.asmNullableTypes.put(fqName2, nullableType);
    }

    private void registerFqName(@NotNull FqName kotlinFqName, @NotNull FqName javaFqName) {
        if (kotlinFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinFqName", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "registerFqName"));
        }
        if (javaFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaFqName", "org/jetbrains/jet/lang/resolve/java/mapping/KotlinToJavaTypesMap", "registerFqName"));
        }
        this.kotlinToJavaFqName.put(kotlinFqName, javaFqName);
    }
}

