/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import jet.runtime.typeinfo.JetValueParameter;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;

@KotlinClass(abiVersion=19, data={";\u0006)Aa+\u0019:jC:\u001cWMC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\u0007),GO\u0003\u0003mC:<'\"\u0002;za\u0016\u001c(\u0002B#ok6Taa[8uY&t'B\u0002\u001fj]&$hHC\u0003mC\n,GN\u0003\u0004TiJLgn\u001a\u0006\u0011C2dwn^:J]B{7/\u001b;j_:TqAQ8pY\u0016\fgNC\tbY2|wo](viB{7/\u001b;j_:T1c];qKJ\u0004xn]5uS>tg)Y2u_JT1!\u00138u\u0015\u0011Q\u0017M^1\u000b'\u001d,G/\u00117m_^\u001c\u0018J\u001c)pg&$\u0018n\u001c8\u000b)\u001d,G/\u00117m_^\u001cx*\u001e;Q_NLG/[8o\u0015!9W\r\u001e'bE\u0016d'BD1mY><8\u000fU8tSRLwN\u001c\u0006\ta>\u001c\u0018\u000e^5p]*Aq\u000e\u001d9pg&$XMC\u0005tkB,'\u000f]8tK*)q\u000e\u001e5fe*AAo\\*ue&twMC\u0005J\u001dZ\u000b%+S!O)*Y\u0011JT0W\u0003JK\u0015IT\"F\u00151yU\u000bV0W\u0003JK\u0015IT\"F=*\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001E\u0004\u000b\r!1\u0001C\u0002\r\u0001\u0015\u0019Aa\u0001\u0005\u0006\u0019\u0001)1\u0001B\u0002\t\r1\u0001Qa\u0001\u0003\u0004\u0011\u001fa\u0001!B\u0001\t\u0011\u0015\u0011A1\u0002\u0005\u0003\u000b\t!a\u0001C\u0003\u0006\u0005\u0011\u0011\u0001\u0002\u0001\u0003D\u00021\u0015\u0011DB\u0003\u0002\u0011\u000fI1!\u0003\u0002\u0006\u0003!\u0015Qf\u0004\u0003d\ta-\u0011EA\u0003\u0002\u0011\u0013)6\u0001C\u0003\u0004\t\u0017I\u0011\u0001\"\u0001\u000e\u0007\u0011E\u0011\"\u0001C\u0001[=!1\r\u0002M\u0007C\t)\u0011\u0001#\u0003V\u0007!)1\u0001\"\u0004\n\u0003\u0011\u0005Qb\u0001\u0003\n\u0013\u0005!\t!L\b\u0005G\u0012AJ!\t\u0002\u0006\u0003!!Qk\u0001\u0005\u0006\u0007\u0011%\u0011\"\u0001E\u0007\u001b\r!\u0019\"C\u0001\t\u000e5ZA!\u0019\u0003\u0019\u000f\u0005\u0012Q!\u0001\u0005\u0006+\u000e!Qa\u0001\u0003\b\u0013\u0005!)!L\n\u0005\u0007aQQT\u0002\u0003\u0001\u0011+i!!B\u0001\t\u0006A\u001b\u0001!\t\u0002\u0006\u0003!%\u0011kA\u0003\u0005\u0015%\tA\u0011A\u0007\u0002\u0011\u001di\u001b\u0002B\u0002\u0019\u0017\u0005\u0012Q!\u0001E\u0003#\u000e\u0019AaC\u0005\u0002\u0011\u001di3\u0003B\u0002\u0019\u0018u5A\u0001\u0001\u0005\r\u001b\t)\u0011\u0001#\u0002Q\u0007\u0001\t#!B\u0001\t\u0006E\u001bQ\u0001b\u0006\n\u0003!9Q\"\u0001\u0005\b['!1\u0002'\u0007\"\u0005\u0015\t\u0001\u0002B)\u0004\u0007\u0011e\u0011\"\u0001E\u0007a5\u0001\\\u0002\r\b6k\u0015!D!9\u0001\u0019\tu5A\u0001\u0001E\u0005\u001b\t)\u0011\u0001\u0003\u0003Q\u0007\u0005ij\u0001\u0002\u0001\t\f5\u0011Q!\u0001E\u0005!\u000e\rQT\u0002\u0003\u0001\u0011\u001bi!!B\u0001\t\nA\u001b!!(\u0004\u0005\u0001!9QBA\u0003\u0002\u0011\u0015\u00016QA\u0011\u0003\u000b\u0005A)!U\u0002\u0010\t\u0011I\u0011\u0001\u0002\u0001\u000e\u0003!5Q\"\u0001C\u0003\u001b\u0005Ai!D\u0001\u0005\u00025\tA\u0011A\u0007\u0002\t\u000b\u0001"})
public final class Variance
extends Enum<Variance>
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    public static final /* enum */ Variance INVARIANT;
    public static final /* enum */ Variance IN_VARIANCE;
    public static final /* enum */ Variance OUT_VARIANCE;
    @NotNull
    private final String label;
    private final boolean allowsInPosition;
    private final boolean allowsOutPosition;
    private final int superpositionFactor;
    private static final /* synthetic */ Variance[] $VALUES;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(Variance.class);
        Variance[] varianceArray = new Variance[3];
        Variance[] varianceArray2 = varianceArray;
        varianceArray[0] = INVARIANT = new Variance("", true, true, 0);
        varianceArray[1] = IN_VARIANCE = new Variance("in", true, false, -1);
        varianceArray[2] = OUT_VARIANCE = new Variance("out", false, true, 1);
        $VALUES = varianceArray;
    }

    public final boolean allowsPosition(@JetValueParameter(name="position") @NotNull Variance position) {
        boolean bl;
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/jet/lang/types/Variance", "allowsPosition"));
        }
        Intrinsics.checkParameterIsNotNull(position, "position");
        Variance variance = position;
        if (Intrinsics.areEqual(variance, IN_VARIANCE)) {
            bl = this.allowsInPosition;
        } else if (Intrinsics.areEqual(variance, OUT_VARIANCE)) {
            bl = this.allowsOutPosition;
        } else if (Intrinsics.areEqual(variance, INVARIANT)) {
            bl = this.allowsInPosition ? this.allowsOutPosition : false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public final Variance superpose(@JetValueParameter(name="other") @NotNull Variance other) {
        Variance variance;
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/jet/lang/types/Variance", "superpose"));
        }
        Intrinsics.checkParameterIsNotNull(other, "other");
        int r = this.superpositionFactor * other.superpositionFactor;
        switch (r) {
            case 0: {
                variance = INVARIANT;
                break;
            }
            case -1: {
                variance = IN_VARIANCE;
                break;
            }
            case 1: {
                variance = OUT_VARIANCE;
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Illegal factor: " + r);
            }
        }
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/Variance", "superpose"));
        }
        return variance;
    }

    @NotNull
    public final Variance opposite() {
        Variance variance;
        Variance variance2 = this;
        if (Intrinsics.areEqual(variance2, INVARIANT)) {
            variance = INVARIANT;
        } else if (Intrinsics.areEqual(variance2, IN_VARIANCE)) {
            variance = OUT_VARIANCE;
        } else if (Intrinsics.areEqual(variance2, OUT_VARIANCE)) {
            variance = IN_VARIANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/Variance", "opposite"));
        }
        return variance;
    }

    @NotNull
    public String toString() {
        String string = this.label;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/Variance", "toString"));
        }
        return string;
    }

    @NotNull
    public final String getLabel() {
        String string = this.label;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/Variance", "getLabel"));
        }
        return string;
    }

    public final boolean getAllowsInPosition() {
        return this.allowsInPosition;
    }

    public final boolean getAllowsOutPosition() {
        return this.allowsOutPosition;
    }

    protected Variance(@JetValueParameter(name="label") @NotNull String label, @JetValueParameter(name="allowsInPosition") boolean allowsInPosition, @JetValueParameter(name="allowsOutPosition") boolean allowsOutPosition, @JetValueParameter(name="superpositionFactor") int superpositionFactor) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/jet/lang/types/Variance", "<init>"));
        }
        Intrinsics.checkParameterIsNotNull(label, "label");
        this.label = label;
        this.allowsInPosition = allowsInPosition;
        this.allowsOutPosition = allowsOutPosition;
        this.superpositionFactor = superpositionFactor;
    }

    public static Variance[] values() {
        return (Variance[])$VALUES.clone();
    }

    public static Variance valueOf(String string) {
        return Enum.valueOf(Variance.class, string);
    }
}

