/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.config;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Function1;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.k2js.config.EcmaVersion;

public abstract class Config {
    private final boolean inlineEnabled;
    @NotNull
    private final Project project;
    @Nullable
    private List<JetFile> libFiles;
    @NotNull
    private final EcmaVersion target;
    @NotNull
    private final String moduleId;
    private final boolean sourcemap;
    @NotNull
    private final BindingTrace trace;

    public Config(@NotNull Project project, @NotNull String moduleId, @NotNull EcmaVersion ecmaVersion, boolean sourcemap, boolean inlineEnabled) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/k2js/config/Config", "<init>"));
        }
        if (moduleId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleId", "org/jetbrains/k2js/config/Config", "<init>"));
        }
        if (ecmaVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ecmaVersion", "org/jetbrains/k2js/config/Config", "<init>"));
        }
        this.libFiles = null;
        this.trace = new BindingTraceContext();
        this.project = project;
        this.target = ecmaVersion;
        this.moduleId = moduleId;
        this.sourcemap = sourcemap;
        this.inlineEnabled = inlineEnabled;
    }

    public boolean isSourcemap() {
        return this.sourcemap;
    }

    public boolean isInlineEnabled() {
        return this.inlineEnabled;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/Config", "getProject"));
        }
        return project;
    }

    @NotNull
    public EcmaVersion getTarget() {
        EcmaVersion ecmaVersion = this.target;
        if (ecmaVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/Config", "getTarget"));
        }
        return ecmaVersion;
    }

    @NotNull
    public String getModuleId() {
        String string = this.moduleId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/Config", "getModuleId"));
        }
        return string;
    }

    public abstract boolean checkLibFilesAndReportErrors(@NotNull Function1<String, Unit> var1);

    @NotNull
    protected abstract List<JetFile> generateLibFiles();

    @NotNull
    public final List<JetFile> getLibFiles() {
        if (this.libFiles == null) {
            this.libFiles = this.generateLibFiles();
        }
        List<JetFile> list = this.libFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/Config", "getLibFiles"));
        }
        return list;
    }

    @Nullable
    public BindingContext getLibraryContext() {
        return null;
    }

    @NotNull
    public BindingTrace getTrace() {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/Config", "getTrace"));
        }
        return bindingTrace;
    }

    @Nullable
    public ModuleDescriptor getLibraryModule() {
        return null;
    }

    @NotNull
    public static Collection<JetFile> withJsLibAdded(@NotNull Collection<JetFile> files, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/config/Config", "withJsLibAdded"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/config/Config", "withJsLibAdded"));
        }
        ArrayList<JetFile> allFiles = Lists.newArrayList();
        allFiles.addAll(files);
        allFiles.addAll(config.getLibFiles());
        ArrayList<JetFile> arrayList = allFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/config/Config", "withJsLibAdded"));
        }
        return arrayList;
    }

    public boolean isTestConfig() {
        return false;
    }
}

