/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.common.collect.Maps;
import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsDynamicScope;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.reflect.ReflectionTypes;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.tasks.TasksPackage;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.k2js.config.Config;
import org.jetbrains.k2js.config.EcmaVersion;
import org.jetbrains.k2js.config.LibrarySourcesConfig;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.StandardClasses;
import org.jetbrains.k2js.translate.context.generator.Generator;
import org.jetbrains.k2js.translate.context.generator.Rule;
import org.jetbrains.k2js.translate.intrinsic.Intrinsics;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.ManglingUtils;

public final class StaticContext {
    @NotNull
    private final JsProgram program;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final Namer namer;
    @NotNull
    private final Intrinsics intrinsics;
    @NotNull
    private final StandardClasses standardClasses;
    @NotNull
    private final ReflectionTypes reflectionTypes;
    @NotNull
    private final JsScope rootScope;
    @NotNull
    private final Generator<JsName> names;
    @NotNull
    private final Map<FqName, JsName> packageNames;
    @NotNull
    private final Generator<JsScope> scopes;
    @NotNull
    private final Generator<JsExpression> qualifiers;
    @NotNull
    private final Generator<Boolean> qualifierIsNull;
    @NotNull
    private final Map<JsScope, JsFunction> scopeToFunction;
    @NotNull
    private final Config config;
    @NotNull
    private final EcmaVersion ecmaVersion;

    public static StaticContext generateStaticContext(@NotNull BindingContext bindingContext, @NotNull Config config, @NotNull ModuleDescriptor moduleDescriptor) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/k2js/translate/context/StaticContext", "generateStaticContext"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/translate/context/StaticContext", "generateStaticContext"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/k2js/translate/context/StaticContext", "generateStaticContext"));
        }
        JsProgram program = new JsProgram("main");
        Namer namer = Namer.newInstance(program.getRootScope());
        Intrinsics intrinsics = new Intrinsics();
        StandardClasses standardClasses = StandardClasses.bindImplementations(namer.getKotlinScope());
        return new StaticContext(program, bindingContext, namer, intrinsics, standardClasses, program.getRootScope(), config, moduleDescriptor);
    }

    private StaticContext(@NotNull JsProgram program, @NotNull BindingContext bindingContext, @NotNull Namer namer, @NotNull Intrinsics intrinsics, @NotNull StandardClasses standardClasses, @NotNull JsScope rootScope, @NotNull Config config, @NotNull ModuleDescriptor moduleDescriptor) {
        if (program == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "program", "org/jetbrains/k2js/translate/context/StaticContext", "<init>"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/k2js/translate/context/StaticContext", "<init>"));
        }
        if (namer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namer", "org/jetbrains/k2js/translate/context/StaticContext", "<init>"));
        }
        if (intrinsics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intrinsics", "org/jetbrains/k2js/translate/context/StaticContext", "<init>"));
        }
        if (standardClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "standardClasses", "org/jetbrains/k2js/translate/context/StaticContext", "<init>"));
        }
        if (rootScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/k2js/translate/context/StaticContext", "<init>"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/translate/context/StaticContext", "<init>"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/k2js/translate/context/StaticContext", "<init>"));
        }
        this.names = new NameGenerator();
        this.packageNames = Maps.newHashMap();
        this.scopes = new ScopeGenerator();
        this.qualifiers = new QualifierGenerator();
        this.qualifierIsNull = new QualifierIsNullGenerator();
        this.scopeToFunction = Maps.newHashMap();
        this.program = program;
        this.bindingContext = bindingContext;
        this.namer = namer;
        this.intrinsics = intrinsics;
        this.rootScope = rootScope;
        this.standardClasses = standardClasses;
        this.config = config;
        this.ecmaVersion = config.getTarget();
        this.reflectionTypes = new ReflectionTypes(moduleDescriptor);
    }

    public boolean isEcma5() {
        return this.ecmaVersion == EcmaVersion.v5;
    }

    @NotNull
    public JsProgram getProgram() {
        JsProgram jsProgram = this.program;
        if (jsProgram == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getProgram"));
        }
        return jsProgram;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingContext;
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getBindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    public Intrinsics getIntrinsics() {
        Intrinsics intrinsics = this.intrinsics;
        if (intrinsics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getIntrinsics"));
        }
        return intrinsics;
    }

    @NotNull
    public Namer getNamer() {
        Namer namer = this.namer;
        if (namer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getNamer"));
        }
        return namer;
    }

    @NotNull
    public ReflectionTypes getReflectionTypes() {
        ReflectionTypes reflectionTypes = this.reflectionTypes;
        if (reflectionTypes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getReflectionTypes"));
        }
        return reflectionTypes;
    }

    @NotNull
    public JsScope getRootScope() {
        JsScope jsScope = this.rootScope;
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getRootScope"));
        }
        return jsScope;
    }

    @NotNull
    public JsScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext", "getScopeForDescriptor"));
        }
        JsScope scope2 = this.scopes.get(descriptor.getOriginal());
        assert (scope2 != null) : "Must have a scope for descriptor";
        JsScope jsScope = scope2;
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getScopeForDescriptor"));
        }
        return jsScope;
    }

    @NotNull
    public JsFunction getFunctionWithScope(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext", "getFunctionWithScope"));
        }
        JsScope scope2 = this.getScopeForDescriptor(descriptor);
        JsFunction function = this.scopeToFunction.get(scope2);
        assert (scope2.equals(function.getScope())) : "Inconsistency.";
        JsFunction jsFunction = function;
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getFunctionWithScope"));
        }
        return jsFunction;
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext", "getQualifiedReference"));
        }
        if (descriptor instanceof PackageViewDescriptor) {
            JsNameRef jsNameRef = this.getQualifiedReference(((PackageViewDescriptor)descriptor).getFqName());
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getQualifiedReference"));
            }
            return jsNameRef;
        }
        if (descriptor instanceof PackageFragmentDescriptor) {
            JsNameRef jsNameRef = this.getQualifiedReference(((PackageFragmentDescriptor)descriptor).getFqName());
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getQualifiedReference"));
            }
            return jsNameRef;
        }
        JsNameRef jsNameRef = new JsNameRef(this.getNameForDescriptor(descriptor), this.getQualifierForDescriptor(descriptor));
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getQualifiedReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/k2js/translate/context/StaticContext", "getQualifiedReference"));
        }
        JsNameRef jsNameRef = new JsNameRef(this.getNameForPackage(packageFqName), packageFqName.isRoot() ? null : this.getQualifierForParentPackage(packageFqName.parent()));
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getQualifiedReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext", "getNameForDescriptor"));
        }
        JsName name = this.names.get(descriptor.getOriginal());
        assert (name != null) : "Must have name for descriptor";
        JsName jsName = name;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getNameForDescriptor"));
        }
        return jsName;
    }

    @NotNull
    public JsName getNameForPackage(final @NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/k2js/translate/context/StaticContext", "getNameForPackage"));
        }
        JsName jsName = ContainerUtil.getOrCreate(this.packageNames, packageFqName, new Factory<JsName>(){

            @Override
            public JsName create() {
                String name = Namer.generatePackageName(packageFqName);
                return StaticContext.this.getRootScope().declareName(name);
            }
        });
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getNameForPackage"));
        }
        return jsName;
    }

    @NotNull
    private JsNameRef getQualifierForParentPackage(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/k2js/translate/context/StaticContext", "getQualifierForParentPackage"));
        }
        JsNameRef result2 = null;
        JsNameRef qualifier = null;
        for (FqName pathElement : ContainerUtil.reverse(packageFqName.path())) {
            JsNameRef ref = this.getNameForPackage(pathElement).makeRef();
            if (qualifier == null) {
                result2 = ref;
            } else {
                qualifier.setQualifier(ref);
            }
            qualifier = ref;
        }
        assert (result2 != null) : "didn't iterate: " + packageFqName;
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getQualifierForParentPackage"));
        }
        return jsNameRef;
    }

    @NotNull
    public Config getConfig() {
        Config config = this.config;
        if (config == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getConfig"));
        }
        return config;
    }

    @NotNull
    public JsName declarePropertyOrPropertyAccessorName(@NotNull DeclarationDescriptor descriptor, @NotNull String name, boolean fresh) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext", "declarePropertyOrPropertyAccessorName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/k2js/translate/context/StaticContext", "declarePropertyOrPropertyAccessorName"));
        }
        JsScope scope2 = this.getEnclosingScope(descriptor);
        JsName jsName = fresh ? scope2.declareFreshName(name) : scope2.declareName(name);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "declarePropertyOrPropertyAccessorName"));
        }
        return jsName;
    }

    @NotNull
    private JsScope getEnclosingScope(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext", "getEnclosingScope"));
        }
        DeclarationDescriptor containingDeclaration = JsDescriptorUtils.getContainingDeclaration(descriptor);
        JsScope jsScope = this.getScopeForDescriptor(containingDeclaration.getOriginal());
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/context/StaticContext", "getEnclosingScope"));
        }
        return jsScope;
    }

    @Nullable
    public JsExpression getQualifierForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext", "getQualifierForDescriptor"));
        }
        if (this.qualifierIsNull.get(descriptor.getOriginal()) != null) {
            return null;
        }
        return this.qualifiers.get(descriptor.getOriginal());
    }

    private static class QualifierIsNullGenerator
    extends Generator<Boolean> {
        private QualifierIsNullGenerator() {
            Rule<Boolean> propertiesInClassHaveNoQualifiers = new Rule<Boolean>(){

                @Override
                public Boolean apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$QualifierIsNullGenerator$1", "apply"));
                    }
                    if (descriptor instanceof PropertyDescriptor && descriptor.getContainingDeclaration() instanceof ClassDescriptor) {
                        return true;
                    }
                    return null;
                }
            };
            this.addRule(propertiesInClassHaveNoQualifiers);
        }
    }

    private final class QualifierGenerator
    extends Generator<JsExpression> {
        public QualifierGenerator() {
            Rule<JsExpression> standardObjectsHaveKotlinQualifier = new Rule<JsExpression>(){

                @Override
                public JsExpression apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$QualifierGenerator$1", "apply"));
                    }
                    if (!StaticContext.this.standardClasses.isStandardObject(descriptor)) {
                        return null;
                    }
                    return StaticContext.this.namer.kotlinObject();
                }
            };
            Rule<JsExpression> packageLevelDeclarationsHaveEnclosingPackagesNamesAsQualifier = new Rule<JsExpression>(){

                @Override
                public JsExpression apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$QualifierGenerator$2", "apply"));
                    }
                    if (AnnotationsUtils.isNativeObject(descriptor)) {
                        return null;
                    }
                    DeclarationDescriptor containingDescriptor = JsDescriptorUtils.getContainingDeclaration(descriptor);
                    if (!(containingDescriptor instanceof PackageFragmentDescriptor)) {
                        return null;
                    }
                    JsNameRef result2 = StaticContext.this.getQualifierForParentPackage(((PackageFragmentDescriptor)containingDescriptor).getFqName());
                    String moduleName = this.getExternalModuleName(descriptor);
                    if (moduleName == null) {
                        return result2;
                    }
                    if ("<unknown>".equals(moduleName)) {
                        return null;
                    }
                    return JsAstUtils.replaceRootReference(result2, new JsArrayAccess(StaticContext.this.namer.kotlin("modules"), StaticContext.this.program.getStringLiteral(moduleName)));
                }

                private String getExternalModuleName(DeclarationDescriptor descriptor) {
                    if (JsDescriptorUtils.isBuiltin(descriptor)) {
                        return "builtins";
                    }
                    PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor);
                    if (element == null && descriptor instanceof PropertyAccessorDescriptor) {
                        element = DescriptorToSourceUtils.descriptorToDeclaration(((PropertyAccessorDescriptor)descriptor).getCorrespondingProperty());
                    }
                    if (element == null) {
                        return null;
                    }
                    return element.getContainingFile().getUserData(LibrarySourcesConfig.EXTERNAL_MODULE_NAME);
                }
            };
            Rule<JsExpression> constructorOrClassObjectHasTheSameQualifierAsTheClass = new Rule<JsExpression>(){

                @Override
                public JsExpression apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$QualifierGenerator$3", "apply"));
                    }
                    if (descriptor instanceof ConstructorDescriptor || DescriptorUtils.isClassObject(descriptor)) {
                        return StaticContext.this.getQualifierForDescriptor(descriptor.getContainingDeclaration());
                    }
                    return null;
                }
            };
            Rule<JsExpression> libraryObjectsHaveKotlinQualifier = new Rule<JsExpression>(){

                @Override
                public JsExpression apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$QualifierGenerator$4", "apply"));
                    }
                    if (AnnotationsUtils.isLibraryObject(descriptor)) {
                        return StaticContext.this.namer.kotlinObject();
                    }
                    return null;
                }
            };
            Rule<JsExpression> nativeObjectsHaveNativePartOfFullQualifier = new Rule<JsExpression>(){

                @Override
                public JsExpression apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$QualifierGenerator$5", "apply"));
                    }
                    if (descriptor instanceof ConstructorDescriptor || !AnnotationsUtils.isNativeObject(descriptor)) {
                        return null;
                    }
                    DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
                    if (containingDeclaration != null && AnnotationsUtils.isNativeObject(containingDeclaration)) {
                        return StaticContext.this.getQualifiedReference(containingDeclaration);
                    }
                    return null;
                }
            };
            Rule<JsExpression> staticMembersHaveContainerQualifier = new Rule<JsExpression>(){

                @Override
                public JsExpression apply(@NotNull DeclarationDescriptor descriptor) {
                    CallableDescriptor callableDescriptor;
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$QualifierGenerator$6", "apply"));
                    }
                    if (descriptor instanceof CallableDescriptor && !AnnotationsUtils.isNativeObject(descriptor) && DescriptorUtils.isStaticDeclaration(callableDescriptor = (CallableDescriptor)descriptor)) {
                        return StaticContext.this.getQualifiedReference(callableDescriptor.getContainingDeclaration());
                    }
                    return null;
                }
            };
            this.addRule(libraryObjectsHaveKotlinQualifier);
            this.addRule(constructorOrClassObjectHasTheSameQualifierAsTheClass);
            this.addRule(standardObjectsHaveKotlinQualifier);
            this.addRule(packageLevelDeclarationsHaveEnclosingPackagesNamesAsQualifier);
            this.addRule(nativeObjectsHaveNativePartOfFullQualifier);
            this.addRule(staticMembersHaveContainerQualifier);
        }
    }

    private final class ScopeGenerator
    extends Generator<JsScope> {
        public ScopeGenerator() {
            Rule<JsScope> generateNewScopesForClassesWithNoAncestors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$ScopeGenerator$1", "apply"));
                    }
                    if (!(descriptor instanceof ClassDescriptor)) {
                        return null;
                    }
                    if (JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor) == null) {
                        return StaticContext.this.getRootScope().innerObjectScope("Scope for class " + descriptor.getName());
                    }
                    return null;
                }
            };
            Rule<JsScope> generateInnerScopesForDerivedClasses = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$ScopeGenerator$2", "apply"));
                    }
                    if (!(descriptor instanceof ClassDescriptor)) {
                        return null;
                    }
                    ClassDescriptor superclass = JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor);
                    if (superclass == null) {
                        return null;
                    }
                    return StaticContext.this.getScopeForDescriptor(superclass).innerObjectScope("Scope for class " + descriptor.getName());
                }
            };
            Rule<JsScope> generateNewScopesForPackageDescriptors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$ScopeGenerator$3", "apply"));
                    }
                    if (!(descriptor instanceof PackageFragmentDescriptor)) {
                        return null;
                    }
                    return StaticContext.this.getRootScope().innerObjectScope("Package " + descriptor.getName());
                }
            };
            Rule<JsScope> generateInnerScopesForMembers = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$ScopeGenerator$4", "apply"));
                    }
                    JsScope enclosingScope = StaticContext.this.getEnclosingScope(descriptor);
                    return enclosingScope.innerObjectScope("Scope for member " + descriptor.getName());
                }
            };
            Rule<JsScope> createFunctionObjectsForCallableDescriptors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$ScopeGenerator$5", "apply"));
                    }
                    if (!(descriptor instanceof CallableDescriptor)) {
                        return null;
                    }
                    JsScope enclosingScope = StaticContext.this.getEnclosingScope(descriptor);
                    JsFunction correspondingFunction = JsAstUtils.createFunctionWithEmptyBody(enclosingScope);
                    assert (!StaticContext.this.scopeToFunction.containsKey(correspondingFunction.getScope())) : "Scope to function value overridden for " + descriptor;
                    StaticContext.this.scopeToFunction.put(correspondingFunction.getScope(), correspondingFunction);
                    return correspondingFunction.getScope();
                }
            };
            this.addRule(createFunctionObjectsForCallableDescriptors);
            this.addRule(generateNewScopesForClassesWithNoAncestors);
            this.addRule(generateInnerScopesForDerivedClasses);
            this.addRule(generateNewScopesForPackageDescriptors);
            this.addRule(generateInnerScopesForMembers);
        }
    }

    private final class NameGenerator
    extends Generator<JsName> {
        public NameGenerator() {
            Rule<JsName> namesForDynamic = new Rule<JsName>(){

                @Override
                @Nullable
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$NameGenerator$1", "apply"));
                    }
                    if (TasksPackage.isDynamic(descriptor)) {
                        String name = descriptor.getName().asString();
                        return JsDynamicScope.INSTANCE$.declareName(name);
                    }
                    return null;
                }
            };
            Rule<JsName> namesForStandardClasses = new Rule<JsName>(){

                @Override
                @Nullable
                public JsName apply(@NotNull DeclarationDescriptor data2) {
                    if (data2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/k2js/translate/context/StaticContext$NameGenerator$2", "apply"));
                    }
                    if (!StaticContext.this.standardClasses.isStandardObject(data2)) {
                        return null;
                    }
                    return StaticContext.this.standardClasses.getStandardObjectName(data2);
                }
            };
            Rule<JsName> memberDeclarationsInsideParentsScope = new Rule<JsName>(){

                @Override
                @Nullable
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$NameGenerator$3", "apply"));
                    }
                    JsScope scope2 = StaticContext.this.getEnclosingScope(descriptor);
                    return scope2.declareFreshName(ManglingUtils.getSuggestedName(descriptor));
                }
            };
            Rule<JsName> constructorOrClassObjectHasTheSameNameAsTheClass = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$NameGenerator$4", "apply"));
                    }
                    if (descriptor instanceof ConstructorDescriptor || DescriptorUtils.isClassObject(descriptor)) {
                        return StaticContext.this.getNameForDescriptor(descriptor.getContainingDeclaration());
                    }
                    return null;
                }
            };
            Rule<JsName> propertyOrPropertyAccessor = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    PropertyDescriptor propertyDescriptor;
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$NameGenerator$5", "apply"));
                    }
                    if (descriptor instanceof PropertyAccessorDescriptor) {
                        propertyDescriptor = ((PropertyAccessorDescriptor)descriptor).getCorrespondingProperty();
                    } else if (descriptor instanceof PropertyDescriptor) {
                        propertyDescriptor = (PropertyDescriptor)descriptor;
                    } else {
                        return null;
                    }
                    String nameFromAnnotation = AnnotationsUtils.getNameForAnnotatedObjectWithOverrides(propertyDescriptor);
                    if (nameFromAnnotation != null) {
                        return StaticContext.this.declarePropertyOrPropertyAccessorName(descriptor, nameFromAnnotation, false);
                    }
                    String propertyName = ManglingUtils.getSuggestedName(propertyDescriptor);
                    if (!DescriptorUtils.isExtension(propertyDescriptor)) {
                        if (Visibilities.isPrivate(propertyDescriptor.getVisibility())) {
                            propertyName = ManglingUtils.getMangledName(propertyDescriptor, propertyName);
                        }
                        return StaticContext.this.declarePropertyOrPropertyAccessorName(descriptor, propertyName, false);
                    }
                    assert (!(descriptor instanceof PropertyDescriptor)) : "descriptor should not be instance of PropertyDescriptor: " + descriptor;
                    boolean isGetter = descriptor instanceof PropertyGetterDescriptor;
                    String accessorName = Namer.getNameForAccessor(propertyName, isGetter, false);
                    return StaticContext.this.declarePropertyOrPropertyAccessorName(descriptor, accessorName, false);
                }
            };
            Rule<JsName> predefinedObjectsHasUnobfuscatableNames = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$NameGenerator$6", "apply"));
                    }
                    if (descriptor instanceof CallableMemberDescriptor && !((CallableMemberDescriptor)descriptor).getOverriddenDescriptors().isEmpty()) {
                        return null;
                    }
                    String name = AnnotationsUtils.getNameForAnnotatedObjectWithOverrides(descriptor);
                    if (name != null) {
                        return StaticContext.this.getEnclosingScope(descriptor).declareName(name);
                    }
                    return null;
                }
            };
            Rule<JsName> overridingDescriptorsReferToOriginalName = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/StaticContext$NameGenerator$7", "apply"));
                    }
                    if (!(descriptor instanceof FunctionDescriptor)) {
                        return null;
                    }
                    FunctionDescriptor overriddenDescriptor = JsDescriptorUtils.getOverriddenDescriptor((FunctionDescriptor)descriptor);
                    if (overriddenDescriptor == null) {
                        return null;
                    }
                    JsScope scope2 = StaticContext.this.getEnclosingScope(descriptor);
                    JsName result2 = StaticContext.this.getNameForDescriptor(overriddenDescriptor);
                    scope2.declareName(result2.getIdent());
                    return result2;
                }
            };
            this.addRule(namesForDynamic);
            this.addRule(namesForStandardClasses);
            this.addRule(constructorOrClassObjectHasTheSameNameAsTheClass);
            this.addRule(propertyOrPropertyAccessor);
            this.addRule(predefinedObjectsHasUnobfuscatableNames);
            this.addRule(overridingDescriptorsReferToOriginalName);
            this.addRule(memberDeclarationsInsideParentsScope);
        }
    }
}

