/* The following code was generated by JFlex 1.4.3 on 10/13/14 2:48 PM */

package org.jetbrains.jet.lexer;

import java.util.*;
import com.intellij.lexer.*;
import com.intellij.psi.*;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import org.jetbrains.jet.lexer.KotlinLexerException;

import org.jetbrains.jet.lexer.JetTokens;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 10/13/14 2:48 PM from the specification file
 * <tt>/Users/abreslav/work/kotlin/compiler/frontend/src/org/jetbrains/jet/lexer/Jet.flex</tt>
 */
class _JetLexer implements FlexLexer {
  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int STRING = 2;
  public static final int BLOCK_COMMENT = 8;
  public static final int YYINITIAL = 0;
  public static final int LONG_TEMPLATE_ENTRY = 12;
  public static final int DOC_COMMENT = 10;
  public static final int RAW_STRING = 4;
  public static final int SHORT_TEMPLATE_ENTRY = 6;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  4,  4,  5, 5
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\7\1\0\1\3\23\0\1\3\1\14\1\31\1\13"+
    "\1\10\1\72\1\70\1\26\1\76\1\77\1\40\1\65\1\101\1\24"+
    "\1\21\1\12\1\15\11\1\1\73\1\100\1\66\1\63\1\67\1\64"+
    "\1\11\1\2\1\17\2\2\1\23\1\22\5\4\1\20\3\4\1\25"+
    "\3\4\1\60\3\4\1\16\2\4\1\74\1\27\1\75\1\0\1\4"+
    "\1\6\1\44\1\54\1\46\1\62\1\43\1\57\1\52\1\34\1\35"+
    "\1\55\1\51\1\45\1\4\1\50\1\47\1\42\1\4\1\53\1\36"+
    "\1\33\1\30\1\61\1\56\1\16\1\41\1\4\1\32\1\71\1\37"+
    "\54\0\1\4\12\0\1\4\4\0\1\4\5\0\27\4\1\0\37\4"+
    "\1\0\u013f\4\31\0\162\4\4\0\14\4\16\0\5\4\11\0\1\4"+
    "\213\0\1\4\13\0\1\4\1\0\3\4\1\0\1\4\1\0\24\4"+
    "\1\0\54\4\1\0\46\4\1\0\5\4\4\0\202\4\10\0\105\4"+
    "\1\0\46\4\2\0\2\4\6\0\20\4\41\0\46\4\2\0\1\4"+
    "\7\0\47\4\110\0\33\4\5\0\3\4\56\0\32\4\5\0\13\4"+
    "\25\0\12\5\4\0\2\4\1\0\143\4\1\0\1\4\17\0\2\4"+
    "\7\0\2\4\12\5\3\4\2\0\1\4\20\0\1\4\1\0\36\4"+
    "\35\0\3\4\60\0\46\4\13\0\1\4\u0152\0\66\4\3\0\1\4"+
    "\22\0\1\4\7\0\12\4\4\0\12\5\25\0\10\4\2\0\2\4"+
    "\2\0\26\4\1\0\7\4\1\0\1\4\3\0\4\4\3\0\1\4"+
    "\36\0\2\4\1\0\3\4\4\0\12\5\2\4\23\0\6\4\4\0"+
    "\2\4\2\0\26\4\1\0\7\4\1\0\2\4\1\0\2\4\1\0"+
    "\2\4\37\0\4\4\1\0\1\4\7\0\12\5\2\0\3\4\20\0"+
    "\11\4\1\0\3\4\1\0\26\4\1\0\7\4\1\0\2\4\1\0"+
    "\5\4\3\0\1\4\22\0\1\4\17\0\2\4\4\0\12\5\25\0"+
    "\10\4\2\0\2\4\2\0\26\4\1\0\7\4\1\0\2\4\1\0"+
    "\5\4\3\0\1\4\36\0\2\4\1\0\3\4\4\0\12\5\1\0"+
    "\1\4\21\0\1\4\1\0\6\4\3\0\3\4\1\0\4\4\3\0"+
    "\2\4\1\0\1\4\1\0\2\4\3\0\2\4\3\0\3\4\3\0"+
    "\10\4\1\0\3\4\55\0\11\5\25\0\10\4\1\0\3\4\1\0"+
    "\27\4\1\0\12\4\1\0\5\4\46\0\2\4\4\0\12\5\25\0"+
    "\10\4\1\0\3\4\1\0\27\4\1\0\12\4\1\0\5\4\3\0"+
    "\1\4\40\0\1\4\1\0\2\4\4\0\12\5\25\0\10\4\1\0"+
    "\3\4\1\0\27\4\1\0\20\4\46\0\2\4\4\0\12\5\25\0"+
    "\22\4\3\0\30\4\1\0\11\4\1\0\1\4\2\0\7\4\72\0"+
    "\60\4\1\0\2\4\14\0\7\4\11\0\12\5\47\0\2\4\1\0"+
    "\1\4\2\0\2\4\1\0\1\4\2\0\1\4\6\0\4\4\1\0"+
    "\7\4\1\0\3\4\1\0\1\4\1\0\1\4\2\0\2\4\1\0"+
    "\4\4\1\0\2\4\11\0\1\4\2\0\5\4\1\0\1\4\11\0"+
    "\12\5\2\0\2\4\42\0\1\4\37\0\12\5\26\0\10\4\1\0"+
    "\42\4\35\0\4\4\164\0\42\4\1\0\5\4\1\0\2\4\25\0"+
    "\12\5\6\0\6\4\112\0\46\4\12\0\51\4\7\0\132\4\5\0"+
    "\104\4\5\0\122\4\6\0\7\4\1\0\77\4\1\0\1\4\1\0"+
    "\4\4\2\0\7\4\1\0\1\4\1\0\4\4\2\0\47\4\1\0"+
    "\1\4\1\0\4\4\2\0\37\4\1\0\1\4\1\0\4\4\2\0"+
    "\7\4\1\0\1\4\1\0\4\4\2\0\7\4\1\0\7\4\1\0"+
    "\27\4\1\0\37\4\1\0\1\4\1\0\4\4\2\0\7\4\1\0"+
    "\47\4\1\0\23\4\16\0\11\5\56\0\125\4\14\0\u026c\4\2\0"+
    "\10\4\12\0\32\4\5\0\113\4\25\0\15\4\1\0\4\4\16\0"+
    "\22\4\16\0\22\4\16\0\15\4\1\0\3\4\17\0\64\4\43\0"+
    "\1\4\4\0\1\4\3\0\12\5\46\0\12\5\6\0\130\4\10\0"+
    "\51\4\127\0\35\4\51\0\12\5\36\4\2\0\5\4\u038b\0\154\4"+
    "\224\0\234\4\4\0\132\4\6\0\26\4\2\0\6\4\2\0\46\4"+
    "\2\0\6\4\2\0\10\4\1\0\1\4\1\0\1\4\1\0\1\4"+
    "\1\0\37\4\2\0\65\4\1\0\7\4\1\0\1\4\3\0\3\4"+
    "\1\0\7\4\3\0\4\4\2\0\6\4\4\0\15\4\5\0\3\4"+
    "\1\0\7\4\164\0\1\4\15\0\1\4\202\0\1\4\4\0\1\4"+
    "\2\0\12\4\1\0\1\4\3\0\5\4\6\0\1\4\1\0\1\4"+
    "\1\0\1\4\1\0\4\4\1\0\3\4\1\0\7\4\3\0\3\4"+
    "\5\0\5\4\u0ebb\0\2\4\52\0\5\4\5\0\2\4\4\0\126\4"+
    "\6\0\3\4\1\0\132\4\1\0\4\4\5\0\50\4\4\0\136\4"+
    "\21\0\30\4\70\0\20\4\u0200\0\u19b6\4\112\0\u51a6\4\132\0\u048d\4"+
    "\u0773\0\u2ba4\4\u215c\0\u012e\4\2\0\73\4\225\0\7\4\14\0\5\4"+
    "\5\0\1\4\1\0\12\4\1\0\15\4\1\0\5\4\1\0\1\4"+
    "\1\0\2\4\1\0\2\4\1\0\154\4\41\0\u016b\4\22\0\100\4"+
    "\2\0\66\4\50\0\14\4\164\0\5\4\1\0\207\4\23\0\12\5"+
    "\7\0\32\4\6\0\32\4\13\0\131\4\3\0\6\4\2\0\6\4"+
    "\2\0\6\4\2\0\3\4\43\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\1\1\1\2\1\3\1\4\2\1\1\5\1\6"+
    "\1\7\1\10\1\2\1\11\1\12\1\13\1\14\1\15"+
    "\3\3\1\16\1\17\15\3\1\20\1\21\1\22\1\23"+
    "\1\24\2\1\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\34\1\35\1\36\1\35\1\1\1\37\2\35"+
    "\1\40\1\1\1\40\3\41\1\42\1\43\1\2\1\0"+
    "\2\44\1\0\1\45\1\0\1\5\1\0\1\46\1\47"+
    "\1\50\1\51\1\0\1\52\1\0\2\2\1\44\1\53"+
    "\1\54\1\55\1\56\2\13\1\0\3\3\1\57\1\60"+
    "\1\61\1\3\1\62\2\3\1\63\14\3\1\64\1\65"+
    "\1\66\1\67\1\70\1\71\1\72\1\73\1\74\1\75"+
    "\1\76\1\77\1\0\1\100\2\101\2\0\1\40\1\102"+
    "\1\103\1\0\1\104\1\44\1\3\2\0\1\105\1\106"+
    "\1\107\1\110\1\0\1\2\2\0\1\111\4\3\1\112"+
    "\4\3\1\113\10\3\1\114\1\3\1\115\1\3\1\116"+
    "\1\117\1\120\2\0\1\121\2\40\1\45\1\5\1\122"+
    "\1\123\2\44\1\0\1\124\2\3\1\125\3\3\1\126"+
    "\3\3\1\127\3\3\1\130\1\3\1\131\1\77\1\0"+
    "\1\132\1\133\1\3\1\134\1\135\1\3\1\136\3\3"+
    "\1\137\1\140\1\141\1\0\3\3\1\142\1\143\1\3"+
    "\1\144\2\3\1\145\1\146";

  private static int [] zzUnpackAction() {
    int [] result = new int[237];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\102\0\204\0\306\0\u0108\0\u014a\0\u018c\0\u01ce"+
    "\0\u0210\0\u0252\0\u0294\0\u02d6\0\u0318\0\u035a\0\u039c\0\u03de"+
    "\0\u0420\0\u0462\0\u04a4\0\u04e6\0\u0528\0\u018c\0\u056a\0\u05ac"+
    "\0\u05ee\0\u018c\0\u0630\0\u0672\0\u06b4\0\u06f6\0\u0738\0\u077a"+
    "\0\u07bc\0\u07fe\0\u0840\0\u0882\0\u08c4\0\u0906\0\u0948\0\u098a"+
    "\0\u09cc\0\u018c\0\u0a0e\0\u0a50\0\u0a92\0\u0ad4\0\u0b16\0\u0b58"+
    "\0\u0b9a\0\u018c\0\u018c\0\u018c\0\u018c\0\u018c\0\u018c\0\u0bdc"+
    "\0\u018c\0\u0c1e\0\u0c60\0\u018c\0\u018c\0\u0ca2\0\u0ce4\0\u0d26"+
    "\0\u0d68\0\u018c\0\u0daa\0\u0dec\0\u018c\0\u018c\0\u0e2e\0\u0e70"+
    "\0\u018c\0\u0eb2\0\u0ef4\0\u0f36\0\u0f78\0\u0fba\0\u0ffc\0\u103e"+
    "\0\u1080\0\u018c\0\u10c2\0\u1104\0\u1146\0\u1188\0\u11ca\0\u120c"+
    "\0\u124e\0\u018c\0\u018c\0\u018c\0\u018c\0\u018c\0\u1290\0\u12d2"+
    "\0\u1314\0\u1356\0\u1398\0\u0210\0\u0210\0\u0210\0\u13da\0\u018c"+
    "\0\u141c\0\u145e\0\u14a0\0\u14e2\0\u1524\0\u1566\0\u15a8\0\u15ea"+
    "\0\u162c\0\u166e\0\u16b0\0\u16f2\0\u1734\0\u1776\0\u17b8\0\u0210"+
    "\0\u17fa\0\u018c\0\u018c\0\u018c\0\u018c\0\u018c\0\u018c\0\u018c"+
    "\0\u018c\0\u018c\0\u183c\0\u187e\0\u018c\0\u018c\0\u18c0\0\u1902"+
    "\0\u1944\0\u1986\0\u018c\0\u018c\0\u19c8\0\u018c\0\u1a0a\0\u018c"+
    "\0\u1a4c\0\u1a8e\0\u1ad0\0\u1b12\0\u1b12\0\u018c\0\u1b54\0\u1b96"+
    "\0\u1bd8\0\u1c1a\0\u018c\0\u1c5c\0\u1c9e\0\u1ce0\0\u1d22\0\u0210"+
    "\0\u1d64\0\u1da6\0\u1de8\0\u1e2a\0\u018c\0\u1e6c\0\u1eae\0\u1ef0"+
    "\0\u1f32\0\u1f74\0\u1fb6\0\u1ff8\0\u203a\0\u0210\0\u207c\0\u0210"+
    "\0\u20be\0\u0210\0\u0210\0\u018c\0\u2100\0\u2142\0\u1902\0\u018c"+
    "\0\u2184\0\u018c\0\u018c\0\u018c\0\u018c\0\u21c6\0\u2208\0\u2208"+
    "\0\u0210\0\u224a\0\u228c\0\u0210\0\u22ce\0\u2310\0\u2352\0\u0210"+
    "\0\u2394\0\u23d6\0\u2418\0\u0210\0\u245a\0\u249c\0\u24de\0\u0210"+
    "\0\u2520\0\u0210\0\u018c\0\u2562\0\u0ce4\0\u0210\0\u25a4\0\u0210"+
    "\0\u0210\0\u25e6\0\u0210\0\u2628\0\u266a\0\u26ac\0\u0210\0\u0210"+
    "\0\u0210\0\u26ee\0\u2730\0\u2772\0\u27b4\0\u0210\0\u0210\0\u27f6"+
    "\0\u0210\0\u2838\0\u287a\0\u0210\0\u0210";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[237];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\7\1\10\1\11\1\12\1\11\1\7\1\13\1\12"+
    "\1\14\1\15\1\16\1\17\1\20\1\21\3\11\1\22"+
    "\2\11\1\23\1\11\1\24\1\7\1\11\1\25\1\26"+
    "\1\27\1\11\1\30\1\31\1\32\1\33\1\11\1\34"+
    "\1\35\1\36\1\11\1\37\1\40\1\41\2\11\1\42"+
    "\1\43\1\11\1\44\1\45\1\46\1\47\1\50\1\51"+
    "\1\52\1\53\1\54\1\55\1\56\1\57\1\60\1\61"+
    "\1\62\1\63\1\64\1\65\1\66\1\67\7\70\1\71"+
    "\1\72\16\70\1\73\1\70\1\74\57\70\1\75\1\72"+
    "\16\70\1\75\1\70\1\76\50\70\2\7\1\77\1\7"+
    "\1\77\1\7\1\100\1\0\6\7\3\77\1\7\2\77"+
    "\1\7\1\77\2\7\1\77\2\7\1\101\3\77\2\7"+
    "\22\77\17\7\12\102\1\103\25\102\1\104\41\102\1\7"+
    "\1\10\1\11\1\12\1\11\1\7\1\13\1\12\1\14"+
    "\1\15\1\16\1\17\1\20\1\21\3\11\1\22\2\11"+
    "\1\23\1\11\1\24\1\7\1\11\1\25\1\105\1\27"+
    "\1\11\1\30\1\31\1\106\1\33\1\11\1\34\1\35"+
    "\1\36\1\11\1\37\1\40\1\41\2\11\1\42\1\43"+
    "\1\11\1\44\1\45\1\46\1\47\1\50\1\51\1\52"+
    "\1\53\1\54\1\55\1\56\1\57\1\60\1\61\1\62"+
    "\1\63\1\64\1\65\1\66\1\67\103\0\1\10\13\0"+
    "\1\10\2\0\1\107\1\110\1\111\1\112\17\0\1\112"+
    "\1\0\1\107\11\0\1\111\23\0\2\11\1\0\2\11"+
    "\7\0\4\11\1\0\2\11\1\0\1\11\2\0\1\11"+
    "\2\0\4\11\2\0\22\11\22\0\1\12\3\0\1\12"+
    "\72\0\6\113\2\0\72\113\2\0\1\114\1\0\1\114"+
    "\1\0\1\115\7\0\3\114\1\0\2\114\1\0\1\114"+
    "\2\0\1\114\2\0\4\114\2\0\22\114\21\0\1\116"+
    "\1\0\1\116\1\0\1\117\7\0\3\116\1\0\2\116"+
    "\1\0\1\116\2\0\1\116\2\0\4\116\2\0\22\116"+
    "\31\0\1\120\25\0\1\121\22\0\1\122\32\0\1\123"+
    "\122\0\1\124\25\0\1\125\17\0\1\126\13\0\1\126"+
    "\1\127\1\130\1\107\1\110\1\111\1\112\17\0\1\112"+
    "\1\0\1\107\6\0\1\130\2\0\1\111\23\0\1\131"+
    "\13\0\1\131\3\0\1\132\104\0\1\133\36\0\1\134"+
    "\3\0\1\135\12\0\7\24\1\0\16\24\1\136\1\137"+
    "\52\24\31\0\1\140\51\0\2\11\1\0\2\11\7\0"+
    "\4\11\1\0\2\11\1\0\1\11\2\0\1\11\2\0"+
    "\1\11\1\141\2\11\2\0\1\142\11\11\1\143\7\11"+
    "\20\0\2\11\1\0\2\11\7\0\4\11\1\0\2\11"+
    "\1\0\1\11\2\0\1\11\2\0\3\11\1\144\2\0"+
    "\7\11\1\145\6\11\1\146\3\11\20\0\2\11\1\0"+
    "\2\11\7\0\4\11\1\0\2\11\1\0\1\11\2\0"+
    "\1\147\2\0\4\11\2\0\22\11\102\0\1\150\17\0"+
    "\2\11\1\0\2\11\7\0\4\11\1\0\2\11\1\0"+
    "\1\11\2\0\1\11\2\0\4\11\2\0\3\11\1\151"+
    "\16\11\20\0\2\11\1\0\2\11\7\0\4\11\1\0"+
    "\2\11\1\0\1\11\2\0\1\11\2\0\4\11\2\0"+
    "\4\11\1\152\15\11\20\0\2\11\1\0\2\11\7\0"+
    "\4\11\1\0\2\11\1\0\1\11\2\0\1\11\2\0"+
    "\3\11\1\153\2\0\22\11\20\0\2\11\1\0\2\11"+
    "\7\0\4\11\1\0\2\11\1\0\1\11\2\0\1\11"+
    "\2\0\4\11\2\0\4\11\1\154\1\11\1\155\13\11"+
    "\20\0\2\11\1\0\2\11\7\0\4\11\1\0\2\11"+
    "\1\0\1\11\2\0\1\11\2\0\4\11\2\0\13\11"+
    "\1\156\6\11\20\0\2\11\1\0\2\11\7\0\4\11"+
    "\1\0\2\11\1\0\1\11\2\0\1\157\2\0\4\11"+
    "\2\0\22\11\20\0\2\11\1\0\2\11\7\0\4\11"+
    "\1\0\2\11\1\0\1\11\2\0\1\11\2\0\4\11"+
    "\2\0\2\11\1\160\17\11\20\0\2\11\1\0\2\11"+
    "\7\0\4\11\1\0\2\11\1\0\1\11\2\0\1\11"+
    "\2\0\4\11\2\0\12\11\1\161\7\11\20\0\2\11"+
    "\1\0\2\11\7\0\4\11\1\0\2\11\1\0\1\11"+
    "\2\0\1\11\2\0\1\11\1\162\2\11\2\0\22\11"+
    "\20\0\2\11\1\0\2\11\7\0\4\11\1\0\2\11"+
    "\1\0\1\11\2\0\1\163\2\0\4\11\2\0\3\11"+
    "\1\164\2\11\1\165\13\11\20\0\2\11\1\0\2\11"+
    "\7\0\4\11\1\0\2\11\1\0\1\11\2\0\1\11"+
    "\2\0\1\11\1\166\2\11\2\0\22\11\20\0\2\11"+
    "\1\0\2\11\7\0\4\11\1\0\2\11\1\0\1\11"+
    "\2\0\1\11\2\0\4\11\2\0\3\11\1\167\16\11"+
    "\20\0\2\11\1\0\2\11\7\0\4\11\1\0\2\11"+
    "\1\0\1\11\2\0\1\11\2\0\4\11\2\0\6\11"+
    "\1\170\13\11\102\0\1\171\3\0\1\172\75\0\1\173"+
    "\1\0\1\174\77\0\1\175\101\0\1\176\106\0\1\177"+
    "\102\0\1\200\73\0\1\201\111\0\1\202\6\0\7\70"+
    "\2\0\16\70\1\0\1\70\1\0\50\70\2\0\1\203"+
    "\1\0\1\203\1\0\1\204\7\0\3\203\1\0\2\203"+
    "\1\0\1\203\2\0\1\203\1\0\1\205\4\203\2\0"+
    "\22\203\17\0\7\206\1\0\20\206\1\207\51\206\31\0"+
    "\1\210\51\0\2\77\1\0\2\77\7\0\4\77\1\0"+
    "\2\77\1\0\1\77\2\0\1\77\2\0\4\77\2\0"+
    "\22\77\17\0\6\211\2\0\72\211\1\0\2\77\1\0"+
    "\2\77\7\0\4\77\1\0\2\77\1\0\1\77\2\0"+
    "\1\77\2\0\1\77\1\212\2\77\2\0\22\77\57\0"+
    "\1\213\53\0\1\214\110\0\1\215\61\0\1\131\13\0"+
    "\1\131\3\0\1\216\61\0\1\217\13\0\1\217\4\0"+
    "\1\111\1\0\1\217\32\0\1\111\5\0\1\217\14\0"+
    "\6\113\1\220\1\0\72\113\1\0\2\114\1\0\2\114"+
    "\7\0\4\114\1\0\2\114\1\0\1\114\2\0\1\114"+
    "\2\0\4\114\2\0\22\114\17\0\6\221\2\0\72\221"+
    "\1\0\2\116\1\0\2\116\7\0\4\116\1\0\2\116"+
    "\1\0\1\116\2\0\1\116\2\0\4\116\2\0\22\116"+
    "\17\0\6\222\2\0\72\222\7\120\1\0\72\120\40\0"+
    "\1\223\41\0\7\123\1\0\72\123\36\0\1\224\11\0"+
    "\1\225\114\0\1\226\17\0\1\126\13\0\1\126\3\0"+
    "\1\227\1\111\1\112\17\0\1\112\13\0\1\111\23\0"+
    "\2\127\12\0\1\127\1\0\1\127\1\230\1\231\2\127"+
    "\1\0\1\232\14\0\1\232\2\127\1\230\1\127\5\0"+
    "\1\127\2\0\1\127\2\0\1\127\20\0\1\130\13\0"+
    "\1\130\2\0\1\107\1\215\23\0\1\107\35\0\1\131"+
    "\13\0\1\131\4\0\1\111\1\112\17\0\1\112\13\0"+
    "\1\111\22\0\7\24\1\0\72\24\31\0\1\233\51\0"+
    "\2\11\1\0\2\11\7\0\4\11\1\0\2\11\1\0"+
    "\1\11\2\0\1\11\2\0\2\11\1\234\1\11\2\0"+
    "\12\11\1\235\7\11\20\0\2\11\1\0\2\11\7\0"+
    "\4\11\1\0\2\11\1\0\1\11\2\0\1\11\2\0"+
    "\4\11\2\0\1\11\1\236\20\11\20\0\2\11\1\0"+
    "\2\11\7\0\4\11\1\0\2\11\1\0\1\11\2\0"+
    "\1\237\2\0\4\11\2\0\1\240\2\11\1\241\16\11"+
    "\20\0\2\11\1\0\2\11\7\0\4\11\1\0\2\11"+
    "\1\0\1\11\2\0\1\11\2\0\4\11\2\0\1\11"+
    "\1\242\20\11\20\0\2\11\1\0\2\11\7\0\4\11"+
    "\1\0\2\11\1\0\1\11\2\0\1\11\2\0\4\11"+
    "\2\0\5\11\1\243\14\11\20\0\2\11\1\0\2\11"+
    "\7\0\4\11\1\0\2\11\1\0\1\11\2\0\1\11"+
    "\2\0\3\11\1\244\2\0\22\11\20\0\2\11\1\0"+
    "\2\11\7\0\4\11\1\0\2\11\1\0\1\11\2\0"+
    "\1\11\2\0\4\11\2\0\22\11\1\0\1\245\16\0"+
    "\2\11\1\0\2\11\7\0\4\11\1\0\2\11\1\0"+
    "\1\11\2\0\1\11\2\0\4\11\2\0\3\11\1\246"+
    "\16\11\20\0\2\11\1\0\2\11\7\0\4\11\1\0"+
    "\2\11\1\0\1\11\2\0\1\11\2\0\4\11\2\0"+
    "\7\11\1\247\12\11\20\0\2\11\1\0\2\11\7\0"+
    "\4\11\1\0\2\11\1\0\1\11\2\0\1\11\2\0"+
    "\4\11\2\0\14\11\1\250\5\11\20\0\2\11\1\0"+
    "\2\11\7\0\4\11\1\0\2\11\1\0\1\11\2\0"+
    "\1\11\2\0\4\11\2\0\4\11\1\251\15\11\20\0"+
    "\2\11\1\0\2\11\7\0\4\11\1\0\2\11\1\0"+
    "\1\11\2\0\1\11\2\0\1\252\3\11\2\0\22\11"+
    "\20\0\2\11\1\0\2\11\7\0\4\11\1\0\2\11"+
    "\1\0\1\11\2\0\1\11\2\0\4\11\2\0\2\11"+
    "\1\253\17\11\20\0\2\11\1\0\2\11\7\0\4\11"+
    "\1\0\2\11\1\0\1\11\2\0\1\11\2\0\2\11"+
    "\1\254\1\11\2\0\2\11\1\255\17\11\20\0\2\11"+
    "\1\0\2\11\7\0\4\11\1\0\2\11\1\0\1\11"+
    "\2\0\1\11\2\0\4\11\2\0\7\11\1\256\12\11"+
    "\20\0\2\11\1\0\2\11\7\0\4\11\1\0\2\11"+
    "\1\0\1\11\2\0\1\11\2\0\4\11\2\0\4\11"+
    "\1\257\15\11\20\0\2\11\1\0\2\11\7\0\4\11"+
    "\1\0\2\11\1\0\1\11\2\0\1\11\2\0\4\11"+
    "\2\0\12\11\1\260\7\11\20\0\2\11\1\0\2\11"+
    "\7\0\4\11\1\0\2\11\1\0\1\11\2\0\1\11"+
    "\2\0\2\11\1\261\1\11\2\0\22\11\20\0\2\11"+
    "\1\0\2\11\7\0\4\11\1\0\2\11\1\0\1\11"+
    "\2\0\1\11\2\0\4\11\2\0\4\11\1\262\5\11"+
    "\1\263\7\11\102\0\1\264\17\0\2\203\1\0\2\203"+
    "\7\0\4\203\1\0\2\203\1\0\1\203\2\0\1\203"+
    "\2\0\4\203\2\0\22\203\17\0\6\265\2\0\72\265"+
    "\1\0\2\266\12\0\1\266\1\0\1\266\2\0\2\266"+
    "\17\0\2\266\1\0\1\266\5\0\1\266\2\0\1\266"+
    "\2\0\1\266\50\0\1\267\50\0\6\211\1\270\1\0"+
    "\72\211\1\0\2\77\1\0\2\77\7\0\4\77\1\0"+
    "\2\77\1\0\1\77\2\0\1\77\2\0\2\77\1\271"+
    "\1\77\2\0\22\77\40\0\1\216\61\0\1\217\13\0"+
    "\1\217\4\0\1\111\34\0\1\111\22\0\6\221\1\272"+
    "\1\0\72\221\6\222\1\273\1\0\72\222\12\0\1\274"+
    "\70\0\2\275\1\0\2\275\7\0\4\275\1\0\2\275"+
    "\1\0\1\275\2\0\1\275\2\0\4\275\2\0\22\275"+
    "\20\0\1\131\13\0\1\131\105\0\1\215\3\0\1\232"+
    "\14\0\1\232\40\0\2\276\12\0\1\276\1\0\1\276"+
    "\1\0\1\216\2\276\17\0\2\276\1\0\1\276\5\0"+
    "\1\276\2\0\1\276\2\0\1\276\20\0\1\277\13\0"+
    "\1\277\6\0\1\300\40\0\1\300\15\0\2\11\1\0"+
    "\2\11\7\0\4\11\1\0\2\11\1\0\1\11\2\0"+
    "\1\11\2\0\3\11\1\301\2\0\22\11\20\0\2\11"+
    "\1\0\2\11\7\0\4\11\1\0\2\11\1\0\1\11"+
    "\2\0\1\11\2\0\4\11\2\0\6\11\1\302\13\11"+
    "\20\0\2\11\1\0\2\11\7\0\4\11\1\0\2\11"+
    "\1\0\1\11\2\0\1\11\2\0\4\11\2\0\2\11"+
    "\1\303\17\11\20\0\2\11\1\0\2\11\7\0\4\11"+
    "\1\0\2\11\1\0\1\11\2\0\1\11\2\0\4\11"+
    "\2\0\2\11\1\304\17\11\20\0\2\11\1\0\2\11"+
    "\7\0\4\11\1\0\2\11\1\0\1\11\2\0\1\11"+
    "\2\0\2\11\1\305\1\11\2\0\22\11\20\0\2\11"+
    "\1\0\2\11\7\0\4\11\1\0\2\11\1\0\1\11"+
    "\2\0\1\11\2\0\4\11\2\0\2\11\1\306\17\11"+
    "\20\0\2\11\1\0\2\11\7\0\4\11\1\0\2\11"+
    "\1\0\1\11\2\0\1\11\2\0\4\11\2\0\10\11"+
    "\1\307\11\11\20\0\2\11\1\0\2\11\7\0\4\11"+
    "\1\0\2\11\1\0\1\11\2\0\1\11\2\0\4\11"+
    "\2\0\2\11\1\310\17\11\20\0\2\11\1\0\2\11"+
    "\7\0\4\11\1\0\2\11\1\0\1\11\2\0\1\11"+
    "\2\0\3\11\1\311\2\0\22\11\20\0\2\11\1\0"+
    "\2\11\7\0\4\11\1\0\2\11\1\0\1\11\2\0"+
    "\1\11\2\0\1\312\3\11\2\0\22\11\20\0\2\11"+
    "\1\0\2\11\7\0\4\11\1\0\2\11\1\0\1\11"+
    "\2\0\1\11\2\0\4\11\2\0\2\11\1\313\17\11"+
    "\20\0\2\11\1\0\2\11\7\0\4\11\1\0\2\11"+
    "\1\0\1\11\2\0\1\11\2\0\4\11\2\0\4\11"+
    "\1\314\15\11\20\0\2\11\1\0\2\11\7\0\4\11"+
    "\1\0\2\11\1\0\1\11\2\0\1\315\2\0\4\11"+
    "\2\0\22\11\20\0\2\11\1\0\2\11\7\0\4\11"+
    "\1\0\2\11\1\0\1\11\2\0\1\11\2\0\4\11"+
    "\2\0\3\11\1\316\16\11\20\0\2\11\1\0\2\11"+
    "\7\0\4\11\1\0\2\11\1\0\1\11\2\0\1\11"+
    "\2\0\4\11\2\0\4\11\1\317\15\11\20\0\2\11"+
    "\1\0\2\11\7\0\4\11\1\0\2\11\1\0\1\11"+
    "\2\0\1\11\2\0\4\11\2\0\7\11\1\320\12\11"+
    "\20\0\2\11\1\0\2\11\7\0\4\11\1\0\2\11"+
    "\1\0\1\11\2\0\1\11\2\0\3\11\1\321\2\0"+
    "\22\11\20\0\2\11\1\0\2\11\7\0\4\11\1\0"+
    "\2\11\1\0\1\11\2\0\1\11\2\0\3\11\1\322"+
    "\2\0\22\11\17\0\6\265\1\323\1\0\72\265\1\0"+
    "\2\324\12\0\1\324\1\0\1\324\2\0\2\324\17\0"+
    "\2\324\1\0\1\324\5\0\1\324\2\0\1\324\2\0"+
    "\1\324\20\0\2\77\1\0\2\77\7\0\4\77\1\0"+
    "\2\77\1\0\1\77\2\0\1\77\2\0\3\77\1\325"+
    "\2\0\22\77\20\0\2\276\12\0\1\276\1\0\1\276"+
    "\2\0\2\276\1\0\1\232\14\0\1\232\2\276\1\0"+
    "\1\276\5\0\1\276\2\0\1\276\2\0\1\276\20\0"+
    "\1\277\13\0\1\277\65\0\2\11\1\0\2\11\7\0"+
    "\4\11\1\0\2\11\1\0\1\11\2\0\1\11\2\0"+
    "\4\11\2\0\15\11\1\326\4\11\20\0\2\11\1\0"+
    "\2\11\7\0\4\11\1\0\2\11\1\0\1\11\2\0"+
    "\1\11\2\0\4\11\2\0\3\11\1\327\16\11\20\0"+
    "\2\11\1\0\2\11\7\0\4\11\1\0\2\11\1\0"+
    "\1\11\2\0\1\11\2\0\1\330\3\11\2\0\22\11"+
    "\20\0\2\11\1\0\2\11\7\0\4\11\1\0\2\11"+
    "\1\0\1\11\2\0\1\11\2\0\4\11\2\0\12\11"+
    "\1\331\7\11\20\0\2\11\1\0\2\11\7\0\4\11"+
    "\1\0\2\11\1\0\1\11\2\0\1\11\2\0\4\11"+
    "\2\0\3\11\1\332\16\11\20\0\2\11\1\0\2\11"+
    "\7\0\4\11\1\0\2\11\1\0\1\11\2\0\1\11"+
    "\2\0\3\11\1\333\2\0\22\11\20\0\2\11\1\0"+
    "\2\11\7\0\4\11\1\0\2\11\1\0\1\11\2\0"+
    "\1\11\2\0\2\11\1\334\1\11\2\0\22\11\20\0"+
    "\2\11\1\0\2\11\7\0\4\11\1\0\2\11\1\0"+
    "\1\11\2\0\1\11\2\0\4\11\2\0\5\11\1\335"+
    "\14\11\20\0\2\11\1\0\2\11\7\0\4\11\1\0"+
    "\2\11\1\0\1\11\2\0\1\11\2\0\4\11\2\0"+
    "\12\11\1\336\7\11\20\0\2\11\1\0\2\11\7\0"+
    "\4\11\1\0\2\11\1\0\1\11\2\0\1\11\2\0"+
    "\4\11\2\0\10\11\1\337\11\11\20\0\2\11\1\0"+
    "\2\11\7\0\4\11\1\0\2\11\1\0\1\11\2\0"+
    "\1\11\2\0\4\11\2\0\2\11\1\340\17\11\20\0"+
    "\2\11\1\0\2\11\7\0\4\11\1\0\2\11\1\0"+
    "\1\11\2\0\1\11\2\0\4\11\2\0\2\11\1\341"+
    "\17\11\20\0\2\342\12\0\1\342\1\0\1\342\2\0"+
    "\2\342\17\0\2\342\1\0\1\342\5\0\1\342\2\0"+
    "\1\342\2\0\1\342\20\0\2\11\1\0\2\11\7\0"+
    "\4\11\1\0\2\11\1\0\1\11\2\0\1\11\2\0"+
    "\4\11\2\0\4\11\1\343\15\11\20\0\2\11\1\0"+
    "\2\11\7\0\4\11\1\0\2\11\1\0\1\11\2\0"+
    "\1\11\2\0\4\11\2\0\11\11\1\344\10\11\20\0"+
    "\2\11\1\0\2\11\7\0\4\11\1\0\2\11\1\0"+
    "\1\11\2\0\1\11\2\0\4\11\2\0\7\11\1\345"+
    "\12\11\20\0\2\11\1\0\2\11\7\0\4\11\1\0"+
    "\2\11\1\0\1\11\2\0\1\11\2\0\1\346\3\11"+
    "\2\0\22\11\20\0\2\11\1\0\2\11\7\0\4\11"+
    "\1\0\2\11\1\0\1\11\2\0\1\11\2\0\4\11"+
    "\2\0\7\11\1\347\12\11\20\0\2\206\12\0\1\206"+
    "\1\0\1\206\2\0\2\206\17\0\2\206\1\0\1\206"+
    "\5\0\1\206\2\0\1\206\2\0\1\206\20\0\2\11"+
    "\1\0\2\11\7\0\4\11\1\0\2\11\1\0\1\11"+
    "\2\0\1\11\2\0\2\11\1\350\1\11\2\0\22\11"+
    "\20\0\2\11\1\0\2\11\7\0\4\11\1\0\2\11"+
    "\1\0\1\11\2\0\1\11\2\0\4\11\2\0\2\11"+
    "\1\351\17\11\20\0\2\11\1\0\2\11\7\0\4\11"+
    "\1\0\2\11\1\0\1\11\2\0\1\352\2\0\4\11"+
    "\2\0\22\11\20\0\2\11\1\0\2\11\7\0\4\11"+
    "\1\0\2\11\1\0\1\11\2\0\1\11\2\0\4\11"+
    "\2\0\3\11\1\353\16\11\20\0\2\11\1\0\2\11"+
    "\7\0\4\11\1\0\2\11\1\0\1\11\2\0\1\11"+
    "\2\0\4\11\2\0\2\11\1\354\17\11\20\0\2\11"+
    "\1\0\2\11\7\0\4\11\1\0\2\11\1\0\1\11"+
    "\2\0\1\11\2\0\3\11\1\355\2\0\22\11\17\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[10428];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;
  private static final char[] EMPTY_BUFFER = new char[0];
  private static final int YYEOF = -1;
  private static java.io.Reader zzReader = null; // Fake

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\6\0\1\11\16\1\1\11\3\1\1\11\17\1\1\11"+
    "\7\1\6\11\1\1\1\11\2\1\2\11\4\1\1\11"+
    "\2\1\2\11\1\1\1\0\1\11\1\1\1\0\1\1"+
    "\1\0\1\1\1\0\2\1\1\11\1\1\1\0\1\1"+
    "\1\0\3\1\5\11\1\1\1\0\7\1\1\11\21\1"+
    "\11\11\1\1\1\0\2\11\1\1\2\0\1\1\2\11"+
    "\1\0\1\11\1\1\1\11\2\0\3\1\1\11\1\0"+
    "\1\1\2\0\1\11\11\1\1\11\16\1\1\11\2\0"+
    "\1\1\1\11\1\1\4\11\2\1\1\0\22\1\1\11"+
    "\1\0\15\1\1\0\13\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[237];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** this buffer may contains the current text array to be matched when it is cheap to acquire it */
  private char[] zzBufferArray;

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    private static final class State {
        final int lBraceCount;
        final int state;

        public State(int state, int lBraceCount) {
            this.state = state;
            this.lBraceCount = lBraceCount;
        }

        @Override
        public String toString() {
            return "yystate = " + state + (lBraceCount == 0 ? "" : "lBraceCount = " + lBraceCount);
        }
    }

    private final Stack<State> states = new Stack<State>();
    private int lBraceCount;
    
    private int commentStart;
    private int commentDepth;

    private void pushState(int state) {
        states.push(new State(yystate(), lBraceCount));
        lBraceCount = 0;
        yybegin(state);
    }

    private void popState() {
        State state = states.pop();
        lBraceCount = state.lBraceCount;
        yybegin(state.state);
    }

    private IElementType commentStateToTokenType(int state) {
        switch (state) {
            case BLOCK_COMMENT:
                return JetTokens.BLOCK_COMMENT;
            case DOC_COMMENT:
                return JetTokens.DOC_COMMENT;
            default:
                throw new IllegalArgumentException("Unexpected state: " + state);
        }
    }


  _JetLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  _JetLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1330) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart(){
    return zzStartRead;
  }

  public final int getTokenEnd(){
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end,int initialState){
    zzBuffer = buffer;
    zzBufferArray = com.intellij.util.text.CharArrayUtil.fromSequenceWithoutCopying(buffer);
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzPushbackPos = 0;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBufferArray != null ? zzBufferArray[zzStartRead+pos]:zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) throws KotlinLexerException {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new KotlinLexerException(message + "\n at '" + yytext() + "'\n" + zzBuffer);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  throws KotlinLexerException {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() {
    if (!zzEOFDone) {
      zzEOFDone = true;
      return;

    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException, KotlinLexerException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;
    char[] zzBufferArrayL = zzBufferArray;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = (zzBufferArrayL != null ? zzBufferArrayL[zzCurrentPosL++] : zzBufferL.charAt(zzCurrentPosL++));
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = (zzBufferArrayL != null ? zzBufferArrayL[zzCurrentPosL++] : zzBufferL.charAt(zzCurrentPosL++));
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 102: 
          { return JetTokens.TYPE_ALIAS_KEYWORD ;
          }
        case 103: break;
        case 3: 
          { return JetTokens.IDENTIFIER;
          }
        case 104: break;
        case 12: 
          { pushState(STRING); return JetTokens.OPEN_QUOTE;
          }
        case 105: break;
        case 77: 
          { return JetTokens.FOR_KEYWORD ;
          }
        case 106: break;
        case 99: 
          { return JetTokens.RETURN_KEYWORD ;
          }
        case 107: break;
        case 87: 
          { return JetTokens.NULL_KEYWORD ;
          }
        case 108: break;
        case 35: 
          { if (lBraceCount == 0) {
                                             popState();
                                             return JetTokens.LONG_TEMPLATE_ENTRY_END;
                                           }
                                           lBraceCount--;
                                           return JetTokens.RBRACE;
          }
        case 109: break;
        case 19: 
          { return JetTokens.LT        ;
          }
        case 110: break;
        case 52: 
          { return JetTokens.DO_KEYWORD ;
          }
        case 111: break;
        case 18: 
          { return JetTokens.PLUS      ;
          }
        case 112: break;
        case 55: 
          { return JetTokens.PLUSEQ    ;
          }
        case 113: break;
        case 90: 
          { popState(); return JetTokens.THIS_KEYWORD;
          }
        case 114: break;
        case 28: 
          { return JetTokens.COMMA     ;
          }
        case 115: break;
        case 20: 
          { return JetTokens.GT        ;
          }
        case 116: break;
        case 4: 
          { return JetTokens.WHITE_SPACE;
          }
        case 117: break;
        case 26: 
          { return JetTokens.RPAR      ;
          }
        case 118: break;
        case 54: 
          { return JetTokens.DOUBLE_ARROW;
          }
        case 119: break;
        case 85: 
          { return JetTokens.TRUE_KEYWORD ;
          }
        case 120: break;
        case 37: 
          { return JetTokens.FIELD_IDENTIFIER;
          }
        case 121: break;
        case 59: 
          { return JetTokens.ANDAND    ;
          }
        case 122: break;
        case 64: 
          { pushState(LONG_TEMPLATE_ENTRY); return JetTokens.LONG_TEMPLATE_ENTRY_START;
          }
        case 123: break;
        case 36: 
          { return JetTokens.FLOAT_LITERAL;
          }
        case 124: break;
        case 38: 
          { return JetTokens.EOL_COMMENT;
          }
        case 125: break;
        case 88: 
          { return JetTokens.WHEN_KEYWORD ;
          }
        case 126: break;
        case 73: 
          { pushState(RAW_STRING); return JetTokens.OPEN_QUOTE;
          }
        case 127: break;
        case 22: 
          { return JetTokens.COLON     ;
          }
        case 128: break;
        case 57: 
          { return JetTokens.LTEQ      ;
          }
        case 129: break;
        case 46: 
          { return JetTokens.ARROW     ;
          }
        case 130: break;
        case 32: 
          { popState(); return JetTokens.IDENTIFIER;
          }
        case 131: break;
        case 23: 
          { return JetTokens.LBRACKET  ;
          }
        case 132: break;
        case 68: 
          { yypushback(2); return JetTokens.INTEGER_LITERAL;
          }
        case 133: break;
        case 11: 
          { return JetTokens.CHARACTER_LITERAL;
          }
        case 134: break;
        case 79: 
          { return JetTokens.VAR_KEYWORD ;
          }
        case 135: break;
        case 58: 
          { return JetTokens.GTEQ      ;
          }
        case 136: break;
        case 2: 
          { return JetTokens.INTEGER_LITERAL;
          }
        case 137: break;
        case 14: 
          { return JetTokens.RBRACE    ;
          }
        case 138: break;
        case 94: 
          { return JetTokens.CLASS_KEYWORD ;
          }
        case 139: break;
        case 74: 
          { return JetTokens.TRY_KEYWORD ;
          }
        case 140: break;
        case 8: 
          { return JetTokens.EXCL      ;
          }
        case 141: break;
        case 42: 
          { return JetTokens.EXCLEQ    ;
          }
        case 142: break;
        case 45: 
          { return JetTokens.MINUSEQ   ;
          }
        case 143: break;
        case 100: 
          { return JetTokens.PACKAGE_KEYWORD ;
          }
        case 144: break;
        case 91: 
          { return JetTokens.THROW_KEYWORD ;
          }
        case 145: break;
        case 93: 
          { return JetTokens.SUPER_KEYWORD ;
          }
        case 146: break;
        case 67: 
          { if (commentDepth > 0) {
            commentDepth--;
        }
        else {
             int state = yystate();
             popState();
             zzStartRead = commentStart;
             return commentStateToTokenType(state);
        }
          }
        case 147: break;
        case 96: 
          { return JetTokens.WHILE_KEYWORD ;
          }
        case 148: break;
        case 44: 
          { return JetTokens.MINUSMINUS;
          }
        case 149: break;
        case 101: 
          { return JetTokens.CONTINUE_KEYWORD ;
          }
        case 150: break;
        case 71: 
          { return JetTokens.NOT_IN;
          }
        case 151: break;
        case 6: 
          { return JetTokens.DIV       ;
          }
        case 152: break;
        case 81: 
          { int length = yytext().length();
                                    if (length <= 3) { // closing """
                                        popState();
                                        return JetTokens.CLOSING_QUOTE;
                                    }
                                    else { // some quotes at the end of a string, e.g. """ "foo""""
                                        yypushback(3); // return the closing quotes (""") to the stream
                                        return JetTokens.REGULAR_STRING_PART;
                                    }
          }
        case 153: break;
        case 5: 
          { return JetTokens.LABEL_IDENTIFIER;
          }
        case 154: break;
        case 29: 
          { return JetTokens.REGULAR_STRING_PART;
          }
        case 155: break;
        case 17: 
          { return JetTokens.QUEST     ;
          }
        case 156: break;
        case 69: 
          { pushState(DOC_COMMENT);
    commentDepth = 0;
    commentStart = getTokenStart();
          }
        case 157: break;
        case 60: 
          { return JetTokens.OROR      ;
          }
        case 158: break;
        case 21: 
          { return JetTokens.PERC      ;
          }
        case 159: break;
        case 72: 
          { return JetTokens.EXCLEQEQEQ;
          }
        case 160: break;
        case 61: 
          { return JetTokens.PERCEQ    ;
          }
        case 161: break;
        case 43: 
          { return JetTokens.RANGE     ;
          }
        case 162: break;
        case 1: 
          { return TokenType.BAD_CHARACTER;
          }
        case 163: break;
        case 63: 
          { pushState(SHORT_TEMPLATE_ENTRY);
                                                        yypushback(yylength() - 1);
                                                        return JetTokens.SHORT_TEMPLATE_ENTRY_START;
          }
        case 164: break;
        case 70: 
          { return JetTokens.NOT_IS;
          }
        case 165: break;
        case 15: 
          { return JetTokens.MUL       ;
          }
        case 166: break;
        case 24: 
          { return JetTokens.RBRACKET  ;
          }
        case 167: break;
        case 56: 
          { return JetTokens.PLUSPLUS  ;
          }
        case 168: break;
        case 39: 
          { pushState(BLOCK_COMMENT);
    commentDepth = 0;
    commentStart = getTokenStart();
          }
        case 169: break;
        case 84: 
          { return JetTokens.THIS_KEYWORD ;
          }
        case 170: break;
        case 9: 
          { return JetTokens.DOT       ;
          }
        case 171: break;
        case 27: 
          { return JetTokens.SEMICOLON ;
          }
        case 172: break;
        case 49: 
          { return JetTokens.IF_KEYWORD ;
          }
        case 173: break;
        case 65: 
          { return JetTokens.ESCAPE_SEQUENCE;
          }
        case 174: break;
        case 31: 
          { popState(); return JetTokens.CLOSING_QUOTE;
          }
        case 175: break;
        case 16: 
          { return JetTokens.EQ        ;
          }
        case 176: break;
        case 75: 
          { return JetTokens.AS_SAFE;
          }
        case 177: break;
        case 25: 
          { return JetTokens.LPAR      ;
          }
        case 178: break;
        case 10: 
          { return JetTokens.MINUS     ;
          }
        case 179: break;
        case 97: 
          { return JetTokens.FALSE_KEYWORD ;
          }
        case 180: break;
        case 66: 
          { commentDepth++;
          }
        case 181: break;
        case 76: 
          { return JetTokens.FUN_KEYWORD ;
          }
        case 182: break;
        case 47: 
          { return JetTokens.IS_KEYWORD ;
          }
        case 183: break;
        case 30: 
          { popState(); yypushback(1); return JetTokens.DANGLING_NEWLINE;
          }
        case 184: break;
        case 34: 
          { lBraceCount++; return JetTokens.LBRACE;
          }
        case 185: break;
        case 83: 
          { yypushback(3); return JetTokens.EXCL;
          }
        case 186: break;
        case 40: 
          { return JetTokens.DIVEQ     ;
          }
        case 187: break;
        case 86: 
          { return JetTokens.ELSE_KEYWORD ;
          }
        case 188: break;
        case 51: 
          { return JetTokens.AS_KEYWORD ;
          }
        case 189: break;
        case 48: 
          { return JetTokens.IN_KEYWORD ;
          }
        case 190: break;
        case 53: 
          { return JetTokens.EQEQ      ;
          }
        case 191: break;
        case 80: 
          { return JetTokens.EQEQEQ    ;
          }
        case 192: break;
        case 78: 
          { return JetTokens.VAL_KEYWORD ;
          }
        case 193: break;
        case 89: 
          { return JetTokens.CAPITALIZED_THIS_KEYWORD ;
          }
        case 194: break;
        case 50: 
          { return JetTokens.MULTEQ    ;
          }
        case 195: break;
        case 41: 
          { if (zzCurrentPos == 0) {
                return JetTokens.SHEBANG_COMMENT;
            }
            else {
                yypushback(yylength() - 1);
                return JetTokens.HASH;
            }
          }
        case 196: break;
        case 13: 
          { return JetTokens.LBRACE    ;
          }
        case 197: break;
        case 98: 
          { return JetTokens.OBJECT_KEYWORD ;
          }
        case 198: break;
        case 95: 
          { return JetTokens.BREAK_KEYWORD ;
          }
        case 199: break;
        case 82: 
          { return JetTokens.BLOCK_COMMENT;
          }
        case 200: break;
        case 92: 
          { return JetTokens.TRAIT_KEYWORD ;
          }
        case 201: break;
        case 62: 
          { return JetTokens.COLONCOLON;
          }
        case 202: break;
        case 33: 
          { 
          }
        case 203: break;
        case 7: 
          { return JetTokens.HASH      ;
          }
        case 204: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
            switch (zzLexicalState) {
            case BLOCK_COMMENT: {
              int state = yystate();
        popState();
        zzStartRead = commentStart;
        return commentStateToTokenType(state);
            }
            case 238: break;
            case DOC_COMMENT: {
              int state = yystate();
        popState();
        zzStartRead = commentStart;
        return commentStateToTokenType(state);
            }
            case 239: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
