/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.text.StringUtilRt;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class Comparing {
    public static <T> boolean equal(@Nullable T arg1, @Nullable T arg2) {
        if (arg1 == arg2) {
            return true;
        }
        if (arg1 == null || arg2 == null) {
            return false;
        }
        if (arg1 instanceof Object[] && arg2 instanceof Object[]) {
            Object[] arr1 = (Object[])arg1;
            Object[] arr2 = (Object[])arg2;
            return Arrays.equals(arr1, arr2);
        }
        if (arg1 instanceof CharSequence && arg2 instanceof CharSequence) {
            return Comparing.equal((CharSequence)arg1, (CharSequence)arg2, true);
        }
        return arg1.equals(arg2);
    }

    public static boolean equal(@Nullable String arg1, @Nullable String arg2) {
        return arg1 == null ? arg2 == null : arg1.equals(arg2);
    }

    public static boolean equal(@Nullable CharSequence s1, @Nullable CharSequence s2, boolean caseSensitive) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        int to = 0;
        int po = 0;
        int len = s1.length();
        while (len-- > 0) {
            char c2;
            char c1;
            if ((c1 = s1.charAt(to++)) == (c2 = s2.charAt(po++)) || !caseSensitive && StringUtilRt.charsEqualIgnoreCase(c1, c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(@Nullable String arg1, @Nullable String arg2, boolean caseSensitive) {
        if (arg1 == null || arg2 == null) {
            return arg1 == arg2;
        }
        return caseSensitive ? arg1.equals(arg2) : arg1.equalsIgnoreCase(arg2);
    }

    public static boolean strEqual(@Nullable String arg1, @Nullable String arg2) {
        return Comparing.strEqual(arg1, arg2, true);
    }

    public static boolean strEqual(@Nullable String arg1, @Nullable String arg2, boolean caseSensitive) {
        return Comparing.equal(arg1 == null ? "" : arg1, arg2 == null ? "" : arg2, caseSensitive);
    }

    public static int compare(double o1, double o2) {
        return o1 < o2 ? -1 : (o1 == o2 ? 0 : 1);
    }
}

