/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassOwnerEx;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.JavaDummyHolderFactory;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiFacadeImpl
extends JavaPsiFacadeEx {
    private volatile PsiElementFinder[] myElementFinders;
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private volatile SoftReference<ConcurrentMap<String, PsiPackage>> myPackageCache;
    private final Project myProject;
    private final JavaFileManager myFileManager;

    public JavaPsiFacadeImpl(Project project, PsiManagerImpl psiManager, JavaFileManager javaFileManager, MessageBus bus) {
        this.myProject = project;
        this.myFileManager = javaFileManager;
        this.myConstantEvaluationHelper = new PsiConstantEvaluationHelperImpl();
        final PsiModificationTracker modificationTracker2 = psiManager.getModificationTracker();
        if (bus != null) {
            bus.connect().subscribe(PsiModificationTracker.TOPIC, new PsiModificationTracker.Listener(){
                private long lastTimeSeen = -1L;

                @Override
                public void modificationCountChanged() {
                    long now = modificationTracker2.getJavaStructureModificationCount();
                    if (this.lastTimeSeen != now) {
                        this.lastTimeSeen = now;
                        JavaPsiFacadeImpl.this.myPackageCache = null;
                    }
                }
            });
        }
        DummyHolderFactory.setFactory(new JavaDummyHolderFactory());
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClass"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClass"));
        }
        ProgressIndicatorProvider.checkCanceled();
        if (DumbService.getInstance(this.getProject()).isDumb()) {
            PsiClass[] classes2 = this.findClassesInDumbMode(qualifiedName, scope2);
            if (classes2.length != 0) {
                return classes2[0];
            }
            return null;
        }
        for (PsiElementFinder finder : this.finders()) {
            PsiClass aClass = finder.findClass(qualifiedName, scope2);
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    @NotNull
    private PsiClass[] findClassesInDumbMode(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
        }
        String packageName = StringUtil.getPackageName(qualifiedName);
        PsiPackage pkg = this.findPackage(packageName);
        String className = StringUtil.getShortName(qualifiedName);
        if (pkg == null && packageName.length() < qualifiedName.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope2);
            if (containingClasses.length == 1) {
                PsiClass[] psiClassArray = PsiElementFinder.filterByName(className, containingClasses[0].getInnerClasses());
                if (psiClassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null || !pkg.containsClassNamed(className)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = pkg.findClassByShortName(className, scope2);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
        }
        if (DumbService.getInstance(this.getProject()).isDumb()) {
            PsiClass[] psiClassArray = this.findClassesInDumbMode(qualifiedName, scope2);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
            }
            return psiClassArray;
        }
        SmartList classes2 = new SmartList();
        for (PsiElementFinder finder : this.finders()) {
            PsiClass[] finderClasses = finder.findClasses(qualifiedName, scope2);
            ContainerUtil.addAll(classes2, finderClasses);
        }
        PsiClass[] psiClassArray = classes2.toArray(new PsiClass[classes2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    private PsiElementFinder[] finders() {
        PsiElementFinder[] answer = this.myElementFinders;
        if (answer == null) {
            answer = this.calcFinders();
            this.myElementFinders = answer;
        }
        if (answer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "finders"));
        }
        return answer;
    }

    @NotNull
    private PsiElementFinder[] calcFinders() {
        ArrayList<PsiElementFinderImpl> elementFinders = new ArrayList<PsiElementFinderImpl>();
        elementFinders.add(new PsiElementFinderImpl());
        ContainerUtil.addAll(elementFinders, this.myProject.getExtensions(PsiElementFinder.EP_NAME));
        PsiElementFinder[] psiElementFinderArray = elementFinders.toArray(new PsiElementFinder[elementFinders.size()]);
        if (psiElementFinderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "calcFinders"));
        }
        return psiElementFinderArray;
    }

    @Override
    @NotNull
    public PsiConstantEvaluationHelper getConstantEvaluationHelper() {
        PsiConstantEvaluationHelper psiConstantEvaluationHelper = this.myConstantEvaluationHelper;
        if (psiConstantEvaluationHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getConstantEvaluationHelper"));
        }
        return psiConstantEvaluationHelper;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        PsiPackage aPackage;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findPackage"));
        }
        ConcurrentMap<String, PsiPackage> cache2 = SoftReference.dereference(this.myPackageCache);
        if (cache2 == null) {
            cache2 = new ConcurrentHashMap<String, PsiPackage>();
            this.myPackageCache = new SoftReference<ConcurrentHashMap<String, PsiPackage>>((ConcurrentHashMap<String, PsiPackage>)cache2);
        }
        if ((aPackage = (PsiPackage)cache2.get(qualifiedName)) != null) {
            return aPackage;
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            aPackage = finder.findPackage(qualifiedName);
            if (aPackage == null) continue;
            return ConcurrencyUtil.cacheOrGet(cache2, qualifiedName, aPackage);
        }
        return null;
    }

    @NotNull
    private PsiElementFinder[] filteredFinders() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        PsiElementFinder[] finders = this.finders();
        if (dumbService.isDumb()) {
            List<PsiElementFinder> list = dumbService.filterByDumbAwareness(Arrays.asList(finders));
            finders = list.toArray(new PsiElementFinder[list.size()]);
        }
        if (finders == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "filteredFinders"));
        }
        return finders;
    }

    @Override
    @NotNull
    public PsiJavaParserFacade getParserFacade() {
        PsiElementFactory psiElementFactory = this.getElementFactory();
        if (psiElementFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getParserFacade"));
        }
        return psiElementFactory;
    }

    @Override
    @NotNull
    public PsiResolveHelper getResolveHelper() {
        PsiResolveHelper psiResolveHelper = PsiResolveHelper.SERVICE.getInstance(this.myProject);
        if (psiResolveHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getResolveHelper"));
        }
        return psiResolveHelper;
    }

    @Override
    @NotNull
    public PsiNameHelper getNameHelper() {
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance(this.myProject);
        if (psiNameHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getNameHelper"));
        }
        return psiNameHelper;
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClassNames"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClassNames"));
        }
        THashSet<String> result2 = new THashSet<String>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            result2.addAll(finder.getClassNames(psiPackage, scope2));
        }
        THashSet<String> tHashSet = result2;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClassNames"));
        }
        return tHashSet;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClasses"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClasses"));
        }
        ArrayList result2 = null;
        for (PsiElementFinder finder : this.filteredFinders()) {
            PsiClass[] classes2 = finder.getClasses(psiPackage, scope2);
            if (classes2.length == 0) continue;
            if (result2 == null) {
                result2 = new ArrayList();
            }
            ContainerUtil.addAll(result2, classes2);
        }
        PsiClass[] psiClassArray = result2 == null ? PsiClass.EMPTY_ARRAY : result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClasses"));
        }
        return psiClassArray;
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2, @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "processPackageDirectories"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "processPackageDirectories"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/JavaPsiFacadeImpl", "processPackageDirectories"));
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            if (finder.processPackageDirectories(psiPackage, scope2, consumer, includeLibrarySources)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getSubPackages"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getSubPackages"));
        }
        LinkedHashSet result2 = new LinkedHashSet();
        for (PsiElementFinder finder : this.filteredFinders()) {
            PsiPackage[] packages = finder.getSubPackages(psiPackage, scope2);
            ContainerUtil.addAll(result2, packages);
        }
        PsiPackage[] psiPackageArray = result2.toArray(new PsiPackage[result2.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    public PsiClass[] findClassByShortName(String name, PsiPackage psiPackage, GlobalSearchScope scope2) {
        ArrayList result2 = null;
        for (PsiElementFinder finder : this.filteredFinders()) {
            PsiClass[] classes2 = finder.getClasses(name, psiPackage, scope2);
            if (classes2.length == 0) continue;
            if (result2 == null) {
                result2 = new ArrayList();
            }
            ContainerUtil.addAll(result2, classes2);
        }
        return result2 == null ? PsiClass.EMPTY_ARRAY : result2.toArray(new PsiClass[result2.size()]);
    }

    @Override
    public boolean isPartOfPackagePrefix(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "isPartOfPackagePrefix"));
        }
        Collection<String> packagePrefixes = this.myFileManager.getNonTrivialPackagePrefixes();
        for (String subpackageName : packagePrefixes) {
            if (!PsiNameHelper.isSubpackageOf(subpackageName, packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInPackage(@NotNull PsiElement element, @NotNull PsiPackage aPackage) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/JavaPsiFacadeImpl", "isInPackage"));
        }
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "isInPackage"));
        }
        PsiFile file = FileContextUtil.getContextFile(element);
        if (file instanceof JavaDummyHolder) {
            return ((JavaDummyHolder)file).isInPackage(aPackage);
        }
        if (file instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file).getPackageName();
            return packageName.equals(aPackage.getQualifiedName());
        }
        return false;
    }

    @Override
    public boolean arePackagesTheSame(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiFile file2;
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/psi/impl/JavaPsiFacadeImpl", "arePackagesTheSame"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/psi/impl/JavaPsiFacadeImpl", "arePackagesTheSame"));
        }
        PsiFile file1 = FileContextUtil.getContextFile(element1);
        if (Comparing.equal(file1, file2 = FileContextUtil.getContextFile(element2))) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder && file2 instanceof JavaDummyHolder) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder || file2 instanceof JavaDummyHolder) {
            JavaDummyHolder dummyHolder = (JavaDummyHolder)(file1 instanceof JavaDummyHolder ? file1 : file2);
            PsiFile other = file1 instanceof JavaDummyHolder ? file2 : file1;
            return dummyHolder.isSamePackage(other);
        }
        if (!(file1 instanceof PsiClassOwner)) {
            return false;
        }
        if (!(file2 instanceof PsiClassOwner)) {
            return false;
        }
        String package1 = ((PsiClassOwner)file1).getPackageName();
        String package2 = ((PsiClassOwner)file2).getPackageName();
        return Comparing.equal(package1, package2);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getProject"));
        }
        return project;
    }

    @Override
    @NotNull
    public PsiElementFactory getElementFactory() {
        PsiElementFactory psiElementFactory = PsiElementFactory.SERVICE.getInstance(this.myProject);
        if (psiElementFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getElementFactory"));
        }
        return psiElementFactory;
    }

    @Override
    public void setAssertOnFileLoadingFilter(@NotNull VirtualFileFilter filter, Disposable parentDisposable) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/impl/JavaPsiFacadeImpl", "setAssertOnFileLoadingFilter"));
        }
        ((PsiManagerImpl)PsiManager.getInstance(this.myProject)).setAssertOnFileLoadingFilter(filter, parentDisposable);
    }

    private class PsiElementFinderImpl
    extends PsiElementFinder
    implements DumbAware {
        private PsiElementFinderImpl() {
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "findClass"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "findClass"));
            }
            return JavaPsiFacadeImpl.this.myFileManager.findClass(qualifiedName, scope2);
        }

        @Override
        @NotNull
        public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "findClasses"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "findClasses"));
            }
            PsiClass[] psiClassArray = JavaPsiFacadeImpl.this.myFileManager.findClasses(qualifiedName, scope2);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "findClasses"));
            }
            return psiClassArray;
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "findPackage"));
            }
            return JavaPsiFacadeImpl.this.myFileManager.findPackage(qualifiedName);
        }

        @Override
        @NotNull
        public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
            if (psiPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getSubPackages"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getSubPackages"));
            }
            HashMap<String, PsiPackage> packagesMap = new HashMap<String, PsiPackage>();
            String qualifiedName = psiPackage.getQualifiedName();
            for (PsiDirectory dir : psiPackage.getDirectories(scope2)) {
                PsiDirectory[] subDirs;
                for (PsiDirectory subDir : subDirs = dir.getSubdirectories()) {
                    String subQualifiedName;
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subDir);
                    if (aPackage == null || !(subQualifiedName = aPackage.getQualifiedName()).startsWith(qualifiedName) || packagesMap.containsKey(subQualifiedName)) continue;
                    packagesMap.put(aPackage.getQualifiedName(), aPackage);
                }
            }
            packagesMap.remove(qualifiedName);
            PsiPackage[] psiPackageArray = packagesMap.values().toArray(new PsiPackage[packagesMap.size()]);
            if (psiPackageArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getSubPackages"));
            }
            return psiPackageArray;
        }

        @Override
        @NotNull
        public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
            if (psiPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClasses"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClasses"));
            }
            PsiClass[] psiClassArray = this.getClasses(null, psiPackage, scope2);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClasses"));
            }
            return psiClassArray;
        }

        @Override
        @NotNull
        public PsiClass[] getClasses(@Nullable String shortName, @NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope2) {
            if (psiPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClasses"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClasses"));
            }
            ArrayList<PsiClass> list = null;
            String packageName = psiPackage.getQualifiedName();
            for (PsiDirectory dir : psiPackage.getDirectories(scope2)) {
                PsiClass[] classes2 = JavaDirectoryService.getInstance().getClasses(dir);
                if (classes2.length == 0) continue;
                if (list == null) {
                    list = new ArrayList<PsiClass>();
                }
                for (PsiClass aClass : classes2) {
                    String qualifiedName = aClass.getQualifiedName();
                    if (qualifiedName != null) {
                        qualifiedName = StringUtil.getPackageName(qualifiedName);
                    }
                    if (!Comparing.strEqual(qualifiedName, packageName) || shortName != null && !shortName.equals(aClass.getName())) continue;
                    list.add(aClass);
                }
            }
            if (list == null) {
                if (PsiClass.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClasses"));
                }
                return PsiClass.EMPTY_ARRAY;
            }
            if (list.size() > 1) {
                ContainerUtil.quickSort(list, new Comparator<PsiClass>(){

                    @Override
                    public int compare(PsiClass o1, PsiClass o2) {
                        VirtualFile file1 = PsiUtilCore.getVirtualFile(o1);
                        VirtualFile file2 = PsiUtilCore.getVirtualFile(o2);
                        return file1 == null ? (file2 == null ? 0 : -1) : (file2 == null ? 1 : scope2.compare(file2, file1));
                    }
                });
            }
            PsiClass[] psiClassArray = list.toArray(new PsiClass[list.size()]);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClasses"));
            }
            return psiClassArray;
        }

        @Override
        @NotNull
        public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
            if (psiPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClassNames"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClassNames"));
            }
            HashSet<String> names2 = null;
            FileIndexFacade facade = FileIndexFacade.getInstance(JavaPsiFacadeImpl.this.myProject);
            for (PsiDirectory dir : psiPackage.getDirectories(scope2)) {
                for (PsiFile file : dir.getFiles()) {
                    Set<String> inFile;
                    VirtualFile vFile;
                    if (!(file instanceof PsiClassOwner) || file.getViewProvider().getLanguages().size() != 1 || (vFile = file.getVirtualFile()) != null && !(file instanceof PsiCompiledElement) && !facade.isInSourceContent(vFile) && (!scope2.isForceSearchingInLibrarySources() || !StubTreeLoader.getInstance().canHaveStub(vFile))) continue;
                    Set<String> set = inFile = file instanceof PsiClassOwnerEx ? ((PsiClassOwnerEx)file).getClassNames() : PsiElementFinderImpl.getClassNames(((PsiClassOwner)file).getClasses());
                    if (inFile.isEmpty()) continue;
                    if (names2 == null) {
                        names2 = new HashSet<String>();
                    }
                    names2.addAll(inFile);
                }
            }
            Set<String> set = names2 == null ? Collections.emptySet() : names2;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "getClassNames"));
            }
            return set;
        }

        @Override
        public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope2, final @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
            if (psiPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "processPackageDirectories"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "processPackageDirectories"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/JavaPsiFacadeImpl$PsiElementFinderImpl", "processPackageDirectories"));
            }
            final PsiManager psiManager = PsiManager.getInstance(JavaPsiFacadeImpl.this.getProject());
            return PackageIndex.getInstance(JavaPsiFacadeImpl.this.getProject()).getDirsByPackageName(psiPackage.getQualifiedName(), includeLibrarySources).forEach((Processor<VirtualFile>)new ReadActionProcessor<VirtualFile>(){

                @Override
                public boolean processInReadAction(VirtualFile dir) {
                    if (!scope2.contains(dir)) {
                        return true;
                    }
                    PsiDirectory psiDir = psiManager.findDirectory(dir);
                    return psiDir == null || consumer.process(psiDir);
                }
            });
        }
    }
}

