/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.Loader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

class FileLoader
extends Loader {
    private final File myRootDir;
    private final String myRootDirAbsolutePath;
    private static int misses;
    private static int hits;

    FileLoader(URL url, int index2) throws IOException {
        super(url, index2);
        this.myRootDir = new File(FileUtil.unquote(url.getFile()));
        this.myRootDirAbsolutePath = this.myRootDir.getAbsolutePath();
    }

    private void buildPackageCache(File dir, ClasspathCache.LoaderData loaderData) {
        loaderData.addResourceEntry(this.getRelativeResourcePath(dir));
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        boolean containsClasses = false;
        for (File file : files) {
            boolean isClass = file.getPath().endsWith(".class");
            if (isClass) {
                if (!containsClasses) {
                    loaderData.addResourceEntry(this.getRelativeResourcePath(file));
                    containsClasses = true;
                }
                loaderData.addNameEntry(file.getName());
                continue;
            }
            loaderData.addNameEntry(file.getName());
            this.buildPackageCache(file, loaderData);
        }
    }

    private String getRelativeResourcePath(File file) {
        String relativePath = file.getAbsolutePath().substring(this.myRootDirAbsolutePath.length());
        if ((relativePath = relativePath.replace(File.separatorChar, '/')).startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }

    @Override
    @Nullable
    Resource getResource(String name, boolean check) {
        block9: {
            URL url = null;
            File file = null;
            try {
                url = new URL(this.getBaseURL(), name);
                if (!url.getFile().startsWith(this.getBaseURL().getFile())) {
                    return null;
                }
                file = new File(this.myRootDir, name.replace('/', File.separatorChar));
                if (!check || file.exists()) {
                    if (check && ++misses % 1000 == 0 && ClasspathCache.doDebug) {
                        ClasspathCache.LOG.debug("[Sample of] missed resource " + name + " from " + this.myRootDir);
                    }
                    if (++hits % 1000 == 0 && ClasspathCache.doDebug) {
                        ClasspathCache.LOG.debug("Exists file loader: misses:" + misses + ", hits:" + hits);
                    }
                    return new MyResource(name, url, file, !check);
                }
            }
            catch (Exception exception) {
                if (++misses % 1000 == 0 && ClasspathCache.doDebug) {
                    ClasspathCache.LOG.debug("Missed " + name + " from " + this.myRootDir);
                }
                if (check || file == null || !file.exists()) break block9;
                try {
                    return new MyResource(name, url, file, false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void buildCache(ClasspathCache.LoaderData loaderData) throws IOException {
        block6: {
            File index2 = new File(this.myRootDir, "classpath.index");
            if (index2.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(index2));
                try {
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) == null) {
                            break block6;
                        }
                        loaderData.addResourceEntry(line);
                        loaderData.addNameEntry(line);
                    }
                }
                finally {
                    reader.close();
                }
            }
            loaderData.addResourceEntry("foo.class");
            loaderData.addResourceEntry("bar.properties");
            this.buildPackageCache(this.myRootDir, loaderData);
        }
    }

    @NonNls
    public String toString() {
        return "FileLoader [" + this.myRootDir + "]";
    }

    private class MyResource
    extends Resource {
        private final String myName;
        private final URL myUrl;
        private final File myFile;

        public MyResource(String name, URL url, File file, boolean willLoadBytes) throws IOException {
            this.myName = name;
            this.myUrl = url;
            this.myFile = file;
            if (willLoadBytes) {
                this.getByteBuffer();
            }
        }

        public String getName() {
            return this.myName;
        }

        public URL getURL() {
            return this.myUrl;
        }

        public URL getCodeSourceURL() {
            return FileLoader.this.getBaseURL();
        }

        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.myFile));
        }

        public int getContentLength() throws IOException {
            return -1;
        }

        public String toString() {
            return this.myFile.getAbsolutePath();
        }
    }
}

