/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.evaluate;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.Function2;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory0;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.evaluate.BinaryOperationKey;
import org.jetbrains.jet.lang.evaluate.CompileTimeType;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator$evaluateBinaryAndCheck$2;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator$visitConstantExpression$1;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage$ConstantExpressionEvaluator$65b0d39c;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage$OperationsMapGenerated$7461f880;
import org.jetbrains.jet.lang.evaluate.EvaluatorContext;
import org.jetbrains.jet.lang.evaluate.UnaryOperationKey;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetLabeledExpression;
import org.jetbrains.jet.lang.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.CompileTimeConstantUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage$callUtil$cc168a05;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.constants.AnnotationValue;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueConstant;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.jet.lang.resolve.constants.JavaClassValue;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

@KotlinClass(abiVersion=19, data={"i\u0018)Y2i\u001c8ti\u0006tG/\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_JT1a\u001c:h\u0015%QW\r\u001e2sC&t7OC\u0002kKRTA\u0001\\1oO*AQM^1mk\u0006$XM\u0003\u0006KKR4\u0016n]5u_JT1\u0001]:j\u0015M\u0019u.\u001c9jY\u0016$\u0016.\\3D_:\u001cH/\u00198u\u0015\u001d\u0011Xm]8mm\u0016T\u0011bY8ogR\fg\u000e^:\u000b\u0007\u0005s\u0017P\u0003\u0004l_Rd\u0017N\u001c\u0006\b\u0015\u0016$H+\u001f9f\u0015\u0015!\u0018\u0010]3t\u0015\u0019a\u0014N\\5u}))AO]1dK*a!)\u001b8eS:<GK]1dK*I2\u000f\u001e:j]\u001e,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s\u0015]\u001auN\\:uC:$X\t\u001f9sKN\u001c\u0018n\u001c8Fm\u0006dW/\u0019;pe\u0012\u001aHO]5oO\u0016C\bO]3tg&|g.\u0012<bYV\fGo\u001c:%c)Aq-\u001a;Ue\u0006\u001cWMC\u000bdC:\u0014U-V:fI&s\u0017I\u001c8pi\u0006$\u0018n\u001c8\u000b\u0015\u0015D\bO]3tg&|gNC\u0007KKR,\u0005\u0010\u001d:fgNLwN\u001c\u0006\b\u0005>|G.Z1o\u0015e\u0019'/Z1uK\u000e{W\u000e]5mKRKW.Z\"p]N$\u0018M\u001c;\u000b\u000bY\fG.^3\u000b\u0019\u0015D\b/Z2uK\u0012$\u0016\u0010]3\u000b\r%\u001c\b+\u001e:f\u0015Y)8/Z:WCJL\u0017M\u00197f\u0003N\u001cuN\\:uC:$(\u0002\u00026bm\u0006Taa\u00142kK\u000e$(bF2sK\u0006$Xm\u00149fe\u0006$\u0018n\u001c8Be\u001e,X.\u001a8u\u00159)\u0007\u0010\u001d:fgNLwN\u001c+za\u0016TqbY8na&dW\rV5nKRK\b/\u001a\u0006\u0010\u0007>l\u0007/\u001b7f)&lW\rV=qK*\tr\n]3sCRLwN\\!sOVlWM\u001c;\u000b[\r{gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8sI=\u0003XM]1uS>t\u0017I]4v[\u0016tGO\u0003\u0015de\u0016\fG/Z(qKJ\fG/[8o\u0003J<W/\\3oi\u001a{'OR5sgR\u0004\u0016M]1nKR,'O\u0003\u0005be\u001e,X.\u001a8u\u0015U\u0011Vm]8mm\u0016$g+\u00197vK\u0006\u0013x-^7f]RTQaY1mYNTQ!\\8eK2T\u0011\u0002]1sC6,G/\u001a:\u000b1Y\u000bG.^3QCJ\fW.\u001a;fe\u0012+7o\u0019:jaR|'OC\u0006eKN\u001c'/\u001b9u_J\u001c(BI2sK\u0006$Xm\u00149fe\u0006$\u0018n\u001c8Be\u001e,X.\u001a8u\r>\u0014(+Z2fSZ,'O\u0003\u0007sKN|GN^3e\u0007\u0006dGN\u0003\u0007SKN|GN^3e\u0007\u0006dGN\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(bF6pi2LgN\f6w[:\u0002F.\u0019;g_JlG+\u001f9f\u0015Y)g/\u00197vCR,')\u001b8bef\fe\u000eZ\"iK\u000e\\'\u0002\u0003:fG\u0016Lg/\u001a:\u000b\t9\fW.\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\u001d\r\fG\u000e\\#yaJ,7o]5p]*aQM^1mk\u0006$XmQ1mY*\u0011\"/Z2fSZ,'/\u0012=qe\u0016\u001c8/[8o\u0015U)g/\u00197vCR,WK\\1ss\u0006sGm\u00115fG.T\u0001#[:ESZL7/[8o\u0005fTVM]8\u000b\u001d%\u001c\b+\u001e:f\u0007>t7\u000f^1oi*\u0001\"/Z:pYZ,\u0017I]4v[\u0016tGo\u001d\u0006\u000fm\u0006dW/Z!sOVlWM\u001c;t\u0015\u0011a\u0015n\u001d;\u000b\u001bY\u000bG.^3Be\u001e,X.\u001a8u\u0015\u0011)H/\u001b7\u000b+YL7/\u001b;CS:\f'/_#yaJ,7o]5p]*\u0019\"*\u001a;CS:\f'/_#yaJ,7o]5p]*\u0019b/[:ji\u000e\u000bG\u000e\\#yaJ,7o]5p]*\t\"*\u001a;DC2dW\t\u001f9sKN\u001c\u0018n\u001c8\u000b/YL7/\u001b;D_:\u001cH/\u00198u\u000bb\u0004(/Z:tS>t'\"\u0006&fi\u000e{gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0010m&\u001c\u0018\u000e\u001e&fi\u0016cW-\\3oi*9Q\r\\3nK:$(B\u0003&fi\u0016cW-\\3oi*1b/[:ji2\u000b'-\u001a7fI\u0016C\bO]3tg&|gN\u0003\u000bKKRd\u0015MY3mK\u0012,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u001dm&\u001c\u0018\u000e\u001e)be\u0016tG\u000f[3tSj,G-\u0012=qe\u0016\u001c8/[8o\u0015iQU\r\u001e)be\u0016tG\u000f[3tSj,G-\u0012=qe\u0016\u001c8/[8o\u0015a1\u0018n]5u#V\fG.\u001b4jK\u0012,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0017\u0015\u0016$\u0018+^1mS\u001aLW\rZ#yaJ,7o]5p]*Ib/[:jiNKW\u000e\u001d7f\u001d\u0006lW-\u0012=qe\u0016\u001c8/[8o\u0015]QU\r^*j[BdWMT1nK\u0016C\bO]3tg&|gNC\u000fwSNLGo\u0015;sS:<G+Z7qY\u0006$X-\u0012=qe\u0016\u001c8/[8o\u0015mQU\r^*ue&tw\rV3na2\fG/Z#yaJ,7o]5p]*!b/[:jiVs\u0017M]=FqB\u0014Xm]:j_:T!CS3u+:\f'/_#yaJ,7o]5p]r\u001e!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0003\t\u0007A9!B\u0002\u0005\u0007!\u0019A\u0002A\u0003\u0003\t\u0007AI!\u0002\u0002\u0005\t!)Qa\u0001C\u0005\u0011\u0011a\u0001!B\u0001\t\r\u0015\u0019A1\u0002E\u0006\u0019\u0001)!\u0001b\u0001\t\u000f\u0015\u0019AQ\u0002E\u0007\u0019\u0001)1\u0001\u0002\u0003\t\u00121\u0001QA\u0001\u0003\u0005\u0011#)!\u0001\u0002\u0002\t\u0014\u0015\u0019Aa\u0001E\f\u0019\u0001)1\u0001b\u0003\t\u00191\u0001QA\u0001\u0003\u0004\u0011/)!\u0001\"\u0003\t\t\u0015\t\u0001bD\u0003\u0003\t-A!!\u0002\u0002\u0005\u0018!}QA\u0001C\u0007\u0011\u001b)1\u0001\u0002\u0002\t$1\u0001Qa\u0001C\u0003\u0011Ia\u0001!\u0002\u0002\u0005\u0005!\u0015RA\u0001\u0003\u0003\u0011G)!\u0001\u0002\u0003\t*\u0015\u0011Aa\u0004\u0005\u0016\u000b\r!y\u0002\u0003\u000b\r\u0001\u0015\u0011A1\u0001E\u0017\u000b\r!\t\u0003\u0003\f\r\u0001\u0015\u0011Aq\u0004\u0005\u0015\u000b\t!\t\u0003\u0003\f\u0006\u0007\u0011}\u0001\u0002\u0007\u0007\u0001\u000b\r!\t\u0003#\r\r\u0001\u0015\u0011Aq\u0004\u0005\u0019\u000b\r!Y\u0001C\u000e\r\u0001\u0015\u0011Aq\u0003\u0005\u001c\u000b\r!Y\u0001c\u0010\r\u0001\u0015\u0019Aa\u0001\u0005!\u0019\u0001)!\u0001B\u0006\tB\u0015\u0011AA\u0006E \u000b\r!1\u0001c\u0011\r\u0001\u0015\u0011Aa\u0001E\"\u000b\r!1\u0001#\u0012\r\u0001\u0015\u0011Aa\u0001E#\u000b\r!1\u0001c\u0012\r\u0001\u0015\u0011Aa\u0001E$\u000b\r!1\u0001C\u0013\r\u0001\u0015\u0011Aa\u0001\u0005&\u000b\r!1\u0001\u0003\u0014\r\u0001\u0015\u0011Aa\u0001\u0005'\u000b\r!1\u0001C\u0014\r\u0001\u0015\u0011Aa\u0001\u0005(\u000b\r!1\u0001\u0003\u0015\r\u0001\u0015\u0011Aa\u0001\u0005)\u000b\r!1\u0001C\u0015\r\u0001\u0015\u0011Aa\u0001\u0005*\u000b\r!1\u0001\u0003\u0016\r\u0001\u0015\u0011Aa\u0001\u0005+\u000b\r!1\u0001C\u0016\r\u0001\u0015\u0011Aa\u0001\u0005,\t\ra)!\u0005\u0001\u001a!\u0015\t\u0001rA\u0005\n\u0013!)\u0011\u0001C\u0003\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0019a\t!C\u0002\n\u0005\u0015\t\u0001b\u0002\u000f\u0013[-!\u0011\r\u0002\r\nC\t)\u0011\u0001\u0003\u0004V\u0007\u0011)1\u0001B\u0005\n\u0003!EQf\u0004\u0003a\taA\u0011EA\u0003\u0002\u0011\u001f)6\u0001C\u0003\u0004\t!I\u0011\u0001\u0003\u0005\u000e\u0007\u0011Q\u0011\"\u0001\u0005\t[M!\u0011\u0001'\u0006\u001e\u000e\u0011\u0001\u0001bC\u0007\u0003\u000b\u0005A\u0011\u0002U\u0002\u0001C\t)\u0011\u0001c\u0005R\u0007\u0015!)\"C\u0001\u0005\u00025\t\u0001BC\u0017C\u0002\u0011\u0001\u0001\u0014DO\b\t\u0001AQ\"D\u0002\u0006\u0003!1A\u0012\u0001)\u0004\u0001u=A\u0001\u0001E\u000e\u001b\r)\u0011\u0001C\u0004\r\u0002A\u001b\t!(\u0004\u0005\u0003!qQBA\u0003\u0002\u0011'\u00016!AO\u0007\t\u0005A)\"\u0004\u0002\u0006\u0003!M\u0001ka\u0001\u001e\u000e\u0011\t\u0001RD\u0007\u0003\u000b\u0005A\u0019\u0002U\u0002\u0003C%)\u0011\u0001C\u0003\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0019a\t\u0001$\u0001R\u00075!I\"C\u0001\t\u00165\t\u0001\u0002D\u0007\u0002\u00113i\u0011\u0001\"\u0001\u000e\u0003\u0011\u0005Q\"\u0001C\u0001[5\"\u0011\u0001\u0007\t\u001e\u000e\u0011\u0001\u0001bC\u0007\u0003\u000b\u0005A\u0011\u0002U\u0002\u0001;\u001b!\u0001\u0001#\t\u000e\u0005\u0015\t\u0001b\u0002)\u0004\u0002ueA\u0001\u0001\u0005\u0012\u001b!)\u0011\u0001C\u0007\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0019a\t\u0001U\u0002\u0002C\r)\u0011\u0001c\u0007\r\u0002E\u001b\u0011\u0002\u0002\t\n\u0003!qQ\"\u0001\u0005\u000b\u001b\u0005AI\"D\u0001\t\u001e5nB!\u0001\r\u0014;\u001b!\u0001\u0001c\n\u000e\u0005\u0015\t\u0001\u0002\u0005)\u0004\u0001u5A\u0001\u0001E\u0016\u001b\t)\u0011\u0001C\tQ\u0007\u0003\t3!B\u0001\t\u001c1\u0005\u0011kA\u0004\u0005'%\t\u0001BD\u0007\u0002\u0011Gi\u0011\u0001\u0003\n.P\u0011\t\u0001dFO\u0011\t\u0001Ay#\u0004\u0007\u0006\u0003!\u0015\u0012\"\u0003C\u0001\u0013\u001d)\u0011\u0001C\n\u00113U\u0019Q!\u0001\u0005\u0014\u0019\u0003\u00016\u0001AO\u0007\t\u0001A1\"\u0004\u0002\u0006\u0003!I\u0001k!\u0001\"\u0007\u0015\t\u00012\u0004G\u0001#\u000e9AaF\u0005\u0002\u00119i\u0011\u0001c\n\u000e\u0003!QQ\u0016\n\u0003\u00021\u000bij\u0001\u0002\u0001\t\u00175\u0011Q!\u0001\u0005\n!\u000e\u0001Qt\u0002\u0003\u0001\u00117i1!B\u0001\t\u000f1\u0005\u0001k!\u0001\"\u0013\u0015\t\u0001\"B\u0005\u0006\t\u0003I1!B\u0001\t\r1\u0005A\u0012A)\u0004\u000f\u0011\u0015\u0011\"\u0001E\u000b\u001b\u0005A!\"D\u0001\t\u001a5\u0006D!\u0001M\u001a;\u001b!\u0001\u0001\u0003\u000e\u000e\u0005\u0015\t\u00012\u0004)\u0004\u0001u5A\u0001\u0001E\u0016\u001b\t)\u0011\u0001c\u0007Q\u0007\u0003ij\u0001\u0002\u0001\t65\u0011Q!\u0001\u0005\u0015!\u000e\tQT\u0002\u0003\u0001\u0011oi!!B\u0001\t\u0013A\u001b\u0019!I\u0002\u0006\u0003!1A\u0012A)\u0004\u0017\u0011M\u0012\"\u0001\u0005\r\u001b\u0005Aa\"D\u0001\t\u001d5\t\u0001\u0012F\u0007\u0002\u0011)ic\u0006B\u0001\u00199u5A\u0001\u0001E\u001c\u001b\t)\u0011\u0001C\u0005Q\u0007\u0001ij\u0001\u0002\u0001\t:5\u0011Q!\u0001\u0005\n!\u000e\u0005Qt\u0002\u0003\u0001\u00117i1!B\u0001\t\u000f1\u0005\u0001kA\u0001\"\u0013\u0015\t\u0001\"B\u0005\u0006\t\u0003I1!B\u0001\t\r1\u0005A\u0012A)\u0004\u0013\u0011a\u0012\"\u0001E\u000b\u001b\u0005A!\"D\u0001\t\u00155\t\u0001\u0012D\u0017(\t\u0005AR$(\u0004\u0005\u0001!QRBA\u0003\u0002\u00117\u00016\u0001AO\u0007\t\u0001A)$\u0004\u0002\u0006\u0003!!\u0002k!\u0001\u001e\u000e\u0011\u0001\u0001rG\u0007\u0003\u000b\u0005A\u0011\u0002U\u0002\u0002C\r)\u0011\u0001\u0003\u0004\r\u0002E\u001b\u0011\u0002B\u000f\n\u0003!aQ\"\u0001\u0005\u000f\u001b\u0005AI#D\u0001\t\u00155nB!\u0001M\u001e;\u001b!\u0001\u0001#\u000e\u000e\u0005\u0015\t\u0001\u0002\u0006)\u0004\u0001u=A\u0001\u0001E\u0016\u001b\r)\u0011\u0001\u0003\u0004\r\u0002A\u001b\t!\t\u0002\u0006\u0003!M\u0011kA\u0004\u0005<%\tA\u0011A\u0007\u0002\u0011Si\u0011\u0001\u0003\u0007.'\u0011\t\u0001DHO\u0007\t\u0001A1\"\u0004\u0002\u0006\u0003!I\u0001k\u0001\u0001\"\u0005\u0015\t\u00012C)\u0004\u000b\u0011q\u0012\"\u0001C\u0001\u001b\u0005A!\",\u0016\u0005\u0003auRT\u0003\u0003\u0001\u0011}ia!B\u0001\t+%\u0019\u0011BA\u0003\u0002\u0011W\u00016\u0001AO\u0007\t\u0001AY\"\u0004\u0002\u0006\u0003!9\u0001k!\u0001\"\u0019\u0015\t\u0001\"F\u0005\n\u0013!)\u0011\u0001C\u0003\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0019a\t!U\u0002\b\t{I\u0011\u0001#\f\u000e\u0003!5R\"\u0001E\r[M!\u0011\u0001'\b\u001e\u000e\u0011\u0001\u0001bC\u0007\u0003\u000b\u0005A\u0011\u0002U\u0002\u0001C\t)\u0011\u0001c\u0005R\u0007\u0015!i\"C\u0001\u0005\u00025\t\u0001BCW%\t-A\u0012%(\u0004\u0005\u0001!YQBA\u0003\u0002\u0011]\u00016\u0001AO\b\t\u0001AY\"D\u0002\u0006\u0003!9A\u0012\u0001)\u0004\u0002\u0005JQ!\u0001\u0005\u0006\u0013\u0015!\t!C\u0002\u0006\u0003!1A\u0012\u0001G\u0001#\u000e9A!I\u0005\u0002\u0011+i\u0011\u0001c\f\u000e\u0003!eQ\u0016\n\u0003\f1\tjj\u0001\u0002\u0001\t\u00175\u0011Q!\u0001\u0005\u0019!\u000e\u0001Qt\u0002\u0003\u0001\u00117i1!B\u0001\t\u000f1\u0005\u0001k!\u0001\"\u0013\u0015\t\u0001\"B\u0005\u0006\t\u0003I1!B\u0001\t\r1\u0005A\u0012A)\u0004\u000f\u0011\u0011\u0013\"\u0001E\u000b\u001b\u0005A\t$D\u0001\t\u001a5&Ca\u0003\r$;\u001b!\u0001\u0001C\u0006\u000e\u0005\u0015\t\u0001\"\u0007)\u0004\u0001u=A\u0001\u0001E\u000e\u001b\r)\u0011\u0001C\u0004\r\u0002A\u001b\t!I\u0005\u0006\u0003!)\u0011\"\u0002C\u0001\u0013\r)\u0011\u0001\u0003\u0004\r\u00021\u0005\u0011kA\u0004\u0005G%\t\u0001RC\u0007\u0002\u0011gi\u0011\u0001#\u0007.J\u0011Y\u0001\u0004JO\u0007\t\u0001AI%\u0004\u0002\u0006\u0003!Q\u0002k\u0001\u0001\u001e\u0010\u0011\u0001\u00012D\u0007\u0004\u000b\u0005Aq\u0001$\u0001Q\u0007\u0003\t\u0013\"B\u0001\t\u000b%)A\u0011A\u0005\u0004\u000b\u0005Aa\u0001$\u0001\r\u0002E\u001bq\u0001\u0002\u0013\n\u0003!UQ\"\u0001E\u001b\u001b\u0005AI\",\u0013\u0005\u0017a-ST\u0002\u0003\u0001\u0011-i!!B\u0001\t7A\u001b\u0001!h\u0004\u0005\u0001!mQbA\u0003\u0002\u0011\u001da\t\u0001UB\u0001C%)\u0011\u0001C\u0003\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0019a\t\u0001$\u0001R\u0007\u001d!Y%C\u0001\t\u00165\t\u0001rG\u0007\u0002\u00113iK\u0005B\u0006\u0019Nu5A\u0001\u0001\u0005\f\u001b\t)\u0011\u0001\u0003\u000fQ\u0007\u0001iz\u0001\u0002\u0001\t\u001c5\u0019Q!\u0001\u0005\b\u0019\u0003\u00016\u0011A\u0011\n\u000b\u0005AQ!C\u0003\u0005\u0002%\u0019Q!\u0001\u0005\u0007\u0019\u0003a\t!U\u0002\b\t\u001bJ\u0011\u0001#\u0006\u000e\u0003!eR\"\u0001E\r[\u0013\"1\u0002g\u0014\u001e\u000e\u0011\u0001\u0001bC\u0007\u0003\u000b\u0005AQ\u0004U\u0002\u0001;\u001f!\u0001\u0001c\u0007\u000e\u0007\u0015\t\u0001b\u0002G\u0001!\u000e\u0005\u0011%C\u0003\u0002\u0011\u0015IQ\u0001\"\u0001\n\u0007\u0015\t\u0001B\u0002G\u0001\u0019\u0003\t6a\u0002C(\u0013\u0005A)\"D\u0001\t<5\t\u0001\u0012DW%\t-A\n&(\u0004\u0005\u0001!YQBA\u0003\u0002\u0011y\u00016\u0001AO\b\t\u0001AY\"D\u0002\u0006\u0003!9A\u0012\u0001)\u0004\u0002\u0005JQ!\u0001\u0005\u0006\u0013\u0015!\t!C\u0002\u0006\u0003!1A\u0012\u0001G\u0001#\u000e9A\u0011K\u0005\u0002\u0011+i\u0011\u0001#\u0010\u000e\u0003!eQ\u0016\n\u0003\f1'jj\u0001\u0002\u0001\t\u00175\u0011Q!\u0001\u0005 !\u000e\u0001Qt\u0002\u0003\u0001\u00117i1!B\u0001\t\u000f1\u0005\u0001k!\u0001\"\u0013\u0015\t\u0001\"B\u0005\u0006\t\u0003I1!B\u0001\t\r1\u0005A\u0012A)\u0004\u000f\u0011M\u0013\"\u0001E\u000b\u001b\u0005Ay$D\u0001\t\u001a5&Ca\u0003M+;\u001b!\u0001\u0001C\u0006\u000e\u0005\u0015\t\u0001\u0002\t)\u0004\u0001u=A\u0001\u0001E\u000e\u001b\r)\u0011\u0001C\u0004\r\u0002A\u001b\t!I\u0005\u0006\u0003!)\u0011\"\u0002C\u0001\u0013\r)\u0011\u0001\u0003\u0004\r\u00021\u0005\u0011kA\u0004\u0005V%\t\u0001RC\u0007\u0002\u0011\u0003j\u0011\u0001#\u00076*\u0015\u001dB!9\u0001\u0019\u0010u5A\u0001\u0001\u0005\t\u001b\t)\u0011\u0001c\u0004Q\u0007\u0001\t#!B\u0001\t\u0006E\u001bQ\u0001b\u0004\n\u0003\u0011\u0001Q\"\u0001\u0005\t"})
public final class ConstantExpressionEvaluator
extends JetVisitor<CompileTimeConstant<? extends Object>, JetType>
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    private final stringExpressionEvaluator.1 stringExpressionEvaluator;
    @NotNull
    private final BindingTrace trace;
    public static final object OBJECT$;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(ConstantExpressionEvaluator.class);
        OBJECT$ = object.$init$b$0();
    }

    private final CompileTimeConstant<? extends Object> evaluate(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="expectedType", type="?") JetType expectedType) {
        CompileTimeConstant recordedCompileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        if (recordedCompileTimeConstant != null) {
            return recordedCompileTimeConstant;
        }
        JetVisitor jetVisitor = this;
        JetType jetType = expectedType;
        if (jetType == null) {
            jetType = TypeUtils.NO_EXPECTED_TYPE;
        }
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)expression.accept(jetVisitor, jetType);
        if (compileTimeConstant != null) {
            this.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, compileTimeConstant);
            return compileTimeConstant;
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitConstantExpression(@JetValueParameter(name="expression") @NotNull JetConstantExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        Object object2;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitConstantExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        String text = expression.getText();
        if (text == null) {
            return null;
        }
        IElementType nodeElementType = expression.getNode().getElementType();
        if (Intrinsics.areEqual(nodeElementType, JetNodeTypes.NULL)) {
            return NullValue.NULL;
        }
        Object object3 = nodeElementType;
        if (Intrinsics.areEqual(object3, JetNodeTypes.INTEGER_CONSTANT)) {
            object2 = EvaluatePackage$ConstantExpressionEvaluator$65b0d39c.parseLong(text);
        } else if (Intrinsics.areEqual(object3, JetNodeTypes.FLOAT_CONSTANT)) {
            object2 = EvaluatePackage$ConstantExpressionEvaluator$65b0d39c.parseFloatingLiteral(text);
        } else if (Intrinsics.areEqual(object3, JetNodeTypes.BOOLEAN_CONSTANT)) {
            object2 = EvaluatePackage$ConstantExpressionEvaluator$65b0d39c.parseBoolean(text);
        } else if (Intrinsics.areEqual(object3, JetNodeTypes.CHARACTER_CONSTANT)) {
            object2 = CompileTimeConstantChecker.parseChar(expression);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported constant: " + expression);
        }
        Long result2 = object2;
        if (result2 == null) {
            return null;
        }
        object3 = new ConstantExpressionEvaluator$visitConstantExpression$1(nodeElementType, text);
        return this.createCompileTimeConstant(result2, expectedType, !((ConstantExpressionEvaluator$visitConstantExpression$1)object3).invoke(), true, false);
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitParenthesizedExpression(@JetValueParameter(name="expression") @NotNull JetParenthesizedExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitParenthesizedExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression deparenthesizedExpression = JetPsiUtil.deparenthesize(expression);
        if (deparenthesizedExpression != null ? Intrinsics.areEqual(deparenthesizedExpression, expression) ^ true : false) {
            return this.evaluate(deparenthesizedExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitLabeledExpression(@JetValueParameter(name="expression") @NotNull JetLabeledExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitLabeledExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression != null) {
            return this.evaluate(baseExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitStringTemplateExpression(@JetValueParameter(name="expression") @NotNull JetStringTemplateExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitStringTemplateExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        StringBuilder sb = new StringBuilder();
        int interupted = 0;
        int canBeUsedInAnnotation = 1;
        int usesVariableAsConstant = 0;
        JetStringTemplateEntry[] jetStringTemplateEntryArray = expression.getEntries();
        for (int i = 0; i < jetStringTemplateEntryArray.length; ++i) {
            JetStringTemplateEntry entry;
            JetStringTemplateEntry jetStringTemplateEntry = entry = jetStringTemplateEntryArray[i];
            Intrinsics.checkExpressionValueIsNotNull(jetStringTemplateEntry, "entry");
            StringValue constant = this.stringExpressionEvaluator.evaluate(jetStringTemplateEntry);
            if (constant == null) {
                interupted = 1;
                break;
            }
            if (!constant.canBeUsedInAnnotations()) {
                canBeUsedInAnnotation = 0;
            }
            if (constant.usesVariableAsConstant()) {
                usesVariableAsConstant = 1;
            }
            sb.append((String)constant.getValue());
        }
        return interupted == 0 ? this.createCompileTimeConstant(sb.toString(), expectedType, true, canBeUsedInAnnotation != 0, usesVariableAsConstant != 0) : (CompileTimeConstant<? extends Object>)null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitBinaryExpression(@JetValueParameter(name="expression") @NotNull JetBinaryExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitBinaryExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression leftExpression = expression.getLeft();
        if (leftExpression == null) {
            return null;
        }
        IElementType operationToken = expression.getOperationToken();
        if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationToken)) {
            boolean bl;
            JetType booleanType = KotlinBuiltIns.getInstance().getBooleanType();
            CompileTimeConstant<? extends Object> leftConstant = this.evaluate(leftExpression, booleanType);
            if (leftConstant == null) {
                return null;
            }
            JetExpression rightExpression = expression.getRight();
            if (rightExpression == null) {
                return null;
            }
            CompileTimeConstant<? extends Object> rightConstant = this.evaluate(rightExpression, booleanType);
            if (rightConstant == null) {
                return null;
            }
            Object leftValue = leftConstant.getValue();
            Object rightValue = rightConstant.getValue();
            boolean bl2 = !(!(leftValue instanceof Boolean)) ? !(rightValue instanceof Boolean) : true;
            if (bl2) {
                return null;
            }
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, JetTokens.ANDAND)) {
                bl = ((Boolean)leftValue).booleanValue() ? (Boolean)rightValue : false;
            } else if (Intrinsics.areEqual(iElementType, JetTokens.OROR)) {
                bl = !((Boolean)leftValue).booleanValue() ? (Boolean)rightValue : true;
            } else {
                throw (Throwable)new IllegalArgumentException("Unknown boolean operation token " + operationToken);
            }
            boolean result2 = bl;
            boolean usesVariableAsConstant = !leftConstant.usesVariableAsConstant() ? rightConstant.usesVariableAsConstant() : true;
            return this.createCompileTimeConstant(result2, expectedType, true, true, usesVariableAsConstant);
        }
        JetExpression jetExpression = expression.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull(jetExpression, "expression.getOperationReference()");
        return this.evaluateCall(jetExpression, leftExpression, expectedType);
    }

    private final CompileTimeConstant<? extends Object> evaluateCall(@JetValueParameter(name="callExpression") JetExpression callExpression, @JetValueParameter(name="receiverExpression") JetExpression receiverExpression, @JetValueParameter(name="expectedType", type="?") JetType expectedType) {
        JetElement jetElement = callExpression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage$callUtil$cc168a05.getResolvedCall(jetElement, bindingContext);
        if (resolvedCall == null) {
            return null;
        }
        Name resultingDescriptorName = resolvedCall.getResultingDescriptor().getName();
        OperationArgument argumentForReceiver = this.createOperationArgumentForReceiver(resolvedCall, receiverExpression);
        if (argumentForReceiver == null) {
            return null;
        }
        Set<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> argumentsEntrySet = resolvedCall.getValueArguments().entrySet();
        if (argumentsEntrySet.isEmpty()) {
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "resultingDescriptorName.asString()");
            Object result2 = this.evaluateUnaryAndCheck(argumentForReceiver, string, callExpression);
            if (result2 == null) {
                return null;
            }
            boolean isArgumentPure = this.isPureConstant(argumentForReceiver.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression());
            boolean isNumberConversionMethod = OperatorConventions.NUMBER_CONVERSIONS.contains(resultingDescriptorName);
            return this.createCompileTimeConstant(result2, expectedType, !isNumberConversionMethod ? isArgumentPure : false, canBeUsedInAnnotation, usesVariableAsConstant);
        }
        if (argumentsEntrySet.size() == 1) {
            Map.Entry canBeUsedInAnnotation = (Map.Entry)KotlinPackage.first((Iterable)argumentsEntrySet);
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)KotlinPackage.component1(canBeUsedInAnnotation);
            ResolvedValueArgument argument = (ResolvedValueArgument)KotlinPackage.component2(canBeUsedInAnnotation);
            OperationArgument argumentForParameter = null;
            ResolvedValueArgument resolvedValueArgument = argument;
            Intrinsics.checkExpressionValueIsNotNull(resolvedValueArgument, "argument");
            ValueParameterDescriptor valueParameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "parameter");
            argumentForParameter = this.createOperationArgumentForFirstParameter(resolvedValueArgument, valueParameterDescriptor);
            if (argumentForParameter == null) {
                return null;
            }
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "resultingDescriptorName.asString()");
            if (this.isDivisionByZero(string, argumentForParameter.getValue())) {
                return ErrorValue.create("Division by zero");
            }
            String string2 = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "resultingDescriptorName.asString()");
            Object result3 = this.evaluateBinaryAndCheck(argumentForReceiver, argumentForParameter, string2, callExpression);
            if (result3 == null) {
                return null;
            }
            boolean areArgumentsPure = this.isPureConstant(argumentForReceiver.getExpression()) ? this.isPureConstant(argumentForParameter.getExpression()) : false;
            boolean canBeUsedInAnnotation2 = this.canBeUsedInAnnotation(argumentForReceiver.getExpression()) ? this.canBeUsedInAnnotation(argumentForParameter.getExpression()) : false;
            boolean usesVariableAsConstant = !this.usesVariableAsConstant(argumentForReceiver.getExpression()) ? this.usesVariableAsConstant(argumentForParameter.getExpression()) : true;
            EvaluatorContext c = new EvaluatorContext(canBeUsedInAnnotation2, areArgumentsPure, usesVariableAsConstant);
            Name name = resultingDescriptorName;
            return Intrinsics.areEqual(name, OperatorConventions.COMPARE_TO) ? EvaluatePackage$ConstantExpressionEvaluator$65b0d39c.createCompileTimeConstantForCompareTo(result3, callExpression, c) : (Intrinsics.areEqual(name, OperatorConventions.EQUALS) ? EvaluatePackage$ConstantExpressionEvaluator$65b0d39c.createCompileTimeConstantForEquals(result3, callExpression, c) : this.createCompileTimeConstant(result3, expectedType, areArgumentsPure, canBeUsedInAnnotation2, usesVariableAsConstant));
        }
        return null;
    }

    private final boolean usesVariableAsConstant(@JetValueParameter(name="expression") JetExpression expression) {
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        return compileTimeConstant != null ? compileTimeConstant.usesVariableAsConstant() : false;
    }

    private final boolean canBeUsedInAnnotation(@JetValueParameter(name="expression") JetExpression expression) {
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        return compileTimeConstant != null ? compileTimeConstant.canBeUsedInAnnotations() : false;
    }

    private final boolean isPureConstant(@JetValueParameter(name="expression") JetExpression expression) {
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
        if (compileTimeConstant instanceof IntegerValueConstant) {
            return ((IntegerValueConstant)compileTimeConstant).isPure();
        }
        return false;
    }

    private final Object evaluateUnaryAndCheck(@JetValueParameter(name="receiver") OperationArgument receiver, @JetValueParameter(name="name") String name, @JetValueParameter(name="callExpression") JetExpression callExpression) {
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> functions2 = EvaluatePackage$OperationsMapGenerated$7461f880.getUnaryOperations().get(new UnaryOperationKey<Object>(receiver.getCtcType(), name));
        if (functions2 == null) {
            return null;
        }
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> pair = functions2;
        Function1<? super Object, ? extends Object> function = pair.component1();
        Function1<? super Long, ? extends Long> check = pair.component2();
        Object result2 = null;
        result2 = function.invoke(receiver.getValue());
        if (Intrinsics.areEqual(check, EvaluatePackage$OperationsMapGenerated$7461f880.getEmptyUnaryFun())) {
            return result2;
        }
        KotlinPackage.assert(EvaluatePackage$ConstantExpressionEvaluator$65b0d39c.isIntegerType(receiver.getValue()), "Only integer constants should be checked for overflow");
        KotlinPackage.assert(Intrinsics.areEqual(name, "minus"), "Only negation should be checked for overflow");
        if (Intrinsics.areEqual(receiver.getValue(), result2)) {
            PsiElement psiElement = callExpression;
            DiagnosticFactory0<JetExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
            BindingTrace bindingTrace = this.trace;
            JetExpression jetExpression = PsiTreeUtil.getParentOfType(psiElement, JetExpression.class, true);
            JetExpression jetExpression2 = jetExpression;
            if (jetExpression2 == null) {
                jetExpression2 = callExpression;
            }
            bindingTrace.report(diagnosticFactory0.on((JetExpression)((PsiElement)jetExpression2)));
        }
        return result2;
    }

    private final Object evaluateBinaryAndCheck(@JetValueParameter(name="receiver") OperationArgument receiver, @JetValueParameter(name="parameter") OperationArgument parameter, @JetValueParameter(name="name") String name, @JetValueParameter(name="callExpression") JetExpression callExpression) {
        boolean bl;
        Object object2;
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> functions2 = EvaluatePackage$OperationsMapGenerated$7461f880.getBinaryOperations().get(new BinaryOperationKey<Object, Object>(receiver.getCtcType(), parameter.getCtcType(), name));
        if (functions2 == null) {
            return null;
        }
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> pair = functions2;
        Function2<? super Object, ? super Object, ? extends Object> function = pair.component1();
        Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> checker = pair.component2();
        Object actualResult = null;
        try {
            object2 = function.invoke(receiver.getValue(), parameter.getValue());
        }
        catch (Exception e) {
            object2 = null;
        }
        actualResult = object2;
        if (Intrinsics.areEqual(checker, EvaluatePackage$OperationsMapGenerated$7461f880.getEmptyBinaryFun())) {
            return actualResult;
        }
        boolean bl2 = bl = EvaluatePackage$ConstantExpressionEvaluator$65b0d39c.isIntegerType(receiver.getValue()) ? EvaluatePackage$ConstantExpressionEvaluator$65b0d39c.isIntegerType(parameter.getValue()) : false;
        if (KotlinPackage.getASSERTIONS_ENABLED() && !bl) {
            String e = "Only integer constants should be checked for overflow";
            throw (Throwable)((Object)new AssertionError((Object)e));
        }
        ConstantExpressionEvaluator$evaluateBinaryAndCheck$2 constantExpressionEvaluator$evaluateBinaryAndCheck$2 = ConstantExpressionEvaluator$evaluateBinaryAndCheck$2.INSTANCE$;
        Object object3 = constantExpressionEvaluator$evaluateBinaryAndCheck$2.invoke(receiver.getValue());
        Intrinsics.checkExpressionValueIsNotNull(object3, "toBigInteger(receiver.value)");
        Object object4 = constantExpressionEvaluator$evaluateBinaryAndCheck$2.invoke(parameter.getValue());
        Intrinsics.checkExpressionValueIsNotNull(object4, "toBigInteger(parameter.value)");
        BigInteger resultInBigIntegers = checker.invoke((BigInteger)object3, (BigInteger)object4);
        if (Intrinsics.areEqual(constantExpressionEvaluator$evaluateBinaryAndCheck$2.invoke(actualResult), resultInBigIntegers) ^ true) {
            PsiElement psiElement = callExpression;
            DiagnosticFactory0<JetExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
            BindingTrace bindingTrace = this.trace;
            JetExpression jetExpression = PsiTreeUtil.getParentOfType(psiElement, JetExpression.class, true);
            JetExpression jetExpression2 = jetExpression;
            if (jetExpression2 == null) {
                jetExpression2 = callExpression;
            }
            bindingTrace.report(diagnosticFactory0.on((JetExpression)((PsiElement)jetExpression2)));
        }
        return actualResult;
    }

    private final boolean isDivisionByZero(@JetValueParameter(name="name") String name, @JetValueParameter(name="parameter", type="?") Object parameter) {
        Object v = OperatorConventions.BINARY_OPERATION_NAMES.get(JetTokens.DIV);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual(name, ((Name)v).asString())) {
            if (EvaluatePackage$ConstantExpressionEvaluator$65b0d39c.isIntegerType(parameter)) {
                Object object2 = parameter;
                if (object2 == null) {
                    throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Number");
                }
                return ((Number)object2).longValue() == (long)0;
            }
            if (!(parameter instanceof Float) ? parameter instanceof Double : true) {
                Object object3 = parameter;
                if (object3 == null) {
                    throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Number");
                }
                return ((Number)object3).doubleValue() == 0.0;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitUnaryExpression(@JetValueParameter(name="expression") @NotNull JetUnaryExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitUnaryExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression leftExpression = expression.getBaseExpression();
        if (leftExpression == null) {
            return null;
        }
        JetExpression jetExpression = expression.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull(jetExpression, "expression.getOperationReference()");
        return this.evaluateCall(jetExpression, leftExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitSimpleNameExpression(@JetValueParameter(name="expression") @NotNull JetSimpleNameExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        CallableDescriptor callableDescriptor;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitSimpleNameExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        DeclarationDescriptor enumDescriptor = (DeclarationDescriptor)this.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression);
        if (enumDescriptor != null ? DescriptorUtils.isEnumEntry(enumDescriptor) : false) {
            DeclarationDescriptor declarationDescriptor = enumDescriptor;
            if (declarationDescriptor == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.descriptors.DeclarationDescriptor! cannot be cast to org.jetbrains.jet.lang.descriptors.ClassDescriptor");
            }
            return new EnumValue((ClassDescriptor)declarationDescriptor, false);
        }
        JetElement jetElement = expression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage$callUtil$cc168a05.getResolvedCall(jetElement, bindingContext);
        if (resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) instanceof VariableDescriptor) {
            Object object2;
            CompileTimeConstant<?> compileTimeConstant = ((VariableDescriptor)callableDescriptor).getCompileTimeInitializer();
            if (compileTimeConstant == null) {
                return null;
            }
            if (compileTimeConstant instanceof IntegerValueTypeConstant) {
                IntegerValueTypeConstant integerValueTypeConstant = (IntegerValueTypeConstant)compileTimeConstant;
                JetType jetType = expectedType;
                if (jetType == null) {
                    jetType = TypeUtils.NO_EXPECTED_TYPE;
                }
                object2 = integerValueTypeConstant.getValue(jetType);
            } else {
                object2 = compileTimeConstant.getValue();
            }
            Object value = object2;
            return this.createCompileTimeConstant(value, expectedType, false, OBJECT$.isPropertyCompileTimeConstant((VariableDescriptor)callableDescriptor), true);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitQualifiedExpression(@JetValueParameter(name="expression") @NotNull JetQualifiedExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitQualifiedExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression selectorExpression = expression.getSelectorExpression();
        if (selectorExpression instanceof JetCallExpression) {
            JetExpression receiverExpression;
            CompileTimeConstant<? extends Object> qualifiedCallValue = this.evaluate(selectorExpression, expectedType);
            if (qualifiedCallValue != null) {
                return qualifiedCallValue;
            }
            JetExpression calleeExpression = ((JetCallExpression)selectorExpression).getCalleeExpression();
            if (!(calleeExpression instanceof JetSimpleNameExpression)) {
                return null;
            }
            JetExpression jetExpression = receiverExpression = expression.getReceiverExpression();
            Intrinsics.checkExpressionValueIsNotNull(jetExpression, "receiverExpression");
            return this.evaluateCall(calleeExpression, jetExpression, expectedType);
        }
        if (selectorExpression != null) {
            return this.evaluate(selectorExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitCallExpression(@JetValueParameter(name="expression") @NotNull JetCallExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitCallExpression"));
        }
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetElement jetElement = expression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> call = CallUtilPackage$callUtil$cc168a05.getResolvedCall(jetElement, bindingContext);
        if (call == null) {
            return null;
        }
        CallableDescriptor resultingDescriptor = call.getResultingDescriptor();
        if (CompileTimeConstantUtils.isArrayMethodCall(call)) {
            boolean bl;
            ArrayValue arrayValue;
            ArrayValue arrayValue2;
            List list;
            JetType jetType;
            boolean bl2;
            block11: {
                ArrayValue arrayValue3;
                JetType jetType2 = KotlinPackage.first(resultingDescriptor.getValueParameters()).getVarargElementType();
                if (jetType2 == null) {
                    Intrinsics.throwNpe();
                }
                JetType varargType = jetType2;
                Iterable iterable = call.getValueArguments().values();
                Iterable iterable2 = iterable;
                Collection collection2 = new ArrayList();
                Iterator iterator2 = iterable2.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    ResolvedValueArgument it = (ResolvedValueArgument)t;
                    List<ValueArgument> list2 = it.getArguments();
                    Intrinsics.checkExpressionValueIsNotNull(list2, "it.getArguments()");
                    Iterable iterable3 = ConstantExpressionEvaluator.resolveArguments$b$2(this, list2, varargType);
                    KotlinPackage.addAll(collection2, iterable3);
                }
                List arguments2 = (ArrayList)collection2;
                JetType jetType3 = resultingDescriptor.getReturnType();
                if (jetType3 == null) {
                    Intrinsics.throwNpe();
                }
                iterable = arguments2;
                bl2 = true;
                jetType = jetType3;
                list = arguments2;
                arrayValue2 = arrayValue3;
                arrayValue = arrayValue3;
                for (Collection collection2 : iterable) {
                    CompileTimeConstant it = (CompileTimeConstant)((Object)collection2);
                    if (!it.usesVariableAsConstant()) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            boolean bl3 = bl;
            arrayValue2(list, jetType, bl2, bl3);
            return arrayValue;
        }
        if (resultingDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)resultingDescriptor).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "resultingDescriptor.getContainingDeclaration()");
            ClassDescriptor classDescriptor2 = classDescriptor;
            if (DescriptorUtils.isAnnotationClass(classDescriptor2)) {
                AnnotationDescriptorImpl descriptor = new AnnotationDescriptorImpl(classDescriptor2.getDefaultType(), AnnotationResolver.resolveAnnotationArguments(call, this.trace));
                return new AnnotationValue(descriptor);
            }
        }
        if (CompileTimeConstantUtils.isJavaClassMethodCall(call)) {
            JetType jetType = resultingDescriptor.getReturnType();
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            return new JavaClassValue(jetType);
        }
        return null;
    }

    private final List<CompileTimeConstant<? extends Object>> resolveArguments(@JetValueParameter(name="valueArguments") List<? extends ValueArgument> valueArguments2, @JetValueParameter(name="expectedType") JetType expectedType) {
        ArrayList<CompileTimeConstant> constants = KotlinPackage.arrayListOf(new CompileTimeConstant[0]);
        for (ValueArgument valueArgument : valueArguments2) {
            CompileTimeConstant<? extends Object> compileTimeConstant;
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (!(argumentExpression != null) || !((compileTimeConstant = this.evaluate(argumentExpression, expectedType)) != null)) continue;
            constants.add(compileTimeConstant);
        }
        return constants;
    }

    @Override
    @Nullable
    public CompileTimeConstant<? extends Object> visitJetElement(@JetValueParameter(name="element") @NotNull JetElement element, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "visitJetElement"));
        }
        Intrinsics.checkParameterIsNotNull(element, "element");
        return null;
    }

    private final OperationArgument createOperationArgumentForReceiver(@JetValueParameter(name="resolvedCall") ResolvedCall<? extends CallableDescriptor> resolvedCall, @JetValueParameter(name="expression") JetExpression expression) {
        JetType receiverExpressionType = EvaluatePackage$ConstantExpressionEvaluator$65b0d39c.getReceiverExpressionType(resolvedCall);
        if (receiverExpressionType == null) {
            return null;
        }
        CompileTimeType<? extends Object> receiverCompileTimeType = EvaluatePackage$ConstantExpressionEvaluator$65b0d39c.getCompileTimeType(receiverExpressionType);
        if (receiverCompileTimeType == null) {
            return null;
        }
        return this.createOperationArgument(expression, receiverExpressionType, receiverCompileTimeType);
    }

    private final OperationArgument createOperationArgumentForFirstParameter(@JetValueParameter(name="argument") ResolvedValueArgument argument, @JetValueParameter(name="parameter") ValueParameterDescriptor parameter) {
        JetType jetType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(jetType, "parameter.getType()");
        CompileTimeType<? extends Object> argumentCompileTimeType = EvaluatePackage$ConstantExpressionEvaluator$65b0d39c.getCompileTimeType(jetType);
        if (argumentCompileTimeType == null) {
            return null;
        }
        List<ValueArgument> arguments2 = argument.getArguments();
        if (arguments2.size() != 1) {
            return null;
        }
        JetExpression argumentExpression = KotlinPackage.first(arguments2).getArgumentExpression();
        if (argumentExpression == null) {
            return null;
        }
        JetType jetType2 = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(jetType2, "parameter.getType()");
        return this.createOperationArgument(argumentExpression, jetType2, argumentCompileTimeType);
    }

    private final OperationArgument createOperationArgument(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="expressionType") JetType expressionType, @JetValueParameter(name="compileTimeType") CompileTimeType<? extends Object> compileTimeType) {
        CompileTimeConstant<? extends Object> evaluatedConstant = this.evaluate(expression, expressionType);
        if (evaluatedConstant == null) {
            return null;
        }
        if (evaluatedConstant instanceof IntegerValueTypeConstant) {
            Number evaluationResultWithNewType;
            Number number = evaluationResultWithNewType = ((IntegerValueTypeConstant)evaluatedConstant).getValue(expressionType);
            Intrinsics.checkExpressionValueIsNotNull(number, "evaluationResultWithNewType");
            return new OperationArgument(number, compileTimeType, expression);
        }
        Object evaluationResult = evaluatedConstant.getValue();
        if (evaluationResult == null) {
            return null;
        }
        return new OperationArgument(evaluationResult, compileTimeType, expression);
    }

    @Nullable
    public final CompileTimeConstant<? extends Object> createCompileTimeConstant(@JetValueParameter(name="value", type="?") @Nullable Object value, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType, @JetValueParameter(name="isPure") boolean isPure, @JetValueParameter(name="canBeUsedInAnnotation") boolean canBeUsedInAnnotation, @JetValueParameter(name="usesVariableAsConstant") boolean usesVariableAsConstant) {
        JetType jetType;
        EvaluatorContext c = new EvaluatorContext(canBeUsedInAnnotation, isPure, usesVariableAsConstant);
        if (isPure) {
            jetType = expectedType;
            if (jetType == null) {
                jetType = TypeUtils.NO_EXPECTED_TYPE;
            }
        } else {
            jetType = null;
        }
        return EvaluatePackage$ConstantExpressionEvaluator$65b0d39c.createCompileTimeConstant(value, c, jetType);
    }

    /*
     * WARNING - void declaration
     */
    public static CompileTimeConstant createCompileTimeConstant$default(ConstantExpressionEvaluator constantExpressionEvaluator, Object object2, JetType jetType, boolean bl, boolean bl2, boolean bl3, int n) {
        int n2;
        int n3;
        int n4;
        void var6_9;
        if ((var6_9 & 4) != 0) {
            n4 = 1;
        }
        if ((var6_9 & 8) != 0) {
            n3 = 1;
        }
        if ((var6_9 & 0x10) != 0) {
            n2 = 0;
        }
        return constantExpressionEvaluator.createCompileTimeConstant(object2, jetType, n4 != 0, n3 != 0, n2 != 0);
    }

    @NotNull
    public final BindingTrace getTrace() {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "getTrace"));
        }
        return bindingTrace;
    }

    private ConstantExpressionEvaluator(@JetValueParameter(name="trace") BindingTrace trace) {
        this.trace = trace;
        this.stringExpressionEvaluator = new KObject(this){
            public static final /* synthetic */ KClassImpl $kotlinClass;
            final /* synthetic */ ConstantExpressionEvaluator this$0;

            static {
                $kotlinClass = InternalPackage.kClassFromKotlin(stringExpressionEvaluator.1.class);
            }

            @Nullable
            public final StringValue evaluate(@JetValueParameter(name="entry") @NotNull JetStringTemplateEntry entry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "evaluate"));
                }
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                return (StringValue)entry.accept(this, null);
            }

            @Nullable
            public StringValue visitStringTemplateEntryWithExpression(@JetValueParameter(name="entry") @NotNull JetStringTemplateEntryWithExpression entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitStringTemplateEntryWithExpression"));
                }
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                JetExpression expression = entry.getExpression();
                if (expression == null) {
                    return null;
                }
                return EvaluatePackage$ConstantExpressionEvaluator$65b0d39c.createStringConstant(ConstantExpressionEvaluator.evaluate$b$1(this.this$0, expression, KotlinBuiltIns.getInstance().getStringType()));
            }

            @NotNull
            public StringValue visitLiteralStringTemplateEntry(@JetValueParameter(name="entry") @NotNull JetLiteralStringTemplateEntry entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitLiteralStringTemplateEntry"));
                }
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                StringValue stringValue = new StringValue(entry.getText(), true, false);
                if (stringValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitLiteralStringTemplateEntry"));
                }
                return stringValue;
            }

            @NotNull
            public StringValue visitEscapeStringTemplateEntry(@JetValueParameter(name="entry") @NotNull JetEscapeStringTemplateEntry entry, @JetValueParameter(name="data", type="?") @Nullable Void data2) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitEscapeStringTemplateEntry"));
                }
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                StringValue stringValue = new StringValue(entry.getUnescapedValue(), true, false);
                if (stringValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$stringExpressionEvaluator$1", "visitEscapeStringTemplateEntry"));
                }
                return stringValue;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ ConstantExpressionEvaluator $init$b$0(@JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "$init$b$0"));
        }
        ConstantExpressionEvaluator constantExpressionEvaluator = new ConstantExpressionEvaluator(trace);
        if (constantExpressionEvaluator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "$init$b$0"));
        }
        return constantExpressionEvaluator;
    }

    @Nullable
    public static final /* synthetic */ CompileTimeConstant<? extends Object> evaluate$b$1(@JetValueParameter(name="$this", type="?") ConstantExpressionEvaluator $this, @JetValueParameter(name="expression") @NotNull JetExpression expression, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "evaluate$b$1"));
        }
        return $this.evaluate(expression, expectedType);
    }

    @NotNull
    public static final /* synthetic */ List<CompileTimeConstant<? extends Object>> resolveArguments$b$2(@JetValueParameter(name="$this", type="?") ConstantExpressionEvaluator $this, @JetValueParameter(name="valueArguments") @NotNull List<? extends ValueArgument> valueArguments2, @JetValueParameter(name="expectedType") @NotNull JetType expectedType) {
        if (valueArguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "resolveArguments$b$2"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "resolveArguments$b$2"));
        }
        List<CompileTimeConstant<? extends Object>> list = $this.resolveArguments(valueArguments2, expectedType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator", "resolveArguments$b$2"));
        }
        return list;
    }

    @KotlinClass(abiVersion=19, data={"Q\u0006)qCh\u00197bgNlsN\u00196fGRlcm\u001c:.\u0007>t7\u000f^1oi\u0016C\bO]3tg&|g.\u0012<bYV\fGo\u001c:?\u0015m\u0019uN\\:uC:$X\t\u001f9sKN\u001c\u0018n\u001c8Fm\u0006dW/\u0019;pe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(b\u00016fi*!A.\u00198h\u0015!)g/\u00197vCR,'bA!os*11n\u001c;mS:T!\"\u001a=qe\u0016\u001c8/[8o\u00155QU\r^#yaJ,7o]5p]*\u0019\u0001o]5\u000b\u000bQ\u0014\u0018mY3\u000b\u0019\tKg\u000eZ5oOR\u0013\u0018mY3\u000b\u000fI,7o\u001c7wK*aQ\r\u001f9fGR,G\rV=qK*9!*\u001a;UsB,'\"\u0002;za\u0016\u001c(bE\"p[BLG.\u001a+j[\u0016\u001cuN\\:uC:$(\"C2p]N$\u0018M\u001c;t\u0015uI7\u000f\u0015:pa\u0016\u0014H/_\"p[BLG.\u001a+j[\u0016\u001cuN\\:uC:$(B\u00033fg\u000e\u0014\u0018\u000e\u001d;pe*\u0011b+\u0019:jC\ndW\rR3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b\u000f\t{w\u000e\\3b]\u0012\u000e!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0003!!Qa\u0001C\u0004\u0011\u000fa\u0001!\u0002\u0002\u0005\u0004!-Qa\u0001C\u0005\u0011\u0015a\u0001!\u0002\u0002\u0005\u0004!9Qa\u0001C\u0006\u0011\u001ba\u0001!\u0002\u0002\u0005\u0004!EQa\u0001C\u0007\u0011!a\u0001!\u0002\u0002\u0005\f!MQa\u0001C\b\u0011%a\u0001!\u0002\u0002\u0005\u0010!IQA\u0001C\u0005\u0011\u0015)!\u0001b\u0003\t\u000e\u0015\u0011AQ\u0002\u0005\t\u000b\t!\u0019\u0001c\u0006\u0006\u0007\u0011U\u0001b\u0003\u0007\u0001\u000b\r!9\u0001\u0003\u0007\r\u0001\u0015\u0011AQ\u0003\u0005\f\t\r\u000fAbA\r\u0003\u000b\u0005AA!\f\u0018\u0005\u0007a\u0019QT\u0002\u0003\u0001\u0011\u0013i!!B\u0001\t\u000bA\u001b\u0001!(\u0004\u0005\u0001!1QBA\u0003\u0002\u0011\u0019\u00016\u0011AO\b\t\u0005Ay!D\u0002\u0006\u0003!9A\u0012\u0001)\u0004\u0003\u0005JQ!\u0001\u0005\t\u0013\u0015!\t!C\u0002\u0006\u0003!!A\u0012\u0001G\u0001#\u000eIAaA\u0005\u0002\u0011#i\u0011\u0001C\u0005\u000e\u0003!MQ\"\u0001\u0005\u000b[M!1\u0001\u0007\u0006\u001e\u000e\u0011\u0001\u0001RC\u0007\u0003\u000b\u0005A1\u0002U\u0002\u0001C\t)\u0011\u0001c\u0006R\u0007\u0015!!\"C\u0001\u0005\u00025\t\u0001\u0002D\u001b\u0001"})
    public static final class object
    implements KObject {
        public static final /* synthetic */ KClassImpl $kotlinClass;

        static {
            $kotlinClass = InternalPackage.kClassFromKotlin(object.class);
        }

        @Nullable
        public final CompileTimeConstant<? extends Object> evaluate(@JetValueParameter(name="expression") @NotNull JetExpression expression, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$object", "evaluate"));
            }
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$object", "evaluate"));
            }
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            ConstantExpressionEvaluator evaluator = ConstantExpressionEvaluator.$init$b$0(trace);
            return ConstantExpressionEvaluator.evaluate$b$1(evaluator, expression, expectedType);
        }

        public static CompileTimeConstant evaluate$default(object object2, JetExpression jetExpression, BindingTrace bindingTrace, JetType jetType, int n) {
            if ((n & 4) != 0) {
                jetType = TypeUtils.NO_EXPECTED_TYPE;
            }
            return object2.evaluate(jetExpression, bindingTrace, jetType);
        }

        public final boolean isPropertyCompileTimeConstant(@JetValueParameter(name="descriptor") @NotNull VariableDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$object", "isPropertyCompileTimeConstant"));
            }
            Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
            if (descriptor.isVar()) {
                return false;
            }
            if (!(!DescriptorUtils.isObject(descriptor.getContainingDeclaration()) ? DescriptorUtils.isClassObject(descriptor.getContainingDeclaration()) : true) ? DescriptorUtils.isStaticDeclaration(descriptor) : true) {
                JetType returnType = descriptor.getType();
                return !KotlinBuiltIns.isPrimitiveType(returnType) ? KotlinBuiltIns.isString(returnType) : true;
            }
            return false;
        }

        private object() {
        }

        @NotNull
        public static final /* synthetic */ object $init$b$0() {
            object object2 = new object();
            if (object2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$object", "$init$b$0"));
            }
            return object2;
        }
    }

    @KotlinClass(abiVersion=19, data={"_\u0004)\tr\n]3sCRLwN\\!sOVlWM\u001c;\u000b7\r{gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NT1A[3u\u0015\u0011a\u0017M\\4\u000b\u0011\u00154\u0018\r\\;bi\u0016T1!\u00118z\u0015\u0019Yw\u000e\u001e7j]*1A(\u001b8jizRQA^1mk\u0016Tqa\u0019;d)f\u0004XMC\bD_6\u0004\u0018\u000e\\3US6,G+\u001f9f\u0015))\u0007\u0010\u001d:fgNLwN\u001c\u0006\u000e\u0015\u0016$X\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u0007A\u001c\u0018N\u0003\u0003kCZ\f'BB(cU\u0016\u001cGO\u0003\u0006hKR\u001cEo\u0019+za\u0016TQbZ3u\u000bb\u0004(/Z:tS>t'\u0002C4fiZ\u000bG.^3k\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)!\u0001b\u0001\t\u0007\u0015\u0019AA\u0001E\u0001\u0019\u0001)1\u0001\"\u0002\t\u00011\u0001Q!\u0001\u0005\u0005\u000b\r!9\u0001c\u0002\r\u0001\u0015\u0019AA\u0001\u0005\u0007\u0019\u0001)!\u0001b\u0001\t\u0010\u0015\u0019A!\u0002\u0005\b\u0019\u0001)\u0011\u0001\u0003\u0005\u0006\u0005\u00111\u0001RA\u0003\u0003\t\u001bA\t\"\u0002\u0002\u0005\u0005!1QA\u0001\u0003\u0006\u0011\u001d!\u0011\u0001D\u0002\u001a\u0005\u0015\t\u0001\u0002B\u0017\u0016\t\u0001$\u00014B\u0011\t\u000b\u0005AI!C\u0003\u0005\u0002%\u0019Q!\u0001\u0005\u0005\u0019\u0003)6\u0001C\u0003\u0004\t\u0017I\u0011\u0001c\u0004\u000e\u0007\u0011I\u0011\"\u0001E\b[=!\u0001\r\u0002M\u0007C\t)\u0011\u0001c\u0003V\u0007!)1\u0001\"\u0004\n\u0003!AQb\u0001C\n\u0013\u0005A\u0001\"L\b\u0005A\u0012AR!\t\u0002\u0006\u0003!!Qk\u0001\u0005\u0006\u0007\u0011)\u0011\"\u0001\u0005\b\u001b\r!!\"C\u0001\t\u000fUnS\u0011\f\u0003d\u0002a%QT\u0002\u0003\u0001\u0011\u0015i!!B\u0001\t\tA\u001b\u0001!(\u0007\u0005\u0001!-Q\u0002C\u0003\u0002\u0011\u0013IQ\u0001\"\u0001\n\u0007\u0015\t\u0001\u0002\u0002G\u0001!\u000e\u0005QT\u0002\u0003\u0001\u0011\u001bi!!B\u0001\t\fA\u001b\u0011!\t\u0002\u0006\u0003!\u0019\u0011kA\u0005\u0005\n%\tA\u0001A\u0007\u0002\u0011\u001di\u0011\u0001c\u0004\u000e\u0003!A\u0001"})
    private static final class OperationArgument
    implements KObject {
        public static final /* synthetic */ KClassImpl $kotlinClass;
        @NotNull
        private final Object value;
        @NotNull
        private final CompileTimeType<? extends Object> ctcType;
        @NotNull
        private final JetExpression expression;

        static {
            $kotlinClass = InternalPackage.kClassFromKotlin(OperationArgument.class);
        }

        @NotNull
        public final Object getValue() {
            Object object2 = this.value;
            if (object2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "getValue"));
            }
            return object2;
        }

        @NotNull
        public final CompileTimeType<? extends Object> getCtcType() {
            CompileTimeType<? extends Object> compileTimeType = this.ctcType;
            if (compileTimeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "getCtcType"));
            }
            return compileTimeType;
        }

        @NotNull
        public final JetExpression getExpression() {
            JetExpression jetExpression = this.expression;
            if (jetExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "getExpression"));
            }
            return jetExpression;
        }

        public OperationArgument(@JetValueParameter(name="value") @NotNull Object value, @JetValueParameter(name="ctcType") @NotNull CompileTimeType<? extends Object> ctcType, @JetValueParameter(name="expression") @NotNull JetExpression expression) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "<init>"));
            }
            if (ctcType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctcType", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "<init>"));
            }
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/evaluate/ConstantExpressionEvaluator$OperationArgument", "<init>"));
            }
            Intrinsics.checkParameterIsNotNull(value, "value");
            Intrinsics.checkParameterIsNotNull(ctcType, "ctcType");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            this.value = value;
            this.ctcType = ctcType;
            this.expression = expression;
        }
    }
}

