/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Stack;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.parsing.AbstractTokenStreamPredicate;
import org.jetbrains.jet.lang.parsing.JetParsing;
import org.jetbrains.jet.lang.parsing.LastBefore;
import org.jetbrains.jet.lang.parsing.PrecedingCommentsBinder;
import org.jetbrains.jet.lang.parsing.PrecedingDocCommentsBinder;
import org.jetbrains.jet.lang.parsing.SemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.jet.lang.parsing.TokenStreamPattern;
import org.jetbrains.jet.lang.parsing.TrailingCommentsBinder;
import org.jetbrains.jet.lang.parsing.TruncatedSemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetSingleValueToken;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

abstract class AbstractJetParsing {
    private static final Logger LOGGER = Logger.getInstance(AbstractJetParsing.class);
    private static final Map<String, JetKeywordToken> SOFT_KEYWORD_TEXTS = new HashMap<String, JetKeywordToken>();
    protected final SemanticWhitespaceAwarePsiBuilder myBuilder;

    public AbstractJetParsing(SemanticWhitespaceAwarePsiBuilder builder) {
        this.myBuilder = builder;
    }

    protected IElementType getLastToken() {
        int i;
        int currentOffset = this.myBuilder.getCurrentOffset();
        for (i = 1; i <= currentOffset && JetTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(this.myBuilder.rawLookup(-i)); ++i) {
        }
        return this.myBuilder.rawLookup(-i);
    }

    protected boolean expect(JetToken expectation, String message) {
        return this.expect(expectation, message, null);
    }

    protected PsiBuilder.Marker mark() {
        return this.myBuilder.mark();
    }

    protected void error(String message) {
        this.myBuilder.error(message);
    }

    protected boolean expect(JetToken expectation, String message, TokenSet recoverySet) {
        if (this.at(expectation)) {
            this.advance();
            return true;
        }
        this.errorWithRecovery(message, recoverySet);
        return false;
    }

    protected boolean expectNoAdvance(JetToken expectation, String message) {
        if (this.at(expectation)) {
            this.advance();
            return true;
        }
        this.error(message);
        return false;
    }

    protected void errorWithRecovery(String message, TokenSet recoverySet) {
        IElementType tt = this.tt();
        if (recoverySet == null || recoverySet.contains(tt) || recoverySet.contains(JetTokens.EOL_OR_SEMICOLON) && (this.eof() || tt == JetTokens.SEMICOLON || this.myBuilder.newlineBeforeCurrentToken())) {
            this.error(message);
        } else {
            this.errorAndAdvance(message);
        }
    }

    protected boolean errorAndAdvance(String message) {
        return this.errorAndAdvance(message, 1);
    }

    protected boolean errorAndAdvance(String message, int advanceTokenCount) {
        PsiBuilder.Marker err = this.mark();
        this.advance(advanceTokenCount);
        err.error(message);
        return false;
    }

    protected boolean eof() {
        return this.myBuilder.eof();
    }

    protected void advance() {
        this.myBuilder.advanceLexer();
    }

    protected void advance(int advanceTokenCount) {
        for (int i = 0; i < advanceTokenCount; ++i) {
            this.advance();
        }
    }

    protected void advanceAt(IElementType current) {
        assert (this._at(current));
        this.myBuilder.advanceLexer();
    }

    protected void advanceAtSet(IElementType ... tokens) {
        assert (this._atSet(tokens));
        this.myBuilder.advanceLexer();
    }

    protected void advanceAtSet(TokenSet set) {
        assert (this._atSet(set));
        this.myBuilder.advanceLexer();
    }

    protected IElementType tt() {
        return this.myBuilder.getTokenType();
    }

    protected boolean _at(IElementType expectation) {
        IElementType token = this.tt();
        return this.tokenMatches(token, expectation);
    }

    private boolean tokenMatches(IElementType token, IElementType expectation) {
        if (token == expectation) {
            return true;
        }
        if (expectation == JetTokens.EOL_OR_SEMICOLON) {
            if (this.eof()) {
                return true;
            }
            if (token == JetTokens.SEMICOLON) {
                return true;
            }
            if (this.myBuilder.newlineBeforeCurrentToken()) {
                return true;
            }
        }
        return false;
    }

    protected boolean at(IElementType expectation) {
        JetKeywordToken keywordToken;
        JetKeywordToken expectedKeyword;
        if (this._at(expectation)) {
            return true;
        }
        IElementType token = this.tt();
        if (token == JetTokens.IDENTIFIER && expectation instanceof JetKeywordToken && (expectedKeyword = (JetKeywordToken)expectation).isSoft() && expectedKeyword.getValue().equals(this.myBuilder.getTokenText())) {
            this.myBuilder.remapCurrentToken(expectation);
            return true;
        }
        if (expectation == JetTokens.IDENTIFIER && token instanceof JetKeywordToken && (keywordToken = (JetKeywordToken)token).isSoft()) {
            this.myBuilder.remapCurrentToken(JetTokens.IDENTIFIER);
            return true;
        }
        return false;
    }

    protected boolean _atSet(IElementType ... tokens) {
        return this._atSet(TokenSet.create(tokens));
    }

    protected boolean _atSet(TokenSet set) {
        IElementType token = this.tt();
        if (set.contains(token)) {
            return true;
        }
        if (set.contains(JetTokens.EOL_OR_SEMICOLON)) {
            if (this.eof()) {
                return true;
            }
            if (token == JetTokens.SEMICOLON) {
                return true;
            }
            if (this.myBuilder.newlineBeforeCurrentToken()) {
                return true;
            }
        }
        return false;
    }

    protected boolean atSet(IElementType ... tokens) {
        return this.atSet(TokenSet.create(tokens));
    }

    protected boolean atSet(TokenSet set) {
        if (this._atSet(set)) {
            return true;
        }
        IElementType token = this.tt();
        if (token == JetTokens.IDENTIFIER) {
            JetKeywordToken keywordToken = SOFT_KEYWORD_TEXTS.get(this.myBuilder.getTokenText());
            if (keywordToken != null && set.contains(keywordToken)) {
                this.myBuilder.remapCurrentToken(keywordToken);
                return true;
            }
        } else if (set.contains(JetTokens.IDENTIFIER) && token instanceof JetKeywordToken && ((JetKeywordToken)token).isSoft()) {
            this.myBuilder.remapCurrentToken(JetTokens.IDENTIFIER);
            return true;
        }
        return false;
    }

    protected IElementType lookahead(int k) {
        return this.myBuilder.lookAhead(k);
    }

    protected void consumeIf(JetToken token) {
        if (this.at(token)) {
            this.advance();
        }
    }

    protected void skipUntil(TokenSet tokenSet) {
        boolean stopAtEolOrSemi = tokenSet.contains(JetTokens.EOL_OR_SEMICOLON);
        while (!(this.eof() || tokenSet.contains(this.tt()) || stopAtEolOrSemi && this.at(JetTokens.EOL_OR_SEMICOLON))) {
            this.advance();
        }
    }

    protected void errorUntil(String message, TokenSet tokenSet) {
        PsiBuilder.Marker error = this.mark();
        this.skipUntil(tokenSet);
        error.error(message);
    }

    protected void errorUntilOffset(String mesage, int offset) {
        PsiBuilder.Marker error = this.mark();
        while (!this.eof() && this.myBuilder.getCurrentOffset() < offset) {
            this.advance();
        }
        error.error(mesage);
    }

    protected static void errorIf(PsiBuilder.Marker marker, boolean condition, String message) {
        if (condition) {
            marker.error(message);
        } else {
            marker.drop();
        }
    }

    protected int matchTokenStreamPredicate(TokenStreamPattern pattern) {
        PsiBuilder.Marker currentPosition = this.mark();
        int beginOffset = this.myBuilder.getCurrentOffset();
        Stack<JetSingleValueToken> opens = new Stack<JetSingleValueToken>();
        int openAngleBrackets = 0;
        int openBraces = 0;
        int openParentheses = 0;
        int openBrackets = 0;
        while (!this.eof() && !pattern.processToken(this.myBuilder.getCurrentOffset(), pattern.isTopLevel(openAngleBrackets, openBrackets, openBraces, openParentheses))) {
            if (this.at(JetTokens.LPAR)) {
                ++openParentheses;
                opens.push(JetTokens.LPAR);
            } else if (this.at(JetTokens.LT)) {
                ++openAngleBrackets;
                opens.push(JetTokens.LT);
            } else if (this.at(JetTokens.LBRACE)) {
                ++openBraces;
                opens.push(JetTokens.LBRACE);
            } else if (this.at(JetTokens.LBRACKET)) {
                ++openBrackets;
                opens.push(JetTokens.LBRACKET);
            } else if (this.at(JetTokens.RPAR)) {
                --openParentheses;
                if ((opens.isEmpty() || opens.pop() != JetTokens.LPAR) && pattern.handleUnmatchedClosing(JetTokens.RPAR)) {
                    break;
                }
            } else if (this.at(JetTokens.GT)) {
                --openAngleBrackets;
            } else if (this.at(JetTokens.RBRACE)) {
                --openBraces;
            } else if (this.at(JetTokens.RBRACKET)) {
                --openBrackets;
            }
            this.advance();
        }
        int endOffset = this.myBuilder.getCurrentOffset();
        currentPosition.rollbackTo();
        if (endOffset - beginOffset > 1000 && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            String text = new StringBuilder(this.myBuilder.getOriginalText()).insert(endOffset, "<~~!END!~~>").insert(beginOffset, "<~~!BEGIN!~~>").toString();
            LOGGER.warn("Suspicious big range: \n" + text);
        }
        return pattern.result();
    }

    protected int findLastBefore(TokenSet lookFor, TokenSet stopAt, boolean dontStopRightAfterOccurrence) {
        return this.matchTokenStreamPredicate(new LastBefore(new AtSet(lookFor), new AtSet(stopAt), dontStopRightAfterOccurrence));
    }

    protected int findLastBefore(IElementType lookFor, TokenSet stopAt, boolean dontStopRightAfterOccurrence) {
        return this.matchTokenStreamPredicate(new LastBefore(new At(lookFor), new AtSet(stopAt), dontStopRightAfterOccurrence));
    }

    protected boolean eol() {
        return this.myBuilder.newlineBeforeCurrentToken() || this.eof();
    }

    protected static void closeDeclarationWithCommentBinders(@NotNull PsiBuilder.Marker marker, @NotNull IElementType elementType, boolean precedingNonDocComments) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "org/jetbrains/jet/lang/parsing/AbstractJetParsing", "closeDeclarationWithCommentBinders"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/jet/lang/parsing/AbstractJetParsing", "closeDeclarationWithCommentBinders"));
        }
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders((WhitespacesAndCommentsBinder)((Object)(precedingNonDocComments ? PrecedingCommentsBinder.INSTANCE$ : PrecedingDocCommentsBinder.INSTANCE$)), TrailingCommentsBinder.INSTANCE$);
    }

    protected abstract JetParsing create(SemanticWhitespaceAwarePsiBuilder var1);

    protected JetParsing createTruncatedBuilder(int eofPosition) {
        return this.create(new TruncatedSemanticWhitespaceAwarePsiBuilder(this.myBuilder, eofPosition));
    }

    public String currentContext() {
        String marker = "~!!!~";
        int range = 50;
        CharSequence text = this.myBuilder.getOriginalText();
        int start = Math.max(0, this.myBuilder.getCurrentOffset() - range);
        int end = Math.min(text.length() - 1, this.myBuilder.getCurrentOffset() + 50 + marker.length());
        return new StringBuilder(text).insert(this.myBuilder.getCurrentOffset(), marker).substring(start, end);
    }

    static {
        for (IElementType type2 : JetTokens.SOFT_KEYWORDS.getTypes()) {
            JetKeywordToken keywordToken = (JetKeywordToken)type2;
            assert (keywordToken.isSoft());
            SOFT_KEYWORD_TEXTS.put(keywordToken.getValue(), keywordToken);
        }
        for (IElementType token : JetTokens.KEYWORDS.getTypes()) {
            assert (token instanceof JetKeywordToken) : "Must be JetKeywordToken: " + token;
            assert (!((JetKeywordToken)token).isSoft()) : "Must not be soft: " + token;
        }
    }

    protected class AtFirstTokenOfTokens
    extends AbstractTokenStreamPredicate {
        private final IElementType[] tokens;

        public AtFirstTokenOfTokens(IElementType ... tokens) {
            assert (tokens.length > 0);
            this.tokens = tokens;
        }

        @Override
        public boolean matching(boolean topLevel) {
            int length = this.tokens.length;
            if (!AbstractJetParsing.this.at(this.tokens[0])) {
                return false;
            }
            for (int i = 1; i < length; ++i) {
                IElementType lookAhead = AbstractJetParsing.this.myBuilder.lookAhead(i);
                if (lookAhead != null && AbstractJetParsing.this.tokenMatches(lookAhead, this.tokens[i])) continue;
                return false;
            }
            return true;
        }
    }

    protected class AtSet
    extends AbstractTokenStreamPredicate {
        private final TokenSet lookFor;
        private final TokenSet topLevelOnly;

        public AtSet(TokenSet lookFor, TokenSet topLevelOnly) {
            this.lookFor = lookFor;
            this.topLevelOnly = topLevelOnly;
        }

        public AtSet(TokenSet lookFor) {
            this(lookFor, lookFor);
        }

        public AtSet(IElementType ... lookFor) {
            this(TokenSet.create(lookFor), TokenSet.create(lookFor));
        }

        @Override
        public boolean matching(boolean topLevel) {
            return (topLevel || !AbstractJetParsing.this.atSet(this.topLevelOnly)) && AbstractJetParsing.this.atSet(this.lookFor);
        }
    }

    protected class At
    extends AbstractTokenStreamPredicate {
        private final IElementType lookFor;
        private final boolean topLevelOnly;

        public At(IElementType lookFor, boolean topLevelOnly) {
            this.lookFor = lookFor;
            this.topLevelOnly = topLevelOnly;
        }

        public At(IElementType lookFor) {
            this(lookFor, true);
        }

        @Override
        public boolean matching(boolean topLevel) {
            return (topLevel || !this.topLevelOnly) && AbstractJetParsing.this.at(this.lookFor);
        }
    }

    protected class AtOffset
    extends AbstractTokenStreamPredicate {
        private final int offset;

        public AtOffset(int offset) {
            this.offset = offset;
        }

        @Override
        public boolean matching(boolean topLevel) {
            return AbstractJetParsing.this.myBuilder.getCurrentOffset() == this.offset;
        }
    }

    protected class OptionalMarker {
        private final PsiBuilder.Marker marker;
        private final int offset;

        public OptionalMarker(boolean actuallyMark) {
            this.marker = actuallyMark ? AbstractJetParsing.this.mark() : null;
            this.offset = AbstractJetParsing.this.myBuilder.getCurrentOffset();
        }

        public void done(IElementType elementType) {
            if (this.marker == null) {
                return;
            }
            this.marker.done(elementType);
        }

        public void error(String message) {
            if (this.marker == null) {
                return;
            }
            if (this.offset == AbstractJetParsing.this.myBuilder.getCurrentOffset()) {
                this.marker.drop();
            } else {
                this.marker.error(message);
            }
        }

        public void drop() {
            if (this.marker == null) {
                return;
            }
            this.marker.drop();
        }
    }
}

