/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwnerStub;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.stubs.KotlinTypeProjectionStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lexer.JetTokens;

public class JetTypeProjection
extends JetModifierListOwnerStub<KotlinTypeProjectionStub> {
    public JetTypeProjection(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetTypeProjection", "<init>"));
        }
        super(node);
    }

    public JetTypeProjection(@NotNull KotlinTypeProjectionStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetTypeProjection", "<init>"));
        }
        super(stub, JetStubElementTypes.TYPE_PROJECTION);
    }

    @NotNull
    public JetProjectionKind getProjectionKind() {
        KotlinTypeProjectionStub stub = (KotlinTypeProjectionStub)this.getStub();
        if (stub != null) {
            JetProjectionKind jetProjectionKind = stub.getProjectionKind();
            if (jetProjectionKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetTypeProjection", "getProjectionKind"));
            }
            return jetProjectionKind;
        }
        ASTNode projectionNode = this.getProjectionNode();
        IElementType token = projectionNode != null ? projectionNode.getElementType() : null;
        for (JetProjectionKind projectionKind : JetProjectionKind.values()) {
            if (projectionKind.getToken() != token) continue;
            JetProjectionKind jetProjectionKind = projectionKind;
            if (jetProjectionKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetTypeProjection", "getProjectionKind"));
            }
            return jetProjectionKind;
        }
        throw new IllegalStateException(projectionNode.getText());
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetTypeProjection", "accept"));
        }
        return visitor.visitTypeProjection(this, data2);
    }

    @Nullable
    public JetTypeReference getTypeReference() {
        return (JetTypeReference)this.getStubOrPsiChild(JetStubElementTypes.TYPE_REFERENCE);
    }

    @Nullable
    public ASTNode getProjectionNode() {
        PsiElement star;
        JetModifierList modifierList = this.getModifierList();
        if (modifierList != null) {
            ASTNode node = modifierList.getModifierNode(JetTokens.IN_KEYWORD);
            if (node != null) {
                return node;
            }
            node = modifierList.getModifierNode(JetTokens.OUT_KEYWORD);
            if (node != null) {
                return node;
            }
        }
        if ((star = this.findChildByType(JetTokens.MUL)) != null) {
            return star.getNode();
        }
        return null;
    }
}

