/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.stubs.KotlinPropertyStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.psi.stubs.impl.KotlinStubBaseImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class KotlinPropertyStubImpl
extends KotlinStubBaseImpl<JetProperty>
implements KotlinPropertyStub {
    private final StringRef name;
    private final boolean isVar;
    private final boolean isTopLevel;
    private final boolean hasDelegate;
    private final boolean hasDelegateExpression;
    private final boolean hasInitializer;
    private final boolean hasReceiverTypeRef;
    private final boolean hasReturnTypeRef;
    private final boolean probablyNothingType;
    private final FqName fqName;

    public KotlinPropertyStubImpl(StubElement parent, StringRef name, boolean isVar, boolean isTopLevel, boolean hasDelegate, boolean hasDelegateExpression, boolean hasInitializer, boolean hasReceiverTypeRef, boolean hasReturnTypeRef, boolean probablyNothingType, @Nullable FqName fqName2) {
        super((StubElement<? extends PsiElement>)parent, (IStubElementType<? extends StubElement<? extends Object>, ? extends PsiElement>)JetStubElementTypes.PROPERTY);
        if (isTopLevel && fqName2 == null) {
            throw new IllegalArgumentException("fqName shouldn't be null for top level properties");
        }
        if (hasDelegateExpression && !hasDelegate) {
            throw new IllegalArgumentException("Can't have delegate expression without delegate");
        }
        this.name = name;
        this.isVar = isVar;
        this.isTopLevel = isTopLevel;
        this.hasDelegate = hasDelegate;
        this.hasDelegateExpression = hasDelegateExpression;
        this.hasInitializer = hasInitializer;
        this.hasReceiverTypeRef = hasReceiverTypeRef;
        this.hasReturnTypeRef = hasReturnTypeRef;
        this.probablyNothingType = probablyNothingType;
        this.fqName = fqName2;
    }

    @Override
    public boolean isVar() {
        return this.isVar;
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    @Override
    public boolean hasDelegate() {
        return this.hasDelegate;
    }

    @Override
    public boolean hasDelegateExpression() {
        return this.hasDelegateExpression;
    }

    @Override
    public boolean hasInitializer() {
        return this.hasInitializer;
    }

    @Override
    public boolean hasReceiverTypeRef() {
        return this.hasReceiverTypeRef;
    }

    @Override
    public boolean hasReturnTypeRef() {
        return this.hasReturnTypeRef;
    }

    @Override
    public boolean isProbablyNothingType() {
        return this.probablyNothingType;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        return this.fqName;
    }

    @Override
    public String getName() {
        return StringRef.toString(this.name);
    }
}

