/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.jet.lang.resolve.calls.model.ArgumentMapping;
import org.jetbrains.jet.lang.resolve.calls.model.ArgumentMatch;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.types.lang.InlineUtil;

public class InlineDescriptorUtils {
    public static boolean checkNonLocalReturnUsage(@NotNull DeclarationDescriptor fromFunction, @NotNull JetExpression startExpression, @NotNull BindingTrace trace) {
        if (fromFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFunction", "org/jetbrains/jet/lang/resolve/InlineDescriptorUtils", "checkNonLocalReturnUsage"));
        }
        if (startExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startExpression", "org/jetbrains/jet/lang/resolve/InlineDescriptorUtils", "checkNonLocalReturnUsage"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/InlineDescriptorUtils", "checkNonLocalReturnUsage"));
        }
        Object containingFunction = PsiTreeUtil.getParentOfType((PsiElement)startExpression, JetClassOrObject.class, JetDeclarationWithBody.class);
        if (containingFunction == null) {
            return false;
        }
        DeclarationDescriptor containingFunctionDescriptor = trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, containingFunction);
        if (containingFunctionDescriptor == null) {
            return false;
        }
        BindingContext bindingContext = trace.getBindingContext();
        while (containingFunction instanceof JetFunctionLiteral && fromFunction != containingFunctionDescriptor) {
            if (!InlineDescriptorUtils.isInlineLambda((JetFunctionLiteralExpression)(containingFunction = containingFunction.getParent()), bindingContext, true)) {
                return false;
            }
            containingFunction = (containingFunctionDescriptor = InlineDescriptorUtils.getContainingClassOrFunctionDescriptor(containingFunctionDescriptor, true)) != null ? DescriptorToSourceUtils.descriptorToDeclaration(containingFunctionDescriptor) : null;
        }
        return fromFunction == containingFunctionDescriptor;
    }

    public static boolean isInlineLambda(@NotNull JetFunctionLiteralExpression lambdaExpression, @NotNull BindingContext bindingContext, boolean checkNonLocalReturn) {
        if (lambdaExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "org/jetbrains/jet/lang/resolve/InlineDescriptorUtils", "isInlineLambda"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/resolve/InlineDescriptorUtils", "isInlineLambda"));
        }
        JetExpression call = JetPsiUtil.getParentCallIfPresent(lambdaExpression);
        if (call != null) {
            ValueParameterDescriptor parameter;
            ArgumentMapping mapping2;
            ValueArgument argument;
            CallableDescriptor resultingDescriptor;
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(call, bindingContext);
            CallableDescriptor callableDescriptor = resultingDescriptor = resolvedCall == null ? null : resolvedCall.getResultingDescriptor();
            if (resultingDescriptor instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)resultingDescriptor).getInlineStrategy().isInline() && (argument = CallUtilPackage.getValueArgumentForExpression(resolvedCall.getCall(), lambdaExpression)) != null && (mapping2 = resolvedCall.getArgumentMapping(argument)) instanceof ArgumentMatch && !InlineUtil.hasNoinlineAnnotation(parameter = ((ArgumentMatch)mapping2).getValueParameter())) {
                return !checkNonLocalReturn || InlineDescriptorUtils.allowsNonLocalReturns(parameter);
            }
        }
        return false;
    }

    @Nullable
    public static DeclarationDescriptor getContainingClassOrFunctionDescriptor(@NotNull DeclarationDescriptor descriptor, boolean strict) {
        DeclarationDescriptor currentDescriptor;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/InlineDescriptorUtils", "getContainingClassOrFunctionDescriptor"));
        }
        DeclarationDescriptor declarationDescriptor = currentDescriptor = strict ? descriptor.getContainingDeclaration() : descriptor;
        while (currentDescriptor != null) {
            if (currentDescriptor instanceof FunctionDescriptor || currentDescriptor instanceof ClassDescriptor) {
                return currentDescriptor;
            }
            currentDescriptor = currentDescriptor.getContainingDeclaration();
        }
        return null;
    }

    public static boolean allowsNonLocalReturns(@NotNull CallableDescriptor lambdaDescriptor) {
        if (lambdaDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaDescriptor", "org/jetbrains/jet/lang/resolve/InlineDescriptorUtils", "allowsNonLocalReturns"));
        }
        return !(lambdaDescriptor instanceof ValueParameterDescriptor) || !InlineUtil.hasOnlyLocalReturn((ValueParameterDescriptor)lambdaDescriptor);
    }
}

