/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Mutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetNameReferenceExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.Importer;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;

public class QualifiedExpressionResolver {
    private static final Predicate<DeclarationDescriptor> CLASSIFIERS_AND_PACKAGE_VIEWS = new Predicate<DeclarationDescriptor>(){

        @Override
        public boolean apply(@Nullable DeclarationDescriptor descriptor) {
            return descriptor instanceof ClassifierDescriptor || descriptor instanceof PackageViewDescriptor;
        }
    };

    @NotNull
    public Collection<DeclarationDescriptor> processImportReference(@NotNull JetImportDirective importDirective, @NotNull JetScope scope2, @NotNull JetScope scopeToCheckVisibility, @NotNull Importer importer, @NotNull BindingTrace trace, @NotNull ModuleDescriptor module, @NotNull LookupMode lookupMode) {
        Collection<DeclarationDescriptor> descriptors;
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeToCheckVisibility", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (importer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importer", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (importDirective.isAbsoluteInRootPackage()) {
            trace.report(Errors.UNSUPPORTED.on(importDirective, "TypeHierarchyResolver"));
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
            }
            return list;
        }
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null) {
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
            }
            return list;
        }
        if (importedReference instanceof JetQualifiedExpression) {
            descriptors = this.lookupDescriptorsForQualifiedExpression((JetQualifiedExpression)importedReference, scope2, scopeToCheckVisibility, trace, lookupMode, lookupMode == LookupMode.EVERYTHING);
        } else {
            assert (importedReference instanceof JetSimpleNameExpression);
            descriptors = this.lookupDescriptorsForSimpleNameReference((JetSimpleNameExpression)importedReference, scope2, scopeToCheckVisibility, trace, lookupMode, true, lookupMode == LookupMode.EVERYTHING);
        }
        JetSimpleNameExpression referenceExpression = JetPsiUtil.getLastReference(importedReference);
        if (importDirective.isAllUnder()) {
            if (referenceExpression == null || !QualifiedExpressionResolver.canImportMembersFrom(descriptors, referenceExpression, trace, lookupMode)) {
                List<DeclarationDescriptor> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
                }
                return list;
            }
            for (DeclarationDescriptor descriptor : descriptors) {
                importer.addAllUnderImport(descriptor, module.getPlatformToKotlinClassMap());
            }
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
            }
            return list;
        }
        Name aliasName = JetPsiUtil.getAliasName(importDirective);
        if (aliasName == null) {
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
            }
            return list;
        }
        for (DeclarationDescriptor descriptor : descriptors) {
            importer.addAliasImport(descriptor, aliasName);
        }
        Collection<DeclarationDescriptor> collection = descriptors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        return collection;
    }

    private static boolean canImportMembersFrom(@NotNull Collection<DeclarationDescriptor> descriptors, @NotNull JetSimpleNameExpression reference, @NotNull BindingTrace trace, @NotNull LookupMode lookupMode) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        if (lookupMode == LookupMode.ONLY_CLASSES) {
            return true;
        }
        if (descriptors.size() == 1) {
            return QualifiedExpressionResolver.canImportMembersFrom(descriptors.iterator().next(), reference, trace, lookupMode);
        }
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace, "trace to find out if members can be imported from", reference);
        boolean canImport = false;
        for (DeclarationDescriptor descriptor : descriptors) {
            canImport |= QualifiedExpressionResolver.canImportMembersFrom(descriptor, reference, (BindingTrace)temporaryTrace, lookupMode);
        }
        if (!canImport) {
            temporaryTrace.commit();
        }
        return canImport;
    }

    private static boolean canImportMembersFrom(@NotNull DeclarationDescriptor descriptor, @NotNull JetSimpleNameExpression reference, @NotNull BindingTrace trace, @NotNull LookupMode lookupMode) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "canImportMembersFrom"));
        }
        assert (lookupMode == LookupMode.EVERYTHING);
        if (descriptor instanceof PackageViewDescriptor) {
            return true;
        }
        if (descriptor instanceof ClassDescriptor && !((ClassDescriptor)descriptor).getKind().isSingleton()) {
            return true;
        }
        trace.report(Errors.CANNOT_IMPORT_FROM_ELEMENT.on(reference, descriptor));
        return false;
    }

    @NotNull
    public Collection<DeclarationDescriptor> lookupDescriptorsForUserType(@NotNull JetUserType userType, @NotNull JetScope outerScope, @NotNull BindingTrace trace) {
        if (userType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userType", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
        }
        if (userType.isAbsoluteInRootPackage()) {
            trace.report(Errors.UNSUPPORTED.on(userType, "package"));
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
            }
            return list;
        }
        JetNameReferenceExpression referenceExpression = userType.getReferenceExpression();
        if (referenceExpression == null) {
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
            }
            return list;
        }
        JetUserType qualifier = userType.getQualifier();
        if (qualifier == null) {
            Collection<DeclarationDescriptor> collection = this.lookupDescriptorsForSimpleNameReference(referenceExpression, outerScope, outerScope, trace, LookupMode.ONLY_CLASSES, false, true);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
            }
            return collection;
        }
        Collection<DeclarationDescriptor> declarationDescriptors = this.lookupDescriptorsForUserType(qualifier, outerScope, trace);
        Collection<DeclarationDescriptor> collection = QualifiedExpressionResolver.lookupSelectorDescriptors(referenceExpression, declarationDescriptors, trace, outerScope, LookupMode.ONLY_CLASSES, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
        }
        return collection;
    }

    @NotNull
    public Collection<DeclarationDescriptor> lookupDescriptorsForQualifiedExpression(@NotNull JetQualifiedExpression importedReference, @NotNull JetScope outerScope, @NotNull JetScope scopeToCheckVisibility, @NotNull BindingTrace trace, @NotNull LookupMode lookupMode, boolean storeResult) {
        Collection<DeclarationDescriptor> declarationDescriptors;
        if (importedReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedReference", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeToCheckVisibility", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
        }
        JetExpression receiverExpression = importedReference.getReceiverExpression();
        if (receiverExpression instanceof JetQualifiedExpression) {
            declarationDescriptors = this.lookupDescriptorsForQualifiedExpression((JetQualifiedExpression)receiverExpression, outerScope, scopeToCheckVisibility, trace, lookupMode, storeResult);
        } else {
            assert (receiverExpression instanceof JetSimpleNameExpression);
            declarationDescriptors = this.lookupDescriptorsForSimpleNameReference((JetSimpleNameExpression)receiverExpression, outerScope, scopeToCheckVisibility, trace, lookupMode, true, storeResult);
        }
        JetExpression selectorExpression = importedReference.getSelectorExpression();
        if (!(selectorExpression instanceof JetSimpleNameExpression)) {
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
            }
            return list;
        }
        JetSimpleNameExpression selector = (JetSimpleNameExpression)selectorExpression;
        JetSimpleNameExpression lastReference = JetPsiUtil.getLastReference(receiverExpression);
        if (lastReference == null || !QualifiedExpressionResolver.canImportMembersFrom(declarationDescriptors, lastReference, trace, lookupMode)) {
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
            }
            return list;
        }
        Collection<DeclarationDescriptor> collection = QualifiedExpressionResolver.lookupSelectorDescriptors(selector, declarationDescriptors, trace, scopeToCheckVisibility, lookupMode, storeResult);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForQualifiedExpression"));
        }
        return collection;
    }

    @NotNull
    private static Collection<DeclarationDescriptor> lookupSelectorDescriptors(@NotNull JetSimpleNameExpression selector, @NotNull Collection<DeclarationDescriptor> declarationDescriptors, @NotNull BindingTrace trace, @NotNull JetScope scopeToCheckVisibility, @NotNull LookupMode lookupMode, boolean storeResult) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        if (declarationDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptors", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeToCheckVisibility", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        LinkedHashSet<LookupResult> results = Sets.newLinkedHashSet();
        for (DeclarationDescriptor declarationDescriptor : declarationDescriptors) {
            if (declarationDescriptor instanceof PackageViewDescriptor) {
                results.add(QualifiedExpressionResolver.lookupSimpleNameReference(selector, ((PackageViewDescriptor)declarationDescriptor).getMemberScope(), lookupMode, true));
            }
            if (!(declarationDescriptor instanceof ClassDescriptor)) continue;
            QualifiedExpressionResolver.addResultsForClass(results, selector, lookupMode, (ClassDescriptor)declarationDescriptor);
        }
        Collection<DeclarationDescriptor> collection = QualifiedExpressionResolver.filterAndStoreResolutionResult(results, selector, trace, scopeToCheckVisibility, lookupMode, storeResult);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        return collection;
    }

    private static void addResultsForClass(@NotNull @Mutable Set<LookupResult> results, @NotNull JetSimpleNameExpression selector, @NotNull LookupMode lookupMode, @NotNull ClassDescriptor descriptor) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "addResultsForClass"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "addResultsForClass"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "addResultsForClass"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "addResultsForClass"));
        }
        JetScope scope2 = lookupMode == LookupMode.ONLY_CLASSES ? descriptor.getUnsubstitutedInnerClassesScope() : descriptor.getDefaultType().getMemberScope();
        results.add(QualifiedExpressionResolver.lookupSimpleNameReference(selector, scope2, lookupMode, false));
        results.add(QualifiedExpressionResolver.lookupSimpleNameReference(selector, descriptor.getStaticScope(), lookupMode, true));
        ClassDescriptor classObject = descriptor.getClassObjectDescriptor();
        if (classObject != null) {
            QualifiedExpressionResolver.addResultsForClass(results, selector, lookupMode, classObject);
        }
    }

    @NotNull
    public Collection<DeclarationDescriptor> lookupDescriptorsForSimpleNameReference(@NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope outerScope, @NotNull JetScope scopeToCheckVisibility, @NotNull BindingTrace trace, @NotNull LookupMode lookupMode, boolean packageLevel, boolean storeResult) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeToCheckVisibility", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        LookupResult lookupResult = QualifiedExpressionResolver.lookupSimpleNameReference(referenceExpression, outerScope, lookupMode, packageLevel);
        Collection<DeclarationDescriptor> collection = QualifiedExpressionResolver.filterAndStoreResolutionResult(Collections.singletonList(lookupResult), referenceExpression, trace, scopeToCheckVisibility, lookupMode, storeResult);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        return collection;
    }

    @NotNull
    private static LookupResult lookupSimpleNameReference(@NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope outerScope, @NotNull LookupMode lookupMode, boolean packageLevel) {
        ClassifierDescriptor classifierDescriptor;
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSimpleNameReference"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSimpleNameReference"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSimpleNameReference"));
        }
        Name referencedName = referenceExpression.getReferencedNameAsName();
        LinkedHashSet<DeclarationDescriptor> descriptors = Sets.newLinkedHashSet();
        PackageViewDescriptor packageDescriptor = outerScope.getPackage(referencedName);
        if (packageDescriptor != null) {
            descriptors.add(packageDescriptor);
        }
        if ((classifierDescriptor = outerScope.getClassifier(referencedName)) != null) {
            descriptors.add(classifierDescriptor);
        }
        if (lookupMode == LookupMode.EVERYTHING) {
            descriptors.addAll(outerScope.getFunctions(referencedName));
            descriptors.addAll(outerScope.getProperties(referencedName));
            VariableDescriptor localVariable = outerScope.getLocalVariable(referencedName);
            if (localVariable != null) {
                descriptors.add(localVariable);
            }
        }
        LookupResult lookupResult = new LookupResult(descriptors, outerScope, packageLevel);
        if (lookupResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "lookupSimpleNameReference"));
        }
        return lookupResult;
    }

    @NotNull
    private static Collection<DeclarationDescriptor> filterAndStoreResolutionResult(@NotNull Collection<LookupResult> lookupResults, @NotNull JetSimpleNameExpression referenceExpression, @NotNull BindingTrace trace, @NotNull JetScope scopeToCheckVisibility, @NotNull LookupMode lookupMode, boolean storeResult) {
        LinkedHashSet<DeclarationDescriptor> filteredDescriptors;
        if (lookupResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupResults", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeToCheckVisibility", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (lookupResults.isEmpty()) {
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
            }
            return list;
        }
        LinkedHashSet<DeclarationDescriptor> descriptors = Sets.newLinkedHashSet();
        for (LookupResult lookupResult : lookupResults) {
            descriptors.addAll(lookupResult.descriptors);
        }
        ArrayList<JetScope> possibleResolutionScopes = Lists.newArrayList();
        for (LookupResult lookupResult : lookupResults) {
            if (lookupResult.descriptors.isEmpty()) continue;
            possibleResolutionScopes.add(lookupResult.resolutionScope);
        }
        if (possibleResolutionScopes.isEmpty()) {
            for (LookupResult lookupResult : lookupResults) {
                possibleResolutionScopes.add(lookupResult.resolutionScope);
            }
        }
        if (lookupMode == LookupMode.ONLY_CLASSES) {
            filteredDescriptors = Collections2.filter(descriptors, CLASSIFIERS_AND_PACKAGE_VIEWS);
        } else {
            filteredDescriptors = Sets.newLinkedHashSet();
            for (LookupResult lookupResult : lookupResults) {
                if (lookupResult.packageLevel) {
                    filteredDescriptors.addAll(lookupResult.descriptors);
                    continue;
                }
                filteredDescriptors.addAll(Collections2.filter(lookupResult.descriptors, CLASSIFIERS_AND_PACKAGE_VIEWS));
            }
        }
        if (storeResult) {
            QualifiedExpressionResolver.storeResolutionResult(descriptors, filteredDescriptors, referenceExpression, possibleResolutionScopes, trace, scopeToCheckVisibility);
        }
        LinkedHashSet<DeclarationDescriptor> linkedHashSet = filteredDescriptors;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        return linkedHashSet;
    }

    private static void storeResolutionResult(@NotNull Collection<DeclarationDescriptor> descriptors, @NotNull Collection<DeclarationDescriptor> canBeImportedDescriptors, @NotNull JetSimpleNameExpression referenceExpression, @NotNull Collection<JetScope> possibleResolutionScopes, @NotNull BindingTrace trace, @NotNull JetScope scopeToCheckVisibility) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (canBeImportedDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canBeImportedDescriptors", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (possibleResolutionScopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleResolutionScopes", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeToCheckVisibility", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        assert (canBeImportedDescriptors.size() <= descriptors.size());
        assert (!possibleResolutionScopes.isEmpty());
        JetScope resolutionScope = possibleResolutionScopes.iterator().next();
        if (QualifiedExpressionResolver.resolveClassPackageAmbiguity(canBeImportedDescriptors, referenceExpression, resolutionScope, trace, scopeToCheckVisibility)) {
            return;
        }
        if (descriptors.isEmpty()) {
            trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
            trace.report(Errors.UNRESOLVED_REFERENCE.on(referenceExpression, referenceExpression));
            return;
        }
        DeclarationDescriptor descriptor = null;
        if (descriptors.size() == 1) {
            descriptor = descriptors.iterator().next();
            assert (canBeImportedDescriptors.size() <= 1);
        } else if (canBeImportedDescriptors.size() == 1) {
            descriptor = canBeImportedDescriptors.iterator().next();
        }
        if (descriptor != null) {
            trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, descriptors.iterator().next());
            trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
            if (descriptor instanceof DeclarationDescriptorWithVisibility) {
                QualifiedExpressionResolver.checkVisibility((DeclarationDescriptorWithVisibility)descriptor, trace, referenceExpression, scopeToCheckVisibility);
            }
        }
        if (canBeImportedDescriptors.isEmpty()) {
            assert (descriptors.size() >= 1);
            trace.report(Errors.CANNOT_BE_IMPORTED.on(referenceExpression, descriptors.iterator().next()));
            return;
        }
        if (canBeImportedDescriptors.size() > 1) {
            trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, referenceExpression, descriptors);
        }
    }

    private static boolean resolveClassPackageAmbiguity(@NotNull Collection<DeclarationDescriptor> filteredDescriptors, @NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope resolutionScope, @NotNull BindingTrace trace, @NotNull JetScope scopeToCheckVisibility) {
        if (filteredDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filteredDescriptors", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "resolveClassPackageAmbiguity"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "resolveClassPackageAmbiguity"));
        }
        if (resolutionScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionScope", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "resolveClassPackageAmbiguity"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "resolveClassPackageAmbiguity"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeToCheckVisibility", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "resolveClassPackageAmbiguity"));
        }
        if (filteredDescriptors.size() == 2) {
            PackageViewDescriptor packageView = null;
            ClassDescriptor classDescriptor = null;
            for (DeclarationDescriptor filteredDescriptor : filteredDescriptors) {
                if (filteredDescriptor instanceof PackageViewDescriptor) {
                    packageView = (PackageViewDescriptor)filteredDescriptor;
                    continue;
                }
                if (!(filteredDescriptor instanceof ClassDescriptor)) continue;
                classDescriptor = (ClassDescriptor)filteredDescriptor;
            }
            if (packageView != null && classDescriptor != null && packageView.getFqName().equalsTo(DescriptorUtils.getFqName(classDescriptor))) {
                trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, classDescriptor);
                trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
                QualifiedExpressionResolver.checkVisibility(classDescriptor, trace, referenceExpression, scopeToCheckVisibility);
                return true;
            }
        }
        return false;
    }

    private static void checkVisibility(@NotNull DeclarationDescriptorWithVisibility descriptor, @NotNull BindingTrace trace, @NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope scopeToCheckVisibility) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "checkVisibility"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "checkVisibility"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "checkVisibility"));
        }
        if (scopeToCheckVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeToCheckVisibility", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver", "checkVisibility"));
        }
        if (!Visibilities.isVisible(ReceiverValue.IRRELEVANT_RECEIVER, descriptor, scopeToCheckVisibility.getContainingDeclaration())) {
            trace.report(Errors.INVISIBLE_REFERENCE.on(referenceExpression, descriptor, descriptor.getVisibility(), descriptor.getContainingDeclaration()));
        }
    }

    private static class LookupResult {
        private final Collection<DeclarationDescriptor> descriptors;
        private final JetScope resolutionScope;
        private final boolean packageLevel;

        public LookupResult(@NotNull Collection<DeclarationDescriptor> descriptors, @NotNull JetScope resolutionScope, boolean packageLevel) {
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver$LookupResult", "<init>"));
            }
            if (resolutionScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionScope", "org/jetbrains/jet/lang/resolve/QualifiedExpressionResolver$LookupResult", "<init>"));
            }
            this.descriptors = descriptors;
            this.resolutionScope = resolutionScope;
            this.packageLevel = packageLevel;
        }
    }

    public static enum LookupMode {
        ONLY_CLASSES,
        EVERYTHING;

    }
}

