/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.bindingContextUtil;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.bindingContextUtil.BindingContextUtilPackage$BindingContextUtils$d861c671$getTargetFunctionDescriptor$2;
import org.jetbrains.jet.lang.resolve.bindingContextUtil.BindingContextUtilPackage$BindingContextUtils$d861c671$getTargetFunctionDescriptor$3;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;

@KotlinSyntheticClass(abiVersion=19, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class BindingContextUtilPackage$BindingContextUtils$d861c671 {
    @Nullable
    public static final FunctionDescriptor getTargetFunctionDescriptor(@JetValueParameter(name="$receiver") JetReturnExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/bindingContextUtil/BindingContextUtilPackage$BindingContextUtils$d861c671", "getTargetFunctionDescriptor"));
        }
        Intrinsics.checkParameterIsNotNull(context2, "context");
        JetSimpleNameExpression targetLabel = $receiver.getTargetLabel();
        if (targetLabel != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor;
            PsiElement psiElement = (PsiElement)context2.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement != null) {
                PsiElement psiElement2;
                PsiElement it = psiElement2 = psiElement;
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)context2.get(BindingContext.FUNCTION, it);
            } else {
                simpleFunctionDescriptor = null;
            }
            return simpleFunctionDescriptor;
        }
        BindingContext bindingContext = context2;
        ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
        PsiElement it = $receiver;
        JetDeclarationWithBody jetDeclarationWithBody = PsiTreeUtil.getParentOfType(it, JetDeclarationWithBody.class, false);
        DeclarationDescriptor declarationDescriptor = bindingContext.get(readOnlySlice, jetDeclarationWithBody);
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (containingFunctionDescriptor == null) {
            return null;
        }
        return KotlinPackage.firstOrNull(KotlinPackage.dropWhile(KotlinPackage.stream(containingFunctionDescriptor, BindingContextUtilPackage$BindingContextUtils$d861c671$getTargetFunctionDescriptor$2.INSTANCE$), (Function1)BindingContextUtilPackage$BindingContextUtils$d861c671$getTargetFunctionDescriptor$3.INSTANCE$));
    }

    public static final boolean isUsedAsExpression(@JetValueParameter(name="$receiver") JetExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/bindingContextUtil/BindingContextUtilPackage$BindingContextUtils$d861c671", "isUsedAsExpression"));
        }
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Object v = context2.get(BindingContext.USED_AS_EXPRESSION, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    public static final boolean isUsedAsStatement(@JetValueParameter(name="$receiver") JetExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/bindingContextUtil/BindingContextUtilPackage$BindingContextUtils$d861c671", "isUsedAsStatement"));
        }
        Intrinsics.checkParameterIsNotNull(context2, "context");
        return !BindingContextUtilPackage$BindingContextUtils$d861c671.isUsedAsExpression($receiver, context2);
    }

    public static final <C extends ResolutionContext<C>> void recordScopeAndDataFlowInfo(@JetValueParameter(name="$receiver") ResolutionContext<C> $receiver, @JetValueParameter(name="expression", type="?") @Nullable JetExpression expression) {
        if (expression == null) {
            return;
        }
        $receiver.trace.record(BindingContext.RESOLUTION_SCOPE, expression, $receiver.scope);
        if (Intrinsics.areEqual($receiver.dataFlowInfo, DataFlowInfo.EMPTY) ^ true) {
            $receiver.trace.record(BindingContext.EXPRESSION_DATA_FLOW_INFO, expression, $receiver.dataFlowInfo);
        }
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfo(@JetValueParameter(name="$receiver") BindingContext $receiver, @JetValueParameter(name="expression", type="?") @Nullable JetExpression expression) {
        JetExpression jetExpression;
        JetExpression it;
        Object object2 = expression;
        if (object2 == null || (object2 = (DataFlowInfo)$receiver.get(BindingContext.EXPRESSION_DATA_FLOW_INFO, it = (jetExpression = object2))) == null) {
            object2 = DataFlowInfo.EMPTY;
        }
        if (object2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/bindingContextUtil/BindingContextUtilPackage$BindingContextUtils$d861c671", "getDataFlowInfo"));
        }
        return object2;
    }

    public static final boolean isUnreachableCode(@JetValueParameter(name="$receiver") JetExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/bindingContextUtil/BindingContextUtilPackage$BindingContextUtils$d861c671", "isUnreachableCode"));
        }
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Object v = context2.get(BindingContext.UNREACHABLE_CODE, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }
}

