/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetAnnotatedExpression;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCallableReferenceExpression;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetInstanceExpressionWithLabel;
import org.jetbrains.jet.lang.psi.JetLabeledExpression;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetRootPackageExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.resolve.PossiblyBareType;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TraceEntryFilter;
import org.jetbrains.jet.lang.resolve.TypeResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallExpressionResolver;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.jet.lang.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.jet.lang.resolve.calls.smartcasts.Nullability;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.resolve.source.SourcePackage;
import org.jetbrains.jet.lang.types.CastDiagnosticsUtil;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.TypesPackage;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.LabelResolver;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.expressions.TypeReconstructionUtil;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.slicedmap.WritableSlice;
import org.jetbrains.jet.utils.ThrowingList;

public class BasicExpressionTypingVisitor
extends ExpressionTypingVisitor {
    private static final TokenSet BARE_TYPES_ALLOWED = TokenSet.create(JetTokens.AS_KEYWORD, JetTokens.AS_SAFE);

    protected BasicExpressionTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "<init>"));
        }
        super(facade);
    }

    @Override
    public JetTypeInfo visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitSimpleNameExpression"));
        }
        CallExpressionResolver callExpressionResolver = this.components.expressionTypingServices.getCallExpressionResolver();
        JetTypeInfo typeInfo = callExpressionResolver.getSimpleNameExpressionTypeInfo(expression, ReceiverValue.NO_RECEIVER, null, context2);
        JetType type2 = DataFlowUtils.checkType(typeInfo.getType(), (JetExpression)expression, (ResolutionContext)context2);
        ExpressionTypingUtils.checkCapturingInClosure(expression, context2.trace, context2.scope);
        return JetTypeInfo.create(type2, typeInfo.getDataFlowInfo());
    }

    @Override
    public JetTypeInfo visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitParenthesizedExpression"));
        }
        return this.visitParenthesizedExpression(expression, context2, false);
    }

    public JetTypeInfo visitParenthesizedExpression(JetParenthesizedExpression expression, ExpressionTypingContext context2, boolean isStatement) {
        JetExpression innerExpression = expression.getExpression();
        if (innerExpression == null) {
            return JetTypeInfo.create(null, context2.dataFlowInfo);
        }
        return this.facade.getTypeInfo(innerExpression, (ExpressionTypingContext)context2.replaceScope(context2.scope), isStatement);
    }

    @Override
    public JetTypeInfo visitConstantExpression(@NotNull JetConstantExpression expression, ExpressionTypingContext context2) {
        CompileTimeConstantChecker compileTimeConstantChecker;
        boolean hasError;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitConstantExpression"));
        }
        CompileTimeConstant<? extends Object> value = ConstantExpressionEvaluator.OBJECT$.evaluate(expression, context2.trace, context2.expectedType);
        if (!(value instanceof IntegerValueTypeConstant) && (hasError = (compileTimeConstantChecker = context2.getCompileTimeConstantChecker()).checkConstantExpressionType(value, expression, context2.expectedType))) {
            IElementType elementType = expression.getNode().getElementType();
            return JetTypeInfo.create(this.components.expressionTypingUtils.getDefaultType(elementType), context2.dataFlowInfo);
        }
        assert (value != null) : "CompileTimeConstant should be evaluated for constant expression or an error should be recorded " + expression.getText();
        return BasicExpressionTypingVisitor.createCompileTimeConstantTypeInfo(value, expression, context2);
    }

    @Override
    public JetTypeInfo visitBinaryWithTypeRHSExpression(@NotNull JetBinaryExpressionWithTypeRHS expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression left = expression.getLeft();
        JetTypeReference right = expression.getRight();
        if (right == null) {
            JetTypeInfo leftTypeInfo = this.facade.getTypeInfo(left, contextWithNoExpectedType);
            return JetTypeInfo.create(null, leftTypeInfo.getDataFlowInfo());
        }
        IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
        boolean allowBareTypes = BARE_TYPES_ALLOWED.contains(operationType);
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context2.scope, context2.trace, true, allowBareTypes);
        PossiblyBareType possiblyBareTarget = this.components.expressionTypingServices.getTypeResolver().resolvePossiblyBareType(typeResolutionContext, right);
        if (operationType == JetTokens.COLON) {
            assert (!possiblyBareTarget.isBare()) : "Bare types should not be allowed for static assertions, because argument inference makes no sense there";
            JetType targetType = possiblyBareTarget.getActualType();
            JetTypeInfo typeInfo = this.facade.getTypeInfo(left, (ExpressionTypingContext)contextWithNoExpectedType.replaceExpectedType(targetType));
            this.checkBinaryWithTypeRHS(expression, context2, targetType, typeInfo.getType());
            return DataFlowUtils.checkType(targetType, expression, context2, typeInfo.getDataFlowInfo());
        }
        JetTypeInfo typeInfo = this.facade.getTypeInfo(left, contextWithNoExpectedType);
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        JetType subjectType = typeInfo.getType();
        JetType targetType = TypeReconstructionUtil.reconstructBareType(right, possiblyBareTarget, subjectType, context2.trace);
        if (subjectType != null) {
            this.checkBinaryWithTypeRHS(expression, contextWithNoExpectedType, targetType, subjectType);
            dataFlowInfo = typeInfo.getDataFlowInfo();
            if (operationType == JetTokens.AS_KEYWORD) {
                DataFlowValue value = DataFlowValueFactory.createDataFlowValue(left, subjectType, context2.trace.getBindingContext());
                dataFlowInfo = dataFlowInfo.establishSubtyping(value, targetType);
            }
        }
        JetType result2 = operationType == JetTokens.AS_SAFE ? TypeUtils.makeNullable(targetType) : targetType;
        return DataFlowUtils.checkType(result2, expression, context2, dataFlowInfo);
    }

    private void checkBinaryWithTypeRHS(@NotNull JetBinaryExpressionWithTypeRHS expression, @NotNull ExpressionTypingContext context2, @NotNull JetType targetType, @Nullable JetType actualType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkBinaryWithTypeRHS"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkBinaryWithTypeRHS"));
        }
        if (targetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkBinaryWithTypeRHS"));
        }
        if (actualType == null) {
            return;
        }
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.COLON) {
            return;
        }
        if (operationType != JetTokens.AS_KEYWORD && operationType != JetTokens.AS_SAFE) {
            context2.trace.report(Errors.UNSUPPORTED.on(operationSign, "binary operation with type RHS"));
            return;
        }
        this.checkForCastImpossibilityOrRedundancy(expression, actualType, targetType, context2);
    }

    private void checkForCastImpossibilityOrRedundancy(JetBinaryExpressionWithTypeRHS expression, JetType actualType, JetType targetType, ExpressionTypingContext context2) {
        if (actualType == null || TypeUtils.noExpectedType(targetType)) {
            return;
        }
        if (TypesPackage.isDynamic(targetType)) {
            JetTypeReference right = expression.getRight();
            assert (right != null) : "We know target is dynamic, but RHS is missing";
            context2.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on(right));
            return;
        }
        if (!CastDiagnosticsUtil.isCastPossible(actualType, targetType, this.components.platformToKotlinClassMap)) {
            context2.trace.report(Errors.CAST_NEVER_SUCCEEDS.on(expression.getOperationReference()));
            return;
        }
        JetTypeChecker typeChecker = JetTypeChecker.DEFAULT;
        if (((Object)actualType).equals(targetType)) {
            context2.trace.report(Errors.USELESS_CAST.on(expression));
            return;
        }
        Collection<JetType> possibleTypes = DataFlowUtils.getAllPossibleTypes(expression.getLeft(), context2.dataFlowInfo, actualType, context2.trace.getBindingContext());
        for (JetType possibleType : possibleTypes) {
            if (!typeChecker.isSubtypeOf(possibleType, targetType)) continue;
            context2.trace.report(Errors.USELESS_CAST_STATIC_ASSERT_IS_FINE.on(expression));
            return;
        }
        if (CastDiagnosticsUtil.isCastErased(actualType, targetType, typeChecker)) {
            context2.trace.report(Errors.UNCHECKED_CAST.on(expression, actualType, targetType));
        }
    }

    @Override
    public JetTypeInfo visitThisExpression(@NotNull JetThisExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitThisExpression"));
        }
        JetType result2 = null;
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = BasicExpressionTypingVisitor.resolveToReceiver(expression, context2, false);
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                break;
            }
            case NO_THIS: {
                context2.trace.report(Errors.NO_THIS.on(expression));
                break;
            }
            case SUCCESS: {
                result2 = resolutionResult.getReceiverParameterDescriptor().getType();
                context2.trace.record(BindingContext.EXPRESSION_TYPE, expression.getInstanceReference(), result2);
            }
        }
        return DataFlowUtils.checkType(result2, expression, context2, context2.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitSuperExpression(@NotNull JetSuperExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitSuperExpression"));
        }
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = BasicExpressionTypingVisitor.resolveToReceiver(expression, context2, true);
        if (!JetPsiUtil.isLHSOfDot(expression)) {
            context2.trace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(expression, expression.getText()));
            return this.errorInSuper(expression, context2);
        }
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                return this.errorInSuper(expression, context2);
            }
            case NO_THIS: {
                context2.trace.report(Errors.SUPER_NOT_AVAILABLE.on(expression));
                return this.errorInSuper(expression, context2);
            }
            case SUCCESS: {
                JetType result2 = this.checkPossiblyQualifiedSuper(expression, context2, resolutionResult.getReceiverParameterDescriptor());
                if (result2 != null) {
                    context2.trace.record(BindingContext.EXPRESSION_TYPE, expression.getInstanceReference(), result2);
                }
                return DataFlowUtils.checkType(result2, expression, context2, context2.dataFlowInfo);
            }
        }
        throw new IllegalStateException("Unknown code: " + (Object)((Object)resolutionResult.getCode()));
    }

    private JetTypeInfo errorInSuper(JetSuperExpression expression, ExpressionTypingContext context2) {
        JetTypeReference superTypeQualifier = expression.getSuperTypeQualifier();
        if (superTypeQualifier != null) {
            this.components.expressionTypingServices.getTypeResolver().resolveType(context2.scope, superTypeQualifier, context2.trace, true);
        }
        return JetTypeInfo.create(null, context2.dataFlowInfo);
    }

    private JetType checkPossiblyQualifiedSuper(JetSuperExpression expression, ExpressionTypingContext context2, ReceiverParameterDescriptor thisReceiver) {
        JetTypeReference superTypeQualifier;
        JetType thisType;
        JetType result2;
        block17: {
            TypeSubstitutor substitutor;
            Collection<JetType> supertypes2;
            block14: {
                boolean validType;
                JetTypeArgumentList redundantTypeArguments;
                JetType supertype;
                ClassifierDescriptor classifierCandidate;
                block16: {
                    block15: {
                        result2 = null;
                        thisType = thisReceiver.getType();
                        supertypes2 = thisType.getConstructor().getSupertypes();
                        substitutor = TypeSubstitutor.create(thisType);
                        superTypeQualifier = expression.getSuperTypeQualifier();
                        if (superTypeQualifier == null) break block14;
                        JetTypeElement typeElement = superTypeQualifier.getTypeElement();
                        classifierCandidate = null;
                        supertype = null;
                        redundantTypeArguments = null;
                        if (typeElement instanceof JetUserType) {
                            JetUserType userType = (JetUserType)typeElement;
                            if (userType.getTypeArguments().isEmpty()) {
                                classifierCandidate = this.components.expressionTypingServices.getTypeResolver().resolveClass(context2.scope, userType, context2.trace);
                            } else {
                                supertype = this.components.expressionTypingServices.getTypeResolver().resolveType(context2.scope, superTypeQualifier, context2.trace, true);
                                redundantTypeArguments = userType.getTypeArgumentList();
                            }
                        } else {
                            supertype = this.components.expressionTypingServices.getTypeResolver().resolveType(context2.scope, superTypeQualifier, context2.trace, true);
                        }
                        if (supertype == null) break block15;
                        if (!supertypes2.contains(supertype)) break block16;
                        result2 = supertype;
                        break block16;
                    }
                    if (classifierCandidate instanceof ClassDescriptor) {
                        ClassDescriptor superclass = (ClassDescriptor)classifierCandidate;
                        for (JetType declaredSupertype : supertypes2) {
                            if (!declaredSupertype.getConstructor().equals(superclass.getTypeConstructor())) continue;
                            result2 = substitutor.safeSubstitute(declaredSupertype, Variance.INVARIANT);
                            break;
                        }
                    }
                }
                boolean validClassifier = classifierCandidate != null && !ErrorUtils.isError(classifierCandidate);
                boolean bl = validType = supertype != null && !supertype.isError();
                if (result2 == null && (validClassifier || validType)) {
                    context2.trace.report(Errors.NOT_A_SUPERTYPE.on(superTypeQualifier));
                } else if (redundantTypeArguments != null) {
                    context2.trace.report(Errors.TYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER.on(redundantTypeArguments));
                }
                break block17;
            }
            if (supertypes2.size() > 1) {
                context2.trace.report(Errors.AMBIGUOUS_SUPER.on(expression));
            } else {
                JetType type2 = supertypes2.isEmpty() ? this.components.builtIns.getAnyType() : supertypes2.iterator().next();
                result2 = substitutor.substitute(type2, Variance.INVARIANT);
            }
        }
        if (result2 != null) {
            if (DescriptorUtils.isTrait(thisType.getConstructor().getDeclarationDescriptor()) && DescriptorUtils.isClass(result2.getConstructor().getDeclarationDescriptor())) {
                context2.trace.report(Errors.SUPERCLASS_NOT_ACCESSIBLE_FROM_TRAIT.on(expression));
            }
            context2.trace.record(BindingContext.EXPRESSION_TYPE, expression.getInstanceReference(), result2);
            context2.trace.record(BindingContext.REFERENCE_TARGET, expression.getInstanceReference(), result2.getConstructor().getDeclarationDescriptor());
        }
        if (superTypeQualifier != null) {
            context2.trace.record(BindingContext.TYPE_RESOLUTION_SCOPE, superTypeQualifier, context2.scope);
        }
        return result2;
    }

    @NotNull
    private static LabelResolver.LabeledReceiverResolutionResult resolveToReceiver(JetInstanceExpressionWithLabel expression, ExpressionTypingContext context2, boolean onlyClassReceivers) {
        String labelName = expression.getLabelName();
        if (labelName != null) {
            LabelResolver.LabeledReceiverResolutionResult resolutionResult = LabelResolver.INSTANCE.resolveThisOrSuperLabel(expression, context2, Name.identifier(labelName));
            if (resolutionResult.success()) {
                ReceiverParameterDescriptor receiverParameterDescriptor = resolutionResult.getReceiverParameterDescriptor();
                BasicExpressionTypingVisitor.recordThisOrSuperCallInTraceAndCallExtension(context2, receiverParameterDescriptor, expression);
                if (onlyClassReceivers && !BasicExpressionTypingVisitor.isDeclaredInClass(receiverParameterDescriptor)) {
                    LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabelResolver.LabeledReceiverResolutionResult.labelResolutionSuccess(ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
                    if (labeledReceiverResolutionResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveToReceiver"));
                    }
                    return labeledReceiverResolutionResult;
                }
            }
            LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = resolutionResult;
            if (labeledReceiverResolutionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveToReceiver"));
            }
            return labeledReceiverResolutionResult;
        }
        ReceiverParameterDescriptor result2 = ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER;
        List<ReceiverParameterDescriptor> receivers = context2.scope.getImplicitReceiversHierarchy();
        if (onlyClassReceivers) {
            for (ReceiverParameterDescriptor receiver : receivers) {
                if (!BasicExpressionTypingVisitor.isDeclaredInClass(receiver)) continue;
                result2 = receiver;
                break;
            }
        } else if (!receivers.isEmpty()) {
            result2 = receivers.get(0);
        }
        if (result2 != ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER) {
            context2.trace.record(BindingContext.REFERENCE_TARGET, expression.getInstanceReference(), result2.getContainingDeclaration());
            BasicExpressionTypingVisitor.recordThisOrSuperCallInTraceAndCallExtension(context2, result2, expression);
        }
        LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabelResolver.LabeledReceiverResolutionResult.labelResolutionSuccess(result2);
        if (labeledReceiverResolutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveToReceiver"));
        }
        return labeledReceiverResolutionResult;
    }

    private static void recordThisOrSuperCallInTraceAndCallExtension(ExpressionTypingContext context2, ReceiverParameterDescriptor descriptor, JetExpression expression) {
        BindingTrace trace = context2.trace;
        Call call = CallMaker.makeCall(expression, ReceiverValue.NO_RECEIVER, null, expression, Collections.emptyList());
        ResolutionCandidate<ReceiverParameterDescriptor> resolutionCandidate = ResolutionCandidate.create(call, descriptor, ReceiverValue.NO_RECEIVER, ReceiverValue.NO_RECEIVER, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER);
        ResolvedCallImpl<ReceiverParameterDescriptor> resolvedCall = ResolvedCallImpl.create(resolutionCandidate, TemporaryBindingTrace.create(trace, "Fake trace for fake 'this' or 'super' resolved call"), TracingStrategy.EMPTY, new DataFlowInfoForArgumentsImpl(call));
        resolvedCall.markCallAsCompleted();
        trace.record(BindingContext.RESOLVED_CALL, call, resolvedCall);
        trace.record(BindingContext.CALL, expression, call);
        context2.callResolverExtension.run(resolvedCall, BasicCallResolutionContext.create(context2, call, CheckValueArgumentsMode.DISABLED));
    }

    private static boolean isDeclaredInClass(ReceiverParameterDescriptor receiver) {
        return receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    @Override
    public JetTypeInfo visitBlockExpression(@NotNull JetBlockExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitBlockExpression"));
        }
        return this.components.expressionTypingServices.getBlockReturnedType(expression, context2, false);
    }

    @Override
    public JetTypeInfo visitCallableReferenceExpression(@NotNull JetCallableReferenceExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitCallableReferenceExpression"));
        }
        JetTypeReference typeReference = expression.getTypeReference();
        JetType receiverType = typeReference == null ? null : this.components.expressionTypingServices.getTypeResolver().resolveType(context2.scope, typeReference, context2.trace, false);
        JetSimpleNameExpression callableReference = expression.getCallableReference();
        if (callableReference.getReferencedName().isEmpty()) {
            context2.trace.report(Errors.UNRESOLVED_REFERENCE.on(callableReference, callableReference));
            JetType errorType = ErrorUtils.createErrorType("Empty callable reference");
            return DataFlowUtils.checkType(errorType, expression, context2, context2.dataFlowInfo);
        }
        JetType result2 = this.getCallableReferenceType(expression, receiverType, context2);
        return DataFlowUtils.checkType(result2, expression, context2, context2.dataFlowInfo);
    }

    @Nullable
    private JetType getCallableReferenceType(@NotNull JetCallableReferenceExpression expression, @Nullable JetType lhsType, @NotNull ExpressionTypingContext context2) {
        boolean isExtension;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "getCallableReferenceType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "getCallableReferenceType"));
        }
        JetSimpleNameExpression reference = expression.getCallableReference();
        boolean[] result2 = new boolean[1];
        CallableDescriptor descriptor = this.resolveCallableReferenceTarget(lhsType, context2, expression, result2);
        if (!result2[0]) {
            context2.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
        }
        if (descriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor extensionReceiver2 = descriptor.getExtensionReceiverParameter();
        ReceiverParameterDescriptor dispatchReceiver = descriptor.getDispatchReceiverParameter();
        if (extensionReceiver2 != null && dispatchReceiver != null && descriptor instanceof CallableMemberDescriptor) {
            context2.trace.report(Errors.EXTENSION_IN_CLASS_REFERENCE_NOT_ALLOWED.on(reference, (CallableMemberDescriptor)descriptor));
            return null;
        }
        JetType receiverType = null;
        if (extensionReceiver2 != null) {
            receiverType = extensionReceiver2.getType();
        } else if (dispatchReceiver != null) {
            receiverType = dispatchReceiver.getType();
        }
        boolean bl = isExtension = extensionReceiver2 != null;
        if (descriptor instanceof FunctionDescriptor) {
            return this.createFunctionReferenceType(expression, context2, (FunctionDescriptor)descriptor, receiverType, isExtension);
        }
        if (descriptor instanceof PropertyDescriptor) {
            return this.createPropertyReferenceType(expression, context2, (PropertyDescriptor)descriptor, receiverType, isExtension);
        }
        if (descriptor instanceof VariableDescriptor) {
            context2.trace.report(Errors.UNSUPPORTED.on(reference, "References to variables aren't supported yet"));
            return null;
        }
        throw new UnsupportedOperationException("Callable reference resolved to an unsupported descriptor: " + descriptor);
    }

    @Nullable
    private JetType createFunctionReferenceType(@NotNull JetCallableReferenceExpression expression, @NotNull ExpressionTypingContext context2, @NotNull FunctionDescriptor descriptor, @Nullable JetType receiverType, boolean isExtension) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "createFunctionReferenceType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "createFunctionReferenceType"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "createFunctionReferenceType"));
        }
        JetType type2 = this.components.reflectionTypes.getKFunctionType(Annotations.EMPTY, receiverType, ExpressionTypingUtils.getValueParametersTypes(descriptor.getValueParameters()), descriptor.getReturnType(), isExtension);
        if (type2.isError()) {
            context2.trace.report(Errors.REFLECTION_TYPES_NOT_LOADED.on(expression.getDoubleColonTokenReference()));
            return null;
        }
        AnonymousFunctionDescriptor functionDescriptor = new AnonymousFunctionDescriptor(context2.scope.getContainingDeclaration(), Annotations.EMPTY, CallableMemberDescriptor.Kind.DECLARATION, SourcePackage.toSourceElement(expression));
        FunctionDescriptorUtil.initializeFromFunctionType(functionDescriptor, type2, null, Modality.FINAL, Visibilities.PUBLIC);
        context2.trace.record(BindingContext.FUNCTION, expression, functionDescriptor);
        return type2;
    }

    @Nullable
    private JetType createPropertyReferenceType(@NotNull JetCallableReferenceExpression expression, @NotNull ExpressionTypingContext context2, @NotNull PropertyDescriptor descriptor, @Nullable JetType receiverType, boolean isExtension) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "createPropertyReferenceType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "createPropertyReferenceType"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "createPropertyReferenceType"));
        }
        JetType type2 = this.components.reflectionTypes.getKPropertyType(Annotations.EMPTY, receiverType, descriptor.getType(), isExtension, descriptor.isVar());
        if (type2.isError()) {
            context2.trace.report(Errors.REFLECTION_TYPES_NOT_LOADED.on(expression.getDoubleColonTokenReference()));
            return null;
        }
        LocalVariableDescriptor localVariable = new LocalVariableDescriptor(context2.scope.getContainingDeclaration(), Annotations.EMPTY, Name.special("<anonymous>"), type2, false, SourcePackage.toSourceElement(expression));
        context2.trace.record(BindingContext.VARIABLE, expression, localVariable);
        return type2;
    }

    @Nullable
    private CallableDescriptor resolveCallableReferenceTarget(@Nullable JetType lhsType, @NotNull ExpressionTypingContext context2, @NotNull JetCallableReferenceExpression expression, @NotNull boolean[] result2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveCallableReferenceTarget"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveCallableReferenceTarget"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveCallableReferenceTarget"));
        }
        JetSimpleNameExpression reference = expression.getCallableReference();
        if (lhsType == null) {
            return this.resolveCallableNotCheckingArguments(reference, ReceiverValue.NO_RECEIVER, context2, result2);
        }
        ClassifierDescriptor classifier2 = lhsType.getConstructor().getDeclarationDescriptor();
        if (!(classifier2 instanceof ClassDescriptor)) {
            context2.trace.report(Errors.CALLABLE_REFERENCE_LHS_NOT_A_CLASS.on(expression));
            return null;
        }
        JetScope staticScope = ((ClassDescriptor)classifier2).getStaticScope();
        TemporaryTraceAndCache temporaryForStatic = TemporaryTraceAndCache.create(context2, "trace to resolve callable reference in static scope", reference);
        CallableDescriptor possibleStatic = this.resolveCallableNotCheckingArguments(reference, ReceiverValue.NO_RECEIVER, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceTraceAndCache(temporaryForStatic)).replaceScope(staticScope), result2);
        if (result2[0]) {
            temporaryForStatic.commit();
            return possibleStatic;
        }
        JetScope staticNestedClasses = DescriptorUtils.getStaticNestedClassesScope((ClassDescriptor)classifier2);
        TemporaryTraceAndCache temporaryForNested = TemporaryTraceAndCache.create(context2, "trace to resolve callable reference in static nested classes scope", reference);
        CallableDescriptor possibleNestedClassConstructor = this.resolveCallableNotCheckingArguments(reference, ReceiverValue.NO_RECEIVER, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceTraceAndCache(temporaryForNested)).replaceScope(staticNestedClasses), result2);
        if (result2[0]) {
            temporaryForNested.commit();
            return possibleNestedClassConstructor;
        }
        TransientReceiver receiver = new TransientReceiver(lhsType);
        TemporaryTraceAndCache temporaryWithReceiver = TemporaryTraceAndCache.create(context2, "trace to resolve callable reference with receiver", reference);
        CallableDescriptor descriptor = this.resolveCallableNotCheckingArguments(reference, receiver, (ExpressionTypingContext)context2.replaceTraceAndCache(temporaryWithReceiver), result2);
        if (result2[0]) {
            temporaryWithReceiver.commit();
            return descriptor;
        }
        return null;
    }

    @Nullable
    private CallableDescriptor resolveCallableNotCheckingArguments(@NotNull JetSimpleNameExpression reference, @NotNull ReceiverValue receiver, @NotNull ExpressionTypingContext context2, @NotNull boolean[] result2) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveCallableNotCheckingArguments"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveCallableNotCheckingArguments"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveCallableNotCheckingArguments"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveCallableNotCheckingArguments"));
        }
        Call call = CallMaker.makeCall(reference, receiver, null, reference, ThrowingList.instance());
        TemporaryTraceAndCache funTrace = TemporaryTraceAndCache.create(context2, "trace to resolve callable reference as function", reference);
        ResolvedCall<FunctionDescriptor> function = this.components.expressionTypingServices.getCallExpressionResolver().getResolvedCallForFunction(call, reference, (ResolutionContext)((ExpressionTypingContext)context2.replaceTraceAndCache(funTrace)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE), CheckValueArgumentsMode.DISABLED, result2);
        if (result2[0]) {
            funTrace.commit();
            if (function instanceof VariableAsFunctionResolvedCall) {
                context2.trace.report(Errors.UNSUPPORTED.on(reference, "References to variables aren't supported yet"));
                return null;
            }
            return function != null ? function.getResultingDescriptor() : null;
        }
        TemporaryTraceAndCache varTrace = TemporaryTraceAndCache.create(context2, "trace to resolve callable reference as variable", reference);
        OverloadResolutionResults<VariableDescriptor> variableResults = this.components.expressionTypingServices.getCallResolver().resolveSimpleProperty(BasicCallResolutionContext.create(((ExpressionTypingContext)context2.replaceTraceAndCache(varTrace)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE), call, CheckValueArgumentsMode.DISABLED));
        if (!variableResults.isNothing()) {
            ResolvedCall<VariableDescriptor> variable = OverloadResolutionResultsUtil.getResultingCall(variableResults, context2.contextDependency);
            varTrace.commit();
            if (variable != null) {
                result2[0] = true;
                return variable.getResultingDescriptor();
            }
        }
        return null;
    }

    @Override
    public JetTypeInfo visitQualifiedExpression(@NotNull JetQualifiedExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitQualifiedExpression"));
        }
        CallExpressionResolver callExpressionResolver = this.components.expressionTypingServices.getCallExpressionResolver();
        return callExpressionResolver.getQualifiedExpressionTypeInfo(expression, context2);
    }

    @Override
    public JetTypeInfo visitCallExpression(@NotNull JetCallExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitCallExpression"));
        }
        CallExpressionResolver callExpressionResolver = this.components.expressionTypingServices.getCallExpressionResolver();
        return callExpressionResolver.getCallExpressionTypeInfo(expression, ReceiverValue.NO_RECEIVER, null, context2);
    }

    @Override
    public JetTypeInfo visitUnaryExpression(@NotNull JetUnaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        JetType result2;
        OverloadResolutionResults<FunctionDescriptor> resolutionResults;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitUnaryExpression"));
        }
        ExpressionTypingContext context2 = ExpressionTypingUtils.isUnaryExpressionDependentOnExpectedType(expression) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression == null) {
            return JetTypeInfo.create(null, context2.dataFlowInfo);
        }
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.EXCLEXCL) {
            return this.visitExclExclExpression(expression, context2);
        }
        JetTypeInfo typeInfo = this.facade.safeGetTypeInfo(baseExpression, context2);
        JetType type2 = ExpressionTypingUtils.safeGetType(typeInfo);
        ExpressionReceiver receiver = new ExpressionReceiver(baseExpression, type2);
        Call call = CallMaker.makeCall((ReceiverValue)receiver, expression);
        DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
        Name name = (Name)OperatorConventions.UNARY_OPERATION_NAMES.get(operationType);
        if (name == null) {
            context2.trace.report(Errors.UNSUPPORTED.on(operationSign, "visitUnaryExpression"));
            return JetTypeInfo.create(null, dataFlowInfo);
        }
        if ((operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS) && baseExpression instanceof JetArrayAccessExpression) {
            JetExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context2.trace, "$e", type2);
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context2.trace, "trace to resolve array access set method for unary expression", expression);
            ExpressionTypingContext newContext = (ExpressionTypingContext)context2.replaceBindingTrace(temporaryBindingTrace);
            this.resolveArrayAccessSetMethod((JetArrayAccessExpression)baseExpression, stubExpression, newContext, context2.trace);
        }
        if (!(resolutionResults = this.components.callResolver.resolveCallWithGivenName(context2, call, expression.getOperationReference(), name)).isSuccess()) {
            return JetTypeInfo.create(null, dataFlowInfo);
        }
        JetType returnType = resolutionResults.getResultingDescriptor().getReturnType();
        if (operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS) {
            assert (returnType != null) : "returnType is null for " + resolutionResults.getResultingDescriptor();
            if (KotlinBuiltIns.isUnit(returnType)) {
                result2 = ErrorUtils.createErrorType(this.components.builtIns.getUnit().getName().asString());
                context2.trace.report(Errors.INC_DEC_SHOULD_NOT_RETURN_UNIT.on(operationSign));
            } else {
                JetType receiverType = receiver.getType();
                if (!JetTypeChecker.DEFAULT.isSubtypeOf(returnType, receiverType)) {
                    context2.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, name.asString(), receiverType, returnType));
                } else {
                    context2.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression);
                    BasicExpressionTypingVisitor.checkLValue(context2.trace, baseExpression);
                }
                result2 = receiverType;
            }
        } else {
            result2 = returnType;
        }
        CompileTimeConstant<? extends Object> value = ConstantExpressionEvaluator.OBJECT$.evaluate(expression, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value != null) {
            return BasicExpressionTypingVisitor.createCompileTimeConstantTypeInfo(value, expression, contextWithExpectedType);
        }
        return DataFlowUtils.checkType(result2, expression, contextWithExpectedType, dataFlowInfo);
    }

    @NotNull
    public static JetTypeInfo createCompileTimeConstantTypeInfo(@NotNull CompileTimeConstant<?> value, @NotNull JetExpression expression, @NotNull ExpressionTypingContext context2) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "createCompileTimeConstantTypeInfo"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "createCompileTimeConstantTypeInfo"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "createCompileTimeConstantTypeInfo"));
        }
        JetType expressionType = value.getType(KotlinBuiltIns.getInstance());
        if (value instanceof IntegerValueTypeConstant && context2.contextDependency == ContextDependency.INDEPENDENT) {
            expressionType = ((IntegerValueTypeConstant)value).getType(context2.expectedType);
            ArgumentTypeResolver.updateNumberType(expressionType, expression, context2.trace);
        }
        JetTypeInfo jetTypeInfo = DataFlowUtils.checkType(expressionType, expression, context2, context2.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "createCompileTimeConstantTypeInfo"));
        }
        return jetTypeInfo;
    }

    private JetTypeInfo visitExclExclExpression(@NotNull JetUnaryExpression expression, @NotNull ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitExclExclExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitExclExclExpression"));
        }
        JetExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        assert (operationSign.getReferencedNameElementType() == JetTokens.EXCLEXCL);
        Call call = ControlStructureTypingUtils.createCallForSpecialConstruction(expression, expression.getOperationReference(), Collections.singletonList(baseExpression));
        this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call, "ExclExcl", Collections.singletonList("baseExpr"), Collections.singletonList(true), context2, null);
        JetTypeInfo baseTypeInfo = BindingContextUtils.getRecordedTypeInfo(baseExpression, context2.trace.getBindingContext());
        assert (baseTypeInfo != null) : "Base expression was not processed: " + expression;
        JetType baseType = baseTypeInfo.getType();
        if (baseType == null) {
            return baseTypeInfo;
        }
        DataFlowInfo dataFlowInfo = baseTypeInfo.getDataFlowInfo();
        if (BasicExpressionTypingVisitor.isKnownToBeNotNull(baseExpression, context2) && !baseType.isError()) {
            context2.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on(operationSign, baseType));
        } else {
            DataFlowValue value = DataFlowValueFactory.createDataFlowValue(baseExpression, baseType, context2.trace.getBindingContext());
            dataFlowInfo = dataFlowInfo.disequate(value, DataFlowValue.NULL);
        }
        return JetTypeInfo.create(TypeUtils.makeNotNullable(baseType), dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitLabeledExpression(@NotNull JetLabeledExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        return this.visitLabeledExpression(expression, context2, false);
    }

    @NotNull
    public JetTypeInfo visitLabeledExpression(@NotNull JetLabeledExpression expression, @NotNull ExpressionTypingContext context2, boolean isStatement) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression == null) {
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context2.dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = this.facade.getTypeInfo(baseExpression, context2, isStatement);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitLabeledExpression"));
        }
        return jetTypeInfo;
    }

    private static boolean isKnownToBeNotNull(JetExpression expression, ExpressionTypingContext context2) {
        JetType type2 = context2.trace.get(BindingContext.EXPRESSION_TYPE, expression);
        assert (type2 != null) : "This method is only supposed to be called when the type is not null";
        return BasicExpressionTypingVisitor.isKnownToBeNotNull(expression, type2, context2);
    }

    private static boolean isKnownToBeNotNull(JetExpression expression, JetType jetType, ExpressionTypingContext context2) {
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, jetType, context2.trace.getBindingContext());
        return !context2.dataFlowInfo.getNullability(dataFlowValue).canBeNull();
    }

    public static void checkLValue(@NotNull BindingTrace trace, @NotNull JetExpression expression) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        BasicExpressionTypingVisitor.checkLValue(trace, expression, false);
    }

    private static void checkLValue(@NotNull BindingTrace trace, @NotNull JetExpression expressionWithParenthesis, boolean canBeThis) {
        PropertyDescriptor propertyDescriptor;
        JetExpression reportOn;
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        if (expressionWithParenthesis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionWithParenthesis", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkLValue"));
        }
        JetExpression expression = JetPsiUtil.deparenthesize(expressionWithParenthesis);
        if (expression instanceof JetArrayAccessExpression) {
            JetExpression arrayExpression = ((JetArrayAccessExpression)expression).getArrayExpression();
            if (arrayExpression != null) {
                BasicExpressionTypingVisitor.checkLValue(trace, arrayExpression, true);
            }
            return;
        }
        if (canBeThis && expression instanceof JetThisExpression) {
            return;
        }
        VariableDescriptor variable = BindingContextUtils.extractVariableDescriptorIfAny(trace.getBindingContext(), expression, true);
        JetExpression jetExpression = reportOn = expression != null ? expression : expressionWithParenthesis;
        if (variable instanceof PropertyDescriptor && (propertyDescriptor = (PropertyDescriptor)variable).isSetterProjectedOut()) {
            trace.report(Errors.SETTER_PROJECTED_OUT.on(reportOn, propertyDescriptor));
        }
        if (variable == null) {
            trace.report(Errors.VARIABLE_EXPECTED.on(reportOn));
        }
    }

    @Override
    public JetTypeInfo visitBinaryExpression(@NotNull JetBinaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        JetTypeInfo result2;
        Name referencedName;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitBinaryExpression"));
        }
        ExpressionTypingContext context2 = ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType(expression) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        JetExpression left = expression.getLeft();
        JetExpression right = expression.getRight();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.IDENTIFIER) {
            referencedName = operationSign.getReferencedNameAsName();
            result2 = this.getTypeInfoForBinaryCall(referencedName, context2, expression);
        } else if (OperatorConventions.BINARY_OPERATION_NAMES.containsKey(operationType)) {
            referencedName = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get(operationType);
            result2 = this.getTypeInfoForBinaryCall(referencedName, context2, expression);
        } else {
            if (operationType == JetTokens.ELVIS) {
                return this.visitElvisExpression(expression, context2);
            }
            if (operationType == JetTokens.EQ) {
                result2 = this.visitAssignment(expression, context2);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
                result2 = this.visitAssignmentOperation(expression, context2);
            } else if (OperatorConventions.COMPARISON_OPERATIONS.contains(operationType)) {
                result2 = this.visitComparison(expression, context2, operationSign);
            } else if (OperatorConventions.EQUALS_OPERATIONS.contains(operationType)) {
                result2 = this.visitEquality(expression, context2, operationSign, left, right);
            } else if (OperatorConventions.IDENTITY_EQUALS_OPERATIONS.contains(operationType)) {
                context2.trace.record(BindingContext.REFERENCE_TARGET, operationSign, this.components.builtIns.getIdentityEquals());
                this.ensureNonemptyIntersectionOfOperandTypes(expression, context2);
                result2 = JetTypeInfo.create(this.components.builtIns.getBooleanType(), context2.dataFlowInfo);
            } else if (OperatorConventions.IN_OPERATIONS.contains(operationType)) {
                ValueArgument leftArgument = CallMaker.makeValueArgument(left, left != null ? left : operationSign);
                result2 = this.checkInExpression(expression, operationSign, leftArgument, right, context2);
            } else if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationType)) {
                result2 = this.visitBooleanOperationExpression(operationType, left, right, context2);
            } else {
                context2.trace.report(Errors.UNSUPPORTED.on(operationSign, "Unknown operation"));
                result2 = JetTypeInfo.create(null, context2.dataFlowInfo);
            }
        }
        CompileTimeConstant<? extends Object> value = ConstantExpressionEvaluator.OBJECT$.evaluate(expression, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value != null) {
            return BasicExpressionTypingVisitor.createCompileTimeConstantTypeInfo(value, expression, contextWithExpectedType);
        }
        return DataFlowUtils.checkType(result2, (JetExpression)expression, (ResolutionContext)contextWithExpectedType);
    }

    private JetTypeInfo visitEquality(JetBinaryExpression expression, ExpressionTypingContext context2, JetSimpleNameExpression operationSign, final JetExpression left, final JetExpression right) {
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        if (right == null || left == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(right, context2, this.facade);
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context2, this.facade);
            return JetTypeInfo.create(this.components.builtIns.getBooleanType(), dataFlowInfo);
        }
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, context2);
        JetTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context2, this.facade);
        dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo);
        JetTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithDataFlow);
        dataFlowInfo = rightTypeInfo.getDataFlowInfo();
        TemporaryBindingTrace traceInterpretingRightAsNullableAny = TemporaryBindingTrace.create(context2.trace, "trace to resolve 'equals(Any?)' interpreting as of type Any? an expression:", right);
        traceInterpretingRightAsNullableAny.record(BindingContext.EXPRESSION_TYPE, right, this.components.builtIns.getNullableAnyType());
        Call call = CallMaker.makeCallWithExpressions(expression, receiver, null, operationSign, Collections.singletonList(right));
        ExpressionTypingContext newContext = (ExpressionTypingContext)context2.replaceBindingTrace(traceInterpretingRightAsNullableAny);
        OverloadResolutionResults<FunctionDescriptor> resolutionResults = this.components.callResolver.resolveCallWithGivenName(newContext, call, operationSign, OperatorConventions.EQUALS);
        traceInterpretingRightAsNullableAny.commit(new TraceEntryFilter(){

            @Override
            public boolean accept(@Nullable WritableSlice<?, ?> slice, Object key) {
                if (key == right && slice == BindingContext.EXPRESSION_TYPE) {
                    return false;
                }
                return key != left || slice != BindingContext.SMARTCAST;
            }
        }, true);
        if (resolutionResults.isSuccess()) {
            FunctionDescriptor equals = resolutionResults.getResultingCall().getResultingDescriptor();
            if (this.components.expressionTypingUtils.ensureBooleanResult(operationSign, OperatorConventions.EQUALS, equals.getReturnType(), context2)) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression, context2);
            }
        } else if (resolutionResults.isAmbiguity()) {
            context2.trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(operationSign, resolutionResults.getResultingCalls()));
        } else {
            context2.trace.report(Errors.EQUALS_MISSING.on(operationSign));
        }
        return JetTypeInfo.create(this.components.builtIns.getBooleanType(), dataFlowInfo);
    }

    @NotNull
    private JetTypeInfo visitComparison(@NotNull JetBinaryExpression expression, @NotNull ExpressionTypingContext context2, @NotNull JetSimpleNameExpression operationSign) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        if (operationSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationSign", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        JetTypeInfo typeInfo = this.getTypeInfoForBinaryCall(OperatorConventions.COMPARE_TO, context2, expression);
        DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
        JetType compareToReturnType = typeInfo.getType();
        JetType type2 = null;
        if (compareToReturnType != null && !compareToReturnType.isError()) {
            if (JetTypeChecker.DEFAULT.equalTypes(this.components.builtIns.getIntType(), compareToReturnType)) {
                type2 = this.components.builtIns.getBooleanType();
            } else {
                context2.trace.report(Errors.COMPARE_TO_TYPE_MISMATCH.on(operationSign, compareToReturnType));
            }
        }
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(type2, dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitComparison"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo visitBooleanOperationExpression(@Nullable IElementType operationType, @Nullable JetExpression left, @Nullable JetExpression right, @NotNull ExpressionTypingContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitBooleanOperationExpression"));
        }
        JetType booleanType = this.components.builtIns.getBooleanType();
        JetTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, (ExpressionTypingContext)context2.replaceExpectedType(booleanType), this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        WritableScopeImpl leftScope = ExpressionTypingUtils.newWritableScopeImpl(context2, "Left scope of && or ||");
        boolean isAnd = operationType == JetTokens.ANDAND;
        DataFlowInfo flowInfoLeft = DataFlowUtils.extractDataFlowInfoFromCondition(left, isAnd, context2).and(dataFlowInfo);
        WritableScopeImpl rightScope = isAnd ? leftScope : ExpressionTypingUtils.newWritableScopeImpl(context2, "Right scope of && or ||");
        ExpressionTypingContext contextForRightExpr = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceDataFlowInfo(flowInfoLeft)).replaceScope(rightScope)).replaceExpectedType(booleanType);
        if (right != null) {
            this.facade.getTypeInfo(right, contextForRightExpr);
        }
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(booleanType, dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitBooleanOperationExpression"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo visitElvisExpression(@NotNull JetBinaryExpression expression, @NotNull ExpressionTypingContext contextWithExpectedType) {
        JetType type2;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
        }
        if (contextWithExpectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextWithExpectedType", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
        }
        ExpressionTypingContext context2 = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression left = expression.getLeft();
        JetExpression right = expression.getRight();
        if (left == null || right == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context2, this.facade);
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context2.dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
            }
            return jetTypeInfo;
        }
        Call call = ControlStructureTypingUtils.createCallForSpecialConstruction(expression, expression.getOperationReference(), Lists.newArrayList(left, right));
        ResolvedCall<FunctionDescriptor> resolvedCall = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call, "Elvis", Lists.newArrayList("left", "right"), Lists.newArrayList(true, false), contextWithExpectedType, null);
        JetTypeInfo leftTypeInfo = BindingContextUtils.getRecordedTypeInfo(left, context2.trace.getBindingContext());
        assert (leftTypeInfo != null) : "Left expression was not processed: " + expression;
        JetType leftType = leftTypeInfo.getType();
        if (leftType != null && BasicExpressionTypingVisitor.isKnownToBeNotNull(left, leftType, context2)) {
            context2.trace.report(Errors.USELESS_ELVIS.on(left, leftType));
        }
        JetTypeInfo rightTypeInfo = BindingContextUtils.getRecordedTypeInfo(right, context2.trace.getBindingContext());
        assert (rightTypeInfo != null) : "Right expression was not processed: " + expression;
        JetType rightType = rightTypeInfo.getType();
        DataFlowInfo dataFlowInfo = resolvedCall.getDataFlowInfoForArguments().getResultInfo();
        if (leftType != null && rightType != null && KotlinBuiltIns.isNothingOrNullableNothing(rightType) && !rightType.isMarkedNullable()) {
            DataFlowValue value = DataFlowValueFactory.createDataFlowValue(left, leftType, context2.trace.getBindingContext());
            dataFlowInfo = dataFlowInfo.disequate(value, DataFlowValue.NULL);
        }
        if ((type2 = resolvedCall.getResultingDescriptor().getReturnType()) == null || rightType == null) {
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
            }
            return jetTypeInfo;
        }
        if (!TypeUtils.isNullableType(rightType) && TypeUtils.isNullableType(type2)) {
            type2 = TypeUtils.makeNotNullable(type2);
        }
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(type2, dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitElvisExpression"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo checkInExpression(@NotNull JetElement callElement, @NotNull JetSimpleNameExpression operationSign, @NotNull ValueArgument leftArgument, @Nullable JetExpression right, @NotNull ExpressionTypingContext context2) {
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        if (operationSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationSign", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        if (leftArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftArgument", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        JetExpression left = leftArgument.getArgumentExpression();
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        if (right == null) {
            if (left != null) {
                this.facade.getTypeInfo(left, contextWithNoExpectedType);
            }
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context2.dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
            }
            return jetTypeInfo;
        }
        DataFlowInfo dataFlowInfo = this.facade.getTypeInfo(right, contextWithNoExpectedType).getDataFlowInfo();
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, right, contextWithNoExpectedType);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo);
        OverloadResolutionResults<FunctionDescriptor> resolutionResult = this.components.callResolver.resolveCallWithGivenName(contextWithDataFlow, CallMaker.makeCall(callElement, receiver, null, operationSign, Collections.singletonList(leftArgument)), operationSign, OperatorConventions.CONTAINS);
        JetType containsType = OverloadResolutionResultsUtil.getResultingType(resolutionResult, context2.contextDependency);
        this.components.expressionTypingUtils.ensureBooleanResult(operationSign, OperatorConventions.CONTAINS, containsType, context2);
        if (left != null) {
            dataFlowInfo = this.facade.getTypeInfo(left, contextWithDataFlow).getDataFlowInfo().and(dataFlowInfo);
        }
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(resolutionResult.isSuccess() ? this.components.builtIns.getBooleanType() : null, dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkInExpression"));
        }
        return jetTypeInfo;
    }

    private void ensureNonemptyIntersectionOfOperandTypes(JetBinaryExpression expression, ExpressionTypingContext context2) {
        JetType rightType;
        JetExpression left = expression.getLeft();
        if (left == null) {
            return;
        }
        JetExpression right = expression.getRight();
        JetType leftType = this.facade.getTypeInfo(left, context2).getType();
        if (leftType != null && right != null && (rightType = this.facade.getTypeInfo(right, context2).getType()) != null) {
            if (TypeUtils.isIntersectionEmpty(leftType, rightType)) {
                context2.trace.report(Errors.EQUALITY_NOT_APPLICABLE.on(expression, expression.getOperationReference(), leftType, rightType));
            }
            this.checkSenselessComparisonWithNull(expression, left, right, context2);
        }
    }

    private void checkSenselessComparisonWithNull(@NotNull JetBinaryExpression expression, @NotNull JetExpression left, @NotNull JetExpression right, @NotNull ExpressionTypingContext context2) {
        boolean expressionIsAlways;
        boolean equality;
        JetExpression expr;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkSenselessComparisonWithNull"));
        }
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkSenselessComparisonWithNull"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkSenselessComparisonWithNull"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "checkSenselessComparisonWithNull"));
        }
        if (JetPsiUtil.isNullConstant(left)) {
            expr = right;
        } else if (JetPsiUtil.isNullConstant(right)) {
            expr = left;
        } else {
            return;
        }
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        JetType type2 = this.facade.getTypeInfo(expr, context2).getType();
        if (type2 == null || type2.isError()) {
            return;
        }
        DataFlowValue value = DataFlowValueFactory.createDataFlowValue(expr, type2, context2.trace.getBindingContext());
        Nullability nullability = context2.dataFlowInfo.getNullability(value);
        boolean bl = equality = operationSign.getReferencedNameElementType() == JetTokens.EQEQ || operationSign.getReferencedNameElementType() == JetTokens.EQEQEQ;
        if (nullability == Nullability.NULL) {
            expressionIsAlways = equality;
        } else if (nullability == Nullability.NOT_NULL) {
            expressionIsAlways = !equality;
        } else {
            return;
        }
        context2.trace.report(Errors.SENSELESS_COMPARISON.on(expression, expression, expressionIsAlways));
    }

    @NotNull
    private JetTypeInfo visitAssignmentOperation(JetBinaryExpression expression, ExpressionTypingContext context2) {
        JetTypeInfo jetTypeInfo = this.assignmentIsNotAnExpressionError(expression, context2);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitAssignmentOperation"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo visitAssignment(JetBinaryExpression expression, ExpressionTypingContext context2) {
        JetTypeInfo jetTypeInfo = this.assignmentIsNotAnExpressionError(expression, context2);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitAssignment"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo assignmentIsNotAnExpressionError(JetBinaryExpression expression, ExpressionTypingContext context2) {
        this.facade.checkStatementType(expression, context2);
        context2.trace.report(Errors.ASSIGNMENT_IN_EXPRESSION_CONTEXT.on(expression));
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context2.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "assignmentIsNotAnExpressionError"));
        }
        return jetTypeInfo;
    }

    @Override
    public JetTypeInfo visitArrayAccessExpression(@NotNull JetArrayAccessExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitArrayAccessExpression"));
        }
        JetTypeInfo typeInfo = this.resolveArrayAccessGetMethod(expression, context2);
        return DataFlowUtils.checkType(typeInfo, (JetExpression)expression, (ResolutionContext)context2);
    }

    @NotNull
    public JetTypeInfo getTypeInfoForBinaryCall(@NotNull Name name, @NotNull ExpressionTypingContext context2, @NotNull JetBinaryExpression binaryExpression) {
        OverloadResolutionResults<Object> resolutionResults;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        JetExpression left = binaryExpression.getLeft();
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        if (left != null) {
            dataFlowInfo = this.facade.getTypeInfo(left, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).getDataFlowInfo();
        }
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo);
        if (left != null) {
            ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, context2);
            resolutionResults = this.components.callResolver.resolveBinaryCall((ExpressionTypingContext)contextWithDataFlow.replaceScope(context2.scope), receiver, binaryExpression, name);
        } else {
            resolutionResults = OverloadResolutionResultsImpl.nameNotFound();
        }
        if (resolutionResults.isSingleResult()) {
            dataFlowInfo = resolutionResults.getResultingCall().getDataFlowInfoForArguments().getResultInfo();
        }
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(OverloadResolutionResultsUtil.getResultingType(resolutionResults, context2.contextDependency), dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "getTypeInfoForBinaryCall"));
        }
        return jetTypeInfo;
    }

    @Override
    public JetTypeInfo visitDeclaration(@NotNull JetDeclaration dcl, ExpressionTypingContext context2) {
        if (dcl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dcl", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitDeclaration"));
        }
        context2.trace.report(Errors.DECLARATION_IN_ILLEGAL_CONTEXT.on(dcl));
        return JetTypeInfo.create(null, context2.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitRootPackageExpression(@NotNull JetRootPackageExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitRootPackageExpression"));
        }
        if (!JetPsiUtil.isLHSOfDot(expression)) {
            context2.trace.report(Errors.PACKAGE_IS_NOT_AN_EXPRESSION.on(expression));
        }
        return JetTypeInfo.create(null, context2.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitStringTemplateExpression(@NotNull JetStringTemplateExpression expression, ExpressionTypingContext contextWithExpectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitStringTemplateExpression"));
        }
        final ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        final DataFlowInfo[] dataFlowInfo = new DataFlowInfo[]{context2.dataFlowInfo};
        for (JetStringTemplateEntry entry : expression.getEntries()) {
            entry.accept(new JetVisitorVoid(){

                @Override
                public void visitStringTemplateEntryWithExpression(@NotNull JetStringTemplateEntryWithExpression entry) {
                    if (entry == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor$2", "visitStringTemplateEntryWithExpression"));
                    }
                    JetExpression entryExpression = entry.getExpression();
                    if (entryExpression != null) {
                        JetTypeInfo typeInfo = BasicExpressionTypingVisitor.this.facade.getTypeInfo(entryExpression, (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo[0]));
                        dataFlowInfo[0] = typeInfo.getDataFlowInfo();
                    }
                }

                @Override
                public void visitEscapeStringTemplateEntry(@NotNull JetEscapeStringTemplateEntry entry) {
                    if (entry == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor$2", "visitEscapeStringTemplateEntry"));
                    }
                    CompileTimeConstantChecker.CharacterWithDiagnostic value = CompileTimeConstantChecker.escapedStringToCharacter(entry.getText(), entry);
                    Diagnostic diagnostic = value.getDiagnostic();
                    if (diagnostic != null) {
                        context2.trace.report(diagnostic);
                    }
                }
            });
        }
        ConstantExpressionEvaluator.OBJECT$.evaluate(expression, context2.trace, contextWithExpectedType.expectedType);
        return DataFlowUtils.checkType(this.components.builtIns.getStringType(), expression, contextWithExpectedType, dataFlowInfo[0]);
    }

    @Override
    public JetTypeInfo visitAnnotatedExpression(@NotNull JetAnnotatedExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitAnnotatedExpression"));
        }
        return this.visitAnnotatedExpression(expression, context2, false);
    }

    public JetTypeInfo visitAnnotatedExpression(JetAnnotatedExpression expression, ExpressionTypingContext context2, boolean isStatement) {
        this.components.expressionTypingServices.getAnnotationResolver().resolveAnnotationsWithArguments(context2.scope, expression.getAnnotationEntries(), context2.trace);
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression == null) {
            return JetTypeInfo.create(null, context2.dataFlowInfo);
        }
        return this.facade.getTypeInfo(baseExpression, context2, isStatement);
    }

    @Override
    public JetTypeInfo visitJetElement(@NotNull JetElement element, ExpressionTypingContext context2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "visitJetElement"));
        }
        context2.trace.report(Errors.UNSUPPORTED.on(element, this.getClass().getCanonicalName()));
        return JetTypeInfo.create(null, context2.dataFlowInfo);
    }

    @NotNull
    JetTypeInfo resolveArrayAccessSetMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull JetExpression rightHandSide, @NotNull ExpressionTypingContext context2, @NotNull BindingTrace traceForResolveResult) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        if (rightHandSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightHandSide", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        if (traceForResolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceForResolveResult", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        JetTypeInfo jetTypeInfo = this.resolveArrayAccessSpecialMethod(arrayAccessExpression, rightHandSide, context2, traceForResolveResult, false);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSetMethod"));
        }
        return jetTypeInfo;
    }

    @NotNull
    JetTypeInfo resolveArrayAccessGetMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull ExpressionTypingContext context2) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessGetMethod"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessGetMethod"));
        }
        JetTypeInfo jetTypeInfo = this.resolveArrayAccessSpecialMethod(arrayAccessExpression, null, context2, context2.trace, true);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessGetMethod"));
        }
        return jetTypeInfo;
    }

    @NotNull
    private JetTypeInfo resolveArrayAccessSpecialMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @Nullable JetExpression rightHandSide, @NotNull ExpressionTypingContext oldContext, @NotNull BindingTrace traceForResolveResult, boolean isGet) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        if (oldContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldContext", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        if (traceForResolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceForResolveResult", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        JetExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        if (arrayExpression == null) {
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, oldContext.dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo arrayTypeInfo = this.facade.safeGetTypeInfo(arrayExpression, (ExpressionTypingContext)((ExpressionTypingContext)oldContext.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        JetType arrayType = ExpressionTypingUtils.safeGetType(arrayTypeInfo);
        DataFlowInfo dataFlowInfo = arrayTypeInfo.getDataFlowInfo();
        ExpressionTypingContext context2 = (ExpressionTypingContext)oldContext.replaceDataFlowInfo(dataFlowInfo);
        ExpressionReceiver receiver = new ExpressionReceiver(arrayExpression, arrayType);
        if (!isGet) assert (rightHandSide != null);
        Call call = isGet ? CallMaker.makeArrayGetCall(receiver, arrayAccessExpression, Call.CallType.ARRAY_GET_METHOD) : CallMaker.makeArraySetCall(receiver, arrayAccessExpression, rightHandSide, Call.CallType.ARRAY_SET_METHOD);
        OverloadResolutionResults<FunctionDescriptor> functionResults = this.components.callResolver.resolveCallWithGivenName(context2, call, arrayAccessExpression, Name.identifier(isGet ? "get" : "set"));
        List<JetExpression> indices = arrayAccessExpression.getIndexExpressions();
        if (!indices.isEmpty()) {
            dataFlowInfo = this.facade.getTypeInfo(indices.get(indices.size() - 1), context2).getDataFlowInfo();
        }
        if (!isGet) {
            dataFlowInfo = this.facade.getTypeInfo(rightHandSide, (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo)).getDataFlowInfo();
        }
        if (!functionResults.isSingleResult()) {
            traceForResolveResult.report(isGet ? Errors.NO_GET_METHOD.on(arrayAccessExpression) : Errors.NO_SET_METHOD.on(arrayAccessExpression));
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
            }
            return jetTypeInfo;
        }
        traceForResolveResult.record(isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression, functionResults.getResultingCall());
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(functionResults.getResultingDescriptor().getReturnType(), dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/BasicExpressionTypingVisitor", "resolveArrayAccessSpecialMethod"));
        }
        return jetTypeInfo;
    }
}

